/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.attributeEditor;

import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutAttributePanel;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.EditorUtils;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.TagPanel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.TimeLineIcons;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.table.JBTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class CustomAttributePanel
extends TagPanel {
    private final Vector<String> colNames = new Vector<String>(Arrays.asList("Name", "Value"));
    private final Vector<Vector<Object>> data = new Vector();
    private final DefaultTableModel myTableModel = new CustomAttrTableModel(this.data, this.colNames);
    private final JBPopupMenu myPopupMenu = new JBPopupMenu("Add Attribute");
    private MotionSceneModel.CustomAttributes myCustomAttributes;

    public CustomAttributePanel(MotionLayoutAttributePanel panel) {
        super(panel);
        this.myTitle.setText("Custom");
        this.myTable = new JBTable((TableModel)this.myTableModel);
        this.myRemoveTagButton = EditorUtils.makeButton(TimeLineIcons.REMOVE_TAG);
        this.setup();
        this.myTable.setSelectionMode(0);
        this.myTable.setDefaultRenderer(EditorUtils.AttributesNamesHolder.class, new EditorUtils.AttributesNamesCellRenderer());
        this.myTable.setDefaultRenderer(String.class, new EditorUtils.AttributesValueCellRenderer());
        this.myTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    c.setForeground((Color)(column > 0 ? EditorUtils.ourValueColor : EditorUtils.ourNameColor));
                }
                return c;
            }
        });
        this.myPopupMenu.add(new JMenuItem("test1"));
        this.myAddRemovePanel.myAddButton.setVisible(false);
        this.myAddRemovePanel.myRemoveButton.setVisible(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.myTitle, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        this.add((Component)this.myRemoveTagButton, gbc);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        ++gbc.gridy;
        gbc.fill = 1;
        this.add((Component)this.myTable, gbc);
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.anchor = 17;
        this.add((Component)this.myAddRemovePanel, gbc);
    }

    @Override
    protected void deleteTag() {
        if (this.myCustomAttributes != null && this.myCustomAttributes.deleteTag()) {
            this.setVisible(false);
        }
    }

    @Override
    protected void deleteAttr(int selection) {
        throw new UnsupportedOperationException();
    }

    public void setTag(MotionSceneModel.CustomAttributes tag) {
        this.myCustomAttributes = tag;
        HashMap<String, Object> attr = tag.getAttributes();
        this.data.clear();
        for (String s : attr.keySet()) {
            Vector<Object> v = new Vector<Object>(Arrays.asList(s, attr.get(s)));
            this.data.add(v);
        }
        this.data.sort(Comparator.comparing(row -> (String)row.get(0)));
        this.myTableModel.fireTableDataChanged();
    }

    private class CustomAttrTableModel
    extends DefaultTableModel {
        private CustomAttrTableModel(@NotNull Vector data, Vector columnNames) {
            if (data == null) {
                CustomAttrTableModel.$$$reportNull$$$0(0);
            }
            if (columnNames == null) {
                CustomAttrTableModel.$$$reportNull$$$0(1);
            }
            super(data, columnNames);
        }

        @Override
        public void setValueAt(@NotNull Object value, int rowIndex, int columnIndex) {
            if (value == null) {
                CustomAttrTableModel.$$$reportNull$$$0(2);
            }
            super.setValueAt(value, rowIndex, columnIndex);
            String key = this.getValueAt(rowIndex, 0).toString();
            CustomAttributePanel.this.myCustomAttributes.setValue(key, (String)value);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnNames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/attributeEditor/CustomAttributePanel$CustomAttrTableModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValueAt";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

