/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.attributeEditor;

import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutAttributePanel;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.EditorUtils;
import com.android.tools.idea.uibuilder.handlers.motion.attributeEditor.TagPanel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.TimeLineIcons;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.table.JBTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class OnSwipePanel
extends TagPanel {
    private Vector<String> colNames = new Vector<String>(Arrays.asList("Name", "Value"));
    private Vector<Vector<Object>> data = new Vector();
    private DefaultTableModel myTableModel = new OnSwipeTableModel(this.data, this.colNames);
    MotionSceneModel.OnSwipeTag myOnSwipeTag;
    private JBPopupMenu myPopupMenu = new JBPopupMenu("Add Attribute");
    public ActionListener myAddItemAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String attributeName = ((JMenuItem)e.getSource()).getText();
            String value = "";
            if (OnSwipePanel.this.myOnSwipeTag != null && OnSwipePanel.this.myOnSwipeTag.setValue(attributeName, value)) {
                OnSwipePanel.this.myTableModel.addRow(new Object[]{attributeName, value});
            }
        }
    };

    public OnSwipePanel(MotionLayoutAttributePanel panel) {
        super(panel);
        this.myTitle.setText("Touch Handling (onSwipe)");
        this.myTable = new JBTable((TableModel)this.myTableModel);
        this.myRemoveTagButton = EditorUtils.makeButton(TimeLineIcons.REMOVE_TAG);
        this.setup();
        this.myTable.setSelectionMode(0);
        this.myTable.setDefaultRenderer(EditorUtils.AttributesNamesHolder.class, new EditorUtils.AttributesNamesCellRenderer());
        this.myTable.setDefaultRenderer(String.class, new EditorUtils.AttributesValueCellRenderer());
        this.myTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    c.setForeground((Color)(column > 0 ? EditorUtils.ourValueColor : EditorUtils.ourNameColor));
                }
                return c;
            }
        });
        this.myPopupMenu.add(new JMenuItem("test1"));
        this.myAddRemovePanel.myAddButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                OnSwipePanel.this.myPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.myTitle, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        this.add((Component)this.myRemoveTagButton, gbc);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        ++gbc.gridy;
        gbc.fill = 1;
        this.add((Component)this.myTable, gbc);
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.anchor = 17;
        this.add((Component)this.myAddRemovePanel, gbc);
    }

    @Override
    protected void deleteAttr(int selection) {
        String attributeName = (String)this.myTable.getValueAt(selection, 0);
        if (this.myOnSwipeTag != null && this.myOnSwipeTag.deleteAttribute(attributeName)) {
            this.myTableModel.removeRow(selection);
        }
    }

    @Override
    protected void deleteTag() {
        if (this.myOnSwipeTag != null && this.myOnSwipeTag.deleteTag()) {
            this.setVisible(false);
        }
    }

    private void setupPopup(MotionSceneModel.OnSwipeTag tag, Set<String> strings) {
        this.myOnSwipeTag = tag;
        this.myPopupMenu.removeAll();
        String[] names = tag.getPossibleAttr();
        for (int i = 0; i < names.length; ++i) {
            if (strings.contains(names[i])) continue;
            JMenuItem menuItem = new JMenuItem(names[i]);
            menuItem.addActionListener(this.myAddItemAction);
            this.myPopupMenu.add(menuItem);
        }
    }

    public void setOnSwipeTag(MotionSceneModel.OnSwipeTag tag) {
        this.setVisible(tag != null);
        if (tag == null) {
            this.setVisible(false);
            return;
        }
        HashMap<String, Object> attr = tag.getAttributes();
        this.data.clear();
        for (String s : attr.keySet()) {
            Vector<Object> v = new Vector<Object>(Arrays.asList(s, attr.get(s)));
            this.data.add(v);
        }
        this.myTableModel.fireTableDataChanged();
        this.setupPopup(tag, attr.keySet());
        this.setVisible(true);
    }

    private class OnSwipeTableModel
    extends DefaultTableModel {
        private OnSwipeTableModel(@NotNull Vector data, Vector columnNames) {
            if (data == null) {
                OnSwipeTableModel.$$$reportNull$$$0(0);
            }
            if (columnNames == null) {
                OnSwipeTableModel.$$$reportNull$$$0(1);
            }
            super(data, columnNames);
        }

        @Override
        public void setValueAt(@NotNull Object value, int rowIndex, int columnIndex) {
            if (value == null) {
                OnSwipeTableModel.$$$reportNull$$$0(2);
            }
            super.setValueAt(value, rowIndex, columnIndex);
            String key = this.getValueAt(rowIndex, 0).toString();
            OnSwipePanel.this.myOnSwipeTag.setValue(key, (String)value);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnNames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/attributeEditor/OnSwipePanel$OnSwipeTableModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValueAt";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

