/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.timeline.Gantt;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttCommands;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class Chart {
    public float myPlayBackSpeed = 1.0f;
    Gantt myGantt;
    int myChartLeftInset = JBUI.scale((int)20);
    int myChartRightInset = JBUI.scale((int)20);
    public int myBottomInsert = JBUI.scale((int)20);
    static final int ourViewListWidth = JBUI.scale((int)150);
    int myContainerWidth;
    int myContainerHeight;
    private float myTimeCursorMs = 300.0f;
    float myPixelsPerMs;
    int myAnimationTotalTimeMs = 600;
    int[] myXTicksPixels = new int[20];
    int myXTickCount = 0;
    public float myZoom = 1.0f;
    float myPixelsPerPercent = 5.0f;
    private GanttCommands.Mode myMode = GanttCommands.Mode.UNKNOWN;
    public String mySelectedKeyView;
    Selection mySelection = Selection.NONE;
    MotionSceneModel myModel;
    MotionSceneModel.KeyFrame mySelectedKeyFrame;
    ArrayList<Gantt.ChartElement> myChartElements = new ArrayList();
    ArrayList<Gantt.ViewElement> myViewElements = new ArrayList();
    private static Color myTimeCursorColor = new JBColor(-12746271, -12746271);
    private static Color myTimeCursorStartColor = new JBColor(-12738063, -12725775);
    private static Color myTimeCursorEndColor = new JBColor(-12738063, -12725775);
    static Color myGridColor = new Color(-8158333);
    static Color myUnSelectedLineColor = new Color(14710170);
    static Color ourMySelectedLineColor = new Color(3701209);
    static Color ourPrimaryPanelBackground = new JBColor(0xF5F5F5, 2961201);
    static Color ourSecondaryPanelBackground = new JBColor(0xFCFCFC, 3224629);
    static Color ourAvgBackground = new JBColor(0xF8F8F8, 3092787);
    static Color ourBorder = new JBColor(0xC9C9C9, 2369063);
    static Color ourBorderLight = new JBColor(0xE8E6E6, 3948353);
    static int ourGraphHeight = JBUI.scale((int)60);
    GraphElements myGraphElements;
    private String myDelayedKeyFrameId;
    private int myDelayedKeyFramePos;
    private String myDelayedKeyType;

    public float getTimeCursorMs() {
        return this.myTimeCursorMs;
    }

    public void setTimeCursorMs(float timeCursorMs) {
        this.myTimeCursorMs = timeCursorMs;
        this.myGantt.updateLabel();
    }

    public float getAnimationTotalTimeMs() {
        return this.myAnimationTotalTimeMs;
    }

    public void setAnimationTotalTimeMs(int time2) {
        this.myAnimationTotalTimeMs = time2;
        this.update(Gantt.ChartElement.Reason.ZOOM);
    }

    public void setMotionSceneModel(MotionSceneModel model) {
        this.myModel = model;
        if (this.myModel != null) {
            int duration = this.myModel.getTransitionTag((int)0).duration;
            this.setAnimationTotalTimeMs(duration);
            this.myGantt.setDurationMs(duration);
        }
        if (this.myDelayedKeyFrameId == null && this.mySelectedKeyFrame != null) {
            this.myDelayedKeyFrameId = this.mySelectedKeyFrame.target;
            this.myDelayedKeyType = this.mySelectedKeyFrame.mType;
            this.myDelayedKeyFramePos = this.mySelectedKeyFrame.framePosition;
        }
        if (this.myDelayedKeyFrameId != null) {
            MotionSceneModel.MotionSceneView m = this.myModel.getMotionSceneView(this.myDelayedKeyFrameId);
            switch (this.myDelayedKeyType) {
                case "KeyPosition": {
                    for (MotionSceneModel.KeyPos position : m.myKeyPositions) {
                        if (position.framePosition != this.myDelayedKeyFramePos) continue;
                        this.mySelectedKeyFrame = position;
                    }
                    break;
                }
                case "KeyAttributes": {
                    for (MotionSceneModel.KeyAttributes attr : m.myKeyAttributes) {
                        if (attr.framePosition != this.myDelayedKeyFramePos) continue;
                        this.mySelectedKeyFrame = attr;
                    }
                    break;
                }
                case "KeyCycle": {
                    for (MotionSceneModel.KeyCycle cycle : m.myKeyCycles) {
                        if (cycle.framePosition != this.myDelayedKeyFramePos) continue;
                        this.mySelectedKeyFrame = cycle;
                    }
                    break;
                }
            }
            this.update(Gantt.ChartElement.Reason.SELECTION_CHANGED);
            this.myDelayedKeyFrameId = null;
        }
    }

    public void delayedSelectKeyFrame(String type, String name, int fpos) {
        this.myDelayedKeyFrameId = name;
        this.myDelayedKeyFramePos = fpos;
        this.myDelayedKeyType = type;
    }

    public static Color getColorForPosition(int position) {
        if (position == 0) {
            return myTimeCursorStartColor;
        }
        if (position == 100) {
            return myTimeCursorEndColor;
        }
        return myTimeCursorColor;
    }

    public void setMode(GanttCommands.Mode mode) {
        this.myMode = mode;
        this.update(Gantt.ChartElement.Reason.MODE_CHANGE);
    }

    public GanttCommands.Mode getMode() {
        return this.myMode;
    }

    @Nullable
    public String getSelectedKeyView() {
        return this.mySelectedKeyView;
    }

    @Nullable
    public MotionSceneModel.KeyFrame getSelectedKeyFrame() {
        return this.mySelectedKeyFrame;
    }

    public float getPlayBackSpeed() {
        return this.myPlayBackSpeed;
    }

    public float getAnimationTimeInMs() {
        return this.myAnimationTotalTimeMs;
    }

    public Chart(Gantt gantt) {
        this.myGantt = gantt;
    }

    public void setCursorPosition(float position) {
        this.setTimeCursorMs(position * (float)this.myAnimationTotalTimeMs);
        this.update(Gantt.ChartElement.Reason.CURSOR_POSITION_CHANGED);
    }

    public float getProgress() {
        return this.getTimeCursorMs() / (float)this.myAnimationTotalTimeMs;
    }

    public int getFramePosition() {
        return (int)((0.5f + 100.0f * this.getTimeCursorMs()) / (float)this.myAnimationTotalTimeMs);
    }

    public int getCursorPosition() {
        float time2 = this.getTimeCursorMs();
        return this.myChartLeftInset + (int)(time2 * this.myPixelsPerMs);
    }

    public void add(Gantt.ChartElement element) {
        this.myChartElements.add(element);
    }

    public void update(Gantt.ChartElement.Reason reason) {
        switch (reason) {
            case RESIZE: 
            case ZOOM: {
                this.updateZoom();
                break;
            }
            case SELECTION_CHANGED: {
                this.myGantt.selectionChanged();
                break;
            }
        }
        for (Gantt.ChartElement chartElement : this.myChartElements) {
            chartElement.update(reason);
        }
    }

    public void setZoom(float zoom) {
        this.myZoom = zoom;
        this.update(Gantt.ChartElement.Reason.ZOOM);
    }

    public void updateZoom() {
        int width = this.myContainerWidth - this.myChartRightInset - this.myChartLeftInset;
        this.myPixelsPerPercent = this.myZoom * (float)width / 100.0f;
        this.myPixelsPerMs = this.myZoom * (float)width / (float)this.myAnimationTotalTimeMs;
    }

    public int getmNumberOfViews() {
        return this.myViewElements.size();
    }

    public void clear() {
        this.myViewElements.clear();
    }

    public void addView(Gantt.ViewElement viewElement) {
        this.myViewElements.add(viewElement);
    }

    public int getGraphWidth() {
        return (int)(this.myPixelsPerPercent * 100.0f) + this.myChartLeftInset + this.myChartRightInset;
    }

    static enum Selection {
        NONE,
        ROW,
        KEY,
        VIEW,
        TIME_POINT;

    }

    static class GraphElements {
        final String myElement;
        final String myViewId;
        final Type myType;

        GraphElements(Type type, String viewId, String element) {
            this.myViewId = viewId;
            this.myElement = element;
            this.myType = type;
        }

        public String toString() {
            return this.myElement;
        }

        static enum Type {
            ATTRIBUTES,
            CYCLES;

        }
    }
}

