/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.timeline.Chart;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.ColumnHead;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttCommands;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttController;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.GanttEventListener;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.MotionSceneModel;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.TimeLineRows;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.TrackControls;
import com.android.tools.idea.uibuilder.handlers.motion.timeline.ViewList;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;

public class Gantt
extends JPanel
implements GanttCommands {
    public static final int HEADER_HEIGHT = JBUI.scale((int)30);
    private static final JBDimension SLIDER_DIMENSION = JBUI.size((int)140, (int)16);
    GanttController myGanttController = new GanttController();
    private Chart myChart = new Chart(this);
    private ViewList myViewList = new ViewList(this.myChart);
    private ColumnHead myColumnHead = new ColumnHead(this.myChart);
    private TimeLineRows myRowGraphc = new TimeLineRows(this.myChart);
    private JScrollPane myScrollPane = new JBScrollPane((Component)this.myRowGraphc);
    TrackControls myTrackControls = new TrackControls(this.myChart);
    JTextField myDuration;
    private DecimalFormat myFormat = new DecimalFormat("####.00");
    private MotionSceneModel myMotionSceneModel;
    private JLabel myTitleLabel;

    public Gantt(GanttEventListener listener2) {
        super(new BorderLayout());
        this.add((Component)this.buildTitleBar(), "North");
        this.add((Component)this.myScrollPane, "Center");
        this.myScrollPane.setColumnHeaderView(this.myColumnHead);
        this.myScrollPane.setRowHeaderView(this.myViewList);
        this.myScrollPane.setCorner("UPPER_LEFT_CORNER", this.myTrackControls);
        this.myScrollPane.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        JViewport viewPort = this.myScrollPane.getViewport();
        viewPort.setScrollMode(1);
        viewPort.setScrollMode(2);
        viewPort.setScrollMode(0);
        this.myRowGraphc.getAutoscrolls();
        this.myChart.myContainerHeight = this.myScrollPane.getViewport().getHeight();
        this.myChart.myContainerWidth = this.myScrollPane.getViewport().getWidth();
        this.setBackground(Chart.ourSecondaryPanelBackground);
        this.setup();
        if (listener2 != null) {
            listener2.onInit(this);
        }
        this.myGanttController.setListener(listener2);
        this.myTrackControls.setGantt(this.myGanttController);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ((Gantt)Gantt.this).myChart.myContainerHeight = Gantt.this.myScrollPane.getViewport().getHeight();
                ((Gantt)Gantt.this).myChart.myContainerWidth = Gantt.this.myScrollPane.getViewport().getWidth();
                Gantt.this.myChart.update(ChartElement.Reason.RESIZE);
            }
        });
        MouseAdapter timeLineMouse = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Gantt.this.repaint();
            }

            private float clamp(float value, float min, float max) {
                return Math.max(min, Math.min(value, max));
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int pos = e.getX();
                float timeCursorMs = (float)(pos - ((Gantt)Gantt.this).myChart.myChartLeftInset) / ((Gantt)Gantt.this).myChart.myPixelsPerMs;
                Gantt.this.myChart.setTimeCursorMs(this.clamp(timeCursorMs, 0.0f, ((Gantt)Gantt.this).myChart.myAnimationTotalTimeMs));
                float percent = Gantt.this.myChart.getTimeCursorMs() / (float)((Gantt)Gantt.this).myChart.myAnimationTotalTimeMs;
                JViewport viewPort = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, Gantt.this.myRowGraphc);
                Rectangle rec = Gantt.this.myRowGraphc.getVisibleRect();
                Gantt.this.myGanttController.framePosition(percent);
                int dx = 0;
                if (pos + 1 < rec.x) {
                    dx = pos - rec.x;
                }
                if (pos > rec.x + rec.width) {
                    dx = pos - (rec.x + rec.width);
                }
                if (dx != 0) {
                    rec.x += dx / 2;
                    Gantt.this.myRowGraphc.scrollRectToVisible(rec);
                }
                Gantt.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                float pos = (float)((int)(100.0f * Gantt.this.myChart.getTimeCursorMs() / Gantt.this.myChart.getAnimationTotalTimeMs())) / 100.0f;
                float timeCursorMs = pos * Gantt.this.myChart.getAnimationTotalTimeMs();
                Gantt.this.myChart.setTimeCursorMs(this.clamp(timeCursorMs, 0.0f, ((Gantt)Gantt.this).myChart.myAnimationTotalTimeMs));
                float percent = Gantt.this.myChart.getTimeCursorMs() / (float)((Gantt)Gantt.this).myChart.myAnimationTotalTimeMs;
                Gantt.this.myGanttController.framePosition(percent);
                Gantt.this.repaint();
            }
        };
        this.myColumnHead.addMouseMotionListener(timeLineMouse);
        this.myColumnHead.addMouseWheelListener(timeLineMouse);
        this.myColumnHead.addMouseListener(timeLineMouse);
        Dimension min = this.getMinimumSize();
        this.setMinimumSize(new Dimension(min.width, 2 * min.height));
    }

    void selectionChanged() {
        this.myGanttController.myListener.selectionEvent();
    }

    public void setZoom(float percent) {
        this.myChart.setZoom(percent);
    }

    public MotionSceneModel.KeyFrame getSelectedKey(String id) {
        return this.myChart.mySelectedKeyFrame;
    }

    public void clearSelectedKey() {
        this.myChart.mySelectedKeyFrame = null;
    }

    public MotionSceneModel.TransitionTag getTransitionTag() {
        if (this.myChart.myModel == null) {
            return null;
        }
        return this.myChart.myModel.getTransitionTag(0);
    }

    public MotionSceneModel.OnSwipeTag getOnSwipeTag() {
        return this.myChart.myModel.getOnSwipeTag();
    }

    private JPanel buildTitleBar() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder((Border)JBUI.Borders.empty((int)0, (int)JBUI.scale((int)4)));
        this.myTitleLabel = new JLabel("Timeline");
        panel.add((Component)this.myTitleLabel, "West");
        JPanel right = new JPanel();
        right.add(new JLabel("Duration(ms)"));
        this.myDuration = new JTextField();
        this.myDuration.setText("XXXXX");
        this.myDuration.setPreferredSize(this.myDuration.getPreferredSize());
        this.myDuration.setText("600");
        ((PlainDocument)this.myDuration.getDocument()).setDocumentFilter(new IntFilter());
        this.myDuration.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextField c = (JTextField)e.getSource();
                ActionListener[] listeners = c.getActionListeners();
                ActionEvent event = new ActionEvent(c, 1001, null);
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].actionPerformed(event);
                }
            }
        });
        this.myDuration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Gantt.this.myGanttController.myListener != null) {
                    int duration = Integer.parseInt(Gantt.this.myDuration.getText());
                    Gantt.this.myGanttController.myListener.transitionDuration(duration);
                    Gantt.this.myChart.setAnimationTotalTimeMs(duration);
                }
            }
        });
        this.myDuration.setAlignmentX(0.0f);
        right.add(this.myDuration);
        right.add(new JLabel(StudioIcons.LayoutEditor.Motion.MIN_SCALE));
        right.add(this.createZoomSlider());
        right.add(new JLabel(StudioIcons.LayoutEditor.Motion.MAX_SCALE));
        panel.add((Component)right, "East");
        return panel;
    }

    @NotNull
    private JSlider createZoomSlider() {
        JSlider slider = new JSlider();
        slider.setPreferredSize((Dimension)SLIDER_DIMENSION);
        slider.setValue(0);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Gantt.this.setZoom(1.0f + (float)((JSlider)e.getSource()).getValue() / 25.0f);
            }
        });
        JSlider jSlider = slider;
        if (jSlider == null) {
            Gantt.$$$reportNull$$$0(0);
        }
        return jSlider;
    }

    public void setDurationMs(int time2) {
        this.myDuration.setText(Integer.toString(time2));
    }

    void updateLabel() {
        String s;
        switch (this.myChart.getMode()) {
            case START: {
                s = "Start Constraint " + this.myFormat.format(this.myChart.getTimeCursorMs()) + "ms";
                break;
            }
            case END: {
                s = "End Constraint " + this.myFormat.format(this.myChart.getTimeCursorMs()) + "ms";
                break;
            }
            default: {
                s = "Timeline " + this.myFormat.format(this.myChart.getTimeCursorMs()) + "ms";
            }
        }
        this.myTitleLabel.setText(s);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.myRowGraphc == null) {
            return;
        }
        this.myRowGraphc.setBackground(bg);
        this.myViewList.setBackground(bg);
        this.myTrackControls.setBackground(bg);
        this.myScrollPane.setBackground(bg);
        this.myColumnHead.setBackground(bg);
    }

    public void setup() {
    }

    public Chart getChart() {
        return this.myChart;
    }

    public MotionSceneModel getMotionScene() {
        return this.myMotionSceneModel;
    }

    public void setMotionScene(MotionSceneModel motionScene) {
        this.myMotionSceneModel = motionScene;
        if (motionScene.myTransition != null && !motionScene.myTransition.isEmpty()) {
            this.myDuration.setText(Integer.toString(motionScene.myTransition.get((int)0).duration));
        }
        this.myChart.clear();
        for (String s : motionScene.mySceneViews.keySet()) {
            this.myChart.addView(new ViewElement(s, motionScene.mySceneViews.get(s)));
        }
        this.myChart.update(ChartElement.Reason.ADDVIEW);
        this.myChart.setMotionSceneModel(this.myMotionSceneModel);
        this.validate();
        this.repaint();
    }

    @Override
    public void setProgress(float percent) {
        this.myChart.setCursorPosition(percent);
    }

    @Override
    public void setMode(GanttCommands.Mode mode) {
        this.myChart.setMode(mode);
    }

    @Override
    public GanttCommands.Mode getMode() {
        return this.myChart.getMode();
    }

    @Override
    public void update() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/motion/timeline/Gantt", "createZoomSlider"));
    }

    static interface ChartElement {
        public void update(Reason var1);

        public void repaint();

        public void invalidate();

        public static enum Reason {
            RESIZE,
            ADDVIEW,
            SELECTION_CHANGED,
            ZOOM,
            CONSTRUCTION,
            MODE_CHANGE,
            CURSOR_POSITION_CHANGED,
            GRAPH_SELECTED,
            OTHER;

        }
    }

    static class ViewElement {
        String myName;
        int myYStart;
        int myHeight;
        boolean myHasAttribute = false;
        boolean myHasCycle = false;
        boolean myHasPosition = false;
        int myHeightView = 0;
        int myHeightAttribute = 0;
        int myHeightCycle = 0;
        int myHeightPosition = 0;
        MotionSceneModel.MotionSceneView mKeyFrames;

        public ViewElement(String name, MotionSceneModel.MotionSceneView keyFrames) {
            this.myName = name;
            this.mKeyFrames = keyFrames;
        }

        public String toString() {
            return this.myName;
        }

        public Icon getIcon() {
            return this.mKeyFrames.getIcon();
        }

        ViewElement(String name) {
        }
    }

    static class IntFilter
    extends DocumentFilter {
        IntFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.insert(offset, string);
            if (this.test(sb.toString())) {
                super.insertString(fb, offset, string, attr);
            }
        }

        private boolean test(String text) {
            try {
                Integer.parseInt(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.replace(offset, offset + length, text);
            if (this.test(sb.toString())) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            Document doc = fb.getDocument();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.delete(offset, offset + length);
            if (this.test(sb.toString())) {
                super.remove(fb, offset, length);
            }
        }
    }
}

