/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.timeline;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.handlers.motion.MotionSceneString;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.NamedNodeMap;

public class MotionSceneModel {
    public static final boolean BROKEN = true;
    HashMap<String, MotionSceneView> mySceneViews = new HashMap();
    ArrayList<ConstraintSet> myConstraintSets;
    ArrayList<TransitionTag> myTransition;
    OnSwipeTag myOnSwipeTag;
    private VirtualFile myVirtualFile;
    private Project myProject;
    private NlModel myNlModel;

    public TransitionTag getTransitionTag(int i) {
        return this.myTransition.get(i);
    }

    public OnSwipeTag getOnSwipeTag() {
        return this.myOnSwipeTag;
    }

    private XmlFile motionSceneFile() {
        return (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.myProject, this.myVirtualFile);
    }

    public ConstraintSet getStartConstraintSet() {
        TransitionTag tag = this.myTransition.get(0);
        return tag.getConstraintSetStart();
    }

    public ConstraintSet getEndConstraintSet() {
        TransitionTag tag = this.myTransition.get(0);
        return tag.getConstraintSetEnd();
    }

    public MotionSceneView getMotionSceneView(@NotNull String viewId) {
        if (viewId == null) {
            MotionSceneModel.$$$reportNull$$$0(0);
        }
        return this.mySceneViews.get(viewId);
    }

    public void createKeyFrame(final String type, final int framePosition, final String id) {
        final XmlFile xmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.myProject, this.myVirtualFile);
        switch (type) {
            case "KeyPosition": {
                for (KeyPos keys : this.mySceneViews.get((Object)id).myKeyPositions) {
                    if (keys.framePosition != framePosition) continue;
                    return;
                }
                break;
            }
            case "KeyAttribute": {
                for (KeyAttributes keys : this.mySceneViews.get((Object)id).myKeyAttributes) {
                    if (keys.framePosition != framePosition) continue;
                    return;
                }
                break;
            }
            case "KeyCycle": {
                for (KeyCycle keys : this.mySceneViews.get((Object)id).myKeyCycles) {
                    if (keys.framePosition != framePosition) continue;
                    return;
                }
                break;
            }
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (Runnable)new Runnable(){

            @Override
            public void run() {
                XmlTag keyFrame = null;
                XmlTag[] tags = xmlFile.getRootTag().getSubTags();
                for (int i = 0; i < tags.length; ++i) {
                    XmlTag tag = tags[i];
                    String keyNodeName = tag.getName();
                    if (!keyNodeName.equals("KeyFrameSet")) continue;
                    keyFrame = tag;
                    break;
                }
                if (keyFrame == null) {
                    keyFrame = xmlFile.getRootTag().createChildTag("KeyFrameSet", null, null, false);
                    keyFrame = xmlFile.getRootTag().addSubTag(keyFrame, false);
                }
                XmlTag createdTag = keyFrame.createChildTag(type, null, null, false);
                createdTag = keyFrame.addSubTag(createdTag, false);
                createdTag.setAttribute("framePosition", "http://schemas.android.com/apk/res-auto", Integer.toString(framePosition));
                createdTag.setAttribute("target", "http://schemas.android.com/apk/res-auto", "@id/" + id);
                if (type.equals("KeyPosition")) {
                    createdTag.setAttribute("type", "http://schemas.android.com/apk/res-auto", "cartesian");
                }
            }
        });
        if (this.myNlModel != null) {
            LayoutPullParsers.saveFileIfNecessary((PsiFile)xmlFile);
            this.myNlModel.notifyModified(NlModel.ChangeType.EDIT);
        }
    }

    private static void parse(AttributeParse a, XmlAttribute[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            XmlAttribute attribute = attributes[i];
            MotionSceneModel.parse(a, attribute.getName(), attribute.getValue());
        }
    }

    private static void parse(AttributeParse a, String name, String value) {
        a.parse(name, value);
    }

    public static MotionSceneModel parse(NlModel model, Project project, VirtualFile virtualFile, XmlFile file) {
        int i;
        MotionSceneModel motionSceneModel = new MotionSceneModel();
        ArrayList<ConstraintSet> constraintSet = new ArrayList<ConstraintSet>();
        motionSceneModel.myNlModel = model;
        motionSceneModel.myVirtualFile = virtualFile;
        motionSceneModel.myProject = project;
        XmlTag[] tagKeyFrames = file.getRootTag().findSubTags("ConstraintSet");
        for (int i2 = 0; i2 < tagKeyFrames.length; ++i2) {
            XmlTag frame = tagKeyFrames[i2];
            ConstraintSet set = new ConstraintSet();
            set.setId(frame.getAttributeValue("android:id"));
            MotionSceneModel.parse(set, frame.getAttributes());
            constraintSet.add(set);
            XmlTag[] subTags = frame.getSubTags();
            for (int j = 0; j < subTags.length; ++j) {
                XmlTag subtag = subTags[j];
                if (!"Constraint".equals(subtag.getName())) continue;
                ConstraintView view = new ConstraintView();
                view.setId(subtag.getAttributeValue("android:id"));
                motionSceneModel.addKeyFrame(view.mId);
                MotionSceneModel.parse(view, subtag.getAttributes());
                set.myConstraintViews.put(view.mId, view);
            }
        }
        motionSceneModel.myConstraintSets = constraintSet;
        XmlTag[] transitionTags = file.getRootTag().findSubTags("Transition");
        if (transitionTags.length > 0) {
            motionSceneModel.myTransition = new ArrayList();
        }
        for (int i3 = 0; i3 < transitionTags.length; ++i3) {
            TransitionTag transition = new TransitionTag(motionSceneModel);
            XmlTag tag = transitionTags[i3];
            MotionSceneModel.parse(transition, tag.getAttributes());
            motionSceneModel.myTransition.add(transition);
        }
        XmlTag[] onSwipeTags = file.getRootTag().findSubTags("OnSwipe");
        for (i = 0; i < onSwipeTags.length; ++i) {
            OnSwipeTag onSwipeTag = new OnSwipeTag(motionSceneModel);
            XmlTag tag = onSwipeTags[i];
            MotionSceneModel.parse(onSwipeTag, tag.getAttributes());
            motionSceneModel.myOnSwipeTag = onSwipeTag;
        }
        tagKeyFrames = file.getRootTag().findSubTags("KeyFrameSet");
        for (i = 0; i < tagKeyFrames.length; ++i) {
            XmlTag tagKeyFrame = tagKeyFrames[i];
            XmlTag[] tagkey = tagKeyFrame.getSubTags();
            for (int j = 0; j < tagkey.length; ++j) {
                AttributeParse custom;
                XmlTag tag;
                int k;
                XmlTag xmlTag = tagkey[j];
                XmlTag[] customTags = xmlTag.getSubTags();
                String keyNodeName = xmlTag.getName();
                KeyFrame frame = null;
                if ("KeyPosition".equals(keyNodeName)) {
                    frame = new KeyPosition(motionSceneModel);
                } else if ("KeyAttribute".equals(keyNodeName)) {
                    frame = new KeyAttributes(motionSceneModel);
                    for (k = 0; k < customTags.length; ++k) {
                        tag = customTags[k];
                        custom = new CustomAttributes((KeyAttributes)frame);
                        MotionSceneModel.parse(custom, tag.getAttributes());
                        ((KeyAttributes)frame).myCustomAttributes.add((CustomAttributes)custom);
                    }
                } else if ("KeyCycle".equals(keyNodeName)) {
                    frame = new KeyCycle(motionSceneModel);
                    for (k = 0; k < customTags.length; ++k) {
                        tag = customTags[k];
                        custom = new CustomCycleAttributes((KeyCycle)frame);
                        MotionSceneModel.parse(custom, tag.getAttributes());
                        ((KeyCycle)frame).myCustomAttributes.add((CustomCycleAttributes)custom);
                    }
                } else {
                    System.err.println("Unknown name :" + keyNodeName);
                }
                if (frame == null) continue;
                frame.parse(xmlTag.getAttributes());
                motionSceneModel.addKeyFrame(frame);
            }
        }
        return motionSceneModel;
    }

    public static ArrayList<KeyFrame> filterList(ArrayList<? extends KeyFrame> keyList, String name) {
        ArrayList<KeyFrame> ret = new ArrayList<KeyFrame>();
        for (KeyFrame keyFrame : keyList) {
            if (!keyFrame.myAttributes.containsKey(name)) continue;
            ret.add(keyFrame);
        }
        return ret;
    }

    public static String[] getGraphAttributes(ArrayList<? extends KeyFrame> keyList) {
        HashSet<String> set = new HashSet<String>();
        for (KeyFrame keyFrame : keyList) {
            if (keyFrame instanceof KeyAttributes) {
                set.addAll(keyFrame.myAttributes.keySet());
                continue;
            }
            if (!(keyFrame instanceof KeyCycle)) continue;
            set.addAll(keyFrame.myAttributes.keySet());
        }
        return set.toArray(new String[set.size()]);
    }

    void addKeyFrame(String id) {
        MotionSceneView motionView = this.mySceneViews.get(id);
        if (motionView == null) {
            motionView = new MotionSceneView();
            motionView.myModel = this;
            motionView.mid = id;
            this.mySceneViews.put(id, motionView);
        }
    }

    void addKeyFrame(KeyFrame frame) {
        String id = frame.target;
        MotionSceneView motionView = this.mySceneViews.get(id);
        if (motionView == null) {
            motionView = new MotionSceneView();
            motionView.myModel = this;
            motionView.mid = id;
            this.mySceneViews.put(id, motionView);
        }
        if (frame instanceof KeyAttributes) {
            motionView.myKeyAttributes.add((KeyAttributes)frame);
        } else if (frame instanceof KeyPos) {
            motionView.myKeyPositions.add((KeyPos)frame);
        } else if (frame instanceof KeyCycle) {
            motionView.myKeyCycles.add((KeyCycle)frame);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewId", "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel", "getMotionSceneView"));
    }

    static class ConstraintView
    implements AttributeParse {
        String mId;
        HashMap<String, Object> myAllAttributes = new HashMap();
        HashMap<String, String> myConstraintViews = new HashMap();

        ConstraintView() {
        }

        void setId(String id) {
            this.mId = id.substring(id.indexOf(47) + 1);
        }

        @Override
        public void parse(String name, String value) {
            this.myAllAttributes.put(name, value);
        }
    }

    public static class OnSwipeTag
    extends BaseTag
    implements AttributeParse {
        HashMap<String, Object> myAllAttributes;
        public static String[] ourPossibleAttr = new String[]{"maxVelocity", "maxAcceleration", "touchSide", "touchAnchorId", "touchAnchorSide"};
        public String[] myPossibleAttr;

        public String[] getPossibleAttr() {
            return this.myPossibleAttr;
        }

        public HashMap<String, Object> getAttributes() {
            return this.myAllAttributes;
        }

        OnSwipeTag(@NotNull MotionSceneModel model) {
            if (model == null) {
                OnSwipeTag.$$$reportNull$$$0(0);
            }
            super(model, "OnSwipe");
            this.myAllAttributes = new HashMap();
            this.myPossibleAttr = ourPossibleAttr;
            this.myPossibleAttr = ourPossibleAttr;
        }

        @Override
        @Nullable
        public XmlTag findMyTag() {
            XmlTag root;
            XmlFile xmlFile = this.myMotionSceneModel.motionSceneFile();
            XmlTag xmlTag = root = xmlFile != null ? xmlFile.getRootTag() : null;
            if (root == null) {
                return null;
            }
            XmlTag[] onSwipes = root.findSubTags("OnSwipe");
            if (onSwipes.length == 0) {
                return null;
            }
            return onSwipes[0];
        }

        @Override
        public void parse(String name, String value) {
            name = name.substring(name.lastIndexOf(58) + 1);
            this.myAllAttributes.put(name, value);
        }

        @Override
        @Nullable
        public String getValue(@NotNull String key) {
            Object value;
            if (key == null) {
                OnSwipeTag.$$$reportNull$$$0(1);
            }
            return (value = this.myAllAttributes.get(key)) != null ? value.toString() : null;
        }

        @Override
        @NotNull
        public Set<String> getAttributeNames() {
            Set<String> set = this.myAllAttributes.keySet();
            if (set == null) {
                OnSwipeTag.$$$reportNull$$$0(2);
            }
            return set;
        }

        @Override
        public boolean deleteAttribute(@NotNull String attributeName) {
            if (attributeName == null) {
                OnSwipeTag.$$$reportNull$$$0(3);
            }
            if (!super.deleteAttribute(attributeName)) {
                return false;
            }
            this.myAllAttributes.remove(attributeName);
            return true;
        }

        public boolean deleteTag() {
            return this.deleteTag("Delete OnSwing");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$OnSwipeTag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$OnSwipeTag";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributeNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteAttribute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TransitionTag
    extends BaseTag
    implements AttributeParse {
        private final String[] myPossibleAttr;
        String myConstraintSetEnd;
        String myConstraintSetStart;
        int duration;
        HashMap<String, Object> myAllAttributes = new HashMap();
        public static String[] ourPossibleAttr = new String[]{"constraintSetStart", "constraintSetEnd", "duration", "staggered"};

        public String[] getPossibleAttr() {
            return this.myPossibleAttr;
        }

        public HashMap<String, Object> getAttributes() {
            return this.myAllAttributes;
        }

        TransitionTag(MotionSceneModel model) {
            super(model, "Transition");
            this.myPossibleAttr = ourPossibleAttr;
        }

        public ConstraintSet getConstraintSetEnd() {
            if (this.myConstraintSetEnd == null) {
                return null;
            }
            for (ConstraintSet set : this.myMotionSceneModel.myConstraintSets) {
                if (!this.myConstraintSetEnd.equals(set.mId)) continue;
                return set;
            }
            return null;
        }

        public ConstraintSet getConstraintSetStart() {
            if (this.myConstraintSetStart == null) {
                return null;
            }
            for (ConstraintSet set : this.myMotionSceneModel.myConstraintSets) {
                if (!this.myConstraintSetStart.equals(set.mId)) continue;
                return set;
            }
            return null;
        }

        @Override
        public void parse(String name, String value) {
            name = name.substring(name.lastIndexOf(58) + 1);
            this.myAllAttributes.put(name, value);
            if (name.endsWith("constraintSetEnd")) {
                this.myConstraintSetEnd = value;
            } else if (name.endsWith("constraintSetStart")) {
                this.myConstraintSetStart = value;
            } else if (name.endsWith("duration")) {
                this.duration = Integer.parseInt(value);
            }
        }

        @Override
        @Nullable
        public XmlTag findMyTag() {
            XmlTag root;
            XmlFile xmlFile = this.myMotionSceneModel.motionSceneFile();
            XmlTag xmlTag = root = xmlFile != null ? xmlFile.getRootTag() : null;
            if (root == null) {
                return null;
            }
            XmlTag[] onSwipes = root.findSubTags("Transition");
            if (onSwipes.length == 0) {
                return null;
            }
            return onSwipes[0];
        }

        @Override
        public boolean deleteTag(@NotNull String command) {
            if (command == null) {
                TransitionTag.$$$reportNull$$$0(0);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Set<String> getAttributeNames() {
            Set<String> set = this.myAllAttributes.keySet();
            if (set == null) {
                TransitionTag.$$$reportNull$$$0(1);
            }
            return set;
        }

        @Override
        @Nullable
        public String getValue(@NotNull String key) {
            Object value;
            if (key == null) {
                TransitionTag.$$$reportNull$$$0(2);
            }
            return (value = this.myAllAttributes.get(key)) != null ? value.toString() : null;
        }

        @Override
        public boolean setValue(@NotNull String key, @NotNull String value) {
            if (key == null) {
                TransitionTag.$$$reportNull$$$0(3);
            }
            if (value == null) {
                TransitionTag.$$$reportNull$$$0(4);
            }
            if (!super.setValue(key, value)) {
                return false;
            }
            this.parse(key, value);
            return true;
        }

        @Override
        public boolean deleteAttribute(@NotNull String attributeName) {
            if (attributeName == null) {
                TransitionTag.$$$reportNull$$$0(5);
            }
            if (!super.deleteAttribute(attributeName)) {
                return false;
            }
            this.myAllAttributes.remove(attributeName);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$TransitionTag";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$TransitionTag";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributeNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteTag";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteAttribute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ConstraintSet
    implements AttributeParse {
        String mId;
        HashMap<String, ConstraintView> myConstraintViews = new HashMap();

        ConstraintSet() {
        }

        void setId(String id) {
            this.mId = id.substring(id.indexOf(47) + 1);
        }

        @Override
        public void parse(String name, String value) {
            if ("android:id".equals(name)) {
                this.mId = value;
            }
        }
    }

    static interface AttributeParse {
        public void parse(String var1, String var2);
    }

    public static class CustomAttributes
    extends BaseTag
    implements AttributeParse {
        private final KeyAttributes parentKeyAttributes;
        private final HashMap<String, Object> myAttributes;

        @Nullable
        public String getAttributeName() {
            return (String)this.myAttributes.get("attributeName");
        }

        @Nullable
        public String getValueTagName() {
            return Arrays.stream(Type.values()).map(key -> key.getTagName()).filter(tag -> this.myAttributes.containsKey(tag)).findFirst().orElse(null);
        }

        public String toString() {
            return Arrays.toString(this.myAttributes.keySet().toArray());
        }

        public boolean deleteTag() {
            if (!super.deleteTag("Remove custom attribute")) {
                return false;
            }
            this.parentKeyAttributes.getCustomAttributes().remove(this);
            return true;
        }

        @Override
        @NotNull
        public Set<String> getAttributeNames() {
            Set<String> set = Collections.singleton(this.getAttributeName());
            if (set == null) {
                CustomAttributes.$$$reportNull$$$0(0);
            }
            return set;
        }

        @Override
        @Nullable
        public String getValue(@NotNull String key) {
            Object value;
            if (key == null) {
                CustomAttributes.$$$reportNull$$$0(1);
            }
            return (value = this.myAttributes.get(key)) != null ? value.toString() : null;
        }

        @Override
        public boolean setValue(@NotNull String key, @NotNull String value) {
            if (key == null) {
                CustomAttributes.$$$reportNull$$$0(2);
            }
            if (value == null) {
                CustomAttributes.$$$reportNull$$$0(3);
            }
            if (!super.setValue(key, value)) {
                return false;
            }
            this.parse(key, value);
            return true;
        }

        @Override
        public boolean deleteAttribute(@NotNull String attributeName) {
            if (attributeName == null) {
                CustomAttributes.$$$reportNull$$$0(4);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public XmlTag findMyTag() {
            XmlTag[] customAttrs;
            String attributeName = (String)this.myAttributes.get("attributeName");
            if (StringUtil.isEmpty((String)attributeName)) {
                return null;
            }
            XmlTag parent = this.parentKeyAttributes.findMyTag();
            if (parent == null) {
                return null;
            }
            for (XmlTag tag : customAttrs = parent.findSubTags("CustomAttribute")) {
                if (!attributeName.equals(tag.getAttributeValue("attributeName", "http://schemas.android.com/apk/res-auto"))) continue;
                return tag;
            }
            return null;
        }

        public CustomAttributes(@NotNull KeyAttributes frame) {
            if (frame == null) {
                CustomAttributes.$$$reportNull$$$0(5);
            }
            super(frame.getModel(), "");
            this.myAttributes = new HashMap();
            this.parentKeyAttributes = frame;
        }

        public HashMap<String, Object> getAttributes() {
            return this.myAttributes;
        }

        @Override
        public void parse(String name, String value) {
            this.myAttributes.put(name.substring(name.lastIndexOf(58) + 1), value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$CustomAttributes";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributeName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributeNames";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$CustomAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteAttribute";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum Type {
            CUSTOM_COLOR("Color", "customColorValue", "#FFF"),
            CUSTOM_INTEGER("Integer", "customIntegerValue", "2"),
            CUSTOM_FLOAT("Float", "customFloatValue", "1.0"),
            CUSTOM_STRING("String", "customStringValue", "Example"),
            CUSTOM_DIMENSION("Dimension", "customDimension", "20dp"),
            CUSTOM_BOOLEAN("Boolean", "customBoolean", "true");

            private final String myStringValue;
            private final String myTagName;
            private final String myDefaultValue;

            @NotNull
            public String getTagName() {
                String string = this.myTagName;
                if (string == null) {
                    Type.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getDefaultValue() {
                String string = this.myDefaultValue;
                if (string == null) {
                    Type.$$$reportNull$$$0(1);
                }
                return string;
            }

            public String toString() {
                return this.myStringValue;
            }

            private Type(@NotNull String stringValue, String tagName, String defaultValue) {
                if (stringValue == null) {
                    Type.$$$reportNull$$$0(2);
                }
                if (tagName == null) {
                    Type.$$$reportNull$$$0(3);
                }
                if (defaultValue == null) {
                    Type.$$$reportNull$$$0(4);
                }
                this.myStringValue = stringValue;
                this.myTagName = tagName;
                this.myDefaultValue = defaultValue;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$CustomAttributes$Type";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stringValue";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tagName";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "defaultValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTagName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultValue";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$CustomAttributes$Type";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    public static class CustomCycleAttributes
    implements AttributeParse {
        KeyCycle parentKeyCycle;
        HashMap<String, Object> myAttributes = new HashMap();
        public static String[] ourPossibleAttr = new String[]{"attributeName", "customIntegerValue", "customFloatValue", "customDimension"};
        public static String[][] ourDefaults = new String[][]{new String[0], {"1"}, {"1.0"}, {"20dp"}};

        public String[] getDefault(String key) {
            for (int i = 0; i < ourPossibleAttr.length; ++i) {
                if (!key.equals(ourPossibleAttr[i])) continue;
                return ourDefaults.length > i ? ourDefaults[i] : ourDefaults[0];
            }
            return ourDefaults[0];
        }

        public CustomCycleAttributes(KeyCycle frame) {
            this.parentKeyCycle = frame;
        }

        @Override
        public void parse(String name, String value) {
            this.myAttributes.put(name, value);
        }
    }

    public static class KeyCycle
    extends KeyFrame {
        float waveOffset = Float.NaN;
        float wavePeriod = Float.NaN;
        ArrayList<CustomCycleAttributes> myCustomAttributes = new ArrayList();
        String waveShape;
        public static String[] ourPossibleAttr = new String[]{"target", "framePosition", "transitionEasing", "curveFit", "progress", "waveShape", "wavePeriod", "waveOffset", "transitionPathRotate", "alpha", "elevation", "rotation", "rotationX", "rotationY", "scaleX", "scaleY", "translationX", "translationY", "translationZ"};
        public static String[][] ourDefaults = new String[][]{new String[0], new String[0], {"curve=(0.5,0,0.5,1)"}, {"spline", "linear"}, {"0.5"}, {"sin", "square", "triangle", "sawtooth", "reverseSawtooth", "cos", "bounce"}, {"1"}, {"0"}, {"90"}, {"0.5"}, {"20dp"}, {"45"}, {"10"}, {"10"}, {"1.5"}, {"1.5"}, {"20dp"}, {"20dp"}, {"20dp"}};
        public static String[] ourPossibleStandardAttr = new String[]{"alpha", "elevation", "rotation", "rotationX", "rotationY", "scaleX", "scaleY", "translationX", "translationY", "translationZ"};
        HashSet<String> myAndroidAttributes = null;

        @Override
        public String[] getDefault(String key) {
            for (int i = 0; i < ourPossibleAttr.length; ++i) {
                if (!key.equals(ourPossibleAttr[i])) continue;
                return ourDefaults.length > i ? ourDefaults[i] : ourDefaults[0];
            }
            return ourDefaults[0];
        }

        public String toString() {
            return this.getName() + Arrays.toString(this.myAttributes.keySet().toArray());
        }

        @Override
        public boolean isAndroidAttribute(@NotNull String attributeName) {
            if (attributeName == null) {
                KeyCycle.$$$reportNull$$$0(0);
            }
            if (this.myAndroidAttributes == null) {
                this.myAndroidAttributes = new HashSet<String>(Arrays.asList(ourPossibleStandardAttr));
            }
            return this.myAndroidAttributes.contains(attributeName);
        }

        public KeyCycle(MotionSceneModel motionSceneModel) {
            super(motionSceneModel, "Cycle");
            this.mType = "KeyCycle";
            this.myPossibleAttr = ourPossibleAttr;
        }

        @Override
        public void fill(HashMap<String, Object> attributes) {
            attributes.putAll(this.myAttributes);
            if (!Float.isNaN(this.waveOffset)) {
                attributes.put("waveOffset", Float.valueOf(this.waveOffset));
            }
            if (!Float.isNaN(this.wavePeriod)) {
                attributes.put("wavePeriod", Float.valueOf(this.wavePeriod));
            }
            if (this.waveShape != null) {
                attributes.put("waveOffset", this.waveShape);
            }
            super.fill(attributes);
        }

        @Override
        @Nullable
        public String getValue(@NotNull String key) {
            if (key == null) {
                KeyCycle.$$$reportNull$$$0(1);
            }
            switch (key) {
                case "waveOffset": {
                    return String.valueOf(this.waveOffset);
                }
                case "wavePeriod": {
                    return String.valueOf(this.wavePeriod);
                }
                case "waveShape": {
                    return String.valueOf(this.waveShape);
                }
            }
            return super.getValue(key);
        }

        @Override
        void parse(String node, String value) {
            if (node.endsWith("waveOffset")) {
                this.waveOffset = this.fparse(value);
            } else if (node.endsWith("wavePeriod")) {
                this.wavePeriod = Float.parseFloat(value);
            } else if (node.endsWith("waveShape")) {
                this.waveShape = value;
            }
            super.parse(node, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributeName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$KeyCycle";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAndroidAttribute";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class KeyAttributes
    extends KeyFrame {
        String curveFit = null;
        ArrayList<CustomAttributes> myCustomAttributes = new ArrayList();
        public static String[] ourPossibleAttr = new String[]{"framePosition", "target", "transitionEasing", "curveFit", "sizePercent", "progress", "orientation", "alpha", "elevation", "rotation", "rotationX", "rotationY", "transitionPathRotate", "scaleX", "scaleY", "translationX", "translationY", "translationZ", "Custom..."};
        public static String[][] ourDefaults = new String[][]{new String[0], new String[0], {"curve=(0.5,0,0.5,1)"}, {"spline", "linear"}, {"0.5"}, {"0.5"}, {"90"}, {"0.5"}, {"5dp"}, {"45"}, {"10"}, {"10"}, {"90"}, {"1.5"}, {"1.5"}, {"10dp"}, {"10dp"}, {"10dp"}};
        public static String[] ourPossibleStandardAttr = new String[]{"orientation", "alpha", "elevation", "rotation", "rotationX", "rotationY", "scaleX", "scaleY", "translationX", "translationY", "translationZ"};
        HashSet<String> myAndroidAttributes = null;

        @Override
        @NotNull
        public List<CustomAttributes> getCustomAttributes() {
            ArrayList<CustomAttributes> arrayList = this.myCustomAttributes;
            if (arrayList == null) {
                KeyAttributes.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        @Override
        public String[] getDefault(String key) {
            for (int i = 0; i < ourPossibleAttr.length; ++i) {
                if (!key.equals(ourPossibleAttr[i])) continue;
                return ourDefaults.length > i ? ourDefaults[i] : ourDefaults[0];
            }
            return ourDefaults[0];
        }

        @Override
        public boolean isAndroidAttribute(@NotNull String attributeName) {
            if (attributeName == null) {
                KeyAttributes.$$$reportNull$$$0(1);
            }
            if (this.myAndroidAttributes == null) {
                this.myAndroidAttributes = new HashSet<String>(Arrays.asList(ourPossibleStandardAttr));
            }
            return this.myAndroidAttributes.contains(attributeName);
        }

        public KeyAttributes(MotionSceneModel motionSceneModel) {
            super(motionSceneModel, "Targeted Attributes");
            this.mType = "KeyAttribute";
            this.myPossibleAttr = ourPossibleAttr;
        }

        @Override
        public void fill(HashMap<String, Object> attributes) {
            attributes.putAll(this.myAttributes);
            if (this.curveFit != null) {
                attributes.put("curveFit", this.curveFit);
            }
            super.fill(attributes);
        }

        @Override
        @Nullable
        public String getValue(@NotNull String key) {
            if (key == null) {
                KeyAttributes.$$$reportNull$$$0(2);
            }
            switch (key) {
                case "curveFit": {
                    return this.curveFit;
                }
            }
            return super.getValue(key);
        }

        @Override
        void parse(String node, String value) {
            if (node.endsWith("curveFit")) {
                this.curveFit = value;
            } else if (MotionSceneString.ourStandardSet.contains(node)) {
                this.myAttributes.put(node, value);
            } else if (node.endsWith("framePosition") || node.endsWith("")) {
                super.parse(node, value);
            } else {
                this.myAttributes.put(node, new Float(value));
            }
        }

        @Override
        @Nullable
        public CustomAttributes createCustomAttribute(@NotNull String key, @NotNull CustomAttributes.Type type, @NotNull String value) {
            XmlTag keyFrame;
            if (key == null) {
                KeyAttributes.$$$reportNull$$$0(3);
            }
            if (type == null) {
                KeyAttributes.$$$reportNull$$$0(4);
            }
            if (value == null) {
                KeyAttributes.$$$reportNull$$$0(5);
            }
            if ((keyFrame = this.findMyTag()) == null) {
                return null;
            }
            List existing = this.myCustomAttributes.stream().filter(attr -> {
                if (key == null) {
                    KeyAttributes.$$$reportNull$$$0(9);
                }
                return key.equals(attr.getAttributeName());
            }).collect(Collectors.toList());
            for (CustomAttributes attr2 : existing) {
                attr2.deleteTag();
            }
            Computable operation = () -> {
                if (key == null) {
                    KeyAttributes.$$$reportNull$$$0(6);
                }
                if (type == null) {
                    KeyAttributes.$$$reportNull$$$0(7);
                }
                if (value == null) {
                    KeyAttributes.$$$reportNull$$$0(8);
                }
                XmlTag createdTag = keyFrame.createChildTag("CustomAttribute", null, null, false);
                createdTag = keyFrame.addSubTag(createdTag, false);
                createdTag.setAttribute("attributeName", "http://schemas.android.com/apk/res-auto", key);
                createdTag.setAttribute(type.getTagName(), "http://schemas.android.com/apk/res-auto", StringUtil.isNotEmpty((String)value) ? value : type.getDefaultValue());
                CustomAttributes custom = new CustomAttributes(this);
                Arrays.stream(createdTag.getAttributes()).forEach(attr -> custom.parse(attr.getLocalName(), attr.getValue()));
                this.myCustomAttributes.add(custom);
                return custom;
            };
            CustomAttributes newAttribute = (CustomAttributes)WriteCommandAction.runWriteCommandAction((Project)this.myMotionSceneModel.myProject, (Computable)operation);
            this.completeSceneModelUpdate();
            return newAttribute;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$KeyAttributes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributeName";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCustomAttributes";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$KeyAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAndroidAttribute";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomAttribute";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$createCustomAttribute$2";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$createCustomAttribute$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class KeyPosition
    extends KeyPos {
        float percentX = Float.NaN;
        float percentY = Float.NaN;
        public static String[] ourPossibleAttr = new String[]{"framePosition", "target", "transitionEasing", "curveFit", "drawPath", "sizePercent", "sizePercent", "percentY", "percentX", "type"};
        public static String[][] ourDefaults = new String[][]{new String[0], new String[0], {"cubic(0.5,0,0.5,1)"}, {"spline", "linear"}, {"true", "false"}, {"0.5"}, {"0.0"}, {"0.5"}};

        @Override
        public String[] getDefault(String key) {
            for (int i = 0; i < ourPossibleAttr.length; ++i) {
                if (!key.equals(ourPossibleAttr[i])) continue;
                return ourDefaults.length > i ? ourDefaults[i] : ourDefaults[0];
            }
            return ourDefaults[0];
        }

        public KeyPosition(MotionSceneModel motionSceneModel) {
            super(motionSceneModel);
            this.myPossibleAttr = ourPossibleAttr;
            this.mType = "KeyPosition";
        }

        @Override
        public void fill(HashMap<String, Object> attributes) {
            if (!Float.isNaN(this.percentX)) {
                attributes.put("path_percent", Float.valueOf(this.percentX));
            }
            if (!Float.isNaN(this.percentY)) {
                attributes.put("perpendicularPath_percent", Float.valueOf(this.percentY));
            }
            super.fill(attributes);
        }

        @Override
        @Nullable
        public String getValue(@NotNull String key) {
            if (key == null) {
                KeyPosition.$$$reportNull$$$0(0);
            }
            switch (key) {
                case "path_percent": {
                    return String.valueOf(this.percentX);
                }
                case "perpendicularPath_percent": {
                    return String.valueOf(this.percentY);
                }
            }
            return super.getValue(key);
        }

        @Override
        public float getFloat(String type) {
            if ("perpendicularPath_percent".equals(type)) {
                return this.percentY;
            }
            if ("path_percent".equals(type)) {
                return this.percentY;
            }
            return super.getFloat(type);
        }

        @Override
        void parse(String node, String value) {
            if (node.endsWith("path_percent")) {
                this.percentX = Float.parseFloat(value);
            } else if (node.endsWith("perpendicularPath_percent")) {
                this.percentY = Float.parseFloat(value);
            } else if (node.endsWith("framePosition") || node.endsWith("")) {
                super.parse(node, value);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$KeyPosition", "getValue"));
        }
    }

    public static abstract class KeyPos
    extends KeyFrame {
        String transitionEasing = null;

        public KeyPos(MotionSceneModel motionSceneModel) {
            super(motionSceneModel, "Position");
        }

        @Override
        public float getFloat(String type) {
            return super.getFloat(type);
        }

        @Override
        void parse(String node, String value) {
            if (node.endsWith("transitionEasing")) {
                this.transitionEasing = value;
            }
            super.parse(node, value);
        }

        @Override
        public void fill(HashMap<String, Object> attributes) {
            if (this.transitionEasing != null) {
                attributes.put("framePosition", this.framePosition);
            }
            super.fill(attributes);
        }
    }

    public static abstract class KeyFrame
    extends BaseTag {
        protected String mType;
        int framePosition;
        String target;
        HashMap<String, Object> myAttributes;
        protected String[] myPossibleAttr;

        public KeyFrame(@NotNull MotionSceneModel motionSceneModel, @NotNull String title) {
            if (motionSceneModel == null) {
                KeyFrame.$$$reportNull$$$0(0);
            }
            if (title == null) {
                KeyFrame.$$$reportNull$$$0(1);
            }
            super(motionSceneModel, title);
            this.myAttributes = new HashMap();
        }

        @Override
        @Nullable
        public String getValue(@NotNull String key) {
            if (key == null) {
                KeyFrame.$$$reportNull$$$0(2);
            }
            switch (key) {
                case "framePosition": {
                    return String.valueOf(this.framePosition);
                }
                case "target": {
                    return this.target;
                }
            }
            Object value = this.myAttributes.get(key);
            return value != null ? value.toString() : null;
        }

        @Override
        @NotNull
        public Set<String> getAttributeNames() {
            Set<String> set = this.myAttributes.keySet();
            if (set == null) {
                KeyFrame.$$$reportNull$$$0(3);
            }
            return set;
        }

        public abstract String[] getDefault(String var1);

        public CustomAttributes createCustomAttribute(@NotNull String key, @NotNull CustomAttributes.Type type, @NotNull String value) {
            if (key == null) {
                KeyFrame.$$$reportNull$$$0(4);
            }
            if (type == null) {
                KeyFrame.$$$reportNull$$$0(5);
            }
            if (value == null) {
                KeyFrame.$$$reportNull$$$0(6);
            }
            throw new UnsupportedOperationException();
        }

        public String getString(String type) {
            if ("target".equals(type)) {
                return this.target;
            }
            return null;
        }

        public String[] getPossibleAttr() {
            return this.myPossibleAttr;
        }

        public int getFramePosition() {
            return this.framePosition;
        }

        public float getFloat(String type) {
            String val = this.myAttributes.get(type).toString();
            if (val.endsWith("dp")) {
                val = val.substring(0, val.length() - 2);
            }
            return Float.parseFloat(val);
        }

        public void fill(HashMap<String, Object> attributes) {
            attributes.put("framePosition", this.framePosition);
            attributes.put("target", this.target);
            attributes.putAll(this.myAttributes);
        }

        void parse(NamedNodeMap att) {
            int attCount = att.getLength();
            for (int i = 0; i < attCount; ++i) {
                this.parse(att.item(i).getNodeName(), att.item(i).getNodeValue());
            }
        }

        float fparse(String v) {
            if (v.endsWith("dp")) {
                return Float.parseFloat(v.substring(0, v.length() - 2));
            }
            return Float.parseFloat(v);
        }

        void parse(String node, String value) {
            if (value == null) {
                this.myAttributes.remove(node);
                return;
            }
            if (node.endsWith("framePosition")) {
                this.framePosition = Integer.parseInt(value);
            } else if (node.endsWith("target")) {
                this.target = value.substring(value.indexOf(47) + 1);
            } else {
                this.myAttributes.put(node, value);
            }
        }

        private String trim(String node) {
            return node.substring(node.indexOf(58) + 1);
        }

        public void parse(XmlAttribute[] attributes) {
            for (int i = 0; i < attributes.length; ++i) {
                XmlAttribute attribute = attributes[i];
                this.parse(this.trim(attribute.getName()), attribute.getValue());
            }
        }

        @Override
        @Nullable
        public XmlTag findMyTag() {
            XmlTag[] keyFrame;
            XmlTag root;
            XmlFile xmlFile = this.myMotionSceneModel.motionSceneFile();
            XmlTag xmlTag = root = xmlFile != null ? xmlFile.getRootTag() : null;
            if (root == null) {
                return null;
            }
            XmlTag[] keyFrames = root.findSubTags("KeyFrameSet");
            if (keyFrames.length == 0) {
                return null;
            }
            for (XmlTag tag : keyFrame = keyFrames[0].getSubTags()) {
                if (!this.match(tag)) continue;
                return tag;
            }
            return null;
        }

        @Override
        public boolean deleteAttribute(@NotNull String attributeName) {
            if (attributeName == null) {
                KeyFrame.$$$reportNull$$$0(7);
            }
            if (attributeName.equals("target") || attributeName.equals("framePosition")) {
                return false;
            }
            if (!super.deleteAttribute(attributeName)) {
                return false;
            }
            this.myAttributes.remove(attributeName);
            return true;
        }

        public boolean deleteTag() {
            String command = "Delete key attributes for: " + this.target;
            return super.deleteTag(command);
        }

        @Override
        public boolean setValue(@NotNull String key, @NotNull String value) {
            if (key == null) {
                KeyFrame.$$$reportNull$$$0(8);
            }
            if (value == null) {
                KeyFrame.$$$reportNull$$$0(9);
            }
            if (!super.setValue(key, value)) {
                return false;
            }
            this.parse(key, value);
            return true;
        }

        @Override
        public boolean setValues(@NotNull HashMap<String, String> values2) {
            if (values2 == null) {
                KeyFrame.$$$reportNull$$$0(10);
            }
            if (!super.setValues(values2)) {
                return false;
            }
            for (String key : values2.keySet()) {
                this.parse(key, values2.get(key));
            }
            return true;
        }

        boolean match(XmlTag xmlTag) {
            String keyNodeName = xmlTag.getName();
            if (!keyNodeName.equals(this.mType)) {
                return false;
            }
            XmlAttribute[] attr = xmlTag.getAttributes();
            for (int k = 0; k < attr.length; ++k) {
                XmlAttribute attribute = attr[k];
                if (attribute.getName().endsWith("framePosition") && Integer.parseInt(attribute.getValue()) != this.framePosition) {
                    return false;
                }
                if (!attribute.getName().endsWith("target") || attribute.getValue().endsWith(this.target)) continue;
                return false;
            }
            return true;
        }

        public String getName() {
            return this.mType;
        }

        public String getEasingCurve() {
            return (String)this.myAttributes.get("transitionEasing");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "motionSceneModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$KeyFrame";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributeName";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$KeyFrame";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributeNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomAttribute";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteAttribute";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setValues";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseTag {
        protected final MotionSceneModel myMotionSceneModel;
        protected final String myTitle;

        public BaseTag(@NotNull MotionSceneModel model, @NotNull String title) {
            if (model == null) {
                BaseTag.$$$reportNull$$$0(0);
            }
            if (title == null) {
                BaseTag.$$$reportNull$$$0(1);
            }
            this.myMotionSceneModel = model;
            this.myTitle = title;
        }

        @NotNull
        public String getTitle() {
            String string = this.myTitle;
            if (string == null) {
                BaseTag.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public MotionSceneModel getModel() {
            MotionSceneModel motionSceneModel = this.myMotionSceneModel;
            if (motionSceneModel == null) {
                BaseTag.$$$reportNull$$$0(3);
            }
            return motionSceneModel;
        }

        public abstract XmlTag findMyTag();

        public boolean isAndroidAttribute(@NotNull String attributeName) {
            if (attributeName == null) {
                BaseTag.$$$reportNull$$$0(4);
            }
            return false;
        }

        protected void completeSceneModelUpdate() {
            this.myMotionSceneModel.myNlModel.notifyModified(NlModel.ChangeType.EDIT);
            XmlFile xmlFile = this.myMotionSceneModel.motionSceneFile();
            LayoutPullParsers.saveFileIfNecessary((PsiFile)xmlFile);
        }

        public boolean deleteTag(@NotNull String command) {
            XmlTag tag;
            if (command == null) {
                BaseTag.$$$reportNull$$$0(5);
            }
            if ((tag = this.findMyTag()) == null) {
                return false;
            }
            Runnable operation = () -> tag.delete();
            XmlFile xmlFile = this.myMotionSceneModel.motionSceneFile();
            WriteCommandAction.runWriteCommandAction((Project)this.myMotionSceneModel.myProject, (String)command, null, (Runnable)operation, (PsiFile[])new PsiFile[]{xmlFile});
            this.completeSceneModelUpdate();
            return true;
        }

        public boolean setValues(@NotNull HashMap<String, String> values2) {
            XmlTag tag;
            if (values2 == null) {
                BaseTag.$$$reportNull$$$0(6);
            }
            if ((tag = this.findMyTag()) == null) {
                return false;
            }
            String command = "Set attributes";
            Runnable operation = () -> {
                if (values2 == null) {
                    BaseTag.$$$reportNull$$$0(20);
                }
                for (String key : values2.keySet()) {
                    String value = (String)values2.get(key);
                    String namespace = this.isAndroidAttribute(key) ? "http://schemas.android.com/apk/res/android" : "http://schemas.android.com/apk/res-auto";
                    tag.setAttribute(key, namespace, value);
                }
            };
            XmlFile xmlFile = this.myMotionSceneModel.motionSceneFile();
            WriteCommandAction.runWriteCommandAction((Project)this.myMotionSceneModel.myProject, (String)command, null, (Runnable)operation, (PsiFile[])new PsiFile[]{xmlFile});
            this.completeSceneModelUpdate();
            return true;
        }

        protected boolean setValue(@NotNull XmlTag tag, @NotNull String key, @NotNull String value) {
            if (tag == null) {
                BaseTag.$$$reportNull$$$0(7);
            }
            if (key == null) {
                BaseTag.$$$reportNull$$$0(8);
            }
            if (value == null) {
                BaseTag.$$$reportNull$$$0(9);
            }
            String command = "Set " + key + " attribute";
            String namespace = this.isAndroidAttribute(key) ? "http://schemas.android.com/apk/res/android" : "http://schemas.android.com/apk/res-auto";
            Runnable operation = () -> {
                if (tag == null) {
                    BaseTag.$$$reportNull$$$0(17);
                }
                if (key == null) {
                    BaseTag.$$$reportNull$$$0(18);
                }
                if (value == null) {
                    BaseTag.$$$reportNull$$$0(19);
                }
                tag.setAttribute(key, namespace, value);
            };
            XmlFile xmlFile = this.myMotionSceneModel.motionSceneFile();
            WriteCommandAction.runWriteCommandAction((Project)this.myMotionSceneModel.myProject, (String)command, null, (Runnable)operation, (PsiFile[])new PsiFile[]{xmlFile});
            this.completeSceneModelUpdate();
            return true;
        }

        public boolean setValue(@NotNull String key, @NotNull String value) {
            XmlTag tag;
            if (key == null) {
                BaseTag.$$$reportNull$$$0(10);
            }
            if (value == null) {
                BaseTag.$$$reportNull$$$0(11);
            }
            if ((tag = this.findMyTag()) == null) {
                return false;
            }
            return this.setValue(tag, key, value);
        }

        @NotNull
        public abstract Set<String> getAttributeNames();

        @NotNull
        public List<CustomAttributes> getCustomAttributes() {
            List<CustomAttributes> list = Collections.emptyList();
            if (list == null) {
                BaseTag.$$$reportNull$$$0(12);
            }
            return list;
        }

        @Nullable
        public abstract String getValue(@NotNull String var1);

        public boolean deleteAttribute(@NotNull String attributeName) {
            XmlTag tag;
            if (attributeName == null) {
                BaseTag.$$$reportNull$$$0(13);
            }
            if ((tag = this.findMyTag()) == null) {
                return false;
            }
            String command = "Delete " + attributeName + " attribute";
            String namespace = BaseTag.findAttributeNamespace(tag, attributeName);
            if (namespace == null) {
                return false;
            }
            Runnable operation = () -> {
                if (attributeName == null) {
                    BaseTag.$$$reportNull$$$0(16);
                }
                tag.setAttribute(attributeName, namespace, null);
            };
            XmlFile xmlFile = this.myMotionSceneModel.motionSceneFile();
            WriteCommandAction.runWriteCommandAction((Project)this.myMotionSceneModel.myProject, (String)command, null, (Runnable)operation, (PsiFile[])new PsiFile[]{xmlFile});
            this.completeSceneModelUpdate();
            return true;
        }

        @Nullable
        private static String findAttributeNamespace(@NotNull XmlTag tag, @NotNull String attributeName) {
            if (tag == null) {
                BaseTag.$$$reportNull$$$0(14);
            }
            if (attributeName == null) {
                BaseTag.$$$reportNull$$$0(15);
            }
            for (XmlAttribute attribute : tag.getAttributes()) {
                if (!attributeName.equals(attribute.getLocalName())) continue;
                return attribute.getNamespace();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: 
                case 3: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$BaseTag";
                    break;
                }
                case 4: 
                case 13: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributeName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 6: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 7: 
                case 14: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 8: 
                case 10: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 9: 
                case 11: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$BaseTag";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCustomAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 12: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isAndroidAttribute";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteTag";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setValues";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteAttribute";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "findAttributeNamespace";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$deleteAttribute$3";
                    break;
                }
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$setValue$2";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$setValues$1";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MotionSceneView {
        String mid;
        Icon myIcon;
        MotionSceneModel myModel;
        public ArrayList<KeyPos> myKeyPositions = new ArrayList();
        public ArrayList<KeyAttributes> myKeyAttributes = new ArrayList();
        public ArrayList<KeyCycle> myKeyCycles = new ArrayList();

        @NotNull
        public Icon getIcon() {
            if (this.myIcon == null) {
                this.myIcon = this.findIcon();
            }
            Icon icon = this.myIcon;
            if (icon == null) {
                MotionSceneView.$$$reportNull$$$0(0);
            }
            return icon;
        }

        @NotNull
        private Icon findIcon() {
            NlComponent component = this.myModel.myNlModel.find(this.mid);
            if (component == null) {
                Icon icon = StudioIcons.LayoutEditor.Palette.VIEW;
                if (icon == null) {
                    MotionSceneView.$$$reportNull$$$0(1);
                }
                return icon;
            }
            ViewHandlerManager manager = ViewHandlerManager.get(this.myModel.myProject);
            ViewHandler handler = manager.getHandler(component);
            if (handler == null) {
                Icon icon = StudioIcons.LayoutEditor.Palette.VIEW;
                if (icon == null) {
                    MotionSceneView.$$$reportNull$$$0(2);
                }
                return icon;
            }
            Icon icon = handler.getIcon(component);
            if (icon == null) {
                MotionSceneView.$$$reportNull$$$0(3);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/uibuilder/handlers/motion/timeline/MotionSceneModel$MotionSceneView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findIcon";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

