/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.relative.ConstraintType;
import com.android.tools.idea.uibuilder.handlers.relative.DependencyGraph;
import com.android.tools.idea.uibuilder.handlers.relative.GuidelineHandler;
import com.android.tools.idea.uibuilder.handlers.relative.Match;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.SegmentType;
import com.android.tools.idea.uibuilder.model.TextDirection;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ConstraintPainter {
    private static final int ARROW_SIZE = 5;
    private static final int PARENT_RECT_SIZE = 12;

    static void paintConstraint(NlGraphics graphics, GuidelineHandler state, Match match) {
        NlComponent node = match.edge.component;
        if (node == null) {
            return;
        }
        Insets padding = NlComponentHelperKt.getPadding(node);
        Rectangle targetBounds = node == state.layout ? new Rectangle(NlComponentHelperKt.getX(node) + padding.left, NlComponentHelperKt.getY(node) + padding.top, Math.max(0, NlComponentHelperKt.getW(node) - padding.left - padding.right), Math.max(0, NlComponentHelperKt.getH(node) - padding.top - padding.bottom)) : new Rectangle(NlComponentHelperKt.getX(node), NlComponentHelperKt.getY(node), NlComponentHelperKt.getW(node), NlComponentHelperKt.getH(node));
        ConstraintType type = match.type;
        assert (type != null);
        Rectangle sourceBounds = state.myBounds;
        ConstraintPainter.paintConstraint(graphics, type, node, sourceBounds, node, targetBounds, null, true, state.myTextDirection);
    }

    private static void paintConstraint(NlGraphics graphics, DependencyGraph.Constraint constraint, Set<DependencyGraph.Constraint> allConstraints, TextDirection textDirection) {
        DependencyGraph.ViewData source = constraint.from;
        DependencyGraph.ViewData target = constraint.to;
        NlComponent sourceNode = source.node;
        NlComponent targetNode = target.node;
        if (sourceNode == targetNode) {
            return;
        }
        Rectangle sourceBounds = ConstraintPainter.getBounds(sourceNode);
        Rectangle targetBounds = ConstraintPainter.getBounds(targetNode);
        ConstraintPainter.paintConstraint(graphics, constraint.type, sourceNode, sourceBounds, targetNode, targetBounds, allConstraints, false, textDirection);
    }

    private static Rectangle getBounds(NlComponent component) {
        return new Rectangle(NlComponentHelperKt.getX(component), NlComponentHelperKt.getY(component), NlComponentHelperKt.getW(component), NlComponentHelperKt.getH(component));
    }

    public static void paintSelectionFeedback(NlGraphics graphics, NlComponent parentNode, List<NlComponent> childNodes, boolean showDependents, TextDirection textDirection) {
        DependencyGraph dependencyGraph = parentNode.getDependencyGraph();
        Set<NlComponent> horizontalDeps = dependencyGraph.dependsOn(childNodes, false);
        Set<NlComponent> verticalDeps = dependencyGraph.dependsOn(childNodes, true);
        HashSet<NlComponent> deps = new HashSet<NlComponent>(horizontalDeps.size() + verticalDeps.size());
        deps.addAll(horizontalDeps);
        deps.addAll(verticalDeps);
        if (!deps.isEmpty()) {
            for (NlComponent node : deps) {
                if (childNodes.contains(node)) continue;
                Rectangle bounds = ConstraintPainter.getBounds(node);
                graphics.useStyle(NlDrawingStyle.DEPENDENCY);
                graphics.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
        for (NlComponent childNode : childNodes) {
            DependencyGraph.ViewData view = dependencyGraph.getView(childNode);
            if (view == null) continue;
            if (showDependents) {
                ConstraintPainter.paintConstraints(graphics, view.dependedOnBy, textDirection);
            }
            ConstraintPainter.paintConstraints(graphics, view.dependsOn, textDirection);
        }
    }

    private static void paintConstraints(NlGraphics graphics, List<DependencyGraph.Constraint> constraints, TextDirection textDirection) {
        HashSet<DependencyGraph.Constraint> mutableConstraintSet = new HashSet<DependencyGraph.Constraint>(constraints);
        for (DependencyGraph.Constraint constraint : constraints) {
            if (constraint.type != ConstraintType.ALIGN_BASELINE) continue;
            for (DependencyGraph.Constraint c : constraints) {
                if (c.type != ConstraintType.ALIGN_BOTTOM || c.to.node != constraint.to.node) continue;
                mutableConstraintSet.remove(c);
            }
        }
        for (DependencyGraph.Constraint constraint : constraints) {
            if (!mutableConstraintSet.contains(constraint)) continue;
            ConstraintPainter.paintConstraint(graphics, constraint, mutableConstraintSet, textDirection);
        }
    }

    private static void paintConstraint(NlGraphics graphics, ConstraintType type, NlComponent sourceNode, Rectangle sourceBounds, NlComponent targetNode, Rectangle targetBounds, @Nullable Set<DependencyGraph.Constraint> allConstraints, boolean highlightTargetEdge, TextDirection textDirection) {
        SegmentType sourceSegmentTypeX = type.sourceSegmentTypeX;
        SegmentType sourceSegmentTypeY = type.sourceSegmentTypeY;
        SegmentType targetSegmentTypeX = type.targetSegmentTypeX;
        SegmentType targetSegmentTypeY = type.targetSegmentTypeY;
        if (sourceSegmentTypeX == SegmentType.CENTER_VERTICAL && targetSegmentTypeX == SegmentType.CENTER_VERTICAL) {
            ConstraintPainter.paintHorizontalCenterConstraint(graphics, sourceBounds, targetBounds);
            return;
        }
        if (sourceSegmentTypeY == SegmentType.CENTER_HORIZONTAL && targetSegmentTypeY == SegmentType.CENTER_HORIZONTAL) {
            ConstraintPainter.paintVerticalCenterConstraint(graphics, sourceBounds, targetBounds);
            return;
        }
        if (allConstraints != null && (type == ConstraintType.LAYOUT_ABOVE || type == ConstraintType.LAYOUT_BELOW || type == ConstraintType.LAYOUT_LEFT_OF || type == ConstraintType.LAYOUT_RIGHT_OF) && ConstraintPainter.paintCornerConstraint(graphics, type, sourceNode, sourceBounds, targetNode, targetBounds, allConstraints, textDirection)) {
            return;
        }
        if (sourceSegmentTypeX == SegmentType.UNKNOWN) {
            ConstraintPainter.paintVerticalConstraint(graphics, type, sourceNode, sourceBounds, targetNode, targetBounds, highlightTargetEdge);
            return;
        }
        if (sourceSegmentTypeY == SegmentType.UNKNOWN) {
            ConstraintPainter.paintHorizontalConstraint(graphics, type, sourceNode, sourceBounds, targetNode, targetBounds, highlightTargetEdge, textDirection);
            return;
        }
        assert (false);
    }

    private static boolean paintCornerConstraint(NlGraphics graphics, ConstraintType type, NlComponent sourceNode, Rectangle sourceBounds, NlComponent targetNode, Rectangle targetBounds, Set<DependencyGraph.Constraint> allConstraints, TextDirection textDirection) {
        ConstraintType opposite2;
        ConstraintType opposite1;
        SegmentType sourceSegmentTypeX = type.sourceSegmentTypeX;
        SegmentType sourceSegmentTypeY = type.sourceSegmentTypeY;
        SegmentType targetSegmentTypeX = type.targetSegmentTypeX;
        SegmentType targetSegmentTypeY = type.targetSegmentTypeY;
        switch (type) {
            case LAYOUT_BELOW: 
            case LAYOUT_ABOVE: {
                opposite1 = ConstraintType.LAYOUT_LEFT_OF;
                opposite2 = ConstraintType.LAYOUT_RIGHT_OF;
                break;
            }
            case LAYOUT_LEFT_OF: 
            case LAYOUT_RIGHT_OF: {
                opposite1 = ConstraintType.LAYOUT_ABOVE;
                opposite2 = ConstraintType.LAYOUT_BELOW;
                break;
            }
            default: {
                return false;
            }
        }
        DependencyGraph.Constraint pair = null;
        for (DependencyGraph.Constraint constraint : allConstraints) {
            if (constraint.type != opposite1 && constraint.type != opposite2 || constraint.to.node != targetNode || constraint.from.node != sourceNode) continue;
            pair = constraint;
            break;
        }
        if (pair != null) {
            if (sourceSegmentTypeX == SegmentType.UNKNOWN) {
                sourceSegmentTypeX = pair.type.sourceSegmentTypeX;
            }
            if (sourceSegmentTypeY == SegmentType.UNKNOWN) {
                sourceSegmentTypeY = pair.type.sourceSegmentTypeY;
            }
            if (targetSegmentTypeX == SegmentType.UNKNOWN) {
                targetSegmentTypeX = pair.type.targetSegmentTypeX;
            }
            if (targetSegmentTypeY == SegmentType.UNKNOWN) {
                targetSegmentTypeY = pair.type.targetSegmentTypeY;
            }
            int x1 = textDirection.isLeftSegment(sourceSegmentTypeX) ? sourceBounds.x + 1 * sourceBounds.width / 4 : sourceBounds.x + 3 * sourceBounds.width / 4;
            int y1 = sourceSegmentTypeY == SegmentType.TOP ? sourceBounds.y + 1 * sourceBounds.height / 4 : sourceBounds.y + 3 * sourceBounds.height / 4;
            int x2 = textDirection.isLeftSegment(targetSegmentTypeX) ? targetBounds.x + 1 * targetBounds.width / 4 : targetBounds.x + 3 * targetBounds.width / 4;
            int y2 = targetSegmentTypeY == SegmentType.TOP ? targetBounds.y + 1 * targetBounds.height / 4 : targetBounds.y + 3 * targetBounds.height / 4;
            graphics.useStyle(NlDrawingStyle.GUIDELINE);
            graphics.drawArrow(x1, y1, x2, y2);
            allConstraints.remove(pair);
            return true;
        }
        return false;
    }

    private static void paintVerticalConstraint(NlGraphics graphics, ConstraintType type, NlComponent sourceNode, Rectangle sourceBounds, NlComponent targetNode, Rectangle targetBounds, boolean highlightTargetEdge) {
        int endX;
        int startX;
        int sharedY;
        int minRight;
        int maxLeft;
        int center;
        int targetY;
        SegmentType sourceSegmentTypeY = type.sourceSegmentTypeY;
        SegmentType targetSegmentTypeY = type.targetSegmentTypeY;
        Insets targetMargins = NlComponentHelperKt.getMargins(targetNode);
        assert (sourceSegmentTypeY != SegmentType.UNKNOWN);
        assert (targetBounds != null);
        int sourceY = sourceSegmentTypeY.getY(sourceNode, sourceBounds);
        int n = targetY = targetSegmentTypeY == SegmentType.UNKNOWN ? sourceY : targetSegmentTypeY.getY(targetNode, targetBounds);
        if (highlightTargetEdge && type.isRelativeToParentEdge()) {
            graphics.useStyle(NlDrawingStyle.DROP_ZONE_ACTIVE);
            graphics.fillRect(targetBounds.x, targetY - 6, targetBounds.width, 12);
        }
        if ((center = ((maxLeft = Math.max(sourceBounds.x, targetBounds.x)) + (minRight = Math.min(ConstraintPainter.x2(sourceBounds), ConstraintPainter.x2(targetBounds)))) / 2) > sourceBounds.x && center < ConstraintPainter.x2(sourceBounds)) {
            if (targetSegmentTypeY == SegmentType.BOTTOM && targetMargins.bottom > 5) {
                int sharedY2 = targetY + targetMargins.bottom;
                if (sourceY > sharedY2 + 2) {
                    graphics.useStyle(NlDrawingStyle.GUIDELINE_DASHED);
                    graphics.drawLine(targetBounds.x, sharedY2, ConstraintPainter.x2(targetBounds), sharedY2);
                    graphics.useStyle(NlDrawingStyle.GUIDELINE);
                    graphics.drawArrow(center, sourceY, center, sharedY2 + 2);
                    graphics.drawArrow(center, targetY, center, sharedY2 - 3);
                } else {
                    graphics.useStyle(NlDrawingStyle.GUIDELINE);
                    graphics.drawArrow(center, targetY, center, sourceY);
                }
                return;
            }
            if (targetSegmentTypeY == SegmentType.TOP && targetMargins.top > 5) {
                int sharedY3 = targetY - targetMargins.top;
                if (sourceY < sharedY3 - 2) {
                    graphics.useStyle(NlDrawingStyle.GUIDELINE_DASHED);
                    graphics.drawLine(targetBounds.x, sharedY3, ConstraintPainter.x2(targetBounds), sharedY3);
                    graphics.useStyle(NlDrawingStyle.GUIDELINE);
                    graphics.drawArrow(center, sourceY, center, sharedY3 - 3);
                    graphics.drawArrow(center, targetY, center, sharedY3 + 3);
                } else {
                    graphics.useStyle(NlDrawingStyle.GUIDELINE);
                    graphics.drawArrow(center, targetY, center, sourceY);
                }
                return;
            }
            if (sourceY == targetY) {
                if (sourceSegmentTypeY == SegmentType.BOTTOM || sourceSegmentTypeY == SegmentType.BASELINE) {
                    sourceY -= 10;
                } else if (sourceSegmentTypeY == SegmentType.TOP) {
                    sourceY += 10;
                } else {
                    assert (sourceSegmentTypeY == SegmentType.CENTER_HORIZONTAL) : sourceSegmentTypeY;
                    sourceY += sourceBounds.height / 2 - 10;
                }
            } else if (sourceSegmentTypeY == SegmentType.BASELINE) {
                sourceY = targetY - 10;
            }
            graphics.useStyle(NlDrawingStyle.GUIDELINE);
            graphics.drawArrow(center, sourceY, center, targetY);
            return;
        }
        int n2 = sharedY = targetSegmentTypeY == SegmentType.UNKNOWN ? sourceY : targetSegmentTypeY.getY(targetNode, targetBounds);
        if (type.relativeToMargin) {
            if (targetSegmentTypeY == SegmentType.TOP) {
                sharedY -= targetMargins.top;
            } else if (targetSegmentTypeY == SegmentType.BOTTOM) {
                sharedY += targetMargins.bottom;
            }
        }
        if (center <= sourceBounds.x) {
            startX = targetBounds.x + targetBounds.width / 4;
            endX = ConstraintPainter.x2(sourceBounds);
        } else {
            assert (center >= ConstraintPainter.x2(sourceBounds));
            startX = sourceBounds.x;
            endX = targetBounds.x + 3 * targetBounds.width / 4;
        }
        graphics.useStyle(NlDrawingStyle.GUIDELINE_DASHED);
        graphics.drawLine(startX, sharedY, endX, sharedY);
        if (Math.abs(sharedY - sourceY) < 10) {
            if (sourceSegmentTypeY == SegmentType.BASELINE) {
                sourceY = sharedY - 10;
            } else if (sourceSegmentTypeY == SegmentType.TOP) {
                sharedY = sourceY;
                sourceY = sharedY + 10;
            } else {
                sharedY = sourceY;
                sourceY = sharedY - 10;
            }
        }
        graphics.useStyle(NlDrawingStyle.GUIDELINE);
        int x = sourceBounds.x + (sourceSegmentTypeY == SegmentType.BASELINE ? sourceBounds.width / 2 : sourceBounds.width / 4);
        graphics.drawArrow(x, sourceY, x, sharedY);
        int tx = ConstraintPainter.centerX(targetBounds);
        if (targetSegmentTypeY == SegmentType.TOP) {
            int ty = targetBounds.y;
            int margin = targetMargins.top;
            if (margin == 0 || !type.relativeToMargin) {
                graphics.drawArrow(tx, ty + 10, tx, ty);
            } else {
                graphics.drawArrow(tx, ty, tx, ty - margin);
            }
        } else if (targetSegmentTypeY == SegmentType.BOTTOM) {
            int ty = ConstraintPainter.y2(targetBounds);
            int margin = targetMargins.bottom;
            if (margin == 0 || !type.relativeToMargin) {
                graphics.drawArrow(tx, ty - 10, tx, ty);
            } else {
                graphics.drawArrow(tx, ty, tx, ty + margin);
            }
        } else {
            assert (targetSegmentTypeY == SegmentType.BASELINE) : targetSegmentTypeY;
            int ty = targetSegmentTypeY.getY(targetNode, targetBounds);
            graphics.drawArrow(tx, ty - 10, tx, ty);
        }
    }

    private static void paintHorizontalConstraint(NlGraphics graphics, ConstraintType type, NlComponent sourceNode, Rectangle sourceBounds, NlComponent targetNode, Rectangle targetBounds, boolean highlightTargetEdge, TextDirection textDirection) {
        int endY;
        int startY;
        int sharedX;
        int minBottom;
        int maxTop;
        int center;
        int targetX;
        SegmentType sourceSegmentTypeX = type.sourceSegmentTypeX;
        SegmentType targetSegmentTypeX = type.targetSegmentTypeX;
        Insets targetMargins = NlComponentHelperKt.getMargins(targetNode);
        assert (sourceSegmentTypeX != SegmentType.UNKNOWN);
        assert (targetBounds != null);
        int sourceX = sourceSegmentTypeX.getX(textDirection, sourceNode, sourceBounds);
        int n = targetX = targetSegmentTypeX == SegmentType.UNKNOWN ? sourceX : targetSegmentTypeX.getX(textDirection, targetNode, targetBounds);
        if (highlightTargetEdge && type.isRelativeToParentEdge()) {
            graphics.useStyle(NlDrawingStyle.DROP_ZONE_ACTIVE);
            graphics.fillRect(targetX - 6, targetBounds.y, 12, targetBounds.height);
        }
        if ((center = ((maxTop = Math.max(sourceBounds.y, targetBounds.y)) + (minBottom = Math.min(ConstraintPainter.y2(sourceBounds), ConstraintPainter.y2(targetBounds)))) / 2) > sourceBounds.y && center < ConstraintPainter.y2(sourceBounds)) {
            if (textDirection.isRightSegment(targetSegmentTypeX) && targetMargins.right > 5) {
                int sharedX2 = targetX + targetMargins.right;
                if (sourceX > sharedX2 + 2) {
                    graphics.useStyle(NlDrawingStyle.GUIDELINE_DASHED);
                    graphics.drawLine(sharedX2, targetBounds.y, sharedX2, ConstraintPainter.y2(targetBounds));
                    graphics.useStyle(NlDrawingStyle.GUIDELINE);
                    graphics.drawArrow(sourceX, center, sharedX2 + 2, center);
                    graphics.drawArrow(targetX, center, sharedX2 - 3, center);
                } else {
                    graphics.useStyle(NlDrawingStyle.GUIDELINE);
                    graphics.drawArrow(targetX, center, sourceX, center);
                }
                return;
            }
            if (textDirection.isLeftSegment(targetSegmentTypeX) && targetMargins.left > 5) {
                int sharedX3 = targetX - targetMargins.left;
                if (sourceX < sharedX3 - 2) {
                    graphics.useStyle(NlDrawingStyle.GUIDELINE_DASHED);
                    graphics.drawLine(sharedX3, targetBounds.y, sharedX3, ConstraintPainter.y2(targetBounds));
                    graphics.useStyle(NlDrawingStyle.GUIDELINE);
                    graphics.drawArrow(sourceX, center, sharedX3 - 3, center);
                    graphics.drawArrow(targetX, center, sharedX3 + 3, center);
                } else {
                    graphics.useStyle(NlDrawingStyle.GUIDELINE);
                    graphics.drawArrow(targetX, center, sourceX, center);
                }
                return;
            }
            if (sourceX == targetX) {
                if (textDirection.isRightSegment(sourceSegmentTypeX)) {
                    sourceX -= 10;
                } else if (textDirection.isLeftSegment(sourceSegmentTypeX)) {
                    sourceX += 10;
                } else {
                    assert (sourceSegmentTypeX == SegmentType.CENTER_VERTICAL) : sourceSegmentTypeX;
                    sourceX += sourceBounds.width / 2 - 10;
                }
            }
            graphics.useStyle(NlDrawingStyle.GUIDELINE);
            graphics.drawArrow(sourceX, center, targetX, center);
            return;
        }
        int n2 = sharedX = targetSegmentTypeX == SegmentType.UNKNOWN ? sourceX : targetSegmentTypeX.getX(textDirection, targetNode, targetBounds);
        if (type.relativeToMargin) {
            if (textDirection.isLeftSegment(targetSegmentTypeX)) {
                sharedX -= targetMargins.left;
            } else if (textDirection.isRightSegment(targetSegmentTypeX)) {
                sharedX += targetMargins.right;
            }
        }
        if (center <= sourceBounds.y) {
            startY = targetBounds.y + targetBounds.height / 4;
            endY = ConstraintPainter.y2(sourceBounds);
        } else {
            assert (center >= ConstraintPainter.y2(sourceBounds));
            startY = sourceBounds.y;
            endY = targetBounds.y + 3 * targetBounds.height / 2;
        }
        int y = sourceBounds.y + sourceBounds.height / 4;
        graphics.useStyle(NlDrawingStyle.GUIDELINE_DASHED);
        graphics.drawLine(sharedX, startY, sharedX, endY);
        if (Math.abs(sharedX - sourceX) < 10) {
            if (textDirection.isLeftSegment(sourceSegmentTypeX)) {
                sharedX = sourceX;
                sourceX = sharedX + 10;
            } else {
                sharedX = sourceX;
                sourceX = sharedX - 10;
            }
        }
        graphics.useStyle(NlDrawingStyle.GUIDELINE);
        graphics.drawArrow(sourceX, y, sharedX, y);
        int ty = ConstraintPainter.centerY(targetBounds);
        if (textDirection.isLeftSegment(targetSegmentTypeX)) {
            int tx = targetBounds.x;
            int margin = targetMargins.left;
            if (margin == 0 || !type.relativeToMargin) {
                graphics.drawArrow(tx + 10, ty, tx, ty);
            } else {
                graphics.drawArrow(tx, ty, tx - margin, ty);
            }
        } else {
            assert (textDirection.isRightSegment(targetSegmentTypeX));
            int tx = ConstraintPainter.x2(targetBounds);
            int margin = targetMargins.right;
            if (margin == 0 || !type.relativeToMargin) {
                graphics.drawArrow(tx - 10, ty, tx, ty);
            } else {
                graphics.drawArrow(tx, ty, tx + margin, ty);
            }
        }
    }

    private static void paintVerticalCenterConstraint(NlGraphics graphics, Rectangle sourceBounds, Rectangle targetBounds) {
        graphics.useStyle(NlDrawingStyle.GUIDELINE_DASHED);
        graphics.drawLine(targetBounds.x, ConstraintPainter.centerY(targetBounds), ConstraintPainter.x2(targetBounds), ConstraintPainter.centerY(targetBounds));
        graphics.useStyle(NlDrawingStyle.GUIDELINE);
        graphics.drawLine(sourceBounds.x, ConstraintPainter.centerY(sourceBounds), ConstraintPainter.x2(sourceBounds), ConstraintPainter.centerY(sourceBounds));
    }

    private static void paintHorizontalCenterConstraint(NlGraphics graphics, Rectangle sourceBounds, Rectangle targetBounds) {
        graphics.useStyle(NlDrawingStyle.GUIDELINE_DASHED);
        graphics.drawLine(ConstraintPainter.centerX(targetBounds), targetBounds.y, ConstraintPainter.centerX(targetBounds), ConstraintPainter.y2(targetBounds));
        graphics.useStyle(NlDrawingStyle.GUIDELINE);
        graphics.drawLine(ConstraintPainter.centerX(sourceBounds), sourceBounds.y, ConstraintPainter.centerX(sourceBounds), ConstraintPainter.y2(sourceBounds));
    }

    private static int centerX(Rectangle rectangle) {
        return rectangle.x + rectangle.width / 2;
    }

    private static int centerY(Rectangle rectangle) {
        return rectangle.y + rectangle.height / 2;
    }

    private static int x2(Rectangle rectangle) {
        return rectangle.x + rectangle.width;
    }

    private static int y2(Rectangle rectangle) {
        return rectangle.y + rectangle.height;
    }
}

