/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.relative.ConstraintType;
import com.android.tools.lint.detector.api.Lint;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.xml.XmlAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeletionHandler {
    private final List<NlComponent> myChildren;
    private final List<NlComponent> myDeleted;
    private final Set<String> myDeletedIds;
    private final Map<String, NlComponent> myNodeMap;

    public DeletionHandler(@NotNull List<NlComponent> deleted, @NotNull List<NlComponent> moved, @NotNull NlComponent layout2) {
        String id;
        if (deleted == null) {
            DeletionHandler.$$$reportNull$$$0(0);
        }
        if (moved == null) {
            DeletionHandler.$$$reportNull$$$0(1);
        }
        if (layout2 == null) {
            DeletionHandler.$$$reportNull$$$0(2);
        }
        this.myDeleted = deleted;
        this.myChildren = Lists.newArrayList(layout2.getChildren());
        this.myNodeMap = Maps.newHashMapWithExpectedSize((int)this.myChildren.size());
        for (NlComponent view : this.myChildren) {
            id = view.getId();
            if (id == null) continue;
            this.myNodeMap.put(Lint.stripIdPrefix((String)id), view);
        }
        this.myDeletedIds = Sets.newHashSetWithExpectedSize((int)this.myDeleted.size());
        for (NlComponent node : this.myDeleted) {
            id = node.getId();
            if (id == null) continue;
            this.myDeletedIds.add(Lint.stripIdPrefix((String)id));
        }
        for (NlComponent node : moved) {
            id = node.getId();
            if (id == null) continue;
            this.myDeletedIds.remove(Lint.stripIdPrefix((String)id));
        }
    }

    @Nullable
    private static String getId(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            DeletionHandler.$$$reportNull$$$0(3);
        }
        if (attribute.getLocalName().startsWith("layout_") && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace()) && !attribute.getLocalName().startsWith("layout_margin")) {
            String id = attribute.getValue();
            if (id == null) {
                return null;
            }
            if (id.startsWith("@+id/")) {
                return id.substring("@+id/".length());
            }
            if (id.startsWith("@id/")) {
                return id.substring("@id/".length());
            }
        }
        return null;
    }

    public void updateConstraints() {
        if (this.myChildren.size() == this.myDeleted.size()) {
            return;
        }
        for (NlComponent child : this.myChildren) {
            if (this.myDeleted.contains(child)) continue;
            for (XmlAttribute attribute : child.getTag().getAttributes()) {
                ConstraintType type;
                String id = DeletionHandler.getId(attribute);
                if (id == null || !this.myDeletedIds.contains(id)) continue;
                String name = attribute.getLocalName();
                attribute.delete();
                NlComponent deleted = this.myNodeMap.get(id);
                if (deleted == null || (type = ConstraintType.fromAttribute(name)) == null) continue;
                this.transfer(deleted, child, type, 0);
            }
        }
    }

    private void transfer(NlComponent deleted, NlComponent target, ConstraintType targetType, int depth) {
        if (depth == 20) {
            return;
        }
        assert (this.myDeleted.contains(deleted));
        for (XmlAttribute attribute : deleted.getTag().getAttributes()) {
            ConstraintType transfer;
            String name = attribute.getLocalName();
            ConstraintType type = ConstraintType.fromAttribute(name);
            if (type == null || (transfer = DeletionHandler.getCompatibleConstraint(type, targetType)) == null) continue;
            String id = DeletionHandler.getId(attribute);
            if (id != null) {
                if (this.myDeletedIds.contains(id)) {
                    NlComponent nextDeleted = this.myNodeMap.get(id);
                    if (nextDeleted == null) continue;
                    this.transfer(nextDeleted, target, targetType, depth + 1);
                    continue;
                }
                target.setAttribute("http://schemas.android.com/apk/res/android", transfer.name, attribute.getValue());
                continue;
            }
            target.setAttribute("http://schemas.android.com/apk/res/android", name, attribute.getValue());
        }
    }

    @Nullable
    private static ConstraintType getCompatibleConstraint(@NotNull ConstraintType first, @NotNull ConstraintType second) {
        if (first == null) {
            DeletionHandler.$$$reportNull$$$0(4);
        }
        if (second == null) {
            DeletionHandler.$$$reportNull$$$0(5);
        }
        if (first == second) {
            return first;
        }
        switch (second) {
            case ALIGN_LEFT: 
            case LAYOUT_RIGHT_OF: {
                switch (first) {
                    case LAYOUT_CENTER_HORIZONTAL: 
                    case LAYOUT_LEFT_OF: 
                    case ALIGN_LEFT: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_HORIZONTAL;
                    }
                }
                return null;
            }
            case LAYOUT_LEFT_OF: 
            case ALIGN_RIGHT: {
                switch (first) {
                    case LAYOUT_CENTER_HORIZONTAL: 
                    case LAYOUT_LEFT_OF: 
                    case ALIGN_RIGHT: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_HORIZONTAL;
                    }
                }
                return null;
            }
            case ALIGN_TOP: 
            case LAYOUT_BELOW: 
            case ALIGN_BASELINE: {
                switch (first) {
                    case LAYOUT_CENTER_VERTICAL: 
                    case ALIGN_TOP: 
                    case LAYOUT_BELOW: 
                    case ALIGN_BASELINE: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_VERTICAL;
                    }
                }
                return null;
            }
            case ALIGN_BOTTOM: 
            case LAYOUT_ABOVE: {
                switch (first) {
                    case LAYOUT_CENTER_VERTICAL: 
                    case ALIGN_BASELINE: 
                    case ALIGN_BOTTOM: 
                    case LAYOUT_ABOVE: {
                        return first;
                    }
                    case LAYOUT_CENTER_IN_PARENT: {
                        return ConstraintType.LAYOUT_CENTER_VERTICAL;
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moved";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/relative/DeletionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getId";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompatibleConstraint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

