/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative.targets;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.relative.targets.AlignAttributeRules;
import com.android.tools.idea.uibuilder.handlers.relative.targets.BaseRelativeTarget;
import com.android.tools.idea.uibuilder.handlers.relative.targets.RelativeDragTargetKt;
import com.android.tools.idea.uibuilder.handlers.relative.targets.RelativeUtilitiesKt;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0010\u001a\u00020\u000eH\u0002J\u001c\u0010\u0011\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000eH\u0016J*\u0010\u0012\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J*\u0010\u0016\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0019H\u0002J\u001a\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0003J\u001a\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0010\u001a\u00020\u000eH\u0003J3\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$J$\u0010%\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000eH\u0014J\u0010\u0010&\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010'\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/uibuilder/handlers/relative/targets/RelativeDragTarget;", "Lcom/android/tools/idea/common/scene/target/DragBaseTarget;", "()V", "myTargetX", "Lcom/android/tools/idea/uibuilder/handlers/relative/targets/BaseRelativeTarget;", "myTargetY", "recomputeHorizontalConstraint", "", "recomputeVerticalConstraint", "addHorizontalParentConstraints", "", "attributes", "Lcom/android/tools/idea/common/model/NlAttributesHolder;", "x", "", "addVerticalParentConstraint", "y", "mouseDown", "mouseDrag", "closestTargets", "", "Lcom/android/tools/idea/common/scene/target/Target;", "mouseRelease", "closestTarget", "postProcessAttribute", "Lcom/android/tools/idea/common/model/AttributesTransaction;", "preProcessAttribute", "processHorizontalAttributes", "processVerticalAttributes", "updateAlignAttributeIfNeed", "attributesToUpdate", "", "", "coordinateToUpdate", "rules", "Lcom/android/tools/idea/uibuilder/handlers/relative/targets/AlignAttributeRules;", "(Lcom/android/tools/idea/common/model/NlAttributesHolder;[Ljava/lang/String;ILcom/android/tools/idea/uibuilder/handlers/relative/targets/AlignAttributeRules;)V", "updateAttributes", "updateCurrentHorizontalConstraints", "updateVerticalConstraints", "intellij.android.designer"})
public final class RelativeDragTarget
extends DragBaseTarget {
    private BaseRelativeTarget myTargetX;
    private BaseRelativeTarget myTargetY;
    private boolean recomputeHorizontalConstraint;
    private boolean recomputeVerticalConstraint;

    @Override
    public void mouseDown(int x, int y) {
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        if (sceneComponent.getParent() == null) {
            return;
        }
        SceneComponent sceneComponent2 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"myComponent");
        AttributesTransaction attributesTransaction = sceneComponent2.getAuthoritativeNlComponent().startAttributeTransaction();
        Intrinsics.checkExpressionValueIsNotNull((Object)attributesTransaction, (String)"myComponent.authoritativ\u2026artAttributeTransaction()");
        this.preProcessAttribute(attributesTransaction);
        SceneComponent sceneComponent3 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"myComponent");
        this.recomputeHorizontalConstraint = !RelativeDragTargetKt.access$hasHorizontalConstraint(sceneComponent3);
        SceneComponent sceneComponent4 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent4, (String)"myComponent");
        this.recomputeVerticalConstraint = !RelativeDragTargetKt.access$hasVerticalConstraint(sceneComponent4);
        super.mouseDown(x, y);
        this.myComponent.setModelUpdateAuthorized(true);
    }

    private final void preProcessAttribute(AttributesTransaction attributes) {
        AttributesTransaction $receiver;
        String margin = attributes.getAndroidAttribute("layout_margin");
        if (margin != null) {
            Iterator $receiver$iv$iv;
            attributes.removeAndroidAttribute("layout_margin");
            Object $receiver$iv = RelativeDragTargetKt.access$getMARGINS_WITHOUT_RTL$p();
            Object[] objectArray = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                String it = (String)element$iv$iv;
                SceneComponent sceneComponent = this.myComponent;
                Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
                Iterable list$iv$iv = RelativeUtilitiesKt.getProperAttributesForLayout(sceneComponent, it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv.iterator();
            while ($receiver$iv$iv.hasNext()) {
                Object element$iv = $receiver$iv$iv.next();
                String it = (String)element$iv;
                attributes.setAndroidAttribute(it, margin);
            }
        }
        if (Intrinsics.areEqual((Object)($receiver = attributes).getAndroidAttribute("layout_centerInParent"), (Object)"true")) {
            $receiver.removeAndroidAttribute("layout_centerInParent");
            $receiver.setAndroidAttribute("layout_centerHorizontal", "true");
            $receiver.setAndroidAttribute("layout_centerVertical", "true");
        }
    }

    public void mouseDrag(int x, int y, @NotNull List<? extends Target> closestTargets) {
        AttributesTransaction attributes;
        Intrinsics.checkParameterIsNotNull(closestTargets, (String)"closestTargets");
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        sceneComponent.setDragging(true);
        SceneComponent sceneComponent2 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"myComponent");
        AttributesTransaction attributesTransaction = attributes = sceneComponent2.getAuthoritativeNlComponent().startAttributeTransaction();
        Intrinsics.checkExpressionValueIsNotNull((Object)attributesTransaction, (String)"attributes");
        this.updateAttributes(attributesTransaction, x, y);
        attributes.apply();
        this.myChangedComponent = true;
    }

    public void mouseRelease(int x, int y, @NotNull List<? extends Target> closestTarget) {
        Intrinsics.checkParameterIsNotNull(closestTarget, (String)"closestTarget");
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        if (!sceneComponent.isDragging()) {
            return;
        }
        SceneComponent sceneComponent2 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"myComponent");
        sceneComponent2.setDragging(false);
        SceneComponent sceneComponent3 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"myComponent");
        if (sceneComponent3.getParent() != null) {
            AttributesTransaction attributes;
            SceneComponent sceneComponent4 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent4, (String)"myComponent");
            NlComponent component = sceneComponent4.getAuthoritativeNlComponent();
            AttributesTransaction attributesTransaction = attributes = component.startAttributeTransaction();
            Intrinsics.checkExpressionValueIsNotNull((Object)attributesTransaction, (String)"attributes");
            this.updateAttributes(attributesTransaction, x, y);
            this.postProcessAttribute(attributes);
            attributes.apply();
            if (Math.abs(x - this.myFirstMouseX) > 1 || Math.abs(y - this.myFirstMouseY) > 1) {
                StringBuilder stringBuilder = new StringBuilder().append("Dragged ");
                NlComponent nlComponent = component;
                Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent, (String)"component");
                NlWriteCommandAction.run(component, stringBuilder.append(StringUtil.getShortName((String)nlComponent.getTagName())).toString(), new Runnable(attributes){
                    final /* synthetic */ AttributesTransaction $attributes;

                    public final void run() {
                        this.$attributes.commit();
                    }
                    {
                        this.$attributes = attributesTransaction;
                    }
                });
            }
        }
        BaseRelativeTarget baseRelativeTarget = this.myTargetX;
        if (baseRelativeTarget != null) {
            baseRelativeTarget.setMyIsHighlight(false);
        }
        BaseRelativeTarget baseRelativeTarget2 = this.myTargetY;
        if (baseRelativeTarget2 != null) {
            baseRelativeTarget2.setMyIsHighlight(false);
        }
        if (this.myChangedComponent) {
            SceneComponent sceneComponent5 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent5, (String)"myComponent");
            sceneComponent5.getScene().needsLayout(1);
        }
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        SceneComponent parent;
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        SceneComponent sceneComponent2 = sceneComponent.getParent();
        if (sceneComponent2 == null) {
            return;
        }
        SceneComponent sceneComponent3 = parent = sceneComponent2;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"parent");
        int n = RelativeUtilitiesKt.getDrawLeft(sceneComponent3);
        int n2 = RelativeUtilitiesKt.getDrawRight(parent);
        SceneComponent sceneComponent4 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent4, (String)"myComponent");
        int dx = Math.max(n, Math.min(x - this.myOffsetX, n2 - sceneComponent4.getDrawWidth()));
        int n3 = RelativeUtilitiesKt.getDrawTop(parent);
        int n4 = RelativeUtilitiesKt.getDrawBottom(parent);
        SceneComponent sceneComponent5 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent5, (String)"myComponent");
        int dy = Math.max(n3, Math.min(y - this.myOffsetY, n4 - sceneComponent5.getDrawHeight()));
        int newX = this.processHorizontalAttributes(attributes, dx);
        int newY = this.processVerticalAttributes(attributes, dy);
        this.myComponent.setPosition(newX, newY, false);
    }

    private final int processHorizontalAttributes(NlAttributesHolder attributes, int x) {
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        SceneComponent sceneComponent2 = sceneComponent.getParent();
        if (sceneComponent2 == null) {
            Intrinsics.throwNpe();
        }
        SceneComponent parent = sceneComponent2;
        if (this.recomputeHorizontalConstraint) {
            OptionalInt snappedX;
            RelativeDragTargetKt.access$clearHorizontalConstrains(attributes);
            attributes.removeAndroidAttribute("layout_centerHorizontal");
            BaseRelativeTarget baseRelativeTarget = this.myTargetX;
            if (baseRelativeTarget != null) {
                baseRelativeTarget.setMyIsHighlight(false);
            }
            SceneComponent sceneComponent3 = parent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"parent");
            int n = RelativeUtilitiesKt.getDrawLeft(sceneComponent3);
            int n2 = RelativeUtilitiesKt.getDrawRight(parent);
            SceneComponent sceneComponent4 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent4, (String)"myComponent");
            int dx = Math.max(n, Math.min(x, n2 - sceneComponent4.getDrawWidth()));
            OptionalInt optionalInt = snappedX = this.getTargetNotchSnapper().trySnapHorizontal(dx);
            Intrinsics.checkExpressionValueIsNotNull((Object)optionalInt, (String)"snappedX");
            if (optionalInt.isPresent()) {
                this.getTargetNotchSnapper().applyNotches(attributes);
                TargetSnapper targetSnapper = this.getTargetNotchSnapper();
                Intrinsics.checkExpressionValueIsNotNull((Object)targetSnapper, (String)"targetNotchSnapper");
                BaseRelativeTarget baseRelativeTarget2 = this.myTargetX = (BaseRelativeTarget)targetSnapper.getSnappedHorizontalTarget();
                if (baseRelativeTarget2 != null) {
                    baseRelativeTarget2.setMyIsHighlight(true);
                }
                this.getTargetNotchSnapper().clearSnappedNotches();
                return snappedX.getAsInt();
            }
            this.addHorizontalParentConstraints(attributes, dx);
            return dx;
        }
        this.updateCurrentHorizontalConstraints(attributes);
        return x;
    }

    private final void addHorizontalParentConstraints(NlAttributesHolder attributes, int x) {
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        SceneComponent sceneComponent2 = sceneComponent.getParent();
        if (sceneComponent2 == null) {
            Intrinsics.throwNpe();
        }
        SceneComponent parent = sceneComponent2;
        SceneComponent sceneComponent3 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"myComponent");
        int n = x + sceneComponent3.getDrawWidth() / 2;
        SceneComponent sceneComponent4 = parent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent4, (String)"parent");
        if (n < RelativeUtilitiesKt.getDrawCenterX(sceneComponent4)) {
            String it;
            SceneComponent sceneComponent5 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent5, (String)"myComponent");
            Iterable $receiver$iv = RelativeUtilitiesKt.getProperAttributesForLayout(sceneComponent5, "layout_alignParentLeft");
            for (Object element$iv : $receiver$iv) {
                it = (String)element$iv;
                attributes.setAndroidAttribute(it, "true");
            }
            SceneComponent sceneComponent6 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent6, (String)"myComponent");
            $receiver$iv = RelativeUtilitiesKt.getProperAttributesForLayout(sceneComponent6, "layout_marginLeft");
            for (Object element$iv : $receiver$iv) {
                it = (String)element$iv;
                int $i$a$1$forEach = x - RelativeUtilitiesKt.getDrawLeft(parent);
                int $i$f$forEach = 0;
                String string = it;
                NlAttributesHolder nlAttributesHolder = attributes;
                int n2 = Math.max($i$a$1$forEach, $i$f$forEach);
                nlAttributesHolder.setAndroidAttribute(string, RelativeUtilitiesKt.toDpString(n2));
            }
        } else {
            String it;
            SceneComponent sceneComponent7 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent7, (String)"myComponent");
            Iterable $receiver$iv = RelativeUtilitiesKt.getProperAttributesForLayout(sceneComponent7, "layout_alignParentRight");
            for (Object element$iv : $receiver$iv) {
                it = (String)element$iv;
                attributes.setAndroidAttribute(it, "true");
            }
            SceneComponent sceneComponent8 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent8, (String)"myComponent");
            $receiver$iv = RelativeUtilitiesKt.getProperAttributesForLayout(sceneComponent8, "layout_marginRight");
            for (Object element$iv : $receiver$iv) {
                it = (String)element$iv;
                int n3 = RelativeUtilitiesKt.getDrawRight(parent);
                SceneComponent sceneComponent9 = this.myComponent;
                Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent9, (String)"myComponent");
                int n4 = n3 - (x + sceneComponent9.getDrawWidth());
                int n5 = 0;
                String string = it;
                NlAttributesHolder nlAttributesHolder = attributes;
                int n6 = Math.max(n4, n5);
                nlAttributesHolder.setAndroidAttribute(string, RelativeUtilitiesKt.toDpString(n6));
            }
        }
    }

    private final void updateCurrentHorizontalConstraints(NlAttributesHolder attributes) {
        int n;
        int n2;
        String[] stringArray = RelativeUtilitiesKt.getLEFT_ALIGN_ATTRIBUTES();
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        this.updateAlignAttributeIfNeed(attributes, stringArray, RelativeUtilitiesKt.getDrawLeft(sceneComponent), RelativeUtilitiesKt.getLEFT_ATTRIBUTE_RULES());
        String[] stringArray2 = RelativeUtilitiesKt.getRIGHT_ALIGN_ATTRIBUTES();
        SceneComponent sceneComponent2 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"myComponent");
        this.updateAlignAttributeIfNeed(attributes, stringArray2, RelativeUtilitiesKt.getDrawRight(sceneComponent2), RelativeUtilitiesKt.getRIGHT_ATTRIBUTE_RULES());
        SceneComponent sceneComponent3 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"myComponent");
        Scene scene = sceneComponent3.getScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)scene, (String)"myComponent.scene");
        boolean isRtl = scene.isInRTL();
        String[] stringArray3 = RelativeUtilitiesKt.getSTART_ALIGN_ATTRIBUTES();
        if (isRtl) {
            SceneComponent sceneComponent4 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent4, (String)"myComponent");
            n2 = RelativeUtilitiesKt.getDrawRight(sceneComponent4);
        } else {
            SceneComponent sceneComponent5 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent5, (String)"myComponent");
            n2 = RelativeUtilitiesKt.getDrawLeft(sceneComponent5);
        }
        this.updateAlignAttributeIfNeed(attributes, stringArray3, n2, isRtl ? RelativeUtilitiesKt.getRTL_START_ATTRIBUTE_RULES() : RelativeUtilitiesKt.getSTART_ATTRIBUTE_RULES());
        String[] stringArray4 = RelativeUtilitiesKt.getEND_ALIGN_ATTRIBUTES();
        if (isRtl) {
            SceneComponent sceneComponent6 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent6, (String)"myComponent");
            n = RelativeUtilitiesKt.getDrawLeft(sceneComponent6);
        } else {
            SceneComponent sceneComponent7 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent7, (String)"myComponent");
            n = RelativeUtilitiesKt.getDrawRight(sceneComponent7);
        }
        this.updateAlignAttributeIfNeed(attributes, stringArray4, n, isRtl ? RelativeUtilitiesKt.getRTL_END_ATTRIBUTE_RULES() : RelativeUtilitiesKt.getEND_ATTRIBUTE_RULES());
    }

    private final int processVerticalAttributes(NlAttributesHolder attributes, int y) {
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        SceneComponent sceneComponent2 = sceneComponent.getParent();
        if (sceneComponent2 == null) {
            Intrinsics.throwNpe();
        }
        SceneComponent parent = sceneComponent2;
        if (this.recomputeVerticalConstraint) {
            OptionalInt snappedY;
            RelativeDragTargetKt.access$clearVerticalConstrains(attributes);
            attributes.removeAndroidAttribute("layout_centerVertical");
            BaseRelativeTarget baseRelativeTarget = this.myTargetY;
            if (baseRelativeTarget != null) {
                baseRelativeTarget.setMyIsHighlight(false);
            }
            SceneComponent sceneComponent3 = parent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"parent");
            int n = RelativeUtilitiesKt.getDrawTop(sceneComponent3);
            int n2 = RelativeUtilitiesKt.getDrawBottom(parent);
            SceneComponent sceneComponent4 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent4, (String)"myComponent");
            int dy = Math.max(n, Math.min(y, n2 - sceneComponent4.getDrawHeight()));
            OptionalInt optionalInt = snappedY = this.getTargetNotchSnapper().trySnapVertical(dy);
            Intrinsics.checkExpressionValueIsNotNull((Object)optionalInt, (String)"snappedY");
            if (optionalInt.isPresent()) {
                this.getTargetNotchSnapper().applyNotches(attributes);
                TargetSnapper targetSnapper = this.getTargetNotchSnapper();
                Intrinsics.checkExpressionValueIsNotNull((Object)targetSnapper, (String)"targetNotchSnapper");
                BaseRelativeTarget baseRelativeTarget2 = this.myTargetY = (BaseRelativeTarget)targetSnapper.getSnappedVerticalTarget();
                if (baseRelativeTarget2 != null) {
                    baseRelativeTarget2.setMyIsHighlight(true);
                }
                this.getTargetNotchSnapper().clearSnappedNotches();
                return snappedY.getAsInt();
            }
            this.addVerticalParentConstraint(attributes, dy);
            return dy;
        }
        this.updateVerticalConstraints(attributes);
        return y;
    }

    private final void addVerticalParentConstraint(NlAttributesHolder attributes, int y) {
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        SceneComponent sceneComponent2 = sceneComponent.getParent();
        if (sceneComponent2 == null) {
            Intrinsics.throwNpe();
        }
        SceneComponent parent = sceneComponent2;
        SceneComponent sceneComponent3 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"myComponent");
        int n = y + sceneComponent3.getDrawHeight() / 2;
        SceneComponent sceneComponent4 = parent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent4, (String)"parent");
        if (n < RelativeUtilitiesKt.getDrawCenterY(sceneComponent4)) {
            attributes.setAndroidAttribute("layout_alignParentTop", "true");
            int n2 = y - RelativeUtilitiesKt.getDrawTop(parent);
            int n3 = 0;
            String string = "layout_marginTop";
            NlAttributesHolder nlAttributesHolder = attributes;
            int n4 = Math.max(n2, n3);
            nlAttributesHolder.setAndroidAttribute(string, RelativeUtilitiesKt.toDpString(n4));
        } else {
            attributes.setAndroidAttribute("layout_alignParentBottom", "true");
            int n5 = RelativeUtilitiesKt.getDrawBottom(parent);
            SceneComponent sceneComponent5 = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent5, (String)"myComponent");
            int n6 = n5 - (y + sceneComponent5.getDrawHeight());
            int n7 = 0;
            String string = "layout_marginBottom";
            NlAttributesHolder nlAttributesHolder = attributes;
            int n8 = Math.max(n6, n7);
            nlAttributesHolder.setAndroidAttribute(string, RelativeUtilitiesKt.toDpString(n8));
        }
    }

    private final void updateVerticalConstraints(NlAttributesHolder attributes) {
        String[] stringArray = RelativeUtilitiesKt.getTOP_ALIGN_ATTRIBUTES();
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
        this.updateAlignAttributeIfNeed(attributes, stringArray, RelativeUtilitiesKt.getDrawTop(sceneComponent), RelativeUtilitiesKt.getTOP_ATTRIBUTE_RULES());
        String[] stringArray2 = RelativeUtilitiesKt.getBOTTOM_ALIGN_ATTRIBUTES();
        SceneComponent sceneComponent2 = this.myComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"myComponent");
        this.updateAlignAttributeIfNeed(attributes, stringArray2, RelativeUtilitiesKt.getDrawBottom(sceneComponent2), RelativeUtilitiesKt.getBOTTOM_ATTRIBUTE_RULES());
    }

    private final void postProcessAttribute(AttributesTransaction attributes) {
        AttributesTransaction $receiver = attributes;
        if (Intrinsics.areEqual((Object)$receiver.getAndroidAttribute("layout_centerHorizontal"), (Object)"true") && Intrinsics.areEqual((Object)$receiver.getAndroidAttribute("layout_centerVertical"), (Object)"true")) {
            $receiver.removeAndroidAttribute("layout_centerHorizontal");
            $receiver.removeAndroidAttribute("layout_centerVertical");
            $receiver.setAndroidAttribute("layout_centerInParent", "true");
        }
    }

    private final void updateAlignAttributeIfNeed(NlAttributesHolder attributes, String[] attributesToUpdate, int coordinateToUpdate, AlignAttributeRules rules) {
        boolean bl;
        block2: {
            for (Object element$iv : (Object[])attributesToUpdate) {
                String it = (String)element$iv;
                if (!(attributes.getAndroidAttribute(it) != null)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl) {
            SceneComponent sceneComponent = this.myComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"myComponent");
            RelativeUtilitiesKt.updateAlignAttribute(sceneComponent, attributes, coordinateToUpdate, rules);
        }
    }
}

