/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative.targets;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.relative.targets.AlignAttributeRules;
import com.android.tools.idea.uibuilder.handlers.relative.targets.RelativeUtilitiesKt;
import com.android.tools.idea.uibuilder.model.TextDirection;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u00101\u001a\b\u0012\u0004\u0012\u00020\u0002022\u0006\u00103\u001a\u00020$2\b\u00104\u001a\u0004\u0018\u00010\u0002H\u0000\u001a(\u00105\u001a\u0002062\u0006\u00103\u001a\u00020$2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020#2\u0006\u0010:\u001a\u00020\u0007H\u0000\u001a\f\u0010;\u001a\u00020\u0002*\u00020#H\u0000\"\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u000b\u0010\u0004\"\u0014\u0010\f\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\"\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u000f\u0010\u0004\"\u0014\u0010\u0010\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\"\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0013\u0010\u0004\"\u0014\u0010\u0014\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\t\"\u0014\u0010\u0016\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\t\"\u0014\u0010\u0018\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\t\"\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u001b\u0010\u0004\"\u0014\u0010\u001c\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\t\"\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u001f\u0010\u0004\"\u0014\u0010 \u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\t\"\u0018\u0010\"\u001a\u00020#*\u00020$8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\"\u0018\u0010'\u001a\u00020#*\u00020$8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&\"\u0018\u0010)\u001a\u00020#*\u00020$8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010&\"\u0018\u0010+\u001a\u00020#*\u00020$8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010&\"\u0018\u0010-\u001a\u00020#*\u00020$8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010&\"\u0018\u0010/\u001a\u00020#*\u00020$8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010&\u00a8\u0006<"}, d2={"BOTTOM_ALIGN_ATTRIBUTES", "", "", "getBOTTOM_ALIGN_ATTRIBUTES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "BOTTOM_ATTRIBUTE_RULES", "Lcom/android/tools/idea/uibuilder/handlers/relative/targets/AlignAttributeRules;", "getBOTTOM_ATTRIBUTE_RULES", "()Lcom/android/tools/idea/uibuilder/handlers/relative/targets/AlignAttributeRules;", "END_ALIGN_ATTRIBUTES", "getEND_ALIGN_ATTRIBUTES", "END_ATTRIBUTE_RULES", "getEND_ATTRIBUTE_RULES", "LEFT_ALIGN_ATTRIBUTES", "getLEFT_ALIGN_ATTRIBUTES", "LEFT_ATTRIBUTE_RULES", "getLEFT_ATTRIBUTE_RULES", "RIGHT_ALIGN_ATTRIBUTES", "getRIGHT_ALIGN_ATTRIBUTES", "RIGHT_ATTRIBUTE_RULES", "getRIGHT_ATTRIBUTE_RULES", "RTL_END_ATTRIBUTE_RULES", "getRTL_END_ATTRIBUTE_RULES", "RTL_START_ATTRIBUTE_RULES", "getRTL_START_ATTRIBUTE_RULES", "START_ALIGN_ATTRIBUTES", "getSTART_ALIGN_ATTRIBUTES", "START_ATTRIBUTE_RULES", "getSTART_ATTRIBUTE_RULES", "TOP_ALIGN_ATTRIBUTES", "getTOP_ALIGN_ATTRIBUTES", "TOP_ATTRIBUTE_RULES", "getTOP_ATTRIBUTE_RULES", "drawBottom", "", "Lcom/android/tools/idea/common/scene/SceneComponent;", "getDrawBottom", "(Lcom/android/tools/idea/common/scene/SceneComponent;)I", "drawCenterX", "getDrawCenterX", "drawCenterY", "getDrawCenterY", "drawLeft", "getDrawLeft", "drawRight", "getDrawRight", "drawTop", "getDrawTop", "getProperAttributesForLayout", "", "component", "attribute", "updateAlignAttribute", "", "attributes", "Lcom/android/tools/idea/common/model/NlAttributesHolder;", "value", "rules", "toDpString", "intellij.android.designer"})
public final class RelativeUtilitiesKt {
    @NotNull
    private static final AlignAttributeRules TOP_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginTop", "layout_alignParentTop", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)TOP_ATTRIBUTE_RULES.1.INSTANCE), TuplesKt.to((Object)"layout_alignTop", (Object)((Object)TOP_ATTRIBUTE_RULES.2.INSTANCE)), TuplesKt.to((Object)"layout_below", (Object)((Object)TOP_ATTRIBUTE_RULES.3.INSTANCE)));
    @NotNull
    private static final AlignAttributeRules BOTTOM_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginBottom", "layout_alignParentBottom", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)BOTTOM_ATTRIBUTE_RULES.1.INSTANCE), TuplesKt.to((Object)"layout_alignBottom", (Object)((Object)BOTTOM_ATTRIBUTE_RULES.2.INSTANCE)), TuplesKt.to((Object)"layout_above", (Object)((Object)BOTTOM_ATTRIBUTE_RULES.3.INSTANCE)));
    @NotNull
    private static final AlignAttributeRules START_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginStart", "layout_alignParentStart", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)START_ATTRIBUTE_RULES.1.INSTANCE), TuplesKt.to((Object)"layout_alignStart", (Object)((Object)START_ATTRIBUTE_RULES.2.INSTANCE)), TuplesKt.to((Object)"layout_toEndOf", (Object)((Object)START_ATTRIBUTE_RULES.3.INSTANCE)));
    @NotNull
    private static final AlignAttributeRules RTL_START_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginStart", "layout_alignParentStart", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)RTL_START_ATTRIBUTE_RULES.1.INSTANCE), TuplesKt.to((Object)"layout_alignStart", (Object)((Object)RTL_START_ATTRIBUTE_RULES.2.INSTANCE)), TuplesKt.to((Object)"layout_toEndOf", (Object)((Object)RTL_START_ATTRIBUTE_RULES.3.INSTANCE)));
    @NotNull
    private static final AlignAttributeRules LEFT_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginLeft", "layout_alignParentLeft", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)LEFT_ATTRIBUTE_RULES.1.INSTANCE), TuplesKt.to((Object)"layout_alignLeft", (Object)((Object)LEFT_ATTRIBUTE_RULES.2.INSTANCE)), TuplesKt.to((Object)"layout_toRightOf", (Object)((Object)LEFT_ATTRIBUTE_RULES.3.INSTANCE)));
    @NotNull
    private static final AlignAttributeRules END_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginEnd", "layout_alignParentEnd", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)END_ATTRIBUTE_RULES.1.INSTANCE), TuplesKt.to((Object)"layout_alignEnd", (Object)((Object)END_ATTRIBUTE_RULES.2.INSTANCE)), TuplesKt.to((Object)"layout_toStartOf", (Object)((Object)END_ATTRIBUTE_RULES.3.INSTANCE)));
    @NotNull
    private static final AlignAttributeRules RTL_END_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginEnd", "layout_alignParentEnd", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)RTL_END_ATTRIBUTE_RULES.1.INSTANCE), TuplesKt.to((Object)"layout_alignEnd", (Object)((Object)RTL_END_ATTRIBUTE_RULES.2.INSTANCE)), TuplesKt.to((Object)"layout_toStartOf", (Object)((Object)RTL_END_ATTRIBUTE_RULES.3.INSTANCE)));
    @NotNull
    private static final AlignAttributeRules RIGHT_ATTRIBUTE_RULES = new AlignAttributeRules("layout_marginRight", "layout_alignParentRight", (Function2<? super SceneComponent, ? super Integer, Integer>)((Function2)RIGHT_ATTRIBUTE_RULES.1.INSTANCE), TuplesKt.to((Object)"layout_alignRight", (Object)((Object)RIGHT_ATTRIBUTE_RULES.2.INSTANCE)), TuplesKt.to((Object)"layout_toLeftOf", (Object)((Object)RIGHT_ATTRIBUTE_RULES.3.INSTANCE)));
    @NotNull
    private static final String[] TOP_ALIGN_ATTRIBUTES = new String[]{"layout_alignParentTop", "layout_alignTop", "layout_below"};
    @NotNull
    private static final String[] BOTTOM_ALIGN_ATTRIBUTES = new String[]{"layout_alignParentBottom", "layout_alignBottom", "layout_above"};
    @NotNull
    private static final String[] START_ALIGN_ATTRIBUTES = new String[]{"layout_alignParentStart", "layout_alignStart", "layout_toEndOf"};
    @NotNull
    private static final String[] LEFT_ALIGN_ATTRIBUTES = new String[]{"layout_alignParentLeft", "layout_alignLeft", "layout_toRightOf"};
    @NotNull
    private static final String[] END_ALIGN_ATTRIBUTES = new String[]{"layout_alignParentEnd", "layout_alignEnd", "layout_toStartOf"};
    @NotNull
    private static final String[] RIGHT_ALIGN_ATTRIBUTES = new String[]{"layout_alignParentRight", "layout_alignRight", "layout_toLeftOf"};

    @NotNull
    public static final List<String> getProperAttributesForLayout(@NotNull SceneComponent component, @Nullable String attribute) {
        ViewEditor viewEditor;
        TextDirection rtlDirection;
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Scene scene = component.getScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)scene, (String)"component.scene");
        TextDirection textDirection = rtlDirection = scene.isInRTL() ? TextDirection.RIGHT_TO_LEFT : TextDirection.LEFT_TO_RIGHT;
        if (attribute == null) {
            return CollectionsKt.emptyList();
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Scene scene2 = component.getScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)scene2, (String)"component.scene");
        SceneManager sceneManager = scene2.getSceneManager();
        if (sceneManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager");
        }
        ViewEditor viewEditor2 = viewEditor = ((LayoutlibSceneManager)sceneManager).getViewEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)viewEditor2, (String)"viewEditor");
        AndroidVersion androidVersion = viewEditor2.getMinSdkVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"viewEditor.minSdkVersion");
        if (androidVersion.getApiLevel() < 17) {
            builder.add((Object)attribute);
        }
        AndroidVersion androidVersion2 = viewEditor.getTargetSdkVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion2, (String)"viewEditor.targetSdkVersion");
        if (androidVersion2.getApiLevel() >= 17) {
            String string;
            switch (attribute) {
                case "layout_alignParentLeft": {
                    string = rtlDirection.getAttrAlignParentLeft();
                    break;
                }
                case "layout_alignParentRight": {
                    string = rtlDirection.getAttrAlignParentRight();
                    break;
                }
                case "layout_alignLeft": {
                    string = rtlDirection.getAttrLeft();
                    break;
                }
                case "layout_alignRight": {
                    string = rtlDirection.getAttrRight();
                    break;
                }
                case "layout_toLeftOf": {
                    string = rtlDirection.getAttrLeftOf();
                    break;
                }
                case "layout_toRightOf": {
                    string = rtlDirection.getAttrRightOf();
                    break;
                }
                case "layout_marginLeft": {
                    string = rtlDirection.getAttrMarginLeft();
                    break;
                }
                case "layout_marginRight": {
                    string = rtlDirection.getAttrMarginRight();
                    break;
                }
                default: {
                    string = attribute;
                }
            }
            String rtlAttribute = string;
            builder.add((Object)rtlAttribute);
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return (List)immutableList;
    }

    public static final int getDrawLeft(@NotNull SceneComponent $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getDrawX();
    }

    public static final int getDrawTop(@NotNull SceneComponent $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getDrawY();
    }

    public static final int getDrawRight(@NotNull SceneComponent $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getDrawX() + $receiver.getDrawWidth();
    }

    public static final int getDrawBottom(@NotNull SceneComponent $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getDrawY() + $receiver.getDrawHeight();
    }

    public static final int getDrawCenterX(@NotNull SceneComponent $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getDrawX() + $receiver.getDrawWidth() / 2;
    }

    public static final int getDrawCenterY(@NotNull SceneComponent $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getDrawY() + $receiver.getDrawHeight() / 2;
    }

    @NotNull
    public static final String toDpString(int $receiver) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%ddp";
        Object[] objectArray = new Object[]{$receiver};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    public static final void updateAlignAttribute(@NotNull SceneComponent component, @NotNull NlAttributesHolder attributes, int value, @NotNull AlignAttributeRules rules) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Intrinsics.checkParameterIsNotNull((Object)rules, (String)"rules");
        SceneComponent sceneComponent = component.getParent();
        if (sceneComponent == null) {
            Intrinsics.throwNpe();
        }
        SceneComponent parent = sceneComponent;
        if (Intrinsics.areEqual((Object)attributes.getAndroidAttribute(rules.getAlignParentAttribute()), (Object)"true")) {
            String string = rules.getMarginAttribute();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%ddp";
            Object[] objectArray = new Object[1];
            Function2<SceneComponent, Integer, Integer> function2 = rules.getAlignParentRule();
            SceneComponent sceneComponent2 = parent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"parent");
            objectArray[0] = function2.invoke((Object)sceneComponent2, (Object)value);
            Object[] objectArray2 = objectArray;
            String string3 = string;
            NlAttributesHolder nlAttributesHolder = attributes;
            String string4 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            String string5 = string4;
            nlAttributesHolder.setAndroidAttribute(string3, string5);
            return;
        }
        for (Pair<String, Function2<SceneComponent, Integer, Integer>> pair : rules.getAlignWidgetRules()) {
            String id = (String)pair.component1();
            Function2 rule = (Function2)pair.component2();
            String alignWidget = NlComponent.extractId(attributes.getAndroidAttribute(id));
            if (alignWidget == null) continue;
            SceneComponent sceneComponent3 = parent.getSceneComponent(alignWidget);
            if (sceneComponent3 == null) {
                return;
            }
            SceneComponent alignedComponent = sceneComponent3;
            String string = rules.getMarginAttribute();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string6 = "%ddp";
            Object[] objectArray = new Object[1];
            SceneComponent sceneComponent4 = alignedComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent4, (String)"alignedComponent");
            objectArray[0] = rule.invoke((Object)sceneComponent4, (Object)value);
            Object[] objectArray3 = objectArray;
            String string7 = string;
            NlAttributesHolder nlAttributesHolder = attributes;
            String string8 = String.format(string6, Arrays.copyOf(objectArray3, objectArray3.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"java.lang.String.format(format, *args)");
            String string9 = string8;
            nlAttributesHolder.setAndroidAttribute(string7, string9);
            return;
        }
    }

    @NotNull
    public static final AlignAttributeRules getTOP_ATTRIBUTE_RULES() {
        return TOP_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getBOTTOM_ATTRIBUTE_RULES() {
        return BOTTOM_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getSTART_ATTRIBUTE_RULES() {
        return START_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getRTL_START_ATTRIBUTE_RULES() {
        return RTL_START_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getLEFT_ATTRIBUTE_RULES() {
        return LEFT_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getEND_ATTRIBUTE_RULES() {
        return END_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getRTL_END_ATTRIBUTE_RULES() {
        return RTL_END_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final AlignAttributeRules getRIGHT_ATTRIBUTE_RULES() {
        return RIGHT_ATTRIBUTE_RULES;
    }

    @NotNull
    public static final String[] getTOP_ALIGN_ATTRIBUTES() {
        return TOP_ALIGN_ATTRIBUTES;
    }

    @NotNull
    public static final String[] getBOTTOM_ALIGN_ATTRIBUTES() {
        return BOTTOM_ALIGN_ATTRIBUTES;
    }

    @NotNull
    public static final String[] getSTART_ALIGN_ATTRIBUTES() {
        return START_ALIGN_ATTRIBUTES;
    }

    @NotNull
    public static final String[] getLEFT_ALIGN_ATTRIBUTES() {
        return LEFT_ALIGN_ATTRIBUTES;
    }

    @NotNull
    public static final String[] getEND_ALIGN_ATTRIBUTES() {
        return END_ALIGN_ATTRIBUTES;
    }

    @NotNull
    public static final String[] getRIGHT_ALIGN_ATTRIBUTES() {
        return RIGHT_ALIGN_ATTRIBUTES;
    }
}

