/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.res.FloatResources;
import com.android.tools.idea.res.ResourceIdManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutParamsManager {
    private static final Object MISSING = new Object();
    private static final Cache<String, Map<String, Object>> ourDefaultValuesCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).softValues().build();
    private static final Map<String, Function<String, MappedField>> FIELD_MAPPERS = new HashMap<String, Function<String, MappedField>>();
    private static final Function<String, MappedField> CONSTRAINT_LAYOUT_MAPPER = attributeName -> {
        attributeName = StringUtil.trimStart((String)attributeName, (String)"constraint");
        attributeName = StringUtil.trimEnd((String)attributeName, (String)"Of");
        StringBuilder fieldName = new StringBuilder();
        boolean first = true;
        for (String component : Splitter.on((char)'_').split((CharSequence)attributeName)) {
            fieldName.append(first ? StringUtil.decapitalize((String)component) : StringUtil.capitalize((String)component));
            first = false;
        }
        return new MappedField(fieldName.toString(), null);
    };
    private static final Function<String, MappedField> COORDINATOR_LAYOUT_MAPPER = attributeName -> {
        if ("anchor".equals(attributeName)) {
            return new MappedField("anchorId", AttributeFormat.Integer);
        }
        return null;
    };

    public static void registerFieldMapper(@NotNull String layoutParamsClassName, @NotNull Function<String, MappedField> mapper) {
        if (layoutParamsClassName == null) {
            LayoutParamsManager.$$$reportNull$$$0(0);
        }
        if (mapper == null) {
            LayoutParamsManager.$$$reportNull$$$0(1);
        }
        FIELD_MAPPERS.put(layoutParamsClassName, mapper);
    }

    @NotNull
    private static EnumSet<AttributeFormat> attributeFormatFromType(@NotNull Class type) {
        if (type == null) {
            LayoutParamsManager.$$$reportNull$$$0(2);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            EnumSet<AttributeFormat> enumSet = EnumSet.of(AttributeFormat.Integer);
            if (enumSet == null) {
                LayoutParamsManager.$$$reportNull$$$0(3);
            }
            return enumSet;
        }
        if (type == Float.class || type == Float.TYPE) {
            EnumSet<AttributeFormat> enumSet = EnumSet.of(AttributeFormat.Float);
            if (enumSet == null) {
                LayoutParamsManager.$$$reportNull$$$0(4);
            }
            return enumSet;
        }
        if (type == String.class) {
            EnumSet<AttributeFormat> enumSet = EnumSet.of(AttributeFormat.String);
            if (enumSet == null) {
                LayoutParamsManager.$$$reportNull$$$0(5);
            }
            return enumSet;
        }
        EnumSet<AttributeFormat> enumSet = EnumSet.noneOf(AttributeFormat.class);
        if (enumSet == null) {
            LayoutParamsManager.$$$reportNull$$$0(6);
        }
        return enumSet;
    }

    private static boolean setField(@NotNull Object target, @NotNull MappedField fieldName, @Nullable Object value) {
        if (target == null) {
            LayoutParamsManager.$$$reportNull$$$0(7);
        }
        if (fieldName == null) {
            LayoutParamsManager.$$$reportNull$$$0(8);
        }
        try {
            target.getClass().getField(fieldName.name).set(target, value);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            String setterName = "set" + StringUtil.capitalize((String)fieldName.name);
            Optional<Method> setterMethod = Arrays.stream(target.getClass().getMethods()).filter(method -> method.getParameterCount() == 1 && method.getName().equals(setterName)).findFirst();
            if (setterMethod.isPresent()) {
                try {
                    setterMethod.get().invoke(target, value);
                    return true;
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException2) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    @NotNull
    private static Integer getDimensionValue(@NotNull String value, @NotNull Configuration configuration) {
        if (value == null) {
            LayoutParamsManager.$$$reportNull$$$0(9);
        }
        if (configuration == null) {
            LayoutParamsManager.$$$reportNull$$$0(10);
        }
        switch (value) {
            case "fill_parent": 
            case "match_parent": {
                Integer n = -1;
                if (n == null) {
                    LayoutParamsManager.$$$reportNull$$$0(11);
                }
                return n;
            }
            case "wrap_content": {
                Integer n = -2;
                if (n == null) {
                    LayoutParamsManager.$$$reportNull$$$0(12);
                }
                return n;
            }
        }
        FloatResources.TypedValue out = new FloatResources.TypedValue();
        if (FloatResources.parseFloatAttribute(value, out, true)) {
            Integer n = FloatResources.TypedValue.complexToDimensionPixelSize(out.data, configuration);
            if (n == null) {
                LayoutParamsManager.$$$reportNull$$$0(13);
            }
            return n;
        }
        Integer n = 0;
        if (n == null) {
            LayoutParamsManager.$$$reportNull$$$0(14);
        }
        return n;
    }

    @NotNull
    private static EnumSet<AttributeFormat> inferTypeFromField(@NotNull Object layoutParams, @NotNull MappedField mappedField) {
        EnumSet<AttributeFormat> enumSet;
        if (layoutParams == null) {
            LayoutParamsManager.$$$reportNull$$$0(15);
        }
        if (mappedField == null) {
            LayoutParamsManager.$$$reportNull$$$0(16);
        }
        try {
            Field field2 = layoutParams.getClass().getField(mappedField.name);
            enumSet = LayoutParamsManager.attributeFormatFromType(field2.getType());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            EnumSet<AttributeFormat> enumSet2 = EnumSet.noneOf(AttributeFormat.class);
            if (enumSet2 == null) {
                LayoutParamsManager.$$$reportNull$$$0(18);
            }
            return enumSet2;
        }
        if (enumSet == null) {
            LayoutParamsManager.$$$reportNull$$$0(17);
        }
        return enumSet;
    }

    @VisibleForTesting
    @Nullable
    static Object getDefaultValue(@NotNull Object layoutParams, @NotNull MappedField field2) throws NoSuchElementException {
        Object defaultValue;
        String layoutParamsClassName;
        Map<String, Object> layoutParamsDefaults;
        if (layoutParams == null) {
            LayoutParamsManager.$$$reportNull$$$0(19);
        }
        if (field2 == null) {
            LayoutParamsManager.$$$reportNull$$$0(20);
        }
        if ((layoutParamsDefaults = (Map<String, Object>)ourDefaultValuesCache.getIfPresent((Object)(layoutParamsClassName = layoutParams.getClass().getName()))) == null) {
            layoutParamsDefaults = LayoutParamsManager.getDefaultValuesFromClass(layoutParams.getClass());
            ourDefaultValuesCache.put((Object)layoutParamsClassName, layoutParamsDefaults);
        }
        if ((defaultValue = layoutParamsDefaults.getOrDefault(field2.name, MISSING)) == MISSING) {
            throw new NoSuchElementException();
        }
        return defaultValue;
    }

    @NotNull
    private static EnumSet<AttributeFormat> inferTypeFromValue(@Nullable String value) {
        if (value != null && (value.endsWith("dp") || value.endsWith("dip") || value.endsWith("px"))) {
            EnumSet<AttributeFormat> enumSet = EnumSet.of(AttributeFormat.Dimension);
            if (enumSet == null) {
                LayoutParamsManager.$$$reportNull$$$0(21);
            }
            return enumSet;
        }
        EnumSet<AttributeFormat> enumSet = EnumSet.noneOf(AttributeFormat.class);
        if (enumSet == null) {
            LayoutParamsManager.$$$reportNull$$$0(22);
        }
        return enumSet;
    }

    @VisibleForTesting
    @NotNull
    static Map<String, Object> getDefaultValuesFromClass(@NotNull Class layoutParamsClass) {
        if (layoutParamsClass == null) {
            LayoutParamsManager.$$$reportNull$$$0(23);
        }
        Object layoutParamsClassInstance = null;
        for (Constructor<?> constructor : layoutParamsClass.getConstructors()) {
            Object[] parameterDefaults;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != (parameterDefaults = Arrays.stream(parameterTypes).map(type -> {
                if (type == Integer.class || type == Integer.TYPE) {
                    return 0;
                }
                return null;
            }).filter(Objects::nonNull).toArray()).length) continue;
            try {
                layoutParamsClassInstance = constructor.newInstance(parameterDefaults);
                break;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (layoutParamsClassInstance == null) {
            Map<String, Object> map2 = Collections.emptyMap();
            if (map2 == null) {
                LayoutParamsManager.$$$reportNull$$$0(24);
            }
            return map2;
        }
        Field[] fields = layoutParamsClass.getFields();
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        Object finalLayoutParamsClassInstance = layoutParamsClassInstance;
        Arrays.stream(fields).filter(field2 -> !Modifier.isStatic(field2.getModifiers()) && !Modifier.isFinal(field2.getModifiers())).filter(field2 -> !"layoutAnimationParameters".equals(field2.getName())).forEach(field2 -> {
            try {
                defaults.put(field2.getName(), field2.get(finalLayoutParamsClassInstance));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        });
        Method[] methods = layoutParamsClass.getMethods();
        Arrays.stream(methods).filter(method -> method.getParameterCount() == 0 && Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("get")).filter(method -> !method.getDeclaringClass().getName().startsWith("java.lang")).forEach(method -> {
            String propertyName = StringUtil.decapitalize((String)StringUtil.trimStart((String)method.getName(), (String)"get"));
            if (!defaults.containsKey(propertyName)) {
                try {
                    defaults.put(propertyName, method.invoke(finalLayoutParamsClassInstance, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        });
        HashMap<String, Object> hashMap = defaults;
        if (hashMap == null) {
            LayoutParamsManager.$$$reportNull$$$0(25);
        }
        return hashMap;
    }

    @VisibleForTesting
    @NotNull
    static MappedField mapField(@NotNull Object layoutParams, @NotNull String attributeName) {
        if (layoutParams == null) {
            LayoutParamsManager.$$$reportNull$$$0(26);
        }
        if (attributeName == null) {
            LayoutParamsManager.$$$reportNull$$$0(27);
        }
        Class<?> currentClass = layoutParams.getClass();
        while (!currentClass.equals(Object.class)) {
            MappedField mappedField;
            Function<String, MappedField> fieldMapper = FIELD_MAPPERS.get(currentClass.getName());
            if (fieldMapper != null && (mappedField = fieldMapper.apply(attributeName)) != null) {
                MappedField mappedField2;
                try {
                    currentClass.getDeclaredField(mappedField.name);
                    mappedField2 = mappedField;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    String setterName = "set" + StringUtil.capitalize((String)mappedField.name);
                    for (Method method : currentClass.getDeclaredMethods()) {
                        if (!setterName.equals(method.getName())) continue;
                        MappedField mappedField3 = mappedField;
                        if (mappedField3 == null) {
                            LayoutParamsManager.$$$reportNull$$$0(29);
                        }
                        return mappedField3;
                    }
                }
                if (mappedField2 == null) {
                    LayoutParamsManager.$$$reportNull$$$0(28);
                }
                return mappedField2;
            }
            currentClass = currentClass.getSuperclass();
        }
        MappedField mappedField = new MappedField(attributeName, null);
        if (mappedField == null) {
            LayoutParamsManager.$$$reportNull$$$0(30);
        }
        return mappedField;
    }

    @VisibleForTesting
    static boolean setAttribute(@Nullable AttributeDefinition attributeDefinition, @NotNull Object layoutParams, @NotNull String attributeName, @Nullable String value, @NotNull NlModel model) {
        ResourceValue resourceValue2;
        EnumSet<AttributeFormat> inferredTypes;
        if (layoutParams == null) {
            LayoutParamsManager.$$$reportNull$$$0(31);
        }
        if (attributeName == null) {
            LayoutParamsManager.$$$reportNull$$$0(32);
        }
        if (model == null) {
            LayoutParamsManager.$$$reportNull$$$0(33);
        }
        EnumSet<AttributeFormat> enumSet = inferredTypes = attributeDefinition != null ? EnumSet.copyOf(attributeDefinition.getFormats()) : EnumSet.noneOf(AttributeFormat.class);
        if (value != null && (value.startsWith("@") || value.startsWith("?")) && model.getConfiguration().getResourceResolver() != null && (resourceValue2 = model.getConfiguration().getResourceResolver().findResValue(value, false)) != null) {
            value = resourceValue2.getValue();
            switch (resourceValue2.getResourceType()) {
                case INTEGER: 
                case ID: 
                case DIMEN: {
                    inferredTypes.add(AttributeFormat.Integer);
                    break;
                }
                case FRACTION: {
                    inferredTypes.add(AttributeFormat.Float);
                }
            }
            if (resourceValue2.getResourceType() == ResourceType.ID) {
                value = String.valueOf(ResourceIdManager.get(model.getModule()).getOrGenerateId(resourceValue2.asReference()));
            }
        }
        MappedField mappedField = LayoutParamsManager.mapField(layoutParams, attributeName);
        if (inferredTypes.isEmpty()) {
            inferredTypes.addAll(mappedField.type);
        }
        if (inferredTypes.isEmpty()) {
            inferredTypes.addAll(LayoutParamsManager.inferTypeFromValue(value));
        }
        if (inferredTypes.isEmpty()) {
            inferredTypes.addAll(LayoutParamsManager.inferTypeFromField(layoutParams, mappedField));
        }
        Object defaultValue = null;
        try {
            defaultValue = LayoutParamsManager.getDefaultValue(layoutParams, mappedField);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (defaultValue != null && inferredTypes.isEmpty()) {
            inferredTypes.addAll(LayoutParamsManager.attributeFormatFromType(defaultValue.getClass()));
        }
        if (value == null) {
            return LayoutParamsManager.setField(layoutParams, mappedField, defaultValue);
        }
        boolean fieldSet = false;
        block19: for (AttributeFormat type : inferredTypes) {
            switch (type) {
                case Dimension: {
                    fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, LayoutParamsManager.getDimensionValue(value, model.getConfiguration()));
                    break;
                }
                case Integer: {
                    try {
                        fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {
                        fieldSet = false;
                    }
                    break;
                }
                case String: {
                    fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, value);
                    break;
                }
                case Boolean: {
                    fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, Boolean.parseBoolean(value));
                    break;
                }
                case Float: {
                    try {
                        fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, Float.valueOf(Float.parseFloat(value)));
                    }
                    catch (NumberFormatException e) {
                        fieldSet = false;
                    }
                    break;
                }
                case Enum: {
                    Integer intValue;
                    Integer n = intValue = attributeDefinition != null ? attributeDefinition.getValueMapping(value) : null;
                    if (intValue == null) break;
                    fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, intValue);
                    break;
                }
                case Flags: {
                    if (attributeDefinition == null) continue block19;
                    OptionalInt flagValue = Splitter.on((char)'|').splitToList((CharSequence)value).stream().map(StringUtil::trim).map(attributeDefinition::getValueMapping).filter(Objects::nonNull).mapToInt(Integer::intValue).reduce((a, b) -> a | b);
                    if (!flagValue.isPresent()) break;
                    fieldSet = LayoutParamsManager.setField(layoutParams, mappedField, flagValue.getAsInt());
                    break;
                }
            }
            if (!fieldSet) continue;
            return true;
        }
        return false;
    }

    public static boolean setAttribute(@NotNull Object layoutParams, @NotNull String attributeName, @Nullable String value, @NotNull NlModel model) {
        if (layoutParams == null) {
            LayoutParamsManager.$$$reportNull$$$0(34);
        }
        if (attributeName == null) {
            LayoutParamsManager.$$$reportNull$$$0(35);
        }
        if (model == null) {
            LayoutParamsManager.$$$reportNull$$$0(36);
        }
        AttributeDefinition attributeDefinition = ResolutionUtils.getAttributeDefinition(model.getModule(), model.getConfiguration(), "layout_" + attributeName);
        return LayoutParamsManager.setAttribute(attributeDefinition, layoutParams, attributeName, value, model);
    }

    static {
        LayoutParamsManager.registerFieldMapper(ViewGroup.LayoutParams.class.getName(), attributeName -> {
            switch (attributeName) {
                case "width": 
                case "height": {
                    return new MappedField((String)attributeName, AttributeFormat.Dimension);
                }
                case "gravity": {
                    return new MappedField((String)attributeName, AttributeFormat.Flags);
                }
            }
            return null;
        });
        LayoutParamsManager.registerFieldMapper(LinearLayout.LayoutParams.class.getName(), attributeName -> "gravity".equals(attributeName) ? new MappedField((String)attributeName, AttributeFormat.Flags) : null);
        LayoutParamsManager.registerFieldMapper(ViewGroup.MarginLayoutParams.class.getName(), attributeName -> {
            switch (attributeName) {
                case "marginBottom": {
                    return new MappedField("bottomMargin", AttributeFormat.Dimension);
                }
                case "marginTop": {
                    return new MappedField("topMargin", AttributeFormat.Dimension);
                }
                case "marginLeft": {
                    return new MappedField("leftMargin", AttributeFormat.Dimension);
                }
                case "marginRight": {
                    return new MappedField("rightMargin", AttributeFormat.Dimension);
                }
                case "marginStart": {
                    return new MappedField((String)attributeName, AttributeFormat.Dimension);
                }
                case "marginEnd": {
                    return new MappedField((String)attributeName, AttributeFormat.Dimension);
                }
            }
            return null;
        });
        LayoutParamsManager.registerFieldMapper(SdkConstants.CLASS_CONSTRAINT_LAYOUT_PARAMS.oldName(), CONSTRAINT_LAYOUT_MAPPER);
        LayoutParamsManager.registerFieldMapper(SdkConstants.CLASS_CONSTRAINT_LAYOUT_PARAMS.newName(), CONSTRAINT_LAYOUT_MAPPER);
        LayoutParamsManager.registerFieldMapper(SdkConstants.CLASS_COORDINATOR_LAYOUT.oldName() + "$LayoutParams", COORDINATOR_LAYOUT_MAPPER);
        LayoutParamsManager.registerFieldMapper(SdkConstants.CLASS_COORDINATOR_LAYOUT.newName() + "$LayoutParams", COORDINATOR_LAYOUT_MAPPER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutParamsClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/model/LayoutParamsManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 15: 
            case 19: 
            case 26: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutParams";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedField";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutParamsClass";
                break;
            }
            case 27: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/model/LayoutParamsManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "attributeFormatFromType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionValue";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeFromField";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeFromValue";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValuesFromClass";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "mapField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerFieldMapper";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "attributeFormatFromType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setField";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDimensionValue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeFromField";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValuesFromClass";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "mapField";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class MappedField {
        @VisibleForTesting
        @NotNull
        final String name;
        @VisibleForTesting
        @NotNull
        final EnumSet<AttributeFormat> type;

        MappedField(@NotNull String fieldName, @Nullable AttributeFormat type) {
            if (fieldName == null) {
                MappedField.$$$reportNull$$$0(0);
            }
            this.name = fieldName;
            this.type = type != null ? EnumSet.of(type) : EnumSet.noneOf(AttributeFormat.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/android/tools/idea/uibuilder/model/LayoutParamsManager$MappedField", "<init>"));
        }
    }
}

