/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.SdkConstants;
import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.common.editor.NlEditor;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0003*\u00020\u0004\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u0007*\u00020\u00042\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"CUSTOM_DENSITY_ID", "", "currentActivityIsDerivedFromAppCompatActivity", "", "Lcom/android/tools/idea/common/model/NlModel;", "moduleDependsOnAppCompat", "overrideConfigurationDensity", "", "density", "Lcom/android/resources/Density;", "overrideConfigurationScreenSize", "xDimension", "", "yDimension", "intellij.android.designer"})
public final class NlModelHelperKt {
    @NotNull
    public static final String CUSTOM_DENSITY_ID = "Custom Density";

    /*
     * WARNING - void declaration
     */
    public static final void overrideConfigurationScreenSize(@NotNull NlModel $receiver, int xDimension, int yDimension) {
        State newState;
        VirtualFile better;
        Device device;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Configuration configuration = $receiver.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"configuration");
        Device original = configuration.getDevice();
        Device.Builder deviceBuilder = new Device.Builder(original);
        if (original != null) {
            deviceBuilder.setTagId(original.getTagId());
        }
        deviceBuilder.setName("Custom");
        deviceBuilder.setId("Custom");
        Device device2 = device = deviceBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)device2, (String)"device");
        Iterator iterator = device2.getAllStates().iterator();
        while (iterator.hasNext()) {
            Screen screen;
            State state;
            State state2 = state = (State)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)state2, (String)"state");
            Hardware hardware = state2.getHardware();
            Intrinsics.checkExpressionValueIsNotNull((Object)hardware, (String)"state.hardware");
            Screen screen2 = screen = hardware.getScreen();
            Intrinsics.checkExpressionValueIsNotNull((Object)screen2, (String)"screen");
            screen2.setXDimension(xDimension);
            screen.setYDimension(yDimension);
            Density density = screen.getPixelDensity();
            Intrinsics.checkExpressionValueIsNotNull((Object)density, (String)"screen.pixelDensity");
            double dpi = density.getDpiValue();
            double width = (double)xDimension / dpi;
            double height = (double)yDimension / dpi;
            double diagonalLength = Math.sqrt(width * width + height * height);
            screen.setDiagonalLength(diagonalLength);
            screen.setSize(AvdScreenData.getScreenSize(diagonalLength));
            screen.setRatio(AvdScreenData.getScreenRatio(xDimension, yDimension));
            Hardware hardware2 = device.getDefaultHardware();
            Intrinsics.checkExpressionValueIsNotNull((Object)hardware2, (String)"device.defaultHardware");
            Screen screen3 = hardware2.getScreen();
            Intrinsics.checkExpressionValueIsNotNull((Object)screen3, (String)"device.defaultHardware.screen");
            screen.setScreenRound(screen3.getScreenRound());
            Hardware hardware3 = device.getDefaultHardware();
            Intrinsics.checkExpressionValueIsNotNull((Object)hardware3, (String)"device.defaultHardware");
            Screen screen4 = hardware3.getScreen();
            Intrinsics.checkExpressionValueIsNotNull((Object)screen4, (String)"device.defaultHardware.screen");
            screen.setChin(screen4.getChin());
        }
        Configuration configuration2 = $receiver.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
        ConfigurationManager configurationManager = configuration2.getConfigurationManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationManager, (String)"configuration.configurationManager");
        List<Device> devices = configurationManager.getDevices();
        boolean customDeviceReplaced = false;
        int screen = 0;
        List<Device> list = devices;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"devices");
        int dpi = ((Collection)list).size();
        while (screen < dpi) {
            void i;
            Device device3 = devices.get((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)device3, (String)"devices[i]");
            if (Intrinsics.areEqual((Object)"Custom", (Object)device3.getId())) {
                devices.set((int)i, device);
                customDeviceReplaced = true;
                break;
            }
            ++i;
        }
        if (!customDeviceReplaced) {
            devices.add(device);
        }
        if (xDimension > yDimension) {
            better = ConfigurationMatcher.getBetterMatch($receiver.getConfiguration(), device, "Landscape", null, null);
            newState = device.getState("Landscape");
        } else {
            better = ConfigurationMatcher.getBetterMatch($receiver.getConfiguration(), device, "Portrait", null, null);
            newState = device.getState("Portrait");
        }
        if (better != null) {
            Configuration configuration3 = $receiver.getConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
            VirtualFile virtualFile = configuration3.getFile();
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile old = virtualFile;
            Project project = $receiver.getProject();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, better, -1);
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            FileEditor selectedEditor = manager.getSelectedEditor(old);
            manager.openEditor(descriptor, true);
            if (selectedEditor instanceof NlEditor) {
                manager.setSelectedEditor(better, "android-designer2");
            } else if (selectedEditor != null) {
                TextEditorProvider textEditorProvider = TextEditorProvider.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)textEditorProvider, (String)"TextEditorProvider.getInstance()");
                manager.setSelectedEditor(better, textEditorProvider.getEditorTypeId());
            }
            Configuration configuration4 = $receiver.getConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration4, (String)"configuration");
            AndroidFacet facet = AndroidFacet.getInstance(configuration4.getModule());
            if (facet != null) {
                Configuration configuration5 = ConfigurationManager.getOrCreateInstance(facet).getConfiguration(better);
                configuration5.setEffectiveDevice(device, newState);
            }
        } else {
            $receiver.getConfiguration().setEffectiveDevice(device, newState);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void overrideConfigurationDensity(@NotNull NlModel $receiver, @NotNull Density density) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Device device;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Configuration configuration = $receiver.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"configuration");
        Device original = configuration.getDevice();
        Device.Builder deviceBuilder = new Device.Builder(original);
        if (original != null) {
            deviceBuilder.setTagId(original.getTagId());
        }
        deviceBuilder.setName("Custom");
        deviceBuilder.setId(CUSTOM_DENSITY_ID);
        Device device2 = device = deviceBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)device2, (String)"device");
        List list = device2.getAllStates();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"device.allStates");
        Iterable iterable = list;
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            State state = (State)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            Hardware hardware = v3.getHardware();
            Intrinsics.checkExpressionValueIsNotNull((Object)hardware, (String)"it.hardware");
            Screen screen = hardware.getScreen();
            collection.add(screen);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            Screen it;
            Screen screen = it = (Screen)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)screen, (String)"it");
            screen.setPixelDensity(density);
        }
        $receiver.getConfiguration().setEffectiveDevice(device, device.getDefaultState());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean moduleDependsOnAppCompat(@NotNull NlModel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Module module = $receiver.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"this.module");
        if (DependencyManagementUtil.dependsOn(module, GoogleMavenArtifactId.APP_COMPAT_V7)) return true;
        Module module2 = $receiver.getModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"this.module");
        if (!DependencyManagementUtil.dependsOn(module2, GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7)) return false;
        return true;
    }

    public static final boolean currentActivityIsDerivedFromAppCompatActivity(@NotNull NlModel $receiver) {
        PsiClass activityClass;
        String activityClassName;
        Configuration configuration;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Configuration configuration2 = configuration = $receiver.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
        String string = configuration2.getActivity();
        if (string == null) {
            return true;
        }
        String string2 = activityClassName = string;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        if (StringsKt.startsWith$default((String)string2, (String)".", (boolean)false, (int)2, null)) {
            MergedManifest manifest;
            MergedManifest mergedManifest = manifest = MergedManifest.get($receiver.getModule());
            Intrinsics.checkExpressionValueIsNotNull((Object)mergedManifest, (String)"manifest");
            String pkg = StringUtil.notNullize((String)mergedManifest.getPackage());
            activityClassName = pkg + activityClassName;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)$receiver.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)$receiver.getModule(), (String)"this.module");
        for (activityClass = facade.findClass(activityClassName, (v1303633).getModuleScope()); activityClass != null && !SdkConstants.CLASS_APP_COMPAT_ACTIVITY.isEquals(activityClass.getQualifiedName()); activityClass = activityClass.getSuperClass()) {
        }
        return activityClass != null;
    }
}

