/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.SegmentType;
import java.awt.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionHandle {
    public static final int PIXEL_RADIUS = 8;
    public static final int PIXEL_MARGIN = 2;
    @NotNull
    public final NlComponent component;
    private final Position myPosition;

    public int getCenterX() {
        return NlComponentHelperKt.getX(this.component) + (int)(this.myPosition.alignX * (double)NlComponentHelperKt.getW(this.component));
    }

    public int getCenterY() {
        return NlComponentHelperKt.getY(this.component) + (int)(this.myPosition.alignY * (double)NlComponentHelperKt.getH(this.component));
    }

    public SelectionHandle(@NotNull NlComponent component, @NotNull Position position) {
        if (component == null) {
            SelectionHandle.$$$reportNull$$$0(0);
        }
        if (position == null) {
            SelectionHandle.$$$reportNull$$$0(1);
        }
        this.component = component;
        this.myPosition = position;
    }

    public boolean contains(int x, int y, int distance) {
        int xDelta = Math.abs(x - this.getCenterX());
        if (xDelta > distance) {
            return false;
        }
        int yDelta = Math.abs(y - this.getCenterY());
        return yDelta <= distance;
    }

    public Position getPosition() {
        return this.myPosition;
    }

    public int getAwtCursorType() {
        return this.myPosition.getCursorType();
    }

    @NotNull
    public Cursor getCursor() {
        Cursor cursor = Cursor.getPredefinedCursor(this.getAwtCursorType());
        if (cursor == null) {
            SelectionHandle.$$$reportNull$$$0(2);
        }
        return cursor;
    }

    @Nullable
    public SegmentType getHorizontalEdge() {
        return this.myPosition.isTop() ? SegmentType.TOP : (this.myPosition.isBottom() ? SegmentType.BOTTOM : null);
    }

    @Nullable
    public SegmentType getVerticalEdge() {
        return this.myPosition.isLeft() ? SegmentType.LEFT : (this.myPosition.isRight() ? SegmentType.RIGHT : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/model/SelectionHandle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/model/SelectionHandle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCursor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Position {
        TOP_MIDDLE(8, 0.5, 0.0),
        TOP_RIGHT(7, 1.0, 0.0),
        RIGHT_MIDDLE(11, 1.0, 0.5),
        BOTTOM_RIGHT(5, 1.0, 1.0),
        BOTTOM_MIDDLE(9, 0.5, 1.0),
        BOTTOM_LEFT(4, 0.0, 1.0),
        LEFT_MIDDLE(10, 0.0, 0.5),
        TOP_LEFT(6, 0.0, 0.0);

        public final double alignX;
        public final double alignY;
        private final int myAwtCursor;

        private Position(int awtCursor, double alignX, double alignY) {
            this.myAwtCursor = awtCursor;
            this.alignX = alignX;
            this.alignY = alignY;
        }

        private int getCursorType() {
            return this.myAwtCursor;
        }

        public boolean isLeft() {
            return this == TOP_LEFT || this == LEFT_MIDDLE || this == BOTTOM_LEFT;
        }

        public boolean isRight() {
            return this == TOP_RIGHT || this == RIGHT_MIDDLE || this == BOTTOM_RIGHT;
        }

        public boolean isTop() {
            return this == TOP_LEFT || this == TOP_MIDDLE || this == TOP_RIGHT;
        }

        public boolean isBottom() {
            return this == BOTTOM_LEFT || this == BOTTOM_MIDDLE || this == BOTTOM_RIGHT;
        }
    }
}

