/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.model.ResizePolicy;
import com.android.tools.idea.uibuilder.model.SelectionHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SelectionHandles
implements Iterable<SelectionHandle> {
    private final NlComponent myComponent;
    private List<SelectionHandle> myHandles;

    public SelectionHandles(@NotNull NlComponent component) {
        if (component == null) {
            SelectionHandles.$$$reportNull$$$0(0);
        }
        this.myComponent = component;
        this.createHandles();
    }

    public SelectionHandle findHandle(int x, int y, int distance, @NotNull DesignSurface surface) {
        if (surface == null) {
            SelectionHandles.$$$reportNull$$$0(1);
        }
        int ax = Coordinates.dpToPx(surface, (float)x);
        int ay = Coordinates.dpToPx(surface, (float)y);
        int aDistance = Coordinates.dpToPx(surface, (float)distance);
        for (SelectionHandle handle : this.myHandles) {
            if (!handle.contains(ax, ay, aDistance)) continue;
            return handle;
        }
        return null;
    }

    private void createHandles() {
        ResizePolicy resizability = ResizePolicy.getResizePolicy(this.myComponent);
        if (resizability.isResizable()) {
            this.myHandles = new ArrayList<SelectionHandle>(8);
            boolean left = resizability.leftAllowed();
            boolean right = resizability.rightAllowed();
            boolean top = resizability.topAllowed();
            boolean bottom = resizability.bottomAllowed();
            if (left) {
                this.myHandles.add(new SelectionHandle(this.myComponent, SelectionHandle.Position.LEFT_MIDDLE));
                if (top) {
                    this.myHandles.add(new SelectionHandle(this.myComponent, SelectionHandle.Position.TOP_LEFT));
                }
                if (bottom) {
                    this.myHandles.add(new SelectionHandle(this.myComponent, SelectionHandle.Position.BOTTOM_LEFT));
                }
            }
            if (right) {
                this.myHandles.add(new SelectionHandle(this.myComponent, SelectionHandle.Position.RIGHT_MIDDLE));
                if (top) {
                    this.myHandles.add(new SelectionHandle(this.myComponent, SelectionHandle.Position.TOP_RIGHT));
                }
                if (bottom) {
                    this.myHandles.add(new SelectionHandle(this.myComponent, SelectionHandle.Position.BOTTOM_RIGHT));
                }
            }
            if (top) {
                this.myHandles.add(new SelectionHandle(this.myComponent, SelectionHandle.Position.TOP_MIDDLE));
            }
            if (bottom) {
                this.myHandles.add(new SelectionHandle(this.myComponent, SelectionHandle.Position.BOTTOM_MIDDLE));
            }
        } else {
            this.myHandles = Collections.emptyList();
        }
    }

    @Override
    public Iterator<SelectionHandle> iterator() {
        return this.myHandles.iterator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/model/SelectionHandles";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findHandle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

