/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette2;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette2.PalettePanel;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NotNull;

public class DependencyManager {
    private final Project myProject;
    private final Set<String> myMissingLibraries;
    private Module myModule;
    private Palette myPalette;

    public DependencyManager(@NotNull Project project) {
        if (project == null) {
            DependencyManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myMissingLibraries = new HashSet<String>();
        this.myPalette = Palette.EMPTY;
    }

    public void setPalette(@NotNull Palette palette, @NotNull Module module) {
        if (palette == null) {
            DependencyManager.$$$reportNull$$$0(1);
        }
        if (module == null) {
            DependencyManager.$$$reportNull$$$0(2);
        }
        this.myPalette = palette;
        this.myModule = module;
        this.checkForNewMissingDependencies();
    }

    public boolean needsLibraryLoad(@NotNull Palette.Item item) {
        if (item == null) {
            DependencyManager.$$$reportNull$$$0(3);
        }
        return this.myMissingLibraries.contains(item.getGradleCoordinateId());
    }

    public boolean dependsOn(@NotNull GoogleMavenArtifactId artifactId) {
        if (artifactId == null) {
            DependencyManager.$$$reportNull$$$0(4);
        }
        return DependencyManagementUtil.dependsOn(this.myModule, artifactId);
    }

    private boolean checkForNewMissingDependencies() {
        Set missing = Collections.emptySet();
        if (this.myModule != null && !this.myModule.isDisposed() && this.myMissingLibraries.equals(missing = this.myPalette.getGradleCoordinateIds().stream().map(id -> GradleCoordinate.parseCoordinateString((String)(id + ":+"))).filter(Objects::nonNull).map(GoogleMavenArtifactId::forCoordinate).filter(artifactId -> artifactId != null && !DependencyManagementUtil.dependsOn(this.myModule, artifactId)).map(GoogleMavenArtifactId::toString).collect(Collectors.toSet()))) {
            return false;
        }
        this.myMissingLibraries.clear();
        this.myMissingLibraries.addAll(missing);
        return true;
    }

    public void registerDependencyUpdates(@NotNull PalettePanel paletteUI, @NotNull Disposable parentDisposable) {
        if (paletteUI == null) {
            DependencyManager.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            DependencyManager.$$$reportNull$$$0(6);
        }
        this.myProject.getMessageBus().connect(parentDisposable).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> {
            if (paletteUI == null) {
                DependencyManager.$$$reportNull$$$0(8);
            }
            if (result2 == ProjectSystemSyncManager.SyncResult.SUCCESS && this.checkForNewMissingDependencies()) {
                paletteUI.onDependenciesUpdated();
            }
        });
    }

    public void ensureLibraryIsIncluded(@NotNull Palette.Item item) {
        GradleCoordinate coordinate;
        if (item == null) {
            DependencyManager.$$$reportNull$$$0(7);
        }
        if (this.needsLibraryLoad(item) && (coordinate = GradleCoordinate.parseCoordinateString((String)(item.getGradleCoordinateId() + ":+"))) != null) {
            DependencyManagementUtil.addDependencies(this.myModule, Collections.singletonList(coordinate), true);
        }
    }

    public boolean useAndroidxDependencies() {
        if (MigrateToAndroidxUtil.hasAndroidxProperty(this.myModule.getProject())) {
            return MigrateToAndroidxUtil.isAndroidx(this.myModule.getProject());
        }
        if (DependencyManagementUtil.dependsOnAndroidx(this.myModule)) {
            return true;
        }
        return !DependencyManagementUtil.dependsOnOldSupportLib(this.myModule) && (Boolean)StudioFlags.NELE_USE_ANDROIDX_DEFAULT.get() != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "palette";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paletteUI";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/palette2/DependencyManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setPalette";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "needsLibraryLoad";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "dependsOn";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerDependencyUpdates";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureLibraryIsIncluded";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$registerDependencyUpdates$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

