/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.xml.XmlName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlIdPropertyItem
extends NlPropertyItem {
    @VisibleForTesting
    static final int NO_EXIT_CODE = 2;
    @VisibleForTesting
    static final int PREVIEW_EXIT_CODE = 3;
    private static final int REFACTOR_ASK = 0;
    private static final int REFACTOR_NO = 1;
    private static final int REFACTOR_YES = 2;
    private static final int REFACTOR_PREVIEW = 3;
    private static int ourRefactoringChoice = 0;
    private Supplier<DialogBuilder> myDialogSupplier;
    private Supplier<RenameProcessor> myRenameProcessorSupplier;

    protected NlIdPropertyItem(@NotNull XmlName name, @Nullable AttributeDefinition attributeDefinition, @NotNull List<NlComponent> components, @NotNull PropertiesManager propertiesManager) {
        if (name == null) {
            NlIdPropertyItem.$$$reportNull$$$0(0);
        }
        if (components == null) {
            NlIdPropertyItem.$$$reportNull$$$0(1);
        }
        if (propertiesManager == null) {
            NlIdPropertyItem.$$$reportNull$$$0(2);
        }
        super(name, attributeDefinition, components, propertiesManager);
    }

    @Override
    @Nullable
    public String getValue() {
        return NlIdPropertyItem.stripIdPrefix(super.getValue());
    }

    private static String stripIdPrefix(@Nullable String id) {
        if (id != null) {
            if (id.startsWith("@+id/")) {
                return id.substring("@+id/".length());
            }
            if (id.startsWith("@id/")) {
                return id.substring("@id/".length());
            }
        }
        return id;
    }

    @Override
    @Nullable
    public String resolveValue(@Nullable String value) {
        return value;
    }

    @Override
    public void setValue(Object value) {
        XmlAttribute attribute;
        String newValue;
        String newId = value != null ? NlIdPropertyItem.stripIdPrefix(value.toString()) : "";
        String oldId = this.getValue();
        XmlTag tag = this.getTag();
        String string = newValue = !StringUtil.isEmpty((String)newId) && !newId.startsWith("@android:id/") ? "@+id/" + newId : newId;
        if (ourRefactoringChoice != 1 && oldId != null && !oldId.isEmpty() && !newId.isEmpty() && newValue != null && !oldId.equals(newId) && tag != null && tag.isValid() && (attribute = tag.getAttribute("id", "http://schemas.android.com/apk/res/android")) != null) {
            ValueResourceElementWrapper wrapper;
            RenameProcessor processor;
            UsageInfo[] usages;
            Module module = this.getModel().getModule();
            Project project = module.getProject();
            XmlAttributeValue valueElement = attribute.getValueElement();
            if (valueElement != null && valueElement.isValid() && (usages = (processor = this.createRenameProcessor(project, wrapper = new ValueResourceElementWrapper(valueElement), newValue)).findUsages()).length > 0) {
                int choice = ourRefactoringChoice;
                if (choice == 0) {
                    DialogBuilder builder = this.createDialogBuilder(project);
                    builder.setTitle("Update Usages?");
                    JPanel panel = new JPanel(new BorderLayout());
                    JLabel label = new JLabel("<html>Update usages as well?<br>This will update all XML references and Java R field references.<br><br></html>");
                    panel.add((Component)label, "Center");
                    JBCheckBox checkBox = new JBCheckBox("Don't ask again during this session");
                    panel.add((Component)checkBox, "South");
                    builder.setCenterPanel((JComponent)panel);
                    builder.setDimensionServiceKey("idPropertyDimension");
                    builder.removeAllActions();
                    DialogBuilder.CustomizableAction yesAction = builder.addOkAction();
                    yesAction.setText(Messages.YES_BUTTON);
                    builder.addActionDescriptor(dialogWrapper -> new AbstractAction(Messages.NO_BUTTON){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            dialogWrapper.close(2);
                        }
                    });
                    builder.addActionDescriptor(dialogWrapper -> new AbstractAction("Preview"){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            dialogWrapper.close(3);
                        }
                    });
                    builder.addCancelAction();
                    int exitCode = builder.show();
                    choice = exitCode == 0 ? 2 : (exitCode == 2 ? 1 : (exitCode == 3 ? 3 : ourRefactoringChoice));
                    int n = ourRefactoringChoice = checkBox.isSelected() ? choice : 0;
                    if (exitCode == 1) {
                        return;
                    }
                }
                if (choice == 2) {
                    processor.setPreviewUsages(false);
                    processor.run();
                    return;
                }
                if (choice == 3) {
                    processor.setPreviewUsages(true);
                    processor.run();
                    return;
                }
            }
        }
        super.setValue(newValue);
    }

    void setDialogSupplier(@NotNull Supplier<DialogBuilder> dialogSupplier) {
        if (dialogSupplier == null) {
            NlIdPropertyItem.$$$reportNull$$$0(3);
        }
        this.myDialogSupplier = dialogSupplier;
    }

    static void clearRefactoringChoice() {
        ourRefactoringChoice = 0;
    }

    private DialogBuilder createDialogBuilder(@NotNull Project project) {
        if (project == null) {
            NlIdPropertyItem.$$$reportNull$$$0(4);
        }
        return this.myDialogSupplier != null ? this.myDialogSupplier.get() : new DialogBuilder(project);
    }

    void setRenameProcessSupplier(@NotNull Supplier<RenameProcessor> renameProcessorSupplier) {
        if (renameProcessorSupplier == null) {
            NlIdPropertyItem.$$$reportNull$$$0(5);
        }
        this.myRenameProcessorSupplier = renameProcessorSupplier;
    }

    private RenameProcessor createRenameProcessor(@NotNull Project project, @NotNull ValueResourceElementWrapper wrapper, @NotNull String newValue) {
        if (project == null) {
            NlIdPropertyItem.$$$reportNull$$$0(6);
        }
        if (wrapper == null) {
            NlIdPropertyItem.$$$reportNull$$$0(7);
        }
        if (newValue == null) {
            NlIdPropertyItem.$$$reportNull$$$0(8);
        }
        return this.myRenameProcessorSupplier != null ? this.myRenameProcessorSupplier.get() : new RenameProcessor(project, (PsiElement)wrapper, newValue, false, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogSupplier";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameProcessorSupplier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlIdPropertyItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setDialogSupplier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createDialogBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setRenameProcessSupplier";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenameProcessor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

