/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.PropertiesManager;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.lint.checks.ApiLookup;
import com.android.utils.Pair;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlName;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlProperties {
    public static final String STARRED_PROP = "ANDROID.STARRED_PROPERTIES";
    private static NlProperties ourInstance = null;
    private final AndroidDomElementDescriptorProvider myDescriptorProvider = new AndroidDomElementDescriptorProvider();

    public static synchronized NlProperties getInstance() {
        if (ourInstance == null) {
            ourInstance = new NlProperties();
        }
        return ourInstance;
    }

    @NotNull
    public Table<String, String, NlPropertyItem> getProperties(@NotNull AndroidFacet facet, @NotNull PropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        if (facet == null) {
            NlProperties.$$$reportNull$$$0(0);
        }
        if (propertiesManager == null) {
            NlProperties.$$$reportNull$$$0(1);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(2);
        }
        assert (!EventQueue.isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode());
        if (components.isEmpty()) {
            ImmutableTable immutableTable = ImmutableTable.of();
            if (immutableTable == null) {
                NlProperties.$$$reportNull$$$0(3);
            }
            return immutableTable;
        }
        Project project = facet.getModule().getProject();
        Table table2 = (Table)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            if (facet == null) {
                NlProperties.$$$reportNull$$$0(39);
            }
            if (propertiesManager == null) {
                NlProperties.$$$reportNull$$$0(40);
            }
            if (components == null) {
                NlProperties.$$$reportNull$$$0(41);
            }
            return this.getPropertiesImpl(facet, propertiesManager, components);
        });
        if (table2 == null) {
            NlProperties.$$$reportNull$$$0(4);
        }
        return table2;
    }

    @NotNull
    private Table<String, String, NlPropertyItem> getPropertiesImpl(@NotNull AndroidFacet facet, @NotNull PropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        if (facet == null) {
            NlProperties.$$$reportNull$$$0(5);
        }
        if (propertiesManager == null) {
            NlProperties.$$$reportNull$$$0(6);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(7);
        }
        assert (!components.isEmpty());
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(facet);
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        SystemResourceManager systemResourceManager = resourceManagers.getSystemResourceManager();
        if (systemResourceManager == null) {
            Logger.getInstance(NlProperties.class).error("No system resource manager for module: " + facet.getModule().getName());
            ImmutableTable immutableTable = ImmutableTable.of();
            if (immutableTable == null) {
                NlProperties.$$$reportNull$$$0(8);
            }
            return immutableTable;
        }
        AttributeDefinitions localAttrDefs = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttrDefs = ((ResourceManager)systemResourceManager).getAttributeDefinitions();
        Table<String, String, NlPropertyItem> combinedProperties = null;
        Project project = facet.getModule().getProject();
        ApiLookup apiLookup = LintIdeClient.getApiLookup(project);
        int minApi = AndroidModuleInfo.getInstance(facet).getMinSdkVersion().getFeatureLevel();
        for (NlComponent component : components) {
            String className;
            XmlTag tag = component.getTag();
            if (!tag.isValid()) {
                ImmutableTable immutableTable = ImmutableTable.of();
                if (immutableTable == null) {
                    NlProperties.$$$reportNull$$$0(9);
                }
                return immutableTable;
            }
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
            if (elementDescriptor == null) {
                ImmutableTable immutableTable = ImmutableTable.of();
                if (immutableTable == null) {
                    NlProperties.$$$reportNull$$$0(10);
                }
                return immutableTable;
            }
            XmlAttributeDescriptor[] descriptors = elementDescriptor.getAttributesDescriptors(tag);
            HashBasedTable properties = HashBasedTable.create((int)3, (int)descriptors.length);
            for (XmlAttributeDescriptor desc : descriptors) {
                AttributeDefinition attrDef;
                XmlName name = NlProperties.getXmlName(desc, tag);
                if ("http://schemas.android.com/apk/res/android".equals(name.getNamespaceKey()) && apiLookup != null && apiLookup.getFieldVersion("android/R$attr", name.getLocalName()) > minApi) continue;
                AttributeDefinitions attrDefs = "http://schemas.android.com/apk/res/android".equals(name.getNamespaceKey()) ? systemAttrDefs : localAttrDefs;
                AttributeDefinition attributeDefinition = attrDef = attrDefs == null ? null : attrDefs.getAttrDefByName(name.getLocalName());
                if (!NlPropertyItem.isDefinitionAcceptable(name, attrDef)) continue;
                NlPropertyItem property2 = NlPropertyItem.create(name, attrDef, components, propertiesManager);
                properties.put((Object)StringUtil.notNullize((String)name.getNamespaceKey()), (Object)property2.getName(), (Object)property2);
            }
            PsiElement declaration = elementDescriptor.getDeclaration();
            PsiClass tagClass = declaration instanceof PsiClass ? (PsiClass)declaration : null;
            String string = className = tagClass != null ? tagClass.getQualifiedName() : null;
            if (NlComponentHelperKt.getHasNlComponentInfo(component)) {
                String viewClassName;
                ViewInfo view = NlComponentHelperKt.getViewInfo(component);
                String string2 = viewClassName = view != null ? view.getClassName() : null;
                if (localAttrDefs != null && viewClassName != null && className != null && !viewClassName.equals(className)) {
                    NlProperties.addAttributesFromInflatedStyleable((Table<String, String, NlPropertyItem>)properties, localAttrDefs, tagClass, viewClassName, propertiesManager, components);
                }
            }
            switch (tag.getName()) {
                case "AutoCompleteTextView": {
                    AttributeDefinition definition;
                    XmlName popup2 = new XmlName("popupBackground", "http://schemas.android.com/apk/res/android");
                    AttributeDefinition attributeDefinition = definition = systemAttrDefs != null ? systemAttrDefs.getAttrDefByName("popupBackground") : null;
                    if (!NlPropertyItem.isDefinitionAcceptable(popup2, definition)) break;
                    properties.put((Object)"http://schemas.android.com/apk/res/android", (Object)"popupBackground", (Object)NlPropertyItem.create(popup2, definition, components, propertiesManager));
                }
            }
            combinedProperties = NlProperties.combine((Table<String, String, NlPropertyItem>)properties, combinedProperties);
        }
        assert (combinedProperties != null);
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingStart");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingEnd");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"theme");
        NlProperties.setUpDesignProperties(combinedProperties);
        NlProperties.initStarState(combinedProperties);
        Table<String, String, NlPropertyItem> table2 = combinedProperties;
        if (table2 == null) {
            NlProperties.$$$reportNull$$$0(11);
        }
        return table2;
    }

    private static void addAttributesFromInflatedStyleable(@NotNull Table<String, String, NlPropertyItem> properties, @NotNull AttributeDefinitions localAttrDefs, @NotNull PsiClass xmlClass, @NotNull String inflatedClassName, @NotNull PropertiesManager propertiesManager, @NotNull List<NlComponent> components) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(12);
        }
        if (localAttrDefs == null) {
            NlProperties.$$$reportNull$$$0(13);
        }
        if (xmlClass == null) {
            NlProperties.$$$reportNull$$$0(14);
        }
        if (inflatedClassName == null) {
            NlProperties.$$$reportNull$$$0(15);
        }
        if (propertiesManager == null) {
            NlProperties.$$$reportNull$$$0(16);
        }
        if (components == null) {
            NlProperties.$$$reportNull$$$0(17);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)xmlClass.getProject());
        for (PsiClass inflatedClass = ClassUtil.findPsiClass((PsiManager)psiManager, (String)inflatedClassName); inflatedClass != null && inflatedClass != xmlClass; inflatedClass = inflatedClass.getSuperClass()) {
            StyleableDefinition styleable;
            String styleableName = inflatedClass.getName();
            StyleableDefinition styleableDefinition = styleable = styleableName != null ? localAttrDefs.getStyleableByName(styleableName) : null;
            if (styleable == null) continue;
            for (AttributeDefinition attrDef : styleable.getAttributes()) {
                if (properties.contains((Object)"http://schemas.android.com/apk/res/android", (Object)attrDef.getName())) continue;
                XmlName name = NlProperties.getXmlName(attrDef.getName(), "http://schemas.android.com/apk/res-auto");
                NlPropertyItem property2 = NlPropertyItem.create(name, attrDef, components, propertiesManager);
                properties.put((Object)StringUtil.notNullize((String)name.getNamespaceKey()), (Object)property2.getName(), (Object)property2);
            }
        }
    }

    private static void initStarState(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(18);
        }
        for (String starredProperty : NlProperties.getStarredProperties()) {
            Pair<String, String> property2 = NlProperties.split(starredProperty);
            NlPropertyItem item = (NlPropertyItem)properties.get(property2.getFirst(), property2.getSecond());
            if (item == null) continue;
            item.setInitialStarred();
        }
    }

    public static void saveStarState(@Nullable String propertyNamespace, @NotNull String propertyName, boolean starred, @NotNull PropertiesManager propertiesManager) {
        if (propertyName == null) {
            NlProperties.$$$reportNull$$$0(19);
        }
        if (propertiesManager == null) {
            NlProperties.$$$reportNull$$$0(20);
        }
        String propertyNameWithPrefix = NlProperties.getPropertyNameWithPrefix(propertyNamespace, propertyName);
        ArrayList<String> favorites = new ArrayList<String>();
        for (String starredProperty : NlProperties.getStarredProperties()) {
            if (starredProperty.equals(propertyNameWithPrefix)) continue;
            favorites.add(starredProperty);
        }
        if (starred) {
            favorites.add(propertyNameWithPrefix);
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue(STARRED_PROP, Joiner.on((char)';').join(favorites));
        String added = starred ? propertyNameWithPrefix : "";
        String removed = !starred ? propertyNameWithPrefix : "";
        propertiesManager.logFavoritesChange(added, removed, favorites);
    }

    public static String getStarredPropertiesAsString() {
        String starredProperties = PropertiesComponent.getInstance().getValue(STARRED_PROP);
        if (starredProperties == null) {
            starredProperties = "visibility";
        }
        return starredProperties;
    }

    public static Iterable<String> getStarredProperties() {
        return Splitter.on((char)';').trimResults().omitEmptyStrings().split((CharSequence)NlProperties.getStarredPropertiesAsString());
    }

    @NotNull
    private static String getPropertyNameWithPrefix(@Nullable String namespace, @NotNull String propertyName) {
        if (propertyName == null) {
            NlProperties.$$$reportNull$$$0(21);
        }
        if (namespace == null) {
            String string = propertyName;
            if (string == null) {
                NlProperties.$$$reportNull$$$0(22);
            }
            return string;
        }
        switch (namespace) {
            case "http://schemas.android.com/tools": {
                String string = "tools:" + propertyName;
                if (string == null) {
                    NlProperties.$$$reportNull$$$0(23);
                }
                return string;
            }
            case "http://schemas.android.com/apk/res/android": {
                String string = propertyName;
                if (string == null) {
                    NlProperties.$$$reportNull$$$0(24);
                }
                return string;
            }
        }
        String string = "app:" + propertyName;
        if (string == null) {
            NlProperties.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static Pair<String, String> split(@NotNull String propertyNameWithPrefix) {
        if (propertyNameWithPrefix == null) {
            NlProperties.$$$reportNull$$$0(26);
        }
        if (propertyNameWithPrefix.startsWith("tools:")) {
            Pair pair = Pair.of((Object)"http://schemas.android.com/tools", (Object)propertyNameWithPrefix.substring("tools:".length()));
            if (pair == null) {
                NlProperties.$$$reportNull$$$0(27);
            }
            return pair;
        }
        if (propertyNameWithPrefix.startsWith("app:")) {
            Pair pair = Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyNameWithPrefix.substring("app:".length()));
            if (pair == null) {
                NlProperties.$$$reportNull$$$0(28);
            }
            return pair;
        }
        Pair pair = Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)propertyNameWithPrefix);
        if (pair == null) {
            NlProperties.$$$reportNull$$$0(29);
        }
        return pair;
    }

    @NotNull
    private static XmlName getXmlName(@NotNull XmlAttributeDescriptor descriptor, @NotNull XmlTag context) {
        if (descriptor == null) {
            NlProperties.$$$reportNull$$$0(30);
        }
        if (context == null) {
            NlProperties.$$$reportNull$$$0(31);
        }
        String namespace = null;
        if (descriptor instanceof NamespaceAwareXmlAttributeDescriptor) {
            namespace = ((NamespaceAwareXmlAttributeDescriptor)descriptor).getNamespace(context);
        }
        XmlName xmlName = new XmlName(descriptor.getName(), namespace);
        if (xmlName == null) {
            NlProperties.$$$reportNull$$$0(32);
        }
        return xmlName;
    }

    @NotNull
    private static XmlName getXmlName(@NotNull String qualifiedName, @NotNull String defaultNamespace) {
        if (qualifiedName == null) {
            NlProperties.$$$reportNull$$$0(33);
        }
        if (defaultNamespace == null) {
            NlProperties.$$$reportNull$$$0(34);
        }
        if (qualifiedName.startsWith("android:")) {
            XmlName xmlName = new XmlName(StringUtil.trimStart((String)qualifiedName, (String)"android:"), "http://schemas.android.com/apk/res/android");
            if (xmlName == null) {
                NlProperties.$$$reportNull$$$0(35);
            }
            return xmlName;
        }
        XmlName xmlName = new XmlName(qualifiedName, defaultNamespace);
        if (xmlName == null) {
            NlProperties.$$$reportNull$$$0(36);
        }
        return xmlName;
    }

    private static Table<String, String, NlPropertyItem> combine(@NotNull Table<String, String, NlPropertyItem> properties, @Nullable Table<String, String, NlPropertyItem> combinedProperties) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(37);
        }
        if (combinedProperties == null) {
            return properties;
        }
        ArrayList namespaces = new ArrayList(combinedProperties.rowKeySet());
        ArrayList propertiesToRemove = new ArrayList();
        for (String namespace : namespaces) {
            propertiesToRemove.clear();
            for (Map.Entry entry : combinedProperties.row((Object)namespace).entrySet()) {
                NlPropertyItem other = (NlPropertyItem)properties.get((Object)namespace, entry.getKey());
                if (((NlPropertyItem)entry.getValue()).sameDefinition(other)) continue;
                propertiesToRemove.add(entry.getKey());
            }
            for (String propertyName : propertiesToRemove) {
                combinedProperties.remove((Object)namespace, (Object)propertyName);
            }
        }
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res/android", (Object)"id");
        return combinedProperties;
    }

    private static void setUpDesignProperties(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            NlProperties.$$$reportNull$$$0(38);
        }
        ArrayList designProperties = new ArrayList(properties.row((Object)"http://schemas.android.com/tools").keySet());
        for (String propertyName : designProperties) {
            NlPropertyItem item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyName);
            if (item == null) {
                item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res/android", (Object)propertyName);
            }
            if (item == null) continue;
            NlPropertyItem designItem = item.getDesignTimeProperty();
            properties.put((Object)"http://schemas.android.com/tools", (Object)propertyName, (Object)designItem);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 6: 
            case 16: 
            case 20: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 2: 
            case 7: 
            case 17: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/NlProperties";
                break;
            }
            case 12: 
            case 18: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localAttrDefs";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inflatedClassName";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNameWithPrefix";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlProperties";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesImpl";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNameWithPrefix";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 32: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 36: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addAttributesFromInflatedStyleable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "initStarState";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveStarState";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameWithPrefix";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getXmlName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "combine";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setUpDesignProperties";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getProperties$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

