/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.BaseComponentEditor;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.property.EmptyProperty;
import com.android.tools.idea.uibuilder.property.editors.BrowsePanel;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.editors.support.Quantity;
import com.android.tools.idea.uibuilder.property.editors.support.TextEditorWithAutoCompletion;
import com.android.tools.idea.uibuilder.property.renderer.NlDefaultRenderer;
import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Clock;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlReferenceEditor
extends BaseComponentEditor {
    private static final int MIN_TEXT_WIDTH = 50;
    private static final int ICON_SIZE = 16;
    private static final int HORIZONTAL_SPACE_AFTER_LABEL = 4;
    private final JPanel myPanel;
    private final JLabel myIconLabel;
    private final JSlider mySlider;
    private final ComponentManager myProject;
    private final TextEditorWithAutoCompletion myTextEditorWithAutoCompletion;
    private final BrowsePanel myBrowsePanel;
    private final boolean myHasSliderSupport;
    private final boolean myIsInspector;
    private NlProperty myProperty;
    private boolean myPropertyHasSlider;
    private String myLastReadValue;
    private Object myLastWriteValue;
    private boolean myUpdatingProperty;
    private boolean myCompletionsUpdated;

    public static NlTableCellEditor createForTable(@NotNull Project project) {
        if (project == null) {
            NlReferenceEditor.$$$reportNull$$$0(0);
        }
        NlTableCellEditor cellEditor2 = new NlTableCellEditor();
        BrowsePanel browsePanel = new BrowsePanel(cellEditor2, true);
        cellEditor2.init(new NlReferenceEditor(project, cellEditor2, browsePanel, false, true, false, 0), browsePanel);
        return cellEditor2;
    }

    public static NlReferenceEditor createForInspector(@NotNull Project project, @NotNull NlEditingListener listener2) {
        if (project == null) {
            NlReferenceEditor.$$$reportNull$$$0(1);
        }
        if (listener2 == null) {
            NlReferenceEditor.$$$reportNull$$$0(2);
        }
        return new NlReferenceEditor(project, listener2, null, true, true, true, 2);
    }

    public static NlReferenceEditor createForTableTesting(@NotNull Project project, @NotNull NlEditingListener listener2, @NotNull BrowsePanel browsePanel) {
        if (project == null) {
            NlReferenceEditor.$$$reportNull$$$0(3);
        }
        if (listener2 == null) {
            NlReferenceEditor.$$$reportNull$$$0(4);
        }
        if (browsePanel == null) {
            NlReferenceEditor.$$$reportNull$$$0(5);
        }
        return new NlReferenceEditor(project, listener2, browsePanel, false, true, false, 2);
    }

    public static NlReferenceEditor createForInspectorWithBrowseButton(@NotNull Project project, @NotNull NlEditingListener listener2) {
        if (project == null) {
            NlReferenceEditor.$$$reportNull$$$0(6);
        }
        if (listener2 == null) {
            NlReferenceEditor.$$$reportNull$$$0(7);
        }
        BrowsePanel.ContextDelegate delegate = new BrowsePanel.ContextDelegate();
        BrowsePanel browsePanel = new BrowsePanel(delegate, false);
        NlReferenceEditor editor = new NlReferenceEditor(project, listener2, browsePanel, true, true, true, 2);
        delegate.setEditor(editor);
        return editor;
    }

    protected NlReferenceEditor(@NotNull Project project, @NotNull NlEditingListener listener2, @Nullable BrowsePanel browsePanel, boolean includeBorder, boolean includeSliderSupport, boolean isInspector, int verticalSpacing) {
        if (project == null) {
            NlReferenceEditor.$$$reportNull$$$0(8);
        }
        if (listener2 == null) {
            NlReferenceEditor.$$$reportNull$$$0(9);
        }
        super(listener2);
        this.myPanel = new AdtSecondaryPanel((LayoutManager)new BorderLayout());
        this.myIconLabel = new JBLabel();
        this.myPanel.add((Component)this.myIconLabel, "Before");
        this.myPanel.setFocusable(false);
        this.myIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                NlReferenceEditor.this.showBrowseDialog();
            }
        });
        this.myIconLabel.setBorder((Border)JBUI.Borders.emptyRight((int)4));
        Font font = UIUtil.getLabelFont();
        FontMetrics metrics = this.myPanel.getFontMetrics(font);
        int sliderHeight = metrics.getHeight() + 2 * verticalSpacing;
        this.mySlider = new SliderWithTimeDelay();
        this.myPanel.add((Component)this.mySlider, "Before");
        this.mySlider.addChangeListener(event -> this.sliderChange());
        Dimension size = this.mySlider.getMinimumSize();
        size.setSize(size.width * 2, sliderHeight);
        this.mySlider.setMinimumSize(size);
        this.mySlider.setPreferredSize(size);
        this.mySlider.setVisible(includeSliderSupport);
        this.myProject = project;
        this.myTextEditorWithAutoCompletion = TextEditorWithAutoCompletion.create(project, (Insets)JBUI.insets((int)verticalSpacing, (int)3, (int)verticalSpacing, (int)3));
        if (includeBorder) {
            this.myTextEditorWithAutoCompletion.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
            this.myPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
        }
        this.myTextEditorWithAutoCompletion.addLookupListener((LookupListener)new LookupAdapter(){

            public void itemSelected(@NotNull LookupEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                NlReferenceEditor.this.stopEditing(NlReferenceEditor.this.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor$2", "itemSelected"));
            }
        });
        this.myBrowsePanel = browsePanel;
        this.myPanel.add((Component)((Object)this.myTextEditorWithAutoCompletion), "Center");
        if (browsePanel != null) {
            if (includeBorder) {
                this.myBrowsePanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)1));
            }
            this.myPanel.add((Component)((Object)this.myBrowsePanel), "After");
        }
        this.myPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                NlReferenceEditor.this.updateSliderAndIconVisibility();
            }
        });
        this.myTextEditorWithAutoCompletion.registerKeyboardAction(event -> this.stopEditing(this.getText()), KeyStroke.getKeyStroke(10, 0), 1);
        this.myTextEditorWithAutoCompletion.registerKeyboardAction(event -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.myTextEditorWithAutoCompletion.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                NlReferenceEditor.this.editorFocusGain(event);
            }

            @Override
            public void focusLost(@NotNull FocusEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(1);
                }
                NlReferenceEditor.this.editorFocusLost(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myProperty = EmptyProperty.INSTANCE;
        this.myHasSliderSupport = includeSliderSupport;
        this.myIsInspector = isInspector;
    }

    protected TextEditorWithAutoCompletion getTextEditor() {
        return this.myTextEditorWithAutoCompletion;
    }

    protected void editorFocusGain(@NotNull FocusEvent event) {
        if (event == null) {
            NlReferenceEditor.$$$reportNull$$$0(10);
        }
        if (event.getOppositeComponent() != this.mySlider && !this.myCompletionsUpdated && this.myProperty != EmptyProperty.INSTANCE) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                NlProperty property2 = this.myProperty;
                AndroidFacet facet = this.myProperty.getModel().getFacet();
                List<String> completions = TextEditorWithAutoCompletion.loadCompletions(facet, NlReferenceEditor.getResourceTypes(this.myProperty), this.myProperty);
                if (property2 == this.myProperty) {
                    this.myTextEditorWithAutoCompletion.updateCompletions(completions);
                    this.myCompletionsUpdated = true;
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (!this.getText().equals(StringUtil.notNullize((String)property2.getValue()))) {
                            Project project = property2.getModel().getProject();
                            AutoPopupController.getInstance((Project)project).scheduleAutoPopup(this.myTextEditorWithAutoCompletion.getEditor());
                        }
                    });
                }
            });
        }
        this.myTextEditorWithAutoCompletion.selectAll();
    }

    protected void editorFocusLost(@NotNull FocusEvent event) {
        if (event == null) {
            NlReferenceEditor.$$$reportNull$$$0(11);
        }
        if (event.getOppositeComponent() != this.mySlider) {
            this.stopEditing(this.getText());
            this.myTextEditorWithAutoCompletion.removeSelection();
        }
    }

    private static EnumSet<ResourceType> getResourceTypes(@NotNull NlProperty property2) {
        AttributeDefinition definition;
        if (property2 == null) {
            NlReferenceEditor.$$$reportNull$$$0(12);
        }
        if ((definition = property2.getDefinition()) == null || "id".equals(property2.getName())) {
            return EnumSet.noneOf(ResourceType.class);
        }
        EnumSet<ResourceType> resourceTypes = BrowsePanel.getResourceTypes(property2);
        if ("http://schemas.android.com/tools".equals(property2.getNamespace())) {
            resourceTypes.add(ResourceType.SAMPLE_DATA);
        }
        return resourceTypes;
    }

    @NotNull
    private String getText() {
        String text = this.myTextEditorWithAutoCompletion.getDocument().getText();
        String string = Quantity.addUnit(this.myProperty, text);
        if (string == null) {
            NlReferenceEditor.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myTextEditorWithAutoCompletion.setEnabled(enabled);
        if (this.myBrowsePanel != null) {
            this.myBrowsePanel.setVisible(enabled);
        }
        if (!enabled) {
            this.myLastReadValue = "";
            this.myLastWriteValue = "";
            this.myTextEditorWithAutoCompletion.setText("");
        }
    }

    @Override
    @NotNull
    public NlProperty getProperty() {
        NlProperty nlProperty = this.myProperty;
        if (nlProperty == null) {
            NlReferenceEditor.$$$reportNull$$$0(14);
        }
        return nlProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(@NotNull NlProperty property2) {
        if (property2 == null) {
            NlReferenceEditor.$$$reportNull$$$0(15);
        }
        if (this.myProperty != property2) {
            this.myProperty = property2;
            this.myLastReadValue = null;
            if (this.myBrowsePanel != null) {
                this.myBrowsePanel.setProperty(property2);
            }
            this.myCompletionsUpdated = false;
        }
        this.myUpdatingProperty = true;
        try {
            this.myPropertyHasSlider = this.configureSlider();
            if (this.myPropertyHasSlider) {
                this.myPanel.remove(this.myIconLabel);
                this.myPanel.add((Component)this.mySlider, "Before");
            } else {
                this.myPanel.remove(this.mySlider);
                this.myPanel.add((Component)this.myIconLabel, "Before");
            }
            String propValue = StringUtil.notNullize((String)this.myProperty.getValue());
            if (!propValue.equals(this.myLastReadValue)) {
                this.myLastReadValue = propValue;
                this.myLastWriteValue = propValue;
                this.myTextEditorWithAutoCompletion.setText(propValue);
            }
            JBColor color = this.myProperty.isDefaultValue(this.myLastReadValue) ? DEFAULT_VALUE_TEXT_COLOR : CHANGED_VALUE_TEXT_COLOR;
            this.myTextEditorWithAutoCompletion.setTextColor((Color)color);
            this.updateSliderAndIconVisibility();
        }
        finally {
            this.myUpdatingProperty = false;
        }
    }

    private void updateSliderAndIconVisibility() {
        if (this.myPropertyHasSlider) {
            int widthBrowsePanel = this.myBrowsePanel != null ? this.myBrowsePanel.getPreferredSize().width : 0;
            int widthForEditor = this.myPanel.getWidth() - this.mySlider.getPreferredSize().width - widthBrowsePanel;
            this.mySlider.setVisible(widthForEditor >= JBUI.scale((int)50));
        } else {
            int iconSize = JBUI.scale((int)16);
            Icon icon = NlDefaultRenderer.getIcon(this.myProperty, iconSize);
            this.myIconLabel.setIcon(icon);
            this.myIconLabel.setVisible(icon != null);
            this.myIconLabel.setToolTipText("Pick a Resource");
        }
    }

    private boolean configureSlider() {
        int value;
        int maximum;
        if (this.myProperty == null || !this.myHasSliderSupport) {
            return false;
        }
        AttributeDefinition definition = this.myProperty.getDefinition();
        if (definition == null || Collections.disjoint(definition.getFormats(), ImmutableList.of((Object)((Object)AttributeFormat.Dimension), (Object)((Object)AttributeFormat.Float)))) {
            return false;
        }
        switch (this.myProperty.getName()) {
            case "elevation": 
            case "cardElevation": {
                maximum = 24;
                value = this.getValueInDp(0);
                break;
            }
            case "minHeight": {
                maximum = 250;
                value = this.getValueInDp(180);
                break;
            }
            case "mockup_opacity": 
            case "layout_collapseParallaxMultiplier": {
                maximum = 10;
                value = (int)(this.getValueAsFloat(1.0) * 10.0 + 0.5);
                break;
            }
            default: {
                return false;
            }
        }
        this.mySlider.setMinimum(0);
        this.mySlider.setMaximum(maximum);
        this.mySlider.setValue(value);
        return true;
    }

    private int getValueInDp(int defaultValue) {
        String valueAsString = this.myProperty.getValue();
        if (valueAsString == null) {
            return defaultValue;
        }
        ResourceResolver resolver = this.myProperty.getResolver();
        if (resolver == null) {
            return defaultValue;
        }
        Configuration configuration = this.myProperty.getModel().getConfiguration();
        Integer value = ViewEditor.resolveDimensionPixelSize((RenderResources)resolver, valueAsString, configuration);
        if (value == null) {
            return defaultValue;
        }
        return Coordinates.pxToDp(this.myProperty.getModel(), (int)value);
    }

    private double getValueAsFloat(double defaultValue) {
        String valueAsString = this.myProperty.getValue();
        if (valueAsString == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueAsString);
        }
        catch (NumberFormatException ignore) {
            return defaultValue;
        }
    }

    private String getSliderValue() {
        int value = this.mySlider.getValue();
        switch (this.myProperty.getName()) {
            case "layout_collapseParallaxMultiplier": 
            case "mockup_opacity": {
                if (value == 10) {
                    return "1.0";
                }
                return "0." + value;
            }
        }
        return Quantity.addUnit(this.myProperty, String.valueOf(value));
    }

    private void sliderChange() {
        if (this.myUpdatingProperty) {
            return;
        }
        this.myTextEditorWithAutoCompletion.setText(this.getSliderValue());
        if (this.myIsInspector && !this.mySlider.getValueIsAdjusting()) {
            this.stopEditing(this.getText());
        }
    }

    @Override
    public void requestFocus() {
        if (this.myTextEditorWithAutoCompletion.getEditor() != null) {
            this.myTextEditorWithAutoCompletion.requestFocus();
        }
        this.myTextEditorWithAutoCompletion.selectAll();
        this.myTextEditorWithAutoCompletion.scrollRectToVisible(this.myTextEditorWithAutoCompletion.getBounds());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            NlReferenceEditor.$$$reportNull$$$0(16);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public Object getValue() {
        String string = this.getText();
        if (string == null) {
            NlReferenceEditor.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    public void stopEditing(@Nullable Object newValue) {
        this.myTextEditorWithAutoCompletion.setText((String)newValue);
        if (this.myTextEditorWithAutoCompletion.editorHasFocus()) {
            this.myTextEditorWithAutoCompletion.selectAll();
        }
        if (!Objects.equals(newValue, this.myLastWriteValue)) {
            this.myLastWriteValue = newValue;
            this.myLastReadValue = null;
            super.stopEditing(newValue);
        }
    }

    protected void cancel() {
        this.myTextEditorWithAutoCompletion.setText(this.myProperty.getValue());
        this.myTextEditorWithAutoCompletion.selectAll();
        this.cancelEditing();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browsePanel";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperty";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createForTable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createForInspector";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createForTableTesting";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createForInspectorWithBrowseButton";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "editorFocusGain";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "editorFocusLost";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResourceTypes";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SliderWithTimeDelay
    extends JSlider {
        private static final long SHORT_WAIT_MILLIS = 300L;
        private Clock myClock = Clock.systemUTC();
        private long myLastAddNotifyMillis;

        private SliderWithTimeDelay() {
        }

        public void setClock(@NotNull Clock clock) {
            if (clock == null) {
                SliderWithTimeDelay.$$$reportNull$$$0(0);
            }
            this.myClock = clock;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.myLastAddNotifyMillis = this.myClock.millis();
        }

        @Override
        protected void processMouseEvent(@NotNull MouseEvent event) {
            if (event == null) {
                SliderWithTimeDelay.$$$reportNull$$$0(1);
            }
            if (this.myClock.millis() - this.myLastAddNotifyMillis > 300L) {
                super.processMouseEvent(event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clock";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/NlReferenceEditor$SliderWithTimeDelay";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setClock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processMouseEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

