/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.resources.ResourceType;
import com.android.tools.adtui.common.AdtSecondaryPanel;
import com.android.tools.adtui.ptable.PTableCellEditor;
import com.android.tools.idea.uibuilder.property.NlResourceItem;
import com.android.tools.idea.uibuilder.property.editors.support.Quantity;
import com.android.tools.idea.uibuilder.property.editors.support.TextEditorWithAutoCompletion;
import com.android.tools.idea.uibuilder.property.renderer.NlXmlValueRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlResourceValueEditor
extends PTableCellEditor {
    private final JPanel myPanel;
    private final TextEditorWithAutoCompletion myTextEditorWithAutoCompletion;
    private NlResourceItem myItem;
    private boolean myCompletionsUpdated;

    public static NlResourceValueEditor createForSliceTable(@NotNull Project project) {
        if (project == null) {
            NlResourceValueEditor.$$$reportNull$$$0(0);
        }
        return new NlResourceValueEditor(project);
    }

    private NlResourceValueEditor(@NotNull Project project) {
        if (project == null) {
            NlResourceValueEditor.$$$reportNull$$$0(1);
        }
        this.myTextEditorWithAutoCompletion = TextEditorWithAutoCompletion.create(project, (Insets)JBUI.insets((int)4, (int)3, (int)4, (int)3));
        this.myTextEditorWithAutoCompletion.registerKeyboardAction(event -> this.enter(), KeyStroke.getKeyStroke(10, 0), 1);
        this.myTextEditorWithAutoCompletion.registerKeyboardAction(event -> this.cancel(), KeyStroke.getKeyStroke(27, 0), 1);
        this.myTextEditorWithAutoCompletion.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myTextEditorWithAutoCompletion.setFontStyle(1);
        this.myTextEditorWithAutoCompletion.setTextColor((Color)NlXmlValueRenderer.VALUE_COLOR);
        this.myTextEditorWithAutoCompletion.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!NlResourceValueEditor.this.myCompletionsUpdated) {
                    NlResourceValueEditor.this.editorFocusGained();
                }
                NlResourceValueEditor.this.myTextEditorWithAutoCompletion.selectAll();
            }

            @Override
            public void focusLost(@NotNull FocusEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                NlResourceValueEditor.this.myTextEditorWithAutoCompletion.removeSelection();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/NlResourceValueEditor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myPanel = new AdtSecondaryPanel((LayoutManager)new BorderLayout());
        this.myPanel.add((Component)((Object)this.myTextEditorWithAutoCompletion));
        this.myPanel.setFocusable(false);
    }

    public JComponent getPreferredFocusComponent() {
        return this.myTextEditorWithAutoCompletion;
    }

    @NotNull
    private EnumSet<ResourceType> getResourceTypes() {
        EnumSet<ResourceType> enumSet = this.myItem != null ? EnumSet.of(this.myItem.getResourceItem().getType()) : EnumSet.noneOf(ResourceType.class);
        if (enumSet == null) {
            NlResourceValueEditor.$$$reportNull$$$0(2);
        }
        return enumSet;
    }

    private void cancel() {
        this.myTextEditorWithAutoCompletion.setText(this.myItem != null ? this.myItem.getValue() : null);
        this.myTextEditorWithAutoCompletion.selectAll();
        this.cancelCellEditing();
    }

    private void enter() {
        if (this.myTextEditorWithAutoCompletion.editorHasFocus()) {
            this.myTextEditorWithAutoCompletion.selectAll();
        }
        this.saveValue(this.getCellEditorValue());
        this.stopCellEditing();
    }

    private void saveValue(@NotNull String value) {
        if (value == null) {
            NlResourceValueEditor.$$$reportNull$$$0(3);
        }
        this.myItem.setValue(value);
    }

    public Component getTableCellEditorComponent(@NotNull JTable table2, @Nullable Object value, boolean isSelected, int row, int column) {
        if (table2 == null) {
            NlResourceValueEditor.$$$reportNull$$$0(4);
        }
        this.myItem = (NlResourceItem)((Object)value);
        this.myTextEditorWithAutoCompletion.setText(this.myItem != null ? this.myItem.getValue() : null);
        return this.myPanel;
    }

    public String getCellEditorValue() {
        if (this.myItem == null) {
            return null;
        }
        String text = this.myTextEditorWithAutoCompletion.getDocument().getText();
        return Quantity.addUnit(this.myItem.getResourceItem().getType(), text);
    }

    private void editorFocusGained() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            NlResourceItem item = this.myItem;
            List<String> completions = TextEditorWithAutoCompletion.loadCompletions(item.getFacet(), this.getResourceTypes(), null);
            if (item == this.myItem) {
                this.myTextEditorWithAutoCompletion.updateCompletions(completions);
                this.myCompletionsUpdated = true;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/NlResourceValueEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/NlResourceValueEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createForSliceTable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTableCellEditorComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

