/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.StyleFilter;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleEnumSupport
extends EnumSupport {
    protected final StyleFilter myStyleFilter;
    protected final ResourceRepositoryManager myResourceManager;

    public StyleEnumSupport(@NotNull NlProperty property2) {
        if (property2 == null) {
            StyleEnumSupport.$$$reportNull$$$0(0);
        }
        this(property2.getModel().getFacet(), property2);
    }

    private StyleEnumSupport(@NotNull AndroidFacet facet, @NotNull NlProperty property2) {
        if (facet == null) {
            StyleEnumSupport.$$$reportNull$$$0(1);
        }
        if (property2 == null) {
            StyleEnumSupport.$$$reportNull$$$0(2);
        }
        this(property2, new StyleFilter(facet, property2.getResolver()), ResourceRepositoryManager.getOrCreateInstance(facet));
    }

    StyleEnumSupport(@NotNull NlProperty property2, @NotNull StyleFilter styleFilter, @NotNull ResourceRepositoryManager resourceManager) {
        if (property2 == null) {
            StyleEnumSupport.$$$reportNull$$$0(3);
        }
        if (styleFilter == null) {
            StyleEnumSupport.$$$reportNull$$$0(4);
        }
        if (resourceManager == null) {
            StyleEnumSupport.$$$reportNull$$$0(5);
        }
        super(property2);
        this.myStyleFilter = styleFilter;
        this.myResourceManager = resourceManager;
    }

    @Override
    @NotNull
    public List<ValueWithDisplayString> getAllValues() {
        String tagName = this.myProperty.getTagName();
        assert (tagName != null);
        List<ValueWithDisplayString> list = this.convertStylesToDisplayValues(this.myStyleFilter.getWidgetStyles(tagName));
        if (list == null) {
            StyleEnumSupport.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    protected ValueWithDisplayString createFromResolvedValue(@NotNull String resolvedValue, @Nullable String value, @Nullable String hint) {
        String shortDisplay;
        if (resolvedValue == null) {
            StyleEnumSupport.$$$reportNull$$$0(7);
        }
        if (value != null && !value.startsWith("@") && !value.startsWith("?")) {
            ResourceNamespace currentNamespace = this.myResourceManager.getNamespace();
            StyleResourceValue styleFound = this.resolve(currentNamespace, value);
            if (styleFound == null) {
                for (String namespaceUri : this.findKnownNamespaces()) {
                    StyleResourceValue resource;
                    ResourceNamespace namespace = ResourceNamespace.fromNamespaceUri((String)namespaceUri);
                    if (namespace == null || (resource = this.resolve(namespace, value)) == null) continue;
                    styleFound = resource;
                    break;
                }
            }
            value = styleFound != null ? styleFound.asReference().getRelativeResourceUrl(currentNamespace, this.getResolver()).toString() : "@style/" + value;
        }
        String display2 = (shortDisplay = StringUtil.substringAfter((String)resolvedValue, (String)"style/")) != null ? shortDisplay : resolvedValue;
        ValueWithDisplayString valueWithDisplayString = new ValueWithDisplayString(display2, value, this.generateHint(display2, value));
        if (valueWithDisplayString == null) {
            StyleEnumSupport.$$$reportNull$$$0(8);
        }
        return valueWithDisplayString;
    }

    @NotNull
    protected String[] findKnownNamespaces() {
        XmlTag tag = this.getTagOfFirstComponent();
        String[] stringArray = tag != null ? tag.knownNamespaces() : new String[]{};
        if (stringArray == null) {
            StyleEnumSupport.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    @NotNull
    protected ResourceNamespace.Resolver getResolver() {
        XmlTag tag = this.getTagOfFirstComponent();
        ResourceNamespace.Resolver resolver = tag != null ? ResourceHelper.getNamespaceResolver((XmlElement)tag) : ResourceNamespace.Resolver.EMPTY_RESOLVER;
        if (resolver == null) {
            StyleEnumSupport.$$$reportNull$$$0(10);
        }
        return resolver;
    }

    @Nullable
    private XmlTag getTagOfFirstComponent() {
        List<NlComponent> components = this.myProperty.getComponents();
        return !components.isEmpty() ? components.get(0).getTag() : null;
    }

    @Nullable
    protected StyleResourceValue resolve(@NotNull ResourceNamespace namespace, @NotNull String styleName) {
        ResourceResolver resolver;
        if (namespace == null) {
            StyleEnumSupport.$$$reportNull$$$0(11);
        }
        if (styleName == null) {
            StyleEnumSupport.$$$reportNull$$$0(12);
        }
        if ((resolver = this.myProperty.getResolver()) == null) {
            return null;
        }
        return resolver.getStyle(ResourceReference.style((ResourceNamespace)namespace, (String)styleName));
    }

    @Nullable
    protected String generateHint(@NotNull String display2, @Nullable String value) {
        if (display2 == null) {
            StyleEnumSupport.$$$reportNull$$$0(13);
        }
        if (value == null) {
            return "default";
        }
        if (value.endsWith(display2)) {
            return null;
        }
        return value;
    }

    @NotNull
    protected List<ValueWithDisplayString> convertStylesToDisplayValues(@NotNull List<StyleResourceValue> styles2) {
        if (styles2 == null) {
            StyleEnumSupport.$$$reportNull$$$0(14);
        }
        ArrayList<ValueWithDisplayString> values2 = new ArrayList<ValueWithDisplayString>();
        StyleResourceValue previousStyle = null;
        for (StyleResourceValue style : styles2) {
            if (!(previousStyle == null || previousStyle.getNamespace().equals((Object)style.getNamespace()) && previousStyle.isUserDefined() == style.isUserDefined())) {
                values2.add(ValueWithDisplayString.SEPARATOR);
            }
            previousStyle = style;
            values2.add(this.createFromResolvedValue(style.getName(), style.asReference().getRelativeResourceUrl(ResourceNamespace.TODO(), this.getResolver()).toString(), null));
        }
        ArrayList<ValueWithDisplayString> arrayList = values2;
        if (arrayList == null) {
            StyleEnumSupport.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceManager";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/support/StyleEnumSupport";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedValue";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "display";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/support/StyleEnumSupport";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValues";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromResolvedValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findKnownNamespaces";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolver";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertStylesToDisplayValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFromResolvedValue";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateHint";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "convertStylesToDisplayValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

