/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property2.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property2.api.EditorProvider;
import com.android.tools.idea.common.property2.api.InspectorBuilder;
import com.android.tools.idea.common.property2.api.InspectorLineModel;
import com.android.tools.idea.common.property2.api.InspectorPanel;
import com.android.tools.idea.common.property2.api.PropertiesTable;
import com.android.tools.idea.common.property2.api.PropertyEditorModel;
import com.android.tools.idea.uibuilder.api.CustomPanel;
import com.android.tools.idea.uibuilder.api.PropertyComponentHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.idea.uibuilder.property2.inspector.DummyCustomPanel;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0002J.\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0002J\b\u0010\u001e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/uibuilder/property2/inspector/LayoutInspectorBuilder;", "Lcom/android/tools/idea/common/property2/api/InspectorBuilder;", "Lcom/android/tools/idea/uibuilder/property2/NelePropertyItem;", "project", "Lcom/intellij/openapi/project/Project;", "editorProvider", "Lcom/android/tools/idea/common/property2/api/EditorProvider;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/common/property2/api/EditorProvider;)V", "cachedCustomPanels", "", "", "Lcom/android/tools/idea/uibuilder/api/CustomPanel;", "viewHandlerManager", "Lcom/android/tools/idea/uibuilder/handlers/ViewHandlerManager;", "attachToInspector", "", "inspector", "Lcom/android/tools/idea/common/property2/api/InspectorPanel;", "properties", "Lcom/android/tools/idea/common/property2/api/PropertiesTable;", "createCustomPanel", "parentTagName", "getLayoutAttributes", "", "getParentTagName", "isApplicable", "", "attributes", "custom", "Ljavax/swing/JPanel;", "resetCache", "setupCustomPanel", "intellij.android.designer"})
public final class LayoutInspectorBuilder
implements InspectorBuilder<NelePropertyItem> {
    private final ViewHandlerManager viewHandlerManager;
    private final Map<String, CustomPanel> cachedCustomPanels;
    private final EditorProvider<NelePropertyItem> editorProvider;

    @Override
    public void resetCache() {
        this.cachedCustomPanels.clear();
    }

    @Override
    public void attachToInspector(@NotNull InspectorPanel inspector, @NotNull PropertiesTable<? extends NelePropertyItem> properties) {
        Intrinsics.checkParameterIsNotNull((Object)inspector, (String)"inspector");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        List<String> attributes = this.getLayoutAttributes(properties);
        JPanel custom = this.setupCustomPanel(properties);
        if (!this.isApplicable(attributes, custom, properties)) {
            return;
        }
        InspectorLineModel titleModel = InspectorPanel.DefaultImpls.addExpandableTitle$default(inspector, "layout", false, 2, null);
        if (custom != null) {
            InspectorLineModel customLine = inspector.addComponent(custom);
            titleModel.addChild(customLine);
        }
        for (String propertyName : attributes) {
            NelePropertyItem property2 = properties.getOrNull("http://schemas.android.com/apk/res/android", propertyName);
            if (property2 == null) continue;
            InspectorLineModel line = inspector.addEditor((Pair<? extends PropertyEditorModel, ? extends JComponent>)((Pair)this.editorProvider.invoke(property2)));
            titleModel.addChild(line);
        }
    }

    private final boolean isApplicable(List<String> attributes, JPanel custom, PropertiesTable<? extends NelePropertyItem> properties) {
        boolean bl;
        block4: {
            if (custom != null) {
                return true;
            }
            Iterable $receiver$iv = attributes;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    if (!(properties.getOrNull("http://schemas.android.com/apk/res/android", it) != null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<String> getLayoutAttributes(PropertiesTable<? extends NelePropertyItem> properties) {
        ViewHandler handler;
        List attributes = CollectionsKt.mutableListOf((Object[])new String[]{"layout_width", "layout_height"});
        String string = this.getParentTagName(properties);
        if (string == null) {
            return attributes;
        }
        String parentTagName = string;
        ViewHandler viewHandler2 = this.viewHandlerManager.getHandler(parentTagName);
        if (viewHandler2 == null) {
            return attributes;
        }
        ViewHandler viewHandler3 = handler = viewHandler2;
        Intrinsics.checkExpressionValueIsNotNull((Object)viewHandler3, (String)"handler");
        List<String> list = viewHandler3.getLayoutInspectorProperties();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"handler.layoutInspectorProperties");
        attributes.addAll((Collection)list);
        return attributes;
    }

    private final String getParentTagName(PropertiesTable<? extends NelePropertyItem> properties) {
        boolean bl;
        Object parentTagName;
        block5: {
            NelePropertyItem nelePropertyItem = properties.getFirst();
            if (nelePropertyItem == null) {
                return null;
            }
            NelePropertyItem property2 = nelePropertyItem;
            Object object = (NlComponent)CollectionsKt.firstOrNull(property2.getComponents());
            if (object == null || (object = ((NlComponent)object).getParent()) == null || (object = ((NlComponent)object).getTagName()) == null) {
                return null;
            }
            parentTagName = object;
            Iterable $receiver$iv = property2.getComponents();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    NlComponent it = (NlComponent)element$iv;
                    NlComponent nlComponent = it.getParent();
                    if (Intrinsics.areEqual((Object)(nlComponent != null ? nlComponent.getTagName() : null), (Object)parentTagName)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl ? parentTagName : null;
    }

    private final JPanel setupCustomPanel(PropertiesTable<? extends NelePropertyItem> properties) {
        CustomPanel panel;
        String string = this.getParentTagName(properties);
        if (string == null) {
            return null;
        }
        String parentTagName = string;
        CustomPanel customPanel = this.cachedCustomPanels.get(parentTagName);
        if (customPanel == null) {
            customPanel = panel = this.createCustomPanel(parentTagName);
        }
        if (Intrinsics.areEqual((Object)panel, (Object)DummyCustomPanel.INSTANCE)) {
            return null;
        }
        NelePropertyItem nelePropertyItem = properties.getFirst();
        if (nelePropertyItem == null) {
            return null;
        }
        NelePropertyItem property2 = nelePropertyItem;
        NlComponent nlComponent = (NlComponent)CollectionsKt.singleOrNull(property2.getComponents());
        if (nlComponent == null) {
            return null;
        }
        NlComponent component = nlComponent;
        panel.useComponent(component);
        return panel.getPanel();
    }

    private final CustomPanel createCustomPanel(String parentTagName) {
        ViewHandler handler = this.viewHandlerManager.getHandler(parentTagName);
        Object object = handler;
        if (object == null || (object = ((PropertyComponentHandler)object).getLayoutCustomPanel()) == null) {
            object = DummyCustomPanel.INSTANCE;
        }
        Object panel = object;
        Map<String, CustomPanel> map2 = this.cachedCustomPanels;
        Object object2 = panel;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"panel");
        Object object3 = object2;
        map2.put(parentTagName, (CustomPanel)object3);
        return panel;
    }

    public LayoutInspectorBuilder(@NotNull Project project, @NotNull EditorProvider<? super NelePropertyItem> editorProvider) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(editorProvider, (String)"editorProvider");
        this.editorProvider = editorProvider;
        this.viewHandlerManager = ViewHandlerManager.get(project);
        LayoutInspectorBuilder layoutInspectorBuilder = this;
        layoutInspectorBuilder.cachedCustomPanels = map2 = (Map)new LinkedHashMap();
    }
}

