/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property2.support;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.common.property2.api.EnumSupport;
import com.android.tools.idea.common.property2.api.EnumValue;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.property2.NelePropertyItem;
import com.android.tools.idea.uibuilder.property2.support.DerivedStyleFinder;
import com.android.tools.idea.uibuilder.property2.support.StyleEnumSupport;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010$\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0014H\u0004J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010\u001e\u001a\n \u001f*\u0004\u0018\u00010\u001c0\u001c2\u0006\u0010 \u001a\u00020\u001aH\u0014J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\"\u001a\u00020\u001cH\u0002J&\u0010#\u001a\u0004\u0018\u00010\u001a2\u0006\u0010$\u001a\u00020\u001c2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0&H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/uibuilder/property2/support/StyleEnumSupport;", "Lcom/android/tools/idea/common/property2/api/EnumSupport;", "property", "Lcom/android/tools/idea/uibuilder/property2/NelePropertyItem;", "(Lcom/android/tools/idea/uibuilder/property2/NelePropertyItem;)V", "derivedStyles", "Lcom/android/tools/idea/uibuilder/property2/support/DerivedStyleFinder;", "getDerivedStyles", "()Lcom/android/tools/idea/uibuilder/property2/support/DerivedStyleFinder;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "getProperty", "()Lcom/android/tools/idea/uibuilder/property2/NelePropertyItem;", "resolver", "Lcom/android/ide/common/resources/ResourceResolver;", "getResolver", "()Lcom/android/ide/common/resources/ResourceResolver;", "values", "", "Lcom/android/tools/idea/common/property2/api/EnumValue;", "getValues", "()Ljava/util/List;", "convertStyles", "styles", "Lcom/android/ide/common/rendering/api/StyleResourceValue;", "determineHeaderFromLibraryName", "", "libraryName", "displayName", "kotlin.jvm.PlatformType", "style", "getWidgetBaseStyles", "tagName", "resolve", "qualifiedStyleName", "prefixMap", "", "intellij.android.designer"})
public class StyleEnumSupport
implements EnumSupport {
    @NotNull
    private final AndroidFacet facet;
    @Nullable
    private final ResourceResolver resolver;
    @NotNull
    private final DerivedStyleFinder derivedStyles;
    @NotNull
    private final NelePropertyItem property;

    @NotNull
    protected final AndroidFacet getFacet() {
        return this.facet;
    }

    @Nullable
    protected final ResourceResolver getResolver() {
        return this.resolver;
    }

    @NotNull
    protected final DerivedStyleFinder getDerivedStyles() {
        return this.derivedStyles;
    }

    @Override
    @NotNull
    public List<EnumValue> getValues() {
        String tagName = this.property.getTagName();
        CharSequence charSequence = tagName;
        if (charSequence.length() == 0) {
            return CollectionsKt.emptyList();
        }
        List<StyleResourceValue> baseStyles = this.getWidgetBaseStyles(tagName);
        List<StyleResourceValue> styles2 = this.derivedStyles.find(baseStyles, (Function1<? super StyleResourceValue, Boolean>)((Function1)values.styles.1.INSTANCE), (Function1)values.styles.2.INSTANCE);
        return this.convertStyles(styles2);
    }

    protected String displayName(@NotNull StyleResourceValue style) {
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        return style.getName();
    }

    @NotNull
    protected final List<EnumValue> convertStyles(@NotNull List<? extends StyleResourceValue> styles2) {
        ResourceRepositoryManager resourceManager;
        Intrinsics.checkParameterIsNotNull(styles2, (String)"styles");
        ResourceRepositoryManager resourceRepositoryManager = resourceManager = ResourceRepositoryManager.getOrCreateInstance(this.facet);
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceRepositoryManager, (String)"resourceManager");
        ResourceNamespace currentNamespace = resourceRepositoryManager.getNamespace();
        ResourceNamespace.Resolver namespaceResolver = this.property.getNamespaceResolver();
        StyleResourceValue prev = null;
        List result2 = new ArrayList();
        for (StyleResourceValue styleResourceValue : styles2) {
            String xmlValue;
            String string = xmlValue = styleResourceValue.asReference().getRelativeResourceUrl(currentNamespace, namespaceResolver).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"xmlValue");
            String string2 = this.displayName(styleResourceValue);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"displayName(style)");
            EnumValue value = EnumValue.Companion.indented(string, string2);
            if (prev != null && Intrinsics.areEqual((Object)styleResourceValue.getNamespace(), (Object)prev.getNamespace()) && Intrinsics.areEqual((Object)styleResourceValue.getLibraryName(), (Object)prev.getLibraryName())) {
                result2.add(value);
            } else {
                String string3;
                ResourceNamespace resourceNamespace = styleResourceValue.getNamespace();
                if (Intrinsics.areEqual((Object)resourceNamespace, (Object)ResourceNamespace.ANDROID)) {
                    string3 = "Android";
                } else if (Intrinsics.areEqual((Object)resourceNamespace, (Object)ResourceNamespace.TODO())) {
                    string3 = this.determineHeaderFromLibraryName(styleResourceValue.getLibraryName());
                } else {
                    ResourceNamespace resourceNamespace2 = styleResourceValue.getNamespace();
                    Intrinsics.checkExpressionValueIsNotNull((Object)resourceNamespace2, (String)"style.namespace");
                    String string4 = resourceNamespace2.getPackageName();
                    if (string4 == null) {
                        string4 = "Other";
                    }
                    String string5 = StringUtil.getShortName((String)string4, (char)'.');
                    string3 = string5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"StringUtil.getShortName(\u2026ame ?: OTHER_HEADER, '.')");
                }
                String header = string3;
                result2.add(value.withHeader(header));
            }
            prev = styleResourceValue;
        }
        return result2;
    }

    private final String determineHeaderFromLibraryName(String libraryName) {
        CharSequence charSequence;
        return libraryName == null || (charSequence = (CharSequence)libraryName).length() == 0 ? "Project" : (StringsKt.contains$default((CharSequence)libraryName, (CharSequence)"appcompat", (boolean)false, (int)2, null) ? "AppCompat" : "Library");
    }

    /*
     * WARNING - void declaration
     */
    private final List<StyleResourceValue> getWidgetBaseStyles(String tagName) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        ViewHandlerManager manager = ViewHandlerManager.get(this.facet);
        ViewHandler viewHandler2 = manager.getHandler(tagName);
        if (viewHandler2 == null) {
            return CollectionsKt.emptyList();
        }
        ViewHandler handler = viewHandler2;
        List<String> possibleNames = handler.getBaseStyles(tagName);
        ViewHandler viewHandler3 = handler;
        Intrinsics.checkExpressionValueIsNotNull((Object)viewHandler3, (String)"handler");
        Map<String, String> prefixMap = viewHandler3.getPrefixToNamespaceMap();
        List<String> list = possibleNames;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"possibleNames");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            StyleResourceValue styleResourceValue;
            String it;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            String string = it = (String)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            Map<String, String> map2 = prefixMap;
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"prefixMap");
            if (this.resolve(string, map2) == null) continue;
            StyleResourceValue it$iv$iv = styleResourceValue;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final StyleResourceValue resolve(String qualifiedStyleName, Map<String, String> prefixMap) {
        if (this.resolver == null) {
            return null;
        }
        ResourceUrl resourceUrl = ResourceUrl.parseStyleParentReference((String)qualifiedStyleName);
        if (resourceUrl == null) {
            return null;
        }
        ResourceUrl url = resourceUrl;
        ResourceReference resourceReference = url.resolve(ResourceNamespace.ANDROID, new ResourceNamespace.Resolver(prefixMap){
            final /* synthetic */ Map $prefixMap;

            @Nullable
            public final String prefixToUri(String it) {
                return (String)this.$prefixMap.get(it);
            }
            {
                this.$prefixMap = map2;
            }
        });
        if (resourceReference == null) {
            return null;
        }
        ResourceReference reference2 = resourceReference;
        return this.resolver.getStyle(reference2);
    }

    @NotNull
    public final NelePropertyItem getProperty() {
        return this.property;
    }

    public StyleEnumSupport(@NotNull NelePropertyItem property2) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        this.property = property2;
        this.facet = this.property.getModel().getFacet();
        this.resolver = this.property.getResolver();
        this.derivedStyles = new DerivedStyleFinder(this.facet, this.resolver);
    }

    @Override
    @NotNull
    public ListCellRenderer<EnumValue> getRenderer() {
        return EnumSupport.DefaultImpls.getRenderer(this);
    }
}

