/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.analytics.NlUsageTrackerManager;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.TargetProvider;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragDndTarget;
import com.android.tools.idea.uibuilder.menu.NavigationViewSceneView;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlSelectionModel;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.scene.decorator.NlSceneDecoratorFactory;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.SceneMode;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.util.ListenerCollection;
import com.android.util.PropertiesMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorRenderResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.swing.Timer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class LayoutlibSceneManager
extends SceneManager {
    private static final SceneDecoratorFactory DECORATOR_FACTORY = new NlSceneDecoratorFactory();
    @Nullable
    private SceneView mySecondarySceneView;
    private int myDpi;
    private final SelectionChangeListener mySelectionChangeListener;
    private final ModelChangeListener myModelChangeListener;
    private final ConfigurationListener myConfigurationChangeListener;
    private boolean myAreListenersRegistered;
    private final Object myProgressLock;
    @GuardedBy(value="myProgressLock")
    private AndroidPreviewProgressIndicator myCurrentIndicator;
    private final Object myRenderingQueueLock;
    @GuardedBy(value="myRenderingQueueLock")
    private MergingUpdateQueue myRenderingQueue;
    private static final int RENDER_DELAY_MS = 10;
    private RenderTask myRenderTask;
    private final Object myRenderingTaskLock;
    private ResourceNotificationManager.ResourceVersion myRenderedVersion;
    private final ReentrantReadWriteLock myRenderResultLock;
    @GuardedBy(value="myRenderResultLock")
    private RenderResult myRenderResult;
    @GuardedBy(value="myRenderResultLock")
    private RenderResult myLastSuccessfulRenderResult;
    private String myPreviousDeviceName;
    private Locale myPreviousLocale;
    private String myPreviousVersion;
    private String myPreviousTheme;
    private static final int VISUAL_EMPTY_COMPONENT_SIZE = 1;
    private long myElapsedFrameTimeMs;
    private final LinkedList<Runnable> myRenderCallbacks;
    private final Semaphore myUpdateHierarchyLock;
    @NotNull
    private final ViewEditor myViewEditor;
    private final ListenerCollection<RenderListener> myRenderListeners;
    @NotNull
    private final Executor myRenderTaskDisposerExecutor;
    private static boolean ourRenderViewPort;

    protected static LayoutEditorRenderResult.Trigger getTriggerFromChangeType(@Nullable NlModel.ChangeType changeType) {
        if (changeType == null) {
            return null;
        }
        switch (changeType) {
            case RESOURCE_EDIT: 
            case RESOURCE_CHANGED: {
                return LayoutEditorRenderResult.Trigger.RESOURCE_CHANGE;
            }
            case EDIT: 
            case ADD_COMPONENTS: 
            case DELETE: 
            case DND_COMMIT: 
            case DND_END: 
            case DROP: 
            case RESIZE_END: 
            case RESIZE_COMMIT: {
                return LayoutEditorRenderResult.Trigger.EDIT;
            }
            case BUILD: {
                return LayoutEditorRenderResult.Trigger.BUILD;
            }
        }
        return null;
    }

    protected LayoutlibSceneManager(@NotNull NlModel model, @NotNull DesignSurface designSurface, @NotNull Executor renderTaskDisposerExecutor) {
        if (model == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(0);
        }
        if (designSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(1);
        }
        if (renderTaskDisposerExecutor == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(2);
        }
        super(model, designSurface);
        this.myDpi = 0;
        this.mySelectionChangeListener = new SelectionChangeListener();
        this.myModelChangeListener = new ModelChangeListener();
        this.myConfigurationChangeListener = new ConfigurationChangeListener();
        this.myProgressLock = new Object();
        this.myRenderingQueueLock = new Object();
        this.myRenderingTaskLock = new Object();
        this.myRenderResultLock = new ReentrantReadWriteLock();
        this.myElapsedFrameTimeMs = -1L;
        this.myRenderCallbacks = new LinkedList();
        this.myUpdateHierarchyLock = new Semaphore(1);
        this.myRenderListeners = ListenerCollection.createWithDirectExecutor();
        this.myRenderTaskDisposerExecutor = renderTaskDisposerExecutor;
        this.createSceneView();
        this.updateTrackingConfiguration();
        this.getDesignSurface().getSelectionModel().addListener(this.mySelectionChangeListener);
        Scene scene = this.getScene();
        this.myViewEditor = new ViewEditorImpl(model, scene);
        model.getConfiguration().addListener(this.myConfigurationChangeListener);
        ImmutableList<NlComponent> components = model.getComponents();
        if (!components.isEmpty()) {
            NlComponent rootComponent = ((NlComponent)components.get(0)).getRoot();
            boolean previous = this.getScene().isAnimated();
            scene.setAnimated(false);
            SceneComponent root = this.createHierarchy(rootComponent);
            this.updateFromComponent(root, new HashSet<SceneComponent>());
            scene.setRoot(root);
            this.addTargets(root);
            scene.setAnimated(previous);
        }
        model.addListener(this.myModelChangeListener);
        this.myAreListenersRegistered = true;
        scene.selectionChanged(this.getDesignSurface().getSelectionModel(), (List<NlComponent>)this.getDesignSurface().getSelectionModel().getSelection());
    }

    public LayoutlibSceneManager(@NotNull NlModel model, @NotNull DesignSurface designSurface) {
        if (model == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(3);
        }
        if (designSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(4);
        }
        this(model, designSurface, PooledThreadExecutor.INSTANCE);
    }

    @NotNull
    public ViewEditor getViewEditor() {
        ViewEditor viewEditor = this.myViewEditor;
        if (viewEditor == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(5);
        }
        return viewEditor;
    }

    @Override
    @NotNull
    public TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent component) {
        if (component == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(6);
        }
        Scene scene = this.getScene();
        assert (scene.getRoot() != null);
        TemporarySceneComponent tempComponent = new TemporarySceneComponent(this.getScene(), component);
        tempComponent.addTarget(new ConstraintDragDndTarget());
        scene.setAnimated(false);
        scene.getRoot().addChild(tempComponent);
        this.updateFromComponent(tempComponent);
        scene.setAnimated(true);
        TemporarySceneComponent temporarySceneComponent = tempComponent;
        if (temporarySceneComponent == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(7);
        }
        return temporarySceneComponent;
    }

    @Override
    @NotNull
    public SceneDecoratorFactory getSceneDecoratorFactory() {
        SceneDecoratorFactory sceneDecoratorFactory = DECORATOR_FACTORY;
        if (sceneDecoratorFactory == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(8);
        }
        return sceneDecoratorFactory;
    }

    @Override
    public void dispose() {
        if (this.myAreListenersRegistered) {
            NlModel model = this.getModel();
            this.getDesignSurface().getSelectionModel().removeListener(this.mySelectionChangeListener);
            model.getConfiguration().removeListener(this.myConfigurationChangeListener);
            model.removeListener(this.myModelChangeListener);
        }
        this.myRenderListeners.clear();
        this.stopProgressIndicator();
        super.dispose();
        this.myRenderTaskDisposerExecutor.execute(() -> {
            Object object = this.myRenderingTaskLock;
            synchronized (object) {
                if (this.myRenderTask != null) {
                    this.myRenderTask.dispose();
                    this.myRenderTask = null;
                }
            }
            this.myRenderResultLock.writeLock().lock();
            try {
                if (this.myRenderResult != null) {
                    this.myRenderResult.dispose();
                }
                if (this.myLastSuccessfulRenderResult != null) {
                    this.myLastSuccessfulRenderResult.dispose();
                }
                this.myRenderResult = null;
                this.myLastSuccessfulRenderResult = null;
            }
            finally {
                this.myRenderResultLock.writeLock().unlock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopProgressIndicator() {
        Object object = this.myProgressLock;
        synchronized (object) {
            if (this.myCurrentIndicator != null) {
                this.myCurrentIndicator.stop();
                this.myCurrentIndicator = null;
            }
        }
    }

    @Override
    @NotNull
    protected NlDesignSurface getDesignSurface() {
        NlDesignSurface nlDesignSurface = (NlDesignSurface)super.getDesignSurface();
        if (nlDesignSurface == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(9);
        }
        return nlDesignSurface;
    }

    @Override
    @NotNull
    protected SceneView doCreateSceneView() {
        NlModel model = this.getModel();
        NlLayoutType type = model.getType();
        if (type.equals((Object)NlLayoutType.MENU)) {
            SceneView sceneView = this.createSceneViewsForMenu();
            if (sceneView == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(10);
            }
            return sceneView;
        }
        SceneMode mode = this.getDesignSurface().getSceneMode();
        ScreenView primarySceneView = mode.createPrimarySceneView(this.getDesignSurface(), this);
        if (!type.equals((Object)NlLayoutType.PREFERENCE_SCREEN)) {
            this.mySecondarySceneView = mode.createSecondarySceneView(this.getDesignSurface(), this);
        }
        this.getDesignSurface().updateErrorDisplay();
        this.getDesignSurface().getLayeredPane().setPreferredSize(primarySceneView.getPreferredSize());
        ScreenView screenView = primarySceneView;
        if (screenView == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(11);
        }
        return screenView;
    }

    private SceneView createSceneViewsForMenu() {
        NlModel model = this.getModel();
        XmlTag tag = model.getFile().getRootTag();
        ScreenView sceneView = tag != null && Objects.equals(tag.getAttributeValue("showIn", "http://schemas.android.com/tools"), "navigation_view") ? new NavigationViewSceneView(this.getDesignSurface(), this) : new ScreenView(this.getDesignSurface(), this);
        this.getDesignSurface().updateErrorDisplay();
        this.getDesignSurface().getLayeredPane().setPreferredSize(sceneView.getPreferredSize());
        return sceneView;
    }

    @Override
    @NotNull
    public ImmutableList<Layer> getLayers() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(super.getLayers());
        if (this.mySecondarySceneView != null) {
            builder.addAll(this.mySecondarySceneView.getLayers());
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(12);
        }
        return immutableList;
    }

    @Nullable
    public SceneView getSecondarySceneView() {
        return this.mySecondarySceneView;
    }

    @Override
    protected void updateFromComponent(SceneComponent sceneComponent) {
        boolean animate;
        super.updateFromComponent(sceneComponent);
        NlComponent component = sceneComponent.getNlComponent();
        boolean bl = animate = this.getScene().isAnimated() && !sceneComponent.hasNoDimension();
        if (animate) {
            long time2 = System.currentTimeMillis();
            sceneComponent.setPositionTarget(Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getX(component)), Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getY(component)), time2, true);
            sceneComponent.setSizeTarget(Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getW(component)), Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getH(component)), time2, true);
        } else {
            sceneComponent.setPosition(Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getX(component)), Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getY(component)), true);
            sceneComponent.setSize(Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getW(component)), Coordinates.pxToDp(this.getDesignSurface(), NlComponentHelperKt.getH(component)), true);
        }
    }

    @Override
    public void update() {
        super.update();
        NlSelectionModel selectionModel = this.getDesignSurface().getSelectionModel();
        if (this.getScene().getRoot() != null && selectionModel.isEmpty()) {
            this.addTargets(this.getScene().getRoot());
        }
    }

    public void addTargets(@NotNull SceneComponent component) {
        SceneComponent parent;
        ViewHandler componentHandler;
        if (component == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(13);
        }
        if ((componentHandler = NlComponentHelperKt.getViewHandler(component.getNlComponent())) instanceof TargetProvider) {
            component.setTargetProvider(componentHandler);
        }
        if ((parent = component.getParent()) == null) {
            parent = this.getScene().getRoot();
        }
        if (parent == null) {
            return;
        }
        ViewHandler parentHandler = NlComponentHelperKt.getViewHandler(parent.getNlComponent());
        if (parentHandler instanceof ViewGroupHandler) {
            parent.setTargetProvider((ViewGroupHandler)parentHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestRender(@Nullable Runnable callback, final @Nullable LayoutEditorRenderResult.Trigger trigger) {
        if (callback != null) {
            LinkedList<Runnable> linkedList = this.myRenderCallbacks;
            synchronized (linkedList) {
                this.myRenderCallbacks.add(callback);
            }
        }
        this.getRenderingQueue().queue(new Update("model.render", 999){

            public void run() {
                LayoutlibSceneManager.this.render(trigger);
            }

            public boolean canEat(Update update2) {
                return this.equals(update2);
            }
        });
    }

    @Override
    public void requestRender() {
        this.requestRender(null, LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType()));
    }

    public void requestUserInitatedRender() {
        this.requestRender(null, LayoutEditorRenderResult.Trigger.USER);
    }

    @Override
    public void requestLayoutAndRender(boolean animate) {
        this.requestRender(() -> this.getModel().notifyListenersModelLayoutComplete(animate), LayoutlibSceneManager.getTriggerFromChangeType(this.getModel().getLastChangeType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestModelUpdate() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.myProgressLock;
        synchronized (object) {
            if (this.myCurrentIndicator == null) {
                this.myCurrentIndicator = new AndroidPreviewProgressIndicator();
                this.myCurrentIndicator.start();
            }
        }
        this.getRenderingQueue().queue(new Update("model.update", 10){

            public void run() {
                NlModel model = LayoutlibSceneManager.this.getModel();
                Project project = model.getModule().getProject();
                if (!project.isOpen()) {
                    return;
                }
                DumbService.getInstance((Project)project).runWhenSmart(() -> {
                    if (model.getVirtualFile().isValid() && !model.getFacet().isDisposed()) {
                        try {
                            LayoutlibSceneManager.this.updateModel();
                        }
                        catch (Throwable e) {
                            Logger.getInstance(NlModel.class).error(e);
                        }
                    }
                    LayoutlibSceneManager.this.stopProgressIndicator();
                });
            }

            public boolean canEat(Update update2) {
                return this.equals(update2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public MergingUpdateQueue getRenderingQueue() {
        Object object = this.myRenderingQueueLock;
        // MONITORENTER : object
        if (this.myRenderingQueue == null) {
            this.myRenderingQueue = new MergingUpdateQueue("android.layout.rendering", 10, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
            this.myRenderingQueue.setRestartTimerOnAdd(true);
        }
        MergingUpdateQueue mergingUpdateQueue = this.myRenderingQueue;
        // MONITOREXIT : object
        if (mergingUpdateQueue != null) return mergingUpdateQueue;
        LayoutlibSceneManager.$$$reportNull$$$0(14);
        return mergingUpdateQueue;
    }

    public static void setRenderViewPort(boolean state) {
        ourRenderViewPort = state;
    }

    public static boolean isRenderViewPort() {
        return ourRenderViewPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layout(boolean animate) {
        ListenableFuture<RenderResult> futureResult;
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            if (this.myRenderTask == null) {
                return;
            }
            futureResult = this.myRenderTask.layout();
        }
        try {
            RenderResult result2 = (RenderResult)futureResult.get();
            if (result2 != null) {
                this.updateHierarchy(result2);
                this.getModel().notifyListenersModelLayoutComplete(animate);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Logger.getInstance(NlModel.class).warn("Unable to run layout()", (Throwable)e);
        }
    }

    @Nullable
    public RenderResult getRenderResult() {
        this.myRenderResultLock.readLock().lock();
        try {
            RenderResult renderResult = this.myRenderResult;
            return renderResult;
        }
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Map<Object, PropertiesMap> getDefaultProperties() {
        this.myRenderResultLock.readLock().lock();
        if (this.myRenderResult == null) {
            Map<Object, PropertiesMap> map2 = Collections.emptyMap();
            Map<Object, PropertiesMap> map3 = map2;
            if (map3 == null) {
                LayoutlibSceneManager.$$$reportNull$$$0(15);
            }
            return map3;
        }
        ImmutableMap<Object, PropertiesMap> immutableMap = this.myRenderResult.getDefaultProperties();
        ImmutableMap<Object, PropertiesMap> immutableMap2 = immutableMap;
        if (immutableMap2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(16);
        }
        return immutableMap2;
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
    }

    private void updateHierarchy(@Nullable RenderResult result2) {
        try {
            this.myUpdateHierarchyLock.acquire();
            try {
                if (result2 == null || !result2.getRenderResult().isSuccess()) {
                    LayoutlibSceneManager.updateHierarchy(Collections.emptyList(), this.getModel());
                } else {
                    LayoutlibSceneManager.updateHierarchy(this.getRootViews(result2), this.getModel());
                }
            }
            finally {
                this.myUpdateHierarchyLock.release();
            }
            this.getModel().checkStructure();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @NotNull
    private List<ViewInfo> getRootViews(@NotNull RenderResult result2) {
        if (result2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(17);
        }
        ImmutableList<ViewInfo> immutableList = this.getModel().getType() == NlLayoutType.MENU ? result2.getSystemRootViews() : result2.getRootViews();
        if (immutableList == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(18);
        }
        return immutableList;
    }

    @VisibleForTesting
    public static void updateHierarchy(@NotNull XmlTag rootTag, @NotNull List<ViewInfo> rootViews, @NotNull NlModel model) {
        if (rootTag == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(19);
        }
        if (rootViews == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(20);
        }
        if (model == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(21);
        }
        model.syncWithPsi(rootTag, rootViews.stream().map(ViewInfoTagSnapshotNode::new).collect(Collectors.toList()));
        LayoutlibSceneManager.updateBounds(rootViews, model);
    }

    @VisibleForTesting
    public static void updateHierarchy(@NotNull List<ViewInfo> rootViews, @NotNull NlModel model) {
        XmlTag root;
        if (rootViews == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(22);
        }
        if (model == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(23);
        }
        if ((root = LayoutlibSceneManager.getRootTag(model)) != null) {
            LayoutlibSceneManager.updateHierarchy(root, rootViews, model);
        }
    }

    @Nullable
    private static XmlTag getRootTag(@NotNull NlModel model) {
        if (model == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(24);
        }
        if (Disposer.isDisposed((Disposable)model)) {
            return null;
        }
        XmlFile file = (XmlFile)AndroidPsiUtils.getPsiFileSafely(model.getProject(), model.getVirtualFile());
        if (file == null) {
            return null;
        }
        return AndroidPsiUtils.getRootTagSafely(model.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inflate(boolean force) {
        Configuration configuration = this.getModel().getConfiguration();
        Project project = this.getModel().getProject();
        if (project.isDisposed()) {
            return false;
        }
        ResourceNotificationManager resourceNotificationManager = ResourceNotificationManager.getInstance(project);
        LayoutPullParsers.saveFileIfNecessary((PsiFile)this.getModel().getFile());
        RenderResult result2 = null;
        RenderTask resultTask = null;
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            if (this.myRenderTask != null && !force) {
                return false;
            }
            AndroidFacet facet = this.getModel().getFacet();
            this.myRenderedVersion = resourceNotificationManager.getCurrentVersion(facet, (PsiFile)this.getModel().getFile(), configuration);
            RenderService renderService = RenderService.getInstance(this.getModel().getProject());
            if (this.myRenderTask != null && !this.myRenderTask.isDisposed()) {
                this.myRenderTask.dispose();
            }
            this.myRenderTask = renderService.createTask(facet, (PsiFile)this.getModel().getFile(), configuration);
            this.setupRenderTask(this.myRenderTask);
            if (this.myRenderTask != null) {
                this.myRenderTask.getLayoutlibCallback().setAdaptiveIconMaskPath(this.getDesignSurface().getAdaptiveIconShape().getPathDescription());
                result2 = this.myRenderTask.inflate();
                if (result2 == null || !result2.getRenderResult().isSuccess()) {
                    this.myRenderTask.dispose();
                    this.myRenderTask = null;
                    if (result2 == null) {
                        result2 = RenderResult.createBlank((PsiFile)this.getModel().getFile());
                    }
                }
            }
            resultTask = this.myRenderTask;
        }
        this.updateHierarchy(result2);
        this.myRenderResultLock.writeLock().lock();
        try {
            this.updateCachedRenderResult(result2);
        }
        finally {
            this.myRenderResultLock.writeLock().unlock();
        }
        return resultTask != null;
    }

    @GuardedBy(value="myRenderResultLock")
    private void updateCachedRenderResult(RenderResult result2) {
        if (result2 != null && result2.getRenderResult().isSuccess()) {
            if (this.myLastSuccessfulRenderResult != null) {
                this.myLastSuccessfulRenderResult.dispose();
            }
            this.myLastSuccessfulRenderResult = null;
            if (this.myRenderResult != null) {
                this.myRenderResult.dispose();
            }
        } else if (this.myRenderResult != null && this.myRenderResult.getRenderResult().isSuccess()) {
            if (this.myLastSuccessfulRenderResult != null) {
                this.myLastSuccessfulRenderResult.dispose();
            }
            this.myLastSuccessfulRenderResult = this.myRenderResult;
        }
        this.myRenderResult = result2;
    }

    @VisibleForTesting
    protected void setupRenderTask(@Nullable RenderTask task) {
    }

    protected void updateModel() {
        this.inflate(true);
        this.getModel().notifyListenersModelUpdateComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void render(@Nullable LayoutEditorRenderResult.Trigger trigger) {
        try {
            this.renderImpl(trigger);
        }
        catch (Throwable e) {
            if (!this.getModel().getFacet().isDisposed()) {
                throw e;
            }
        }
        finally {
            ImmutableList callbacks;
            LinkedList<Runnable> linkedList = this.myRenderCallbacks;
            synchronized (linkedList) {
                callbacks = ImmutableList.copyOf(this.myRenderCallbacks);
                this.myRenderCallbacks.clear();
            }
            callbacks.forEach(Runnable::run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImpl(@Nullable LayoutEditorRenderResult.Trigger trigger) {
        ListenableFuture<RenderResult> futureResult;
        Configuration configuration = this.getModel().getConfiguration();
        NlDesignSurface surface = this.getDesignSurface();
        if (this.getModel().getConfigurationModificationCount() != configuration.getModificationCount()) {
            if (!StringUtil.equals((CharSequence)configuration.getTheme(), (CharSequence)this.myPreviousTheme)) {
                this.myPreviousTheme = configuration.getTheme();
                NlUsageTrackerManager.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.THEME_CHANGE);
            } else if (configuration.getTarget() != null && !StringUtil.equals((CharSequence)configuration.getTarget().getVersionName(), (CharSequence)this.myPreviousVersion)) {
                this.myPreviousVersion = configuration.getTarget().getVersionName();
                NlUsageTrackerManager.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.API_LEVEL_CHANGE);
            } else if (!configuration.getLocale().equals(this.myPreviousLocale)) {
                this.myPreviousLocale = configuration.getLocale();
                NlUsageTrackerManager.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.LANGUAGE_CHANGE);
            } else if (configuration.getDevice() != null && !StringUtil.equals((CharSequence)configuration.getDevice().getDisplayName(), (CharSequence)this.myPreviousDeviceName)) {
                this.myPreviousDeviceName = configuration.getDevice().getDisplayName();
                NlUsageTrackerManager.getInstance(surface).logAction(LayoutEditorEvent.LayoutEditorEventType.DEVICE_CHANGE);
            }
        }
        NlModel.ChangeType changeType = this.getModel().getLastChangeType();
        this.getModel().resetLastChange();
        long renderStartTimeMs = System.currentTimeMillis();
        boolean inflated = this.inflate(false);
        long elapsedFrameTimeMs = this.myElapsedFrameTimeMs;
        Object object = this.myRenderingTaskLock;
        synchronized (object) {
            if (this.myRenderTask == null) {
                return;
            }
            if (elapsedFrameTimeMs != -1L) {
                this.myRenderTask.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(elapsedFrameTimeMs));
            }
            futureResult = this.myRenderTask.render();
        }
        RenderResult result2 = (RenderResult)Futures.getUnchecked(futureResult);
        if (result2 != null && !inflated) {
            this.updateHierarchy(result2);
        }
        this.myRenderResultLock.writeLock().lock();
        try {
            this.updateCachedRenderResult(result2);
            this.myRenderResultLock.readLock().lock();
        }
        finally {
            this.myRenderResultLock.writeLock().unlock();
        }
        try {
            NlUsageTrackerManager.getInstance(surface).logRenderResult(trigger, this.myRenderResult, System.currentTimeMillis() - renderStartTimeMs);
        }
        finally {
            this.myRenderResultLock.readLock().unlock();
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (!Disposer.isDisposed((Disposable)this)) {
                this.update();
            }
        });
        this.fireRenderListeners();
    }

    public void setElapsedFrameTimeMs(long ms) {
        this.myElapsedFrameTimeMs = ms;
    }

    private void updateTrackingConfiguration() {
        Configuration configuration = this.getModel().getConfiguration();
        this.myPreviousDeviceName = configuration.getDevice() != null ? configuration.getDevice().getDisplayName() : null;
        this.myPreviousVersion = configuration.getTarget() != null ? configuration.getTarget().getVersionName() : null;
        this.myPreviousLocale = configuration.getLocale();
        this.myPreviousTheme = configuration.getTheme();
    }

    private static void clearDerivedData(@NotNull NlComponent component) {
        if (component == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(25);
        }
        NlComponentHelperKt.setBounds(component, 0, 0, -1, -1);
        NlComponentHelperKt.setViewInfo(component, null);
    }

    private static void updateBounds(@NotNull List<ViewInfo> rootViews, @NotNull NlModel model) {
        if (rootViews == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(26);
        }
        if (model == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(27);
        }
        model.flattenComponents().forEach(LayoutlibSceneManager::clearDerivedData);
        Map<TagSnapshot, NlComponent> snapshotToComponent = model.flattenComponents().collect(Collectors.toMap(NlComponent::getSnapshot, Function.identity(), (n1, n2) -> n1));
        Map<XmlTag, NlComponent> tagToComponent = model.flattenComponents().collect(Collectors.toMap(NlComponent::getTag, Function.identity()));
        for (ViewInfo view : rootViews) {
            LayoutlibSceneManager.updateBounds(view, 0, 0, snapshotToComponent, tagToComponent);
        }
        ImmutableList<NlComponent> components = model.getComponents();
        if (!rootViews.isEmpty() && !components.isEmpty()) {
            LayoutlibSceneManager.fixBounds((NlComponent)components.get(0));
        }
    }

    private static void fixBounds(@NotNull NlComponent root) {
        List<NlComponent> children;
        if (root == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(28);
        }
        boolean computeBounds = false;
        if (NlComponentHelperKt.getW(root) == -1 && NlComponentHelperKt.getH(root) == -1) {
            computeBounds = true;
            NlComponent parent = root.getParent();
            if (parent != null && NlComponentHelperKt.getW(parent) >= 0) {
                NlComponentHelperKt.setBounds(root, NlComponentHelperKt.getX(parent), NlComponentHelperKt.getY(parent), 0, 0);
            }
        }
        if (!(children = root.getChildren()).isEmpty()) {
            for (NlComponent child : children) {
                LayoutlibSceneManager.fixBounds(child);
            }
            if (computeBounds) {
                Rectangle rectangle = new Rectangle(NlComponentHelperKt.getX(root), NlComponentHelperKt.getY(root), NlComponentHelperKt.getW(root), NlComponentHelperKt.getH(root));
                for (NlComponent child : children) {
                    rectangle = rectangle.union(new Rectangle(NlComponentHelperKt.getX(child), NlComponentHelperKt.getY(child), NlComponentHelperKt.getW(child), NlComponentHelperKt.getH(child)));
                }
                NlComponentHelperKt.setBounds(root, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private static void updateBounds(@NotNull ViewInfo view, int parentX, int parentY, Map<TagSnapshot, NlComponent> snapshotToComponent, Map<XmlTag, NlComponent> tagToComponent) {
        if (view == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(29);
        }
        ViewInfo bounds = RenderService.getSafeBounds(view);
        Object cookie = view.getCookie();
        if (cookie != null && cookie instanceof TagSnapshot) {
            TagSnapshot snapshot = (TagSnapshot)cookie;
            NlComponent component = snapshotToComponent.get(snapshot);
            if (component == null) {
                component = tagToComponent.get(snapshot.tag);
            }
            if (component != null && NlComponentHelperKt.getViewInfo(component) == null) {
                NlComponentHelperKt.setViewInfo(component, view);
                int left = parentX + bounds.getLeft();
                int top = parentY + bounds.getTop();
                int width = bounds.getRight() - bounds.getLeft();
                int height = bounds.getBottom() - bounds.getTop();
                NlComponentHelperKt.setBounds(component, left, top, Math.max(width, 1), Math.max(height, 1));
            }
        }
        parentX += bounds.getLeft();
        parentY += bounds.getTop();
        for (ViewInfo child : view.getChildren()) {
            LayoutlibSceneManager.updateBounds(child, parentX, parentY, snapshotToComponent, tagToComponent);
        }
    }

    protected void fireRenderListeners() {
        this.myRenderListeners.forEach(RenderListener::onRenderCompleted);
    }

    public void addRenderListener(@NotNull RenderListener listener2) {
        if (listener2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(30);
        }
        this.myRenderListeners.add(listener2);
    }

    public void removeRenderListener(@NotNull RenderListener listener2) {
        if (listener2 == null) {
            LayoutlibSceneManager.$$$reportNull$$$0(31);
        }
        this.myRenderListeners.remove(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderTaskDisposerExecutor";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager";
                break;
            }
            case 6: 
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
            case 20: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootViews";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneDecoratorFactory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateSceneView";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderingQueue";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootViews";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryComponent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addTargets";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRootViews";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateHierarchy";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRootTag";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "clearDerivedData";
                break;
            }
            case 26: 
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updateBounds";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fixBounds";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addRenderListener";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeRenderListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ViewInfoTagSnapshotNode
    implements NlModel.TagSnapshotTreeNode {
        private final ViewInfo myViewInfo;

        public ViewInfoTagSnapshotNode(ViewInfo info) {
            this.myViewInfo = info;
        }

        @Override
        @Nullable
        public TagSnapshot getTagSnapshot() {
            Object result2 = this.myViewInfo.getCookie();
            return result2 instanceof TagSnapshot ? (TagSnapshot)result2 : null;
        }

        @Override
        @NotNull
        public List<NlModel.TagSnapshotTreeNode> getChildren() {
            List<NlModel.TagSnapshotTreeNode> list = this.myViewInfo.getChildren().stream().map(ViewInfoTagSnapshotNode::new).collect(Collectors.toList());
            if (list == null) {
                ViewInfoTagSnapshotNode.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$ViewInfoTagSnapshotNode", "getChildren"));
        }
    }

    private class AndroidPreviewProgressIndicator
    extends ProgressIndicatorBase {
        private final Object myLock = new Object();

        private AndroidPreviewProgressIndicator() {
        }

        public void start() {
            super.start();
            UIUtil.invokeLaterIfNeeded(() -> {
                Timer timer2 = UIUtil.createNamedTimer((String)"Android rendering progress timer", (int)0, event -> {
                    Object object = this.myLock;
                    synchronized (object) {
                        if (this.isRunning()) {
                            LayoutlibSceneManager.this.getDesignSurface().registerIndicator((ProgressIndicator)this);
                        }
                    }
                });
                timer2.setRepeats(false);
                timer2.start();
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.myLock;
            synchronized (object) {
                super.stop();
                ApplicationManager.getApplication().invokeLater(() -> LayoutlibSceneManager.this.getDesignSurface().unregisterIndicator((ProgressIndicator)this));
            }
        }
    }

    private class ConfigurationChangeListener
    implements ConfigurationListener {
        private ConfigurationChangeListener() {
        }

        @Override
        public boolean changed(int flags) {
            if ((flags & 2) != 0) {
                int newDpi = LayoutlibSceneManager.this.getModel().getConfiguration().getDensity().getDpiValue();
                if (LayoutlibSceneManager.this.myDpi != newDpi) {
                    LayoutlibSceneManager.this.update();
                }
            }
            return true;
        }
    }

    private class SelectionChangeListener
    implements SelectionListener {
        private SelectionChangeListener() {
        }

        @Override
        public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
            SceneComponent root;
            if (model == null) {
                SelectionChangeListener.$$$reportNull$$$0(0);
            }
            if (selection == null) {
                SelectionChangeListener.$$$reportNull$$$0(1);
            }
            if ((root = LayoutlibSceneManager.this.getScene().getRoot()) != null) {
                this.clearChildTargets(root);
                if (!selection.isEmpty()) {
                    NlComponent primary = selection.get(0);
                    SceneComponent component = LayoutlibSceneManager.this.getScene().getSceneComponent(primary);
                    if (component != null) {
                        LayoutlibSceneManager.this.addTargets(component);
                    } else {
                        LayoutlibSceneManager.this.addTargets(root);
                    }
                } else {
                    LayoutlibSceneManager.this.addTargets(root);
                }
            }
            LayoutlibSceneManager.this.getScene().needsRebuildList();
        }

        void clearChildTargets(SceneComponent component) {
            component.setTargetProvider(null);
            for (SceneComponent child : component.getChildren()) {
                child.setTargetProvider(null);
                this.clearChildTargets(child);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selection";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$SelectionChangeListener";
            objectArray[2] = "selectionChanged";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ModelChangeListener
    implements ModelListener {
        private ModelChangeListener() {
        }

        @Override
        public void modelDerivedDataChanged(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(0);
            }
            NlDesignSurface surface = LayoutlibSceneManager.this.getDesignSurface();
            LayoutlibSceneManager.this.render(LayoutlibSceneManager.getTriggerFromChangeType(model.getLastChangeType()));
            LayoutlibSceneManager.this.mySelectionChangeListener.selectionChanged(LayoutlibSceneManager.this.getDesignSurface().getSelectionModel(), (List<NlComponent>)LayoutlibSceneManager.this.getDesignSurface().getSelectionModel().getSelection());
        }

        @Override
        public void modelChanged(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(1);
            }
            LayoutlibSceneManager.this.requestModelUpdate();
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!Disposer.isDisposed((Disposable)LayoutlibSceneManager.this)) {
                    LayoutlibSceneManager.this.mySelectionChangeListener.selectionChanged(LayoutlibSceneManager.this.getDesignSurface().getSelectionModel(), (List<NlComponent>)LayoutlibSceneManager.this.getDesignSurface().getSelectionModel().getSelection());
                }
            });
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(2);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!Disposer.isDisposed((Disposable)LayoutlibSceneManager.this)) {
                    boolean previous = LayoutlibSceneManager.this.getScene().isAnimated();
                    LayoutlibSceneManager.this.getScene().setAnimated(animate);
                    LayoutlibSceneManager.this.update();
                    LayoutlibSceneManager.this.getScene().setAnimated(previous);
                }
            });
        }

        @Override
        public void modelActivated(@NotNull NlModel model) {
            ResourceNotificationManager manager;
            ResourceNotificationManager.ResourceVersion version2;
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(3);
            }
            if (!(version2 = (manager = ResourceNotificationManager.getInstance(LayoutlibSceneManager.this.getModel().getProject())).getCurrentVersion(LayoutlibSceneManager.this.getModel().getFacet(), (PsiFile)LayoutlibSceneManager.this.getModel().getFile(), LayoutlibSceneManager.this.getModel().getConfiguration())).equals(LayoutlibSceneManager.this.myRenderedVersion)) {
                LayoutlibSceneManager.this.requestModelUpdate();
                model.updateTheme();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void modelDeactivated(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(4);
            }
            Object object = LayoutlibSceneManager.this.myRenderingQueueLock;
            synchronized (object) {
                if (LayoutlibSceneManager.this.myRenderingQueue != null) {
                    LayoutlibSceneManager.this.myRenderingQueue.cancelAllUpdates();
                }
            }
        }

        @Override
        public void modelLiveUpdate(@NotNull NlModel model, boolean animate) {
            NlDesignSurface surface;
            boolean needsRender;
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(5);
            }
            boolean bl = needsRender = (surface = LayoutlibSceneManager.this.getDesignSurface()).getSceneMode() != SceneMode.BLUEPRINT_ONLY;
            if (needsRender) {
                LayoutlibSceneManager.this.requestLayoutAndRender(animate);
            } else {
                LayoutlibSceneManager.this.layout(animate);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "model";
            objectArray2[1] = "com/android/tools/idea/uibuilder/scene/LayoutlibSceneManager$ModelChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDerivedDataChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChangedOnLayout";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelActivated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDeactivated";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelLiveUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

