/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.scene.draw.DrawHorizontalLine;
import com.android.tools.idea.uibuilder.scene.draw.DrawResize;
import com.android.tools.idea.uibuilder.scene.draw.DrawVerticalLine;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import java.awt.Dimension;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ResizeWithSnapBaseTarget
extends ResizeBaseTarget {
    private static final int MAX_MATCH_DISTANCE = 10;
    private static final int CANNOT_SNAP = Integer.MAX_VALUE;
    protected Dimension myWrapSize;

    public ResizeWithSnapBaseTarget(@NotNull ResizeBaseTarget.Type type) {
        if (type == null) {
            ResizeWithSnapBaseTarget.$$$reportNull$$$0(0);
        }
        super(type);
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            ResizeWithSnapBaseTarget.$$$reportNull$$$0(1);
        }
        if (sceneContext == null) {
            ResizeWithSnapBaseTarget.$$$reportNull$$$0(2);
        }
        if (!this.myComponent.isSelected()) {
            return;
        }
        DrawResize.add(list, sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, this.mIsOver ? 1 : 0);
        if (this.myWrapSize != null) {
            this.renderWrapSizeSnapLines(list, sceneContext, this.myWrapSize.width, this.myWrapSize.height);
        }
    }

    private void renderWrapSizeSnapLines(@NotNull DisplayList list, @NotNull SceneContext sceneContext, int wrapX, int wrapY) {
        if (list == null) {
            ResizeWithSnapBaseTarget.$$$reportNull$$$0(3);
        }
        if (sceneContext == null) {
            ResizeWithSnapBaseTarget.$$$reportNull$$$0(4);
        }
        switch (this.myType) {
            case LEFT_TOP: {
                DrawVerticalLine.add(list, sceneContext, this.myStartX2 - wrapX, this.myStartY2 - wrapY, this.myStartY2);
                DrawHorizontalLine.add(list, sceneContext, this.myStartX2 - wrapX, this.myStartY2 - wrapY, this.myStartX2);
                break;
            }
            case LEFT: {
                DrawVerticalLine.add(list, sceneContext, this.myStartX2 - wrapX, this.myStartY1, this.myStartY2);
                break;
            }
            case LEFT_BOTTOM: {
                DrawVerticalLine.add(list, sceneContext, this.myStartX2 - wrapX, this.myStartY1, this.myStartY1 + wrapY);
                DrawHorizontalLine.add(list, sceneContext, this.myStartX2 - wrapX, this.myStartY2 - wrapY, this.myStartX2);
                break;
            }
            case TOP: {
                DrawHorizontalLine.add(list, sceneContext, this.myStartX1, this.myStartY2 - wrapY, this.myStartX2);
                break;
            }
            case BOTTOM: {
                DrawHorizontalLine.add(list, sceneContext, this.myStartX1, this.myStartY1 + wrapY, this.myStartX2);
                break;
            }
            case RIGHT_TOP: {
                DrawVerticalLine.add(list, sceneContext, this.myStartX1 + wrapX, this.myStartY2 - wrapY, this.myStartY2);
                DrawHorizontalLine.add(list, sceneContext, this.myStartX1, this.myStartY2 - wrapY, this.myStartX1 + wrapX);
                break;
            }
            case RIGHT: {
                DrawVerticalLine.add(list, sceneContext, this.myStartX1 + wrapX, this.myStartY1, this.myStartY2);
                break;
            }
            case RIGHT_BOTTOM: {
                DrawVerticalLine.add(list, sceneContext, this.myStartX1 + wrapX, this.myStartY1, this.myStartY1 + wrapY);
                DrawHorizontalLine.add(list, sceneContext, this.myStartX1, this.myStartY1 + wrapY, this.myStartX1 + wrapX);
            }
        }
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myWrapSize = this.myComponent.getScene().measureWrapSize(this.myComponent);
        super.mouseDown(x, y);
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets) {
        if (closestTargets == null) {
            ResizeWithSnapBaseTarget.$$$reportNull$$$0(5);
        }
        x = this.snapX(x);
        y = this.snapY(y);
        super.mouseDrag(x, y, closestTargets);
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        if (closestTargets == null) {
            ResizeWithSnapBaseTarget.$$$reportNull$$$0(6);
        }
        x = this.snapX(x);
        y = this.snapY(y);
        super.mouseRelease(x, y, closestTargets);
        this.myWrapSize = null;
    }

    protected int getNewXPos(int x) {
        SceneComponent parent = this.myComponent.getParent();
        int parentX = parent != null ? parent.getDrawX() : 0;
        switch (this.myType) {
            case LEFT_TOP: 
            case LEFT: 
            case LEFT_BOTTOM: {
                return Math.min(x, this.myStartX2) - parentX;
            }
            case RIGHT_TOP: 
            case RIGHT: 
            case RIGHT_BOTTOM: {
                return Math.min(x, this.myStartX1) - parentX;
            }
        }
        return this.myStartX1 - parentX;
    }

    protected int getNewYPos(int y) {
        SceneComponent parent = this.myComponent.getParent();
        int parentY = parent != null ? parent.getDrawY() : 0;
        switch (this.myType) {
            case LEFT_TOP: 
            case TOP: 
            case RIGHT_TOP: {
                return Math.min(y, this.myStartY2) - parentY;
            }
            case LEFT_BOTTOM: 
            case BOTTOM: 
            case RIGHT_BOTTOM: {
                return Math.min(y, this.myStartY1) - parentY;
            }
        }
        return this.myStartY1 - parentY;
    }

    protected String getNewWidth(int x) {
        int width = this.getNewDpWidth(x);
        SceneComponent parent = this.myComponent.getParent();
        if (parent != null && width == parent.getDrawWidth() && this.getNewXPos(x) == 0) {
            return "match_parent";
        }
        if (this.myWrapSize != null && width == this.myWrapSize.width) {
            return "wrap_content";
        }
        return String.format("%ddp", width);
    }

    protected String getNewHeight(int y) {
        int height = this.getNewDpHeight(y);
        SceneComponent parent = this.myComponent.getParent();
        if (parent != null && height == parent.getDrawHeight() && this.getNewYPos(y) == 0) {
            return "match_parent";
        }
        if (this.myWrapSize != null && height == this.myWrapSize.height) {
            return "wrap_content";
        }
        return String.format("%ddp", height);
    }

    private int getNewDpWidth(int x) {
        switch (this.myType) {
            case LEFT_TOP: 
            case LEFT: 
            case LEFT_BOTTOM: {
                return Math.abs(this.myStartX2 - x);
            }
            case RIGHT_TOP: 
            case RIGHT: 
            case RIGHT_BOTTOM: {
                return Math.abs(this.myStartX1 - x);
            }
        }
        return this.myStartX2 - this.myStartX1;
    }

    private int getNewDpHeight(int y) {
        switch (this.myType) {
            case LEFT_TOP: 
            case TOP: 
            case RIGHT_TOP: {
                return Math.abs(this.myStartY2 - y);
            }
            case LEFT_BOTTOM: 
            case BOTTOM: 
            case RIGHT_BOTTOM: {
                return Math.abs(this.myStartY1 - y);
            }
        }
        return this.myStartY2 - this.myStartY1;
    }

    private int snapX(int x) {
        int dx = this.snapToParentBoundaryX(x);
        if (Math.abs(dx) < 10) {
            return x + dx;
        }
        dx = this.snapToWrapWidth(x);
        if (Math.abs(dx) < 10) {
            return x + dx;
        }
        return x;
    }

    private int snapY(int y) {
        int dy = this.snapToParentBoundaryY(y);
        if (Math.abs(dy) < 10) {
            return y + dy;
        }
        dy = this.snapToWrapHeight(y);
        if (Math.abs(dy) < 10) {
            return y + dy;
        }
        return y;
    }

    private int snapToWrapWidth(int x) {
        if (this.myWrapSize == null) {
            return Integer.MAX_VALUE;
        }
        int width = this.myWrapSize.width;
        switch (this.myType) {
            case LEFT_TOP: 
            case LEFT: 
            case LEFT_BOTTOM: {
                return x < this.myStartX2 ? this.myStartX2 - x - width : width - (x - this.myStartX2);
            }
            case RIGHT_TOP: 
            case RIGHT: 
            case RIGHT_BOTTOM: {
                return x < this.myStartX1 ? this.myStartX1 - x - width : width - (x - this.myStartX1);
            }
        }
        return Integer.MAX_VALUE;
    }

    private int snapToWrapHeight(int y) {
        if (this.myWrapSize == null) {
            return Integer.MAX_VALUE;
        }
        int height = this.myWrapSize.height;
        switch (this.myType) {
            case LEFT_TOP: 
            case TOP: 
            case RIGHT_TOP: {
                return y < this.myStartY2 ? this.myStartY2 - y - height : height - (y - this.myStartY2);
            }
            case LEFT_BOTTOM: 
            case BOTTOM: 
            case RIGHT_BOTTOM: {
                return y < this.myStartY1 ? this.myStartY1 - y - height : height - (y - this.myStartY1);
            }
        }
        return Integer.MAX_VALUE;
    }

    private int snapToParentBoundaryX(int x) {
        SceneComponent parent = this.myComponent.getParent();
        if (parent == null) {
            return Integer.MAX_VALUE;
        }
        switch (this.myType) {
            case LEFT_TOP: 
            case LEFT: 
            case LEFT_BOTTOM: {
                return x < this.myStartX2 ? -x : parent.getDrawWidth() - (x - this.myStartX2);
            }
            case RIGHT_TOP: 
            case RIGHT: 
            case RIGHT_BOTTOM: {
                return x < this.myStartX1 ? -x : parent.getDrawWidth() - (x - this.myStartX1);
            }
        }
        return Integer.MAX_VALUE;
    }

    private int snapToParentBoundaryY(int y) {
        SceneComponent parent = this.myComponent.getParent();
        if (parent == null) {
            return Integer.MAX_VALUE;
        }
        switch (this.myType) {
            case LEFT_TOP: 
            case TOP: 
            case RIGHT_TOP: {
                return y < this.myStartY2 ? -y : parent.getDrawHeight() - (y - this.myStartY2);
            }
            case LEFT_BOTTOM: 
            case BOTTOM: 
            case RIGHT_BOTTOM: {
                return y < this.myStartY1 ? -y : parent.getDrawHeight() - (y - this.myStartY1);
            }
        }
        return Integer.MAX_VALUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closestTargets";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/ResizeWithSnapBaseTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "renderWrapSizeSnapLines";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDrag";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseRelease";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

