/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.google.common.collect.ImmutableList;
import java.awt.Point;
import java.util.Optional;
import java.util.OptionalInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetSnapper {
    public static final int PARENT = 1;
    public static final int PARENT_TARGET = 2;
    public static final int CHILD = 4;
    public static final int CHILD_TARGET = 8;
    public static final int ALL = 15;
    @NotNull
    private ImmutableList<Notch> myNotchesForSnapping = ImmutableList.of();
    @Nullable
    private Notch myHorizontalNotch = null;
    @Nullable
    private Notch myVerticalNotch = null;
    @Nullable
    private Notch myCircularNotch = null;
    private int myNotchesSourcesMask = 15;

    public void gatherNotches(@NotNull SceneComponent snappable) {
        Notch.Provider notchProvider;
        if (snappable == null) {
            TargetSnapper.$$$reportNull$$$0(0);
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        SceneComponent parent = snappable.getParent();
        if (parent == null) {
            return;
        }
        if ((this.myNotchesSourcesMask & 1) > 0 && (notchProvider = parent.getNotchProvider()) != null) {
            notchProvider.fill(parent, snappable, (ImmutableList.Builder<Notch>)builder);
        }
        if ((this.myNotchesSourcesMask & 2) > 0) {
            TargetSnapper.gatherNotchFromTargets(parent, snappable, (ImmutableList.Builder<Notch>)builder);
        }
        if ((this.myNotchesSourcesMask & 0xC) > 0) {
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                Notch.Provider provider;
                SceneComponent child = parent.getChild(i);
                if (child == snappable) continue;
                if ((this.myNotchesSourcesMask & 4) > 0 && (provider = child.getNotchProvider()) != null) {
                    provider.fill(child, snappable, (ImmutableList.Builder<Notch>)builder);
                }
                if ((this.myNotchesSourcesMask & 8) <= 0) continue;
                TargetSnapper.gatherNotchFromTargets(child, snappable, (ImmutableList.Builder<Notch>)builder);
            }
        }
        this.myNotchesForSnapping = builder.build();
    }

    private static void gatherNotchFromTargets(@NotNull SceneComponent owner, @NotNull SceneComponent snappableComponent, @NotNull ImmutableList.Builder<Notch> builder) {
        if (owner == null) {
            TargetSnapper.$$$reportNull$$$0(1);
        }
        if (snappableComponent == null) {
            TargetSnapper.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            TargetSnapper.$$$reportNull$$$0(3);
        }
        for (Target target : owner.getTargets()) {
            if (!(target instanceof Notch.Provider)) continue;
            ((Notch.Provider)((Object)target)).fill(owner, snappableComponent, builder);
        }
    }

    @NotNull
    public OptionalInt trySnapHorizontal(int x) {
        this.myHorizontalNotch = this.findSnappedNotch(1, x, -1);
        if (this.myHorizontalNotch != null) {
            Point p = new Point();
            this.myHorizontalNotch.isSnappable(x, -1, p);
            OptionalInt optionalInt = OptionalInt.of(p.x);
            if (optionalInt == null) {
                TargetSnapper.$$$reportNull$$$0(4);
            }
            return optionalInt;
        }
        OptionalInt optionalInt = OptionalInt.empty();
        if (optionalInt == null) {
            TargetSnapper.$$$reportNull$$$0(5);
        }
        return optionalInt;
    }

    @NotNull
    public OptionalInt trySnapVertical(int y) {
        this.myVerticalNotch = this.findSnappedNotch(2, -1, y);
        if (this.myVerticalNotch != null) {
            Point p = new Point();
            this.myVerticalNotch.isSnappable(-1, y, p);
            OptionalInt optionalInt = OptionalInt.of(p.y);
            if (optionalInt == null) {
                TargetSnapper.$$$reportNull$$$0(6);
            }
            return optionalInt;
        }
        OptionalInt optionalInt = OptionalInt.empty();
        if (optionalInt == null) {
            TargetSnapper.$$$reportNull$$$0(7);
        }
        return optionalInt;
    }

    @NotNull
    public Optional<Point> trySnapCircle(int x, int y) {
        this.myCircularNotch = this.findSnappedNotch(4, x, y);
        if (this.myCircularNotch != null) {
            Point p = new Point();
            this.myCircularNotch.isSnappable(x, y, p);
            Optional<Point> optional = Optional.of(p);
            if (optional == null) {
                TargetSnapper.$$$reportNull$$$0(8);
            }
            return optional;
        }
        Optional<Point> optional = Optional.empty();
        if (optional == null) {
            TargetSnapper.$$$reportNull$$$0(9);
        }
        return optional;
    }

    @Nullable
    private Notch findSnappedNotch(int type, int x, int y) {
        double distance = Double.MAX_VALUE;
        Notch ret = null;
        Point p = new Point();
        for (Notch notch2 : this.myNotchesForSnapping) {
            double d;
            if (notch2.getType() != type || !notch2.isSnappable(x, y, p) || !((d = p.distanceSq(x, y)) < distance)) continue;
            distance = d;
            ret = notch2;
        }
        return ret;
    }

    public void applyNotches(@NotNull NlAttributesHolder attributes) {
        if (attributes == null) {
            TargetSnapper.$$$reportNull$$$0(10);
        }
        if (this.myHorizontalNotch != null) {
            this.myHorizontalNotch.applyAction(attributes);
        }
        if (this.myVerticalNotch != null) {
            this.myVerticalNotch.applyAction(attributes);
        }
        if (this.myCircularNotch != null) {
            this.myCircularNotch.applyAction(attributes);
        }
    }

    public void renderSnappedNotches(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        if (list == null) {
            TargetSnapper.$$$reportNull$$$0(11);
        }
        if (sceneContext == null) {
            TargetSnapper.$$$reportNull$$$0(12);
        }
        if (component == null) {
            TargetSnapper.$$$reportNull$$$0(13);
        }
        if (this.myHorizontalNotch != null) {
            this.myHorizontalNotch.render(list, sceneContext, component);
        }
        if (this.myVerticalNotch != null) {
            this.myVerticalNotch.render(list, sceneContext, component);
        }
        if (this.myCircularNotch != null) {
            this.myCircularNotch.render(list, sceneContext, component);
        }
    }

    @Nullable
    public Target getSnappedHorizontalTarget() {
        return this.myHorizontalNotch == null ? null : this.myHorizontalNotch.myTarget;
    }

    @Nullable
    public Target getSnappedVerticalTarget() {
        return this.myVerticalNotch == null ? null : this.myVerticalNotch.myTarget;
    }

    public void clearSnappedNotches() {
        this.myHorizontalNotch = null;
        this.myVerticalNotch = null;
        this.myCircularNotch = null;
    }

    public void reset() {
        this.myNotchesForSnapping = ImmutableList.of();
        this.clearSnappedNotches();
    }

    public void setSources(int sourceMask) {
        this.myNotchesSourcesMask = sourceMask;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snappable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snappableComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/scene/target/TargetSnapper";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/TargetSnapper";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "trySnapHorizontal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "trySnapVertical";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "trySnapCircle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "gatherNotches";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "gatherNotchFromTargets";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyNotches";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "renderSnappedNotches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

