/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.uibuilder.scout.Connection;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class WidgetPossibleConnections {
    private ScoutWidget myWidget;
    public ArrayList<Connection> north;
    public ArrayList<Connection> south;
    public ArrayList<Connection> east;
    public ArrayList<Connection> west;
    public ArrayList<Connection> baseline;

    public WidgetPossibleConnections(ScoutWidget widget) {
        this.myWidget = widget;
        this.north = new ArrayList();
        this.south = new ArrayList();
        this.east = new ArrayList();
        this.west = new ArrayList();
        this.baseline = new ArrayList();
    }

    ScoutWidget getWidget() {
        return this.myWidget;
    }

    public ArrayList<Connection> getList(Direction dir) {
        switch (dir) {
            case TOP: {
                return this.north;
            }
            case LEFT: {
                return this.west;
            }
            case RIGHT: {
                return this.east;
            }
            case BOTTOM: {
                return this.south;
            }
            case BASELINE: {
                return this.baseline;
            }
        }
        return this.baseline;
    }

    public void generateAllConnections(ScoutWidget[] otherWidgets) {
        for (Direction anchor : Direction.getAllDirections()) {
            Connection tempConnection;
            if (this.myWidget.getAnchor(anchor).isConnected()) {
                ScoutWidget.Anchor existing = this.myWidget.getAnchor(anchor);
                ScoutWidget targetWidget = existing.getTarget().getOwner();
                int targetIndex = Arrays.asList(otherWidgets).indexOf(targetWidget) - 1;
                Direction destAnchor = existing.getTarget().myDirection;
                Connection preservedConnection = new Connection(targetIndex, anchor, destAnchor, targetWidget);
                this.getList(anchor).add(preservedConnection);
                continue;
            }
            for (int i = 1; i < otherWidgets.length; ++i) {
                ScoutWidget destWidget = otherWidgets[i];
                if (this.myWidget == destWidget || (anchor == Direction.LEFT || anchor == Direction.RIGHT) && destWidget.isHorizontalGuideline() || (anchor == Direction.TOP || anchor == Direction.BOTTOM) && destWidget.isVerticalGuideline() || anchor == Direction.BASELINE && destWidget.isGuideline()) continue;
                int baselineDiff = Math.abs(destWidget.getPos(anchor) - this.myWidget.getPos(anchor));
                if (anchor == Direction.BASELINE && baselineDiff > 15) continue;
                double distanceX = this.myWidget.getRectangle().getCenterX() - destWidget.getRectangle().getCenterX();
                double distanceY = this.myWidget.getRectangle().getCenterY() - destWidget.getRectangle().getCenterY();
                int originLine = this.myWidget.getPos(anchor);
                int destLine = destWidget.getPos(anchor);
                tempConnection = new Connection(i - 1, anchor, anchor, destWidget);
                tempConnection.setMargin(destLine - originLine);
                tempConnection.setDistanceX(distanceX);
                tempConnection.setDistanceY(distanceY);
                tempConnection.calculateCost();
                this.getList(anchor).add(tempConnection);
                if (anchor == Direction.BASELINE || destWidget.isGuideline()) continue;
                destLine = destWidget.getPos(anchor.getOpposite());
                tempConnection = new Connection(i - 1, anchor, anchor.getOpposite(), destWidget);
                tempConnection.setMargin(destLine - originLine);
                tempConnection.setDistanceX(distanceX);
                tempConnection.setDistanceY(distanceY);
                tempConnection.calculateCost();
                this.getList(anchor).add(tempConnection);
            }
            if (anchor != Direction.BASELINE) {
                ScoutWidget parent = otherWidgets[0];
                int originLine = this.myWidget.getPos(anchor);
                int destLine = parent.getPos(anchor);
                tempConnection = new Connection(-1, anchor, anchor, parent);
                tempConnection.setMargin(destLine - originLine);
                tempConnection.calculateCost();
                this.getList(anchor).add(tempConnection);
            }
            tempConnection = new Connection(-2, anchor, anchor, null);
            this.getList(anchor).add(tempConnection);
        }
        this.sortConnections();
    }

    void sortConnections() {
        Collections.sort(this.north, (a, b) -> b.compareTo((Connection)a));
        Collections.sort(this.south, (a, b) -> b.compareTo((Connection)a));
        Collections.sort(this.east, (a, b) -> b.compareTo((Connection)a));
        Collections.sort(this.west, (a, b) -> b.compareTo((Connection)a));
        Collections.sort(this.baseline, (a, b) -> b.compareTo((Connection)a));
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var5_18;
        void var4_12;
        void var3_6;
        String northS = "";
        for (Connection connection : this.north) {
            northS = northS + connection.toString();
            northS = northS + " ";
        }
        String southS = "";
        for (Connection connection : this.south) {
            southS = southS + connection.toString();
            southS = southS + " ";
        }
        String string = "";
        for (Connection connection : this.east) {
            String string3 = (String)var3_6 + connection.toString();
            string3 = string3 + " ";
        }
        String string4 = "";
        for (Connection connection : this.west) {
            String string6 = (String)var4_12 + connection.toString();
            string6 = string6 + " ";
        }
        String string7 = "";
        for (Connection conn : this.baseline) {
            String string9 = (String)var5_18 + conn.toString();
            string9 = string9 + " ";
        }
        String string10 = String.format("%s\nNORTH: %s\nSOUTH: %s\nEAST: %s\nWEST: %s\nBASELINE: %s\n", this.myWidget.toString(), northS, southS, var3_6, var4_12, var5_18);
        return string10;
    }
}

