/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentUtil;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NlDropInsertionPicker {
    private final JTree myTree;

    public NlDropInsertionPicker(@NotNull NlComponentTree tree) {
        if (tree == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(0);
        }
        this((JTree)((Object)tree));
    }

    NlDropInsertionPicker(@NotNull JTree tree) {
        if (tree == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(1);
        }
        this.myTree = tree;
    }

    @Nullable
    public Result findInsertionPointAt(@NotNull Point location, @NotNull List<NlComponent> dragged) {
        if (location == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(2);
        }
        if (dragged == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(3);
        }
        if (dragged.isEmpty()) {
            return this.findInsertionPointAt(location);
        }
        Result result2 = new Result();
        result2.receiver = null;
        result2.nextComponent = null;
        TreePath referencePath = this.myTree.getClosestPathForLocation(location.x, location.y);
        result2.row = this.myTree.getRowForPath(referencePath);
        if (referencePath == null) {
            return null;
        }
        result2.depth = 1;
        Object last = referencePath.getLastPathComponent();
        if (!(last instanceof NlComponent)) {
            return null;
        }
        NlComponent receiverComponent = (NlComponent)last;
        if (this.canChangeInsertionDepth(referencePath, receiverComponent)) {
            Rectangle referenceBounds;
            TreePath parentPath;
            while ((parentPath = referencePath.getParentPath()) != null && (referenceBounds = this.myTree.getPathBounds(referencePath)) != null && this.canSelectLowerDepth(result2.row, result2.depth) && location.x < referenceBounds.x) {
                --result2.depth;
                referencePath = parentPath;
            }
            receiverComponent = (NlComponent)referencePath.getLastPathComponent();
        }
        if (NlDropInsertionPicker.canAddComponent(receiverComponent.getModel(), receiverComponent, dragged)) {
            result2.receiver = receiverComponent;
            if (receiverComponent.getChildCount() != 0) {
                TreePath nextPath = this.myTree.getPathForRow(result2.row + 1);
                result2.nextComponent = nextPath == null ? null : (NlComponent)nextPath.getLastPathComponent();
            }
        } else {
            NlComponent parent = receiverComponent.getParent();
            --result2.depth;
            if (parent == null) {
                result2.receiver = receiverComponent;
            } else {
                result2.receiver = parent;
                result2.nextComponent = receiverComponent.getNextSibling();
                if (result2.depth <= 0) {
                    this.updateInsertionPointAfterLastDescendant(referencePath, result2);
                }
            }
            if (!NlDropInsertionPicker.canAddComponent(result2.receiver.getModel(), result2.receiver, dragged)) {
                result2.receiver = null;
                result2.nextComponent = null;
                return null;
            }
        }
        return result2;
    }

    private void updateInsertionPointAfterLastDescendant(@NotNull TreePath receiverPath, @NotNull Result result2) {
        TreePath currentPath;
        if (receiverPath == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(5);
        }
        TreePath lastDescendantPath = currentPath = receiverPath;
        int lastDesendantRow = result2.row;
        int currentDepth = result2.depth;
        Enumeration<TreePath> descendants = this.myTree.getExpandedDescendants(currentPath);
        while (descendants != null && descendants.hasMoreElements()) {
            do {
                lastDescendantPath = currentPath = descendants.nextElement();
                lastDesendantRow = Math.max(lastDesendantRow, this.myTree.getRowForPath(currentPath));
            } while (descendants.hasMoreElements());
            descendants = this.myTree.getExpandedDescendants(currentPath);
            --currentDepth;
        }
        result2.row = lastDesendantRow + this.myTree.getModel().getChildCount(lastDescendantPath.getLastPathComponent());
        result2.depth = currentDepth;
    }

    private Result findInsertionPointAt(@NotNull Point location) {
        if (location == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(6);
        }
        TreePath path = this.myTree.getSelectionPath();
        TreePath parent = path.getParentPath();
        TreePath referencePath = this.myTree.getClosestPathForLocation(location.x, location.y);
        Result result2 = new Result();
        result2.shouldDelegate = true;
        result2.receiver = (NlComponent)parent.getLastPathComponent();
        if (referencePath == parent) {
            result2.depth = 1;
            result2.row = this.myTree.getRowForPath(referencePath);
            return result2;
        }
        if (referencePath.getParentPath() == parent) {
            result2.depth = 0;
            result2.row = this.myTree.getRowForPath(referencePath);
            return result2;
        }
        return null;
    }

    private boolean canChangeInsertionDepth(@NotNull TreePath path, @NotNull NlComponent component) {
        if (path == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(7);
        }
        if (component == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(8);
        }
        return component.getNextSibling() == null && this.myTree.getExpandedDescendants(path) == null;
    }

    private static boolean canAddComponent(@NotNull NlModel model, @NotNull NlComponent receiver, @NotNull List<NlComponent> dragged) {
        if (model == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(9);
        }
        if (receiver == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(10);
        }
        if (dragged == null) {
            NlDropInsertionPicker.$$$reportNull$$$0(11);
        }
        return model.canAddComponents(dragged, receiver, receiver.getChild(0)) || NlComponentHelperKt.isMorphableToViewGroup(receiver) && !NlComponentUtil.isDescendant(receiver, dragged);
    }

    private boolean canSelectLowerDepth(int row, int relativeDepth) {
        return row == this.myTree.getRowCount() - 1 || relativeDepth > -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragged";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlDropInsertionPicker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findInsertionPointAt";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateInsertionPointAfterLastDescendant";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "canChangeInsertionDepth";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "canAddComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Result {
        NlComponent receiver;
        NlComponent nextComponent;
        int depth;
        int row;
        boolean shouldDelegate = false;
    }
}

