/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.SdkConstants;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlComponentUtil;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEvent;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.tools.idea.uibuilder.structure.NlDropInsertionPicker;
import com.android.tools.idea.uibuilder.structure.NlTreeUtil;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDropListener
extends DropTargetAdapter {
    private static final HashSet<String> ourCopyableAttributes = new HashSet(Arrays.asList("layout_width", "layout_height", "id", "background"));
    private final List<NlComponent> myDragged;
    private final NlComponentTree myTree;
    private DnDTransferItem myTransferItem;
    private NlComponent myDragReceiver;
    private NlComponent myNextDragSibling;
    private final NlDropInsertionPicker myInsertionPicker;

    public NlDropListener(@NotNull NlComponentTree tree) {
        if (tree == null) {
            NlDropListener.$$$reportNull$$$0(0);
        }
        this.myDragged = new ArrayList<NlComponent>();
        this.myTree = tree;
        this.myInsertionPicker = new NlDropInsertionPicker(tree);
    }

    @Override
    public void dragEnter(@NotNull DropTargetDragEvent dragEvent) {
        if (dragEvent == null) {
            NlDropListener.$$$reportNull$$$0(1);
        }
        NlDropEvent event = new NlDropEvent(dragEvent);
        this.captureDraggedComponents(event, true);
        this.updateInsertionPoint(event);
    }

    @Override
    public void dragOver(@NotNull DropTargetDragEvent dragEvent) {
        if (dragEvent == null) {
            NlDropListener.$$$reportNull$$$0(2);
        }
        NlDropEvent event = new NlDropEvent(dragEvent);
        this.updateInsertionPoint(event);
    }

    @Override
    public void dragExit(@NotNull DropTargetEvent event) {
        if (event == null) {
            NlDropListener.$$$reportNull$$$0(3);
        }
        this.myTree.clearInsertionPoint();
        this.clearDraggedComponents();
    }

    @Override
    public void drop(@NotNull DropTargetDropEvent dropEvent) {
        NlDropInsertionPicker.Result finderResult;
        if (dropEvent == null) {
            NlDropListener.$$$reportNull$$$0(4);
        }
        if ((finderResult = this.myInsertionPicker.findInsertionPointAt(dropEvent.getLocation(), this.myDragged)) != null) {
            if (finderResult.shouldDelegate) {
                DelegatedTreeEvent.Type type = DelegatedTreeEvent.Type.DROP;
                boolean eventHandled = NlTreeUtil.delegateEvent(type, this.myTree, finderResult.receiver, finderResult.row);
                if (eventHandled) {
                    dropEvent.acceptDrop(3);
                    dropEvent.dropComplete(true);
                }
            } else {
                NlDropEvent event = new NlDropEvent(dropEvent);
                InsertType insertType = this.captureDraggedComponents(event, false);
                this.myDragReceiver = finderResult.receiver;
                this.myNextDragSibling = finderResult.nextComponent;
                this.performDrop(dropEvent, insertType);
            }
        }
        this.myTree.clearInsertionPoint();
        this.clearDraggedComponents();
    }

    @Nullable
    private InsertType captureDraggedComponents(@NotNull NlDropEvent event, boolean isPreview) {
        if (event == null) {
            NlDropListener.$$$reportNull$$$0(5);
        }
        this.clearDraggedComponents();
        Scene scene = this.myTree.getScene();
        if (scene == null) {
            return null;
        }
        NlModel model = scene.getSceneManager().getModel();
        if (event.isDataFlavorSupported(ItemTransferable.DESIGNER_FLAVOR)) {
            try {
                this.myTransferItem = (DnDTransferItem)event.getTransferable().getTransferData(ItemTransferable.DESIGNER_FLAVOR);
                InsertType insertType = this.determineInsertType(event, isPreview);
                if (insertType.isMove()) {
                    this.myDragged.addAll(NlTreeUtil.keepOnlyAncestors(scene.getDesignSurface().getSelectionModel().getSelection()));
                } else {
                    this.myDragged.addAll(NlTreeUtil.keepOnlyAncestors(model.createComponents(this.myTransferItem, insertType, scene.getDesignSurface())));
                }
                return insertType;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
            }
        }
        return null;
    }

    @NotNull
    private InsertType determineInsertType(@NotNull NlDropEvent event, boolean isPreview) {
        NlModel model;
        if (event == null) {
            NlDropListener.$$$reportNull$$$0(6);
        }
        if ((model = this.myTree.getDesignerModel()) == null || this.myTransferItem == null) {
            InsertType insertType = InsertType.MOVE_INTO;
            if (insertType == null) {
                NlDropListener.$$$reportNull$$$0(7);
            }
            return insertType;
        }
        DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
        InsertType insertType = model.determineInsertType(dragType, this.myTransferItem, isPreview);
        if (insertType == null) {
            NlDropListener.$$$reportNull$$$0(8);
        }
        return insertType;
    }

    private void clearDraggedComponents() {
        this.myDragged.clear();
    }

    private void updateInsertionPoint(@NotNull NlDropEvent event) {
        NlDropInsertionPicker.Result result2;
        if (event == null) {
            NlDropListener.$$$reportNull$$$0(9);
        }
        if ((result2 = this.myInsertionPicker.findInsertionPointAt(event.getLocation(), this.myDragged)) == null) {
            this.myTree.clearInsertionPoint();
            event.reject();
        } else {
            this.myDragReceiver = result2.receiver;
            this.myNextDragSibling = result2.nextComponent;
            this.myTree.markInsertionPoint(result2.row, result2.depth);
            event.accept(this.determineInsertType(event, true) == InsertType.COPY ? event.getDropAction() : 1);
        }
    }

    private void performDrop(@NotNull DropTargetDropEvent event, InsertType insertType) {
        if (event == null) {
            NlDropListener.$$$reportNull$$$0(10);
        }
        this.myTree.skipNextUpdateDelay();
        NlModel model = this.myTree.getDesignerModel();
        assert (model != null);
        if (NlComponentHelperKt.isGroup(this.myDragReceiver) && model.canAddComponents(this.myDragged, this.myDragReceiver, this.myDragReceiver.getChild(0))) {
            this.performNormalDrop(event, insertType, model);
        } else if (!this.myDragReceiver.isRoot() && !NlComponentUtil.isDescendant(this.myDragReceiver, this.myDragged) && NlComponentHelperKt.isMorphableToViewGroup(this.myDragReceiver)) {
            this.morphReceiverIntoViewGroup();
            this.performNormalDrop(event, insertType, model);
        } else {
            ViewHandler handler = NlComponentHelperKt.getViewHandler(this.myDragReceiver);
            if (handler instanceof ViewGroupHandler) {
                ViewGroupHandler groupHandler = (ViewGroupHandler)handler;
                groupHandler.performDrop(model, event, this.myDragReceiver, this.myDragged, this.myNextDragSibling, insertType);
            }
        }
    }

    private void performNormalDrop(@NotNull DropTargetDropEvent event, @NotNull InsertType insertType, @NotNull NlModel model) {
        if (event == null) {
            NlDropListener.$$$reportNull$$$0(11);
        }
        if (insertType == null) {
            NlDropListener.$$$reportNull$$$0(12);
        }
        if (model == null) {
            NlDropListener.$$$reportNull$$$0(13);
        }
        try {
            Scene scene = this.myTree.getScene();
            DesignSurface surface = scene != null ? scene.getDesignSurface() : null;
            model.addComponents(this.myDragged, this.myDragReceiver, this.myNextDragSibling, insertType, surface);
            event.acceptDrop(insertType == InsertType.COPY ? event.getDropAction() : 1);
            event.dropComplete(true);
            model.notifyModified(NlModel.ChangeType.DROP);
            if (scene != null) {
                scene.getDesignSurface().getSelectionModel().setSelection(this.myDragged);
                this.myTree.requestFocus();
            }
        }
        catch (Exception exception) {
            Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
            event.rejectDrop();
        }
    }

    private void morphReceiverIntoViewGroup() {
        AttributesTransaction transaction = this.myDragReceiver.startAttributeTransaction();
        for (AttributeSnapshot attribute : this.myDragReceiver.getAttributes()) {
            if ("tools".equals(attribute.prefix) || ourCopyableAttributes.contains((Object)attribute.name) || attribute.namespace == null) continue;
            transaction.removeAttribute(attribute.namespace, attribute.name);
        }
        NlWriteCommandAction.run(this.myDragReceiver, "", () -> {
            XmlTag tag = this.myDragReceiver.getTag();
            tag.setName(DependencyManagementUtil.mapAndroidxName(ModuleUtilCore.findModuleForPsiElement((PsiElement)tag), SdkConstants.CONSTRAINT_LAYOUT));
            this.myDragReceiver.setTag(tag);
            transaction.commit();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragEvent";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dropEvent";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/structure/NlDropListener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlDropListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "determineInsertType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dragEnter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dragOver";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dragExit";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "captureDraggedComponents";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "determineInsertType";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateInsertionPoint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performDrop";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performNormalDrop";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

