/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockupLayer
extends Layer {
    private final ScreenView myScreenView;
    private Dimension myScreenViewSize = new Dimension();
    @Nullable
    private NlModel myNlModel;
    private List<Mockup> myMockups;

    public MockupLayer(ScreenView screenView) {
        assert (screenView != null);
        this.myScreenView = screenView;
        this.myScreenViewSize = this.myScreenView.getSize(this.myScreenViewSize);
        this.setNlModel(this.myScreenView.getModel());
        this.myMockups = Mockup.createAll(this.myNlModel);
    }

    public void setNlModel(@Nullable NlModel nlModel) {
        if (nlModel != null && nlModel != this.myNlModel) {
            nlModel.addListener(new ModelListener(){

                @Override
                public void modelDerivedDataChanged(@NotNull NlModel model) {
                    if (model == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MockupLayer.this.myMockups = Mockup.createAll(MockupLayer.this.myNlModel);
                }

                @Override
                public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
                    if (model == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "model";
                    objectArray2[1] = "com/android/tools/idea/uibuilder/surface/MockupLayer$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "modelDerivedDataChanged";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "modelChangedOnLayout";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        this.myNlModel = nlModel;
    }

    @Override
    public void paint(@NotNull Graphics2D g) {
        if (g == null) {
            MockupLayer.$$$reportNull$$$0(0);
        }
        if (!this.myScreenView.getSurface().isMockupVisible() || this.myMockups.isEmpty()) {
            return;
        }
        Composite composite = g.getComposite();
        this.myScreenViewSize = this.myScreenView.getSize(this.myScreenViewSize);
        for (int i = 0; i < this.myMockups.size(); ++i) {
            Mockup mockup = this.myMockups.get(i);
            this.paintMockup(g, mockup);
        }
        g.setComposite(composite);
    }

    private void paintMockup(@NotNull Graphics2D g, Mockup mockup) {
        BufferedImage image;
        if (g == null) {
            MockupLayer.$$$reportNull$$$0(1);
        }
        if ((image = mockup.getImage()) != null) {
            Rectangle dest = mockup.getScreenBounds(this.myScreenView);
            Rectangle src = mockup.getComputedCropping();
            g.setComposite(AlphaComposite.getInstance(3, mockup.getAlpha()));
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(image, dest.x, dest.y, dest.x + dest.width, dest.y + dest.height, src.x, src.y, src.x + src.width, src.y + src.height, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "g";
        objectArray2[1] = "com/android/tools/idea/uibuilder/surface/MockupLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "paintMockup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

