/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.api.ResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.ResizePolicy;
import com.android.tools.idea.uibuilder.model.SegmentType;
import com.android.tools.idea.uibuilder.model.SelectionHandle;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class ResizeInteraction
extends Interaction {
    private final SceneView mySceneView;
    private final NlComponent myComponent;
    private final SegmentType myHorizontalEdge;
    private final SegmentType myVerticalEdge;
    private ResizeHandler myResizeHandler;

    public ResizeInteraction(@NotNull SceneView sceneView, @NotNull SceneComponent component, @NotNull SelectionHandle handle) {
        if (sceneView == null) {
            ResizeInteraction.$$$reportNull$$$0(0);
        }
        if (component == null) {
            ResizeInteraction.$$$reportNull$$$0(1);
        }
        if (handle == null) {
            ResizeInteraction.$$$reportNull$$$0(2);
        }
        this.mySceneView = sceneView;
        this.myComponent = component.getNlComponent();
        this.myHorizontalEdge = handle.getHorizontalEdge();
        this.myVerticalEdge = handle.getVerticalEdge();
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int startMask) {
        ViewGroupHandler viewGroupHandler;
        super.begin(x, y, startMask);
        NlComponent parent = this.myComponent.getParent();
        if (parent != null && (viewGroupHandler = ViewHandlerManager.get(this.mySceneView.getModel().getFacet()).findLayoutHandler(parent, false)) != null) {
            ViewEditorImpl editor = new ViewEditorImpl(this.mySceneView);
            this.myResizeHandler = viewGroupHandler.createResizeHandler(editor, this.myComponent, this.myHorizontalEdge, this.myVerticalEdge);
            if (this.myResizeHandler != null) {
                int androidX = Coordinates.getAndroidX(this.mySceneView, this.myStartX);
                int androidY = Coordinates.getAndroidY(this.mySceneView, this.myStartY);
                this.myResizeHandler.start(androidX, androidY, startMask);
            }
        }
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        super.update(x, y, modifiers);
        this.moveTo(x, y, modifiers, false);
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean canceled) {
        super.end(x, y, modifiers, canceled);
        this.moveTo(x, y, modifiers, !canceled);
        if (!canceled) {
            this.mySceneView.getModel().notifyModified(NlModel.ChangeType.RESIZE_END);
        }
    }

    private void moveTo(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean commit) {
        if (this.myResizeHandler == null) {
            return;
        }
        int ax = Coordinates.getAndroidX(this.mySceneView, x);
        int ay = Coordinates.getAndroidY(this.mySceneView, y);
        int deltaX = Coordinates.getAndroidDimension(this.mySceneView, x - this.myStartX);
        int deltaY = Coordinates.getAndroidDimension(this.mySceneView, y - this.myStartY);
        Rectangle newBounds = this.getNewBounds(new Rectangle(NlComponentHelperKt.getX(this.myComponent), NlComponentHelperKt.getY(this.myComponent), NlComponentHelperKt.getW(this.myComponent), NlComponentHelperKt.getH(this.myComponent)), deltaX, deltaY);
        this.myResizeHandler.update(ax, ay, modifiers, newBounds);
        if (commit) {
            NlWriteCommandAction.run(this.myComponent, "Resize", () -> this.myResizeHandler.commit(ax, ay, modifiers, newBounds));
            this.mySceneView.getModel().notifyModified(NlModel.ChangeType.RESIZE_COMMIT);
        }
        this.mySceneView.getSurface().repaint();
    }

    private Rectangle getNewBounds(Rectangle b, int deltaX, int deltaY) {
        boolean isBottom;
        int x = b.x;
        int y = b.y;
        int w = b.width;
        int h = b.height;
        if (deltaX == 0 && deltaY == 0) {
            return b;
        }
        ResizePolicy mResizePolicy = ResizePolicy.full();
        boolean isLeft = this.myVerticalEdge == SegmentType.LEFT || this.myVerticalEdge == SegmentType.START;
        boolean isRight = this.myVerticalEdge == SegmentType.RIGHT || this.myVerticalEdge == SegmentType.END;
        boolean isTop = this.myHorizontalEdge == SegmentType.TOP;
        boolean bl = isBottom = this.myHorizontalEdge == SegmentType.BOTTOM;
        if (mResizePolicy.isAspectPreserving() && w != 0 && h != 0) {
            double aspectRatio = (double)w / (double)h;
            int newW = Math.abs(b.width + (isLeft ? -deltaX : deltaX));
            int newH = Math.abs(b.height + (isTop ? -deltaY : deltaY));
            double newAspectRatio = (double)newW / (double)newH;
            if (newH == 0 || newAspectRatio > aspectRatio) {
                deltaY = (int)((double)deltaX / aspectRatio);
            } else {
                deltaX = (int)((double)deltaY * aspectRatio);
            }
        }
        if (isLeft) {
            int nx1 = b.x + deltaX;
            int x2 = b.x + b.width;
            if (nx1 <= x2) {
                x = nx1;
                w = x2 - x;
            } else {
                w = 0;
                x = x2;
            }
        } else if (isRight) {
            int nx2 = b.x + b.width + deltaX;
            w = nx2 >= b.x ? nx2 - b.x : 0;
        } else assert (this.myVerticalEdge == null) : this.myVerticalEdge;
        if (isTop) {
            int ny1 = b.y + deltaY;
            int y2 = b.y + b.height;
            if (ny1 < y2) {
                y = ny1;
                h = y2 - y;
            } else {
                h = 0;
                y = y2;
            }
        } else if (isBottom) {
            int ny2 = b.y + b.height + deltaY;
            h = ny2 >= b.y ? ny2 - b.y : 0;
        } else assert (this.myHorizontalEdge == null) : this.myHorizontalEdge;
        return new Rectangle(x, y, w, h);
    }

    @Override
    public List<Layer> createOverlays() {
        return Collections.singletonList(new ResizeLayer());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sceneView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "handle";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/uibuilder/surface/ResizeInteraction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ResizeLayer
    extends Layer {
        @Override
        public void create() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void paint(@NotNull Graphics2D gc) {
            if (gc == null) {
                ResizeLayer.$$$reportNull$$$0(0);
            }
            if (ResizeInteraction.this.myResizeHandler != null) {
                ResizeInteraction.this.myResizeHandler.paint(new NlGraphics(gc, ResizeInteraction.this.mySceneView));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/surface/ResizeInteraction$ResizeLayer", "paint"));
        }
    }
}

