/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenViewLayer
extends Layer {
    public static final Map<RenderingHints.Key, Object> HQ_RENDERING_HINTS = ImmutableMap.of((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON, (Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY, (Object)RenderingHints.KEY_INTERPOLATION, (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    public static final int REQUEST_SCALE_DEBOUNCE_TIME_IN_MS = 300;
    private final ScreenView myScreenView;
    @Nullable
    private BufferedImage myScaledDownImage;
    @Nullable
    private RenderResult myLastRenderResult;
    private double myCachedScale;
    private final ScheduledExecutorService myScheduledExecutorService;
    private final RescaleRunnable myRescaleRunnable;
    @Nullable
    private ScheduledFuture<?> myScheduledFuture;
    private Rectangle mySizeRectangle;
    private Dimension myScreenViewSize;

    public ScreenViewLayer(@NotNull ScreenView screenView) {
        if (screenView == null) {
            ScreenViewLayer.$$$reportNull$$$0(0);
        }
        this(screenView, null);
    }

    ScreenViewLayer(@NotNull ScreenView screenView, @Nullable ScheduledExecutorService executor) {
        if (screenView == null) {
            ScreenViewLayer.$$$reportNull$$$0(1);
        }
        this.myRescaleRunnable = new RescaleRunnable();
        this.mySizeRectangle = new Rectangle();
        this.myScreenViewSize = new Dimension();
        this.myScreenView = screenView;
        this.myScheduledExecutorService = executor != null ? executor : Executors.newScheduledThreadPool(1);
        Disposer.register((Disposable)screenView.getSurface(), (Disposable)this);
    }

    @Override
    public void paint(@NotNull Graphics2D g) {
        double scale;
        if (g == null) {
            ScreenViewLayer.$$$reportNull$$$0(2);
        }
        this.myScreenViewSize = this.myScreenView.getSize(this.myScreenViewSize);
        this.mySizeRectangle.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        Rectangle2D.intersect(this.mySizeRectangle, g.getClipBounds(), this.mySizeRectangle);
        if (this.mySizeRectangle.isEmpty()) {
            return;
        }
        RenderResult renderResult = this.myScreenView.getResult();
        if (this.renderResultHasChanged(renderResult)) {
            this.myLastRenderResult = renderResult;
            this.myCachedScale = -1.0;
        }
        if (this.myLastRenderResult == null) {
            return;
        }
        Shape prevClip = null;
        Shape screenShape = this.myScreenView.getScreenShape();
        if (screenShape != null) {
            prevClip = g.getClip();
            g.clip(screenShape);
        }
        if ((scale = this.myScreenView.getScale()) != this.myCachedScale) {
            this.myCachedScale = scale;
            this.myScaledDownImage = null;
            if (this.myCachedScale < 1.0) {
                this.requestHighQualityScaledImage();
            }
        }
        RenderingHints hints = g.getRenderingHints();
        if (this.myScaledDownImage != null && this.myCachedScale < 1.0) {
            ScreenViewLayer.drawScaledDownImage(g, this.myScreenView.getX(), this.myScreenView.getY(), this.myScaledDownImage);
        } else {
            ScreenViewLayer.drawImage(g, this.myScreenView.getX(), this.myScreenView.getY(), this.myCachedScale, this.myLastRenderResult);
        }
        g.setRenderingHints(hints);
        if (prevClip != null) {
            g.setClip(prevClip);
        }
    }

    private static void drawScaledDownImage(@NotNull Graphics2D g, int x, int y, @NotNull BufferedImage scaledDownImage) {
        if (g == null) {
            ScreenViewLayer.$$$reportNull$$$0(3);
        }
        if (scaledDownImage == null) {
            ScreenViewLayer.$$$reportNull$$$0(4);
        }
        g.setRenderingHints(HQ_RENDERING_HINTS);
        UIUtil.drawImage((Graphics)g, (Image)scaledDownImage, (int)x, (int)y, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void drawImage(@NotNull Graphics2D g, int x, int y, double scale, @NotNull RenderResult renderResult) {
        void renderResult2;
        if (g == null) {
            ScreenViewLayer.$$$reportNull$$$0(5);
        }
        if (renderResult == null) {
            ScreenViewLayer.$$$reportNull$$$0(6);
        }
        g.setRenderingHints(HQ_RENDERING_HINTS);
        ImagePool.Image image = renderResult2.getRenderedImage();
        image.drawImageTo(g, x, y, (int)Math.round((double)image.getWidth() * scale), (int)Math.round((double)image.getHeight() * scale));
    }

    private boolean renderResultHasChanged(@Nullable RenderResult renderResult) {
        return renderResult != null && renderResult.hasImage() && renderResult != this.myLastRenderResult;
    }

    private void requestHighQualityScaledImage() {
        if (this.myScheduledFuture != null && !this.myScheduledFuture.isDone()) {
            this.myScheduledFuture.cancel(false);
        }
        try {
            this.myScheduledFuture = this.myScheduledExecutorService.schedule(this.myRescaleRunnable, 300L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            Logger.getInstance(ScreenViewLayer.class).warn((Throwable)e);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myLastRenderResult = null;
        this.myScheduledExecutorService.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static BufferedImage getRetinaScaledImage(@NotNull ImagePool.Image pooledImage, @Nullable GraphicsConfiguration gc, double scale, boolean bl) {
        BufferedImage original;
        if (pooledImage == null) {
            ScreenViewLayer.$$$reportNull$$$0(7);
        }
        if (scale > 1.01) {
            return null;
        }
        BufferedImage bufferedImage = original = gc != null ? pooledImage.getCopy(gc) : pooledImage.getCopy();
        if (original == null) {
            return null;
        }
        if (Math.abs(scale - 0.5) > 0.001) {
            void fastScaling;
            double retinaScale = 2.0 * scale;
            original = fastScaling != false ? ImageUtils.lowQualityFastScale((BufferedImage)original, (double)retinaScale, (double)retinaScale) : ImageUtils.scale((BufferedImage)original, (double)retinaScale, (double)retinaScale);
        }
        return ImageUtils.convertToRetina((BufferedImage)original);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scaledDownImage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderResult";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pooledImage";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ScreenViewLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "drawScaledDownImage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "drawImage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getRetinaScaledImage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class RescaleRunnable
    implements Runnable {
        @Nullable
        private final GraphicsConfiguration myGc = !GraphicsEnvironment.isHeadless() ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration() : null;

        private RescaleRunnable() {
        }

        @Override
        public void run() {
            this.scaleOriginalImage();
        }

        private void scaleOriginalImage() {
            ScreenViewLayer.this.myScaledDownImage = null;
            if (ScreenViewLayer.this.myLastRenderResult == null) {
                return;
            }
            ImagePool.Image image = ScreenViewLayer.this.myLastRenderResult.getRenderedImage();
            if (UIUtil.isRetina() && ImageUtils.supportsRetina()) {
                ScreenViewLayer.this.myScaledDownImage = ScreenViewLayer.getRetinaScaledImage(image, this.myGc, ScreenViewLayer.this.myCachedScale, false);
            }
            if (ScreenViewLayer.this.myScaledDownImage == null) {
                BufferedImage imageCopy = this.myGc != null ? image.getCopy(this.myGc) : image.getCopy();
                ScreenViewLayer.this.myScaledDownImage = ImageUtils.scale((BufferedImage)imageCopy, (double)ScreenViewLayer.this.myCachedScale);
            }
            UIUtil.invokeLaterIfNeeded(() -> ScreenViewLayer.this.myScreenView.getSurface().repaint());
        }
    }
}

