/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlSelectionModel;
import com.android.tools.idea.uibuilder.model.SelectionHandle;
import com.android.tools.idea.uibuilder.model.SelectionHandles;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

public class SelectionLayer
extends Layer {
    private final ScreenView myScreenView;

    public SelectionLayer(@NotNull ScreenView screenView) {
        if (screenView == null) {
            SelectionLayer.$$$reportNull$$$0(0);
        }
        this.myScreenView = screenView;
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        if (gc == null) {
            SelectionLayer.$$$reportNull$$$0(1);
        }
        NlSelectionModel model = this.myScreenView.getSelectionModel();
        for (NlComponent component : model.getSelection()) {
            if (component.isRoot() || !component.isShowing() || SelectionLayer.parentHandlingSelection(component)) continue;
            int x = Coordinates.getSwingX(this.myScreenView, NlComponentHelperKt.getX(component));
            int y = Coordinates.getSwingY(this.myScreenView, NlComponentHelperKt.getY(component));
            int w = Coordinates.getSwingDimension(this.myScreenView, NlComponentHelperKt.getW(component));
            int h = Coordinates.getSwingDimension(this.myScreenView, NlComponentHelperKt.getH(component));
            NlGraphics.drawRect(NlDrawingStyle.SELECTION, gc, x, y, w + 1, h + 1);
            SelectionHandles handles = model.getHandles(component);
            for (SelectionHandle handle : handles) {
                int sx = Coordinates.getSwingX(this.myScreenView, handle.getCenterX());
                int sy = Coordinates.getSwingY(this.myScreenView, handle.getCenterY());
                NlGraphics.drawFilledRect(NlDrawingStyle.SELECTION, gc, sx - 4, sy - 4, 8, 8);
            }
        }
    }

    private static boolean parentHandlingSelection(@NotNull NlComponent component) {
        ViewGroupHandler viewGroupHandler;
        NlComponent parent;
        if (component == null) {
            SelectionLayer.$$$reportNull$$$0(2);
        }
        if ((parent = component.getParent()) == null) {
            return false;
        }
        ViewInfo view = NlComponentHelperKt.getViewInfo(parent);
        if (view == null) {
            return false;
        }
        ViewHandler handler = NlComponentHelperKt.getViewHandler(parent);
        return handler != null && handler instanceof ViewGroupHandler && (viewGroupHandler = (ViewGroupHandler)handler).handlesPainting();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gc";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/surface/SelectionLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parentHandlingSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

