/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.Channel;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.help.StudioHelpManagerImpl;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.utils.HtmlBuilder;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AncestorListenerAdapter;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkUpdaterConfigurable
implements SearchableConfigurable {
    private SdkUpdaterConfigPanel myPanel;
    private Channel myCurrentChannel;
    private Runnable myChannelChangedCallback;
    private List<PackageOperation.StatusChangeListener> myListeners = Lists.newArrayList();

    @NotNull
    public String getId() {
        if ("AndroidSdkUpdater" == null) {
            SdkUpdaterConfigurable.$$$reportNull$$$0(0);
        }
        return "AndroidSdkUpdater";
    }

    @Nls
    public String getDisplayName() {
        return "Android SDK Updater";
    }

    @Nullable
    public String getHelpTopic() {
        return StudioHelpManagerImpl.STUDIO_HELP_PREFIX + "r/studio-ui/sdk-manager.html";
    }

    @Nullable
    public JComponent createComponent() {
        this.myChannelChangedCallback = new Runnable(){

            @Override
            public void run() {
                Channel channel = StudioSettingsController.getInstance().getChannel();
                if (SdkUpdaterConfigurable.this.myCurrentChannel == null) {
                    SdkUpdaterConfigurable.this.myCurrentChannel = channel;
                }
                if (!Objects.equal((Object)channel, (Object)SdkUpdaterConfigurable.this.myCurrentChannel)) {
                    SdkUpdaterConfigurable.this.myCurrentChannel = channel;
                    SdkUpdaterConfigurable.this.myPanel.refresh();
                }
            }
        };
        this.myPanel = new SdkUpdaterConfigPanel(this.myChannelChangedCallback, new StudioDownloader(), StudioSettingsController.getInstance(), this);
        JComponent component = this.myPanel.getComponent();
        component.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                SdkUpdaterConfigurable.this.myChannelChangedCallback.run();
            }
        });
        return this.myPanel.getComponent();
    }

    AndroidSdkHandler getSdkHandler() {
        return AndroidSdkHandler.getInstance((File)this.myPanel.getSelectedSdkLocation());
    }

    RepoManager getRepoManager() {
        return this.getSdkHandler().getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
    }

    public boolean isModified() {
        Configurable updatesConfigurable;
        if (this.myPanel.isModified()) {
            return true;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myPanel.getComponent());
        Settings data = (Settings)Settings.KEY.getData(dataContext);
        if (data != null && (updatesConfigurable = data.find("preferences.updates")) != null) {
            return updatesConfigurable.isModified();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void apply() throws ConfigurationException {
        this.myPanel.saveSources();
        HtmlBuilder message = new HtmlBuilder();
        message.openHtmlBody();
        ArrayList toDelete = Lists.newArrayList();
        HashMap requestedPackages = Maps.newHashMap();
        for (PackageNodeModel packageNodeModel : this.myPanel.getStates()) {
            if (packageNodeModel.getState() == PackageNodeModel.SelectedState.NOT_INSTALLED) {
                if (!packageNodeModel.getPkg().hasLocal()) continue;
                toDelete.add(packageNodeModel.getPkg().getLocal());
                continue;
            }
            if (packageNodeModel.getState() != PackageNodeModel.SelectedState.INSTALLED || !packageNodeModel.getPkg().isUpdate() && packageNodeModel.getPkg().hasLocal()) continue;
            UpdatablePackage pkg = packageNodeModel.getPkg();
            requestedPackages.put(pkg.getRemote(), pkg);
        }
        boolean found = false;
        if (!toDelete.isEmpty()) {
            found = true;
            message.add("The following components will be deleted: \n");
            message.beginList();
            for (LocalPackage item : toDelete) {
                message.listItem().add(item.getDisplayName()).add(", Revision: ").add(item.getVersion().toString());
            }
            message.endList();
        }
        if (!requestedPackages.isEmpty()) {
            found = true;
            message.add("The following components will be installed: \n");
            message.beginList();
            HashMultimap hashMultimap = HashMultimap.create();
            StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(this.getClass());
            RepositoryPackages packages = this.getRepoManager().getPackages();
            for (RemotePackage item : requestedPackages.keySet()) {
                List packageDependencies = InstallerUtil.computeRequiredPackages((Collection)ImmutableList.of((Object)item), (RepositoryPackages)packages, (ProgressIndicator)progress2);
                if (packageDependencies == null) {
                    Messages.showErrorDialog((Project)null, (String)("Unable to resolve dependencies for " + item.getDisplayName()), (String)"Dependency Error");
                    throw new ConfigurationException("Unable to resolve dependencies.");
                }
                for (RemotePackage dependency : packageDependencies) {
                    hashMultimap.put((Object)dependency, (Object)item);
                }
                message.listItem().add(String.format("%1$s %2$s %3$s", item.getDisplayName(), item.getTypeDetails() instanceof DetailsTypes.ApiDetailsType ? "revision" : "version", item.getVersion()));
            }
            for (RemotePackage dependency : hashMultimap.keySet()) {
                if (requestedPackages.containsKey(dependency)) continue;
                HashSet requests = Sets.newHashSet((Iterable)hashMultimap.get((Object)dependency));
                requests.remove(dependency);
                if (requests.isEmpty()) continue;
                message.listItem().add(dependency.getDisplayName()).add(" (Required by ");
                Iterator requestIterator = requests.iterator();
                message.add(((RemotePackage)requestIterator.next()).getDisplayName());
                while (requestIterator.hasNext()) {
                    message.add(", ").add(((RemotePackage)requestIterator.next()).getDisplayName());
                }
                message.add(")");
            }
            message.endList();
        }
        message.closeHtmlBody();
        if (found) {
            ModelWizardDialog modelWizardDialog;
            if (!SdkUpdaterConfigurable.confirmChange(message)) throw new ConfigurationException("Installation was canceled.");
            if (!(requestedPackages.isEmpty() && toDelete.isEmpty() || (modelWizardDialog = SdkQuickfixUtils.createDialogForPackages(this.myPanel.getComponent(), requestedPackages.values(), toDelete, true)) == null)) {
                modelWizardDialog.show();
                for (RemotePackage remotePackage : requestedPackages.keySet()) {
                    PackageOperation installer = this.getRepoManager().getInProgressInstallOperation((RepoPackage)remotePackage);
                    if (installer == null) continue;
                    PackageOperation.StatusChangeListener listener2 = (installer1, progress) -> this.myPanel.getComponent().repaint();
                    this.myListeners.add(listener2);
                    installer.registerStateChangeListener(listener2);
                }
            }
            this.myPanel.refresh();
            return;
        } else {
            this.myChannelChangedCallback.run();
        }
    }

    private static boolean confirmChange(HtmlBuilder message) {
        String[] options = new String[]{Messages.OK_BUTTON, Messages.CANCEL_BUTTON};
        Icon icon = AllIcons.General.Warning;
        return Messages.showIdeaMessageDialog(null, (String)message.getHtml(), (String)"Confirm Change", (String[])options, (int)0, (Icon)icon, null) == 0;
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/updater/configure/SdkUpdaterConfigurable", "getId"));
    }
}

