/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.support.AndroidxName;
import com.android.support.AndroidxNameUtils;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.DependencyManagementException;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a<\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00112\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\u0013\u001a\u00020\n2\b\b\u0002\u0010\u0014\u001a\u00020\nH\u0007\u001a\u0012\u0010\u0015\u001a\u00020\n*\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017\u001a\n\u0010\u0018\u001a\u00020\n*\u00020\u0011\u001a\n\u0010\u0019\u001a\u00020\n*\u00020\u0011\u001a\u0014\u0010\u001a\u001a\u00020\u0001*\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0001\u00a8\u0006\u001e"}, d2={"createAddDependencyMessage", "", "coordinates", "", "Lcom/android/ide/common/repository/GradleCoordinate;", "getExistingPlatformSupportLibraryVersion", "Lcom/android/ide/common/repository/GradleVersion;", "moduleSystem", "Lcom/android/tools/idea/projectsystem/AndroidModuleSystem;", "isPlatformSupportLibrary", "", "coordinate", "transformVersionIfNeeded", "userWantsToAdd", "project", "Lcom/intellij/openapi/project/Project;", "addDependencies", "Lcom/intellij/openapi/module/Module;", "promptUserBeforeAdding", "requestSync", "preferPreview", "dependsOn", "artifactId", "Lcom/android/tools/idea/projectsystem/GoogleMavenArtifactId;", "dependsOnAndroidx", "dependsOnOldSupportLib", "mapAndroidxName", "name", "Lcom/android/support/AndroidxName;", "mapGradleCoordinateToAndroidx", "intellij.android.core"})
@JvmName(name="DependencyManagementUtil")
public final class DependencyManagementUtil {
    public static final boolean dependsOn(@NotNull Module $receiver, @NotNull GoogleMavenArtifactId artifactId) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)artifactId), (String)"artifactId");
        try {
            GradleCoordinate coordinate = new GradleCoordinate(artifactId.getMavenGroupId(), artifactId.getMavenArtifactId(), "+");
            return ProjectSystemUtil.getModuleSystem($receiver).getResolvedDependency(coordinate) != null;
        }
        catch (DependencyManagementException e) {
            Logger.getInstance((String)$receiver.getClass().getName()).warn(e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean dependsOnAndroidx(@NotNull Module $receiver) {
        boolean bl;
        block4: {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Object $receiver$iv = (Object[])GoogleMavenArtifactId.values();
            Object object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                GoogleMavenArtifactId it = (GoogleMavenArtifactId)element$iv$iv;
                if (!StringsKt.startsWith$default((String)it.getMavenGroupId(), (String)"androidx", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                object = $receiver$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    GoogleMavenArtifactId it = (GoogleMavenArtifactId)((Object)element$iv);
                    if (!DependencyManagementUtil.dependsOn($receiver, it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean dependsOnOldSupportLib(@NotNull Module $receiver) {
        boolean bl;
        block4: {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Object $receiver$iv = (Object[])GoogleMavenArtifactId.values();
            Object object = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                GoogleMavenArtifactId it = (GoogleMavenArtifactId)element$iv$iv;
                if (!StringsKt.startsWith$default((String)it.getMavenGroupId(), (String)"com.android.support", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                object = $receiver$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    GoogleMavenArtifactId it = (GoogleMavenArtifactId)((Object)element$iv);
                    if (!DependencyManagementUtil.dependsOn($receiver, it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final String mapAndroidxName(@Nullable Module $receiver, @NotNull AndroidxName name) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Module module = $receiver;
        if (module == null) {
            String string2 = name.defaultName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name.defaultName()");
            return string2;
        }
        boolean dependsOnAndroidx = DependencyManagementUtil.dependsOnAndroidx(module);
        if (dependsOnAndroidx) {
            String string3 = name.newName();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name.newName()");
        } else {
            String string4 = name.oldName();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"name.oldName()");
        }
        return string;
    }

    @NotNull
    public static final String mapGradleCoordinateToAndroidx(@NotNull Module $receiver, @NotNull String coordinate) {
        String string;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)coordinate, (String)"coordinate");
        if ($receiver.isDisposed() || (charSequence = (CharSequence)coordinate).length() == 0) {
            return coordinate;
        }
        if (DependencyManagementUtil.dependsOnAndroidx($receiver)) {
            String string2 = AndroidxNameUtils.getCoordinateMapping((String)coordinate);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"AndroidxNameUtils.getCoordinateMapping(coordinate)");
        } else {
            string = coordinate;
        }
        return string;
    }

    @JvmOverloads
    @NotNull
    public static final List<GradleCoordinate> addDependencies(@NotNull Module $receiver, @NotNull List<GradleCoordinate> coordinates, boolean promptUserBeforeAdding, boolean requestSync, boolean preferPreview) {
        GradleCoordinate it;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(coordinates, (String)"coordinates");
        if (coordinates.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem($receiver);
        Iterable $receiver$iv = coordinates;
        HashSet<Pair> set$iv = new HashSet<Pair>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $receiver$iv) {
            it = (GradleCoordinate)e$iv;
            Pair key$iv = new Pair((Object)it.getGroupId(), (Object)it.getArtifactId());
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinctCoordinates = list$iv;
        List unavailableDependencies = new ArrayList();
        List versionedDependencies = new ArrayList();
        Iterable $receiver$iv2 = distinctCoordinates;
        for (Object element$iv : $receiver$iv2) {
            GradleCoordinate versionedCoordinate;
            GradleCoordinate gradleCoordinate;
            it = (GradleCoordinate)element$iv;
            if (preferPreview) {
                Project project = $receiver.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                gradleCoordinate = ProjectSystemUtil.getProjectSystem(project).getAvailableDependency(it, true);
            } else {
                Project project = $receiver.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                gradleCoordinate = ProjectSystemUtil.getProjectSystem(project).getAvailableDependency(it, false);
                if (gradleCoordinate == null) {
                    Project project2 = $receiver.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                    gradleCoordinate = versionedCoordinate = ProjectSystemUtil.getProjectSystem(project2).getAvailableDependency(it, true);
                }
            }
            if (versionedCoordinate == null) {
                unavailableDependencies.add(it);
                continue;
            }
            versionedDependencies.add(versionedCoordinate);
        }
        $receiver$iv2 = unavailableDependencies;
        if (!$receiver$iv2.isEmpty()) {
            return unavailableDependencies;
        }
        if (promptUserBeforeAdding) {
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            if (!DependencyManagementUtil.userWantsToAdd(project, distinctCoordinates)) {
                return distinctCoordinates;
            }
        }
        $receiver$iv2 = versionedDependencies;
        for (Object element$iv : $receiver$iv2) {
            it = (GradleCoordinate)element$iv;
            moduleSystem.registerDependency(DependencyManagementUtil.transformVersionIfNeeded(it, moduleSystem));
        }
        if (requestSync) {
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            ProjectSystemUtil.getSyncManager(project).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, true);
        }
        return CollectionsKt.emptyList();
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ List addDependencies$default(Module module, List list, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return DependencyManagementUtil.addDependencies(module, list, bl, bl2, bl3);
    }

    @JvmOverloads
    @NotNull
    public static final List<GradleCoordinate> addDependencies(@NotNull Module $receiver, @NotNull List<GradleCoordinate> coordinates, boolean promptUserBeforeAdding, boolean requestSync) {
        return DependencyManagementUtil.addDependencies$default($receiver, coordinates, promptUserBeforeAdding, requestSync, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public static final List<GradleCoordinate> addDependencies(@NotNull Module $receiver, @NotNull List<GradleCoordinate> coordinates, boolean promptUserBeforeAdding) {
        return DependencyManagementUtil.addDependencies$default($receiver, coordinates, promptUserBeforeAdding, false, false, 12, null);
    }

    private static final GradleCoordinate transformVersionIfNeeded(GradleCoordinate coordinate, AndroidModuleSystem moduleSystem) {
        if (!DependencyManagementUtil.isPlatformSupportLibrary(coordinate)) {
            return coordinate;
        }
        GradleVersion gradleVersion = DependencyManagementUtil.getExistingPlatformSupportLibraryVersion(moduleSystem);
        if (gradleVersion == null) {
            return coordinate;
        }
        GradleVersion version2 = gradleVersion;
        String coordinateString = "" + coordinate.getGroupId() + ':' + coordinate.getArtifactId() + ':' + version2;
        GradleCoordinate gradleCoordinate = GradleCoordinate.parseCoordinateString((String)coordinateString);
        if (gradleCoordinate == null) {
            throw (Throwable)new RuntimeException("Could not parse gradle coordinate string " + coordinateString);
        }
        return gradleCoordinate;
    }

    private static final boolean isPlatformSupportLibrary(GradleCoordinate coordinate) {
        GoogleMavenArtifactId googleMavenArtifactId = GoogleMavenArtifactId.Companion.forCoordinate(coordinate);
        return googleMavenArtifactId != null ? googleMavenArtifactId.isPlatformSupportLibrary() : false;
    }

    private static final GradleVersion getExistingPlatformSupportLibraryVersion(AndroidModuleSystem moduleSystem) {
        return (GradleVersion)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])((Object[])GoogleMavenArtifactId.values())), (Function1)getExistingPlatformSupportLibraryVersion.1.INSTANCE), (Function1)((Function1)new Function1<GoogleMavenArtifactId, GradleCoordinate>(moduleSystem){
            final /* synthetic */ AndroidModuleSystem $moduleSystem;

            @Nullable
            public final GradleCoordinate invoke(@NotNull GoogleMavenArtifactId it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return this.$moduleSystem.getRegisteredDependency(it.getCoordinate("+"));
            }
            {
                this.$moduleSystem = androidModuleSystem;
                super(1);
            }
        })), (Function1)getExistingPlatformSupportLibraryVersion.3.INSTANCE));
    }

    private static final boolean userWantsToAdd(Project project, List<GradleCoordinate> coordinates) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return true;
        }
        return Messages.showOkCancelDialog((Project)project, (String)DependencyManagementUtil.createAddDependencyMessage(coordinates), (String)"Add Project Dependency", (Icon)Messages.getErrorIcon()) == 0;
    }

    @NotNull
    public static final String createAddDependencyMessage(@NotNull List<GradleCoordinate> coordinates) {
        Intrinsics.checkParameterIsNotNull(coordinates, (String)"coordinates");
        String libraryNames2 = CollectionsKt.joinToString$default((Iterable)coordinates, (CharSequence)", ", null, null, (int)0, null, (Function1)createAddDependencyMessage.libraryNames.1.INSTANCE, (int)30, null);
        return "This operation requires the " + StringUtil.pluralize((String)"library", (int)coordinates.size()) + ' ' + libraryNames2 + ". \n\n" + "Would you like to add " + StringUtil.pluralize((String)"this", (int)coordinates.size()) + " now?";
    }
}

