/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.tools.idea.npw.importing.ImportUIUtil;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.SdkManagerProgressIndicatorIntegration;
import com.android.tools.idea.welcome.install.WizardException;
import com.google.common.collect.Lists;
import com.intellij.execution.ui.ConsoleViewContentType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallComponentsOperation
extends InstallOperation<File, File> {
    @NotNull
    private final ComponentInstaller myComponentInstaller;
    @NotNull
    private Collection<? extends InstallableComponent> myComponents;

    public InstallComponentsOperation(@NotNull InstallContext context, @NotNull Collection<? extends InstallableComponent> components, @NotNull ComponentInstaller componentInstaller, double progressRatio) {
        if (context == null) {
            InstallComponentsOperation.$$$reportNull$$$0(0);
        }
        if (components == null) {
            InstallComponentsOperation.$$$reportNull$$$0(1);
        }
        if (componentInstaller == null) {
            InstallComponentsOperation.$$$reportNull$$$0(2);
        }
        super(context, progressRatio);
        this.myComponentInstaller = componentInstaller;
        this.myComponents = components;
    }

    @Nullable
    private static String getRetryMessage(Collection<RemotePackage> packages) {
        if (!packages.isEmpty()) {
            ArrayList descriptions = Lists.newArrayList();
            for (RemotePackage p : packages) {
                descriptions.add(p.getDisplayName());
            }
            return ImportUIUtil.formatElementListString(descriptions, "The following SDK component was not installed: %s", "The following SDK components were not installed: %1$s and %2$s", "%1$s and %2$s more SDK components were not installed");
        }
        return null;
    }

    @Override
    @NotNull
    protected File perform(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator, @NotNull File sdkLocation) throws WizardException {
        List<RemotePackage> packages;
        if (indicator == null) {
            InstallComponentsOperation.$$$reportNull$$$0(3);
        }
        if (sdkLocation == null) {
            InstallComponentsOperation.$$$reportNull$$$0(4);
        }
        indicator.setText("Checking for updated SDK components");
        try {
            packages = this.myComponentInstaller.getPackagesToInstall(this.myComponents);
        }
        catch (SdkQuickfixUtils.PackageResolutionException e) {
            throw new WizardException("Failed to determine required packages", e);
        }
        while (!packages.isEmpty()) {
            indicator.setFraction(0.0);
            SdkManagerProgressIndicatorIntegration logger = new SdkManagerProgressIndicatorIntegration(indicator, this.myContext);
            this.myComponentInstaller.installPackages(packages, new StudioDownloader(), (ProgressIndicator)logger);
            try {
                packages = this.myComponentInstaller.getPackagesToInstall(this.myComponents);
            }
            catch (SdkQuickfixUtils.PackageResolutionException e) {
                throw new WizardException("Failed to determine required packages", e);
            }
            String message = InstallComponentsOperation.getRetryMessage(packages);
            if (message == null) continue;
            this.promptToRetry(message, logger.getErrors(), null);
        }
        this.myContext.print("Android SDK is up to date.\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        indicator.setFraction(1.0);
        File file = sdkLocation;
        if (file == null) {
            InstallComponentsOperation.$$$reportNull$$$0(5);
        }
        return file;
    }

    @Override
    public void cleanup(@NotNull File result2) {
        if (result2 == null) {
            InstallComponentsOperation.$$$reportNull$$$0(6);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentInstaller";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkLocation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/install/InstallComponentsOperation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/install/InstallComponentsOperation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

