/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WelcomeFrameProvider;
import com.intellij.openapi.wm.WelcomeScreenProvider;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Rectangle;
import org.jetbrains.annotations.Nullable;

public class FirstRunWizardFrameProvider
implements WelcomeFrameProvider {
    public IdeFrame createFrame() {
        for (WelcomeScreenProvider provider : (WelcomeScreenProvider[])WelcomeScreenProvider.EP_NAME.getExtensions()) {
            if (!(provider instanceof AndroidStudioWelcomeScreenProvider) || !provider.isAvailable()) continue;
            return new WelcomeFrame();
        }
        return this.customizeFlatWelcomeFrame();
    }

    @Nullable
    private IdeFrame customizeFlatWelcomeFrame() {
        for (WelcomeFrameProvider provider : (WelcomeFrameProvider[])WelcomeFrame.EP.getExtensions()) {
            IdeFrame frame;
            if (provider == this || (frame = provider.createFrame()) == null) continue;
            if (frame instanceof FlatWelcomeFrame) {
                FlatWelcomeFrame welcomeFrame = (FlatWelcomeFrame)frame;
                UiNotifyConnector.doWhenFirstShown((Component)welcomeFrame, () -> {
                    Logger.getInstance(this.getClass()).info("Overriding welcome frame to be resizable");
                    welcomeFrame.setResizable(true);
                    Rectangle newBounds = welcomeFrame.getBounds();
                    ScreenUtil.fitToScreen((Rectangle)newBounds);
                    welcomeFrame.setBounds(newBounds);
                });
            }
            return frame;
        }
        return null;
    }
}

