/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.sdklib.devices.Storage;
import com.intellij.openapi.util.text.StringUtil;
import java.math.RoundingMode;
import java.text.NumberFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WelcomeUIUtils {
    private WelcomeUIUtils() {
    }

    public static String getSizeLabel(long size) {
        Storage.Unit[] values2 = Storage.Unit.values();
        Storage.Unit unit = values2[values2.length - 1];
        for (int i = values2.length - 2; unit.getNumberOfBytes() > size && i >= 0; --i) {
            unit = values2[i];
        }
        double space = (double)size * 1.0 / (double)unit.getNumberOfBytes();
        String formatted = WelcomeUIUtils.roundToNumberOfDigits(space, 3);
        return String.format("%s %s", formatted, unit.getDisplayValue());
    }

    private static String roundToNumberOfDigits(double number, int maxDigits) {
        int digits;
        int multiplier = 1;
        for (digits = maxDigits; digits > 0 && number > (double)multiplier; --digits) {
            multiplier *= 10;
        }
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setGroupingUsed(false);
        numberInstance.setRoundingMode(RoundingMode.HALF_UP);
        numberInstance.setMaximumFractionDigits(digits);
        return numberInstance.format(number);
    }

    public static String getMessageWithDetails(@NotNull String message, @Nullable String details) {
        if (message == null) {
            WelcomeUIUtils.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces((String)details)) {
            return message + ".";
        }
        String dotIfNeeded = details.trim().endsWith(".") ? "" : ".";
        return message + ": " + details + dotIfNeeded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/welcome/wizard/WelcomeUIUtils", "getMessageWithDetails"));
    }
}

