/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.whatsnew.assistant;

import com.android.repository.Revision;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.tools.idea.whatsnew.assistant.WhatsNewAssistantBundleCreator;
import com.android.tools.idea.whatsnew.assistant.WhatsNewAssistantSidePanelAction;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.WhatsNewAssistantEvent;
import com.intellij.ide.TipOfTheDayManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.xmlb.annotations.Tag;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhatsNewStartupActivity
implements StartupActivity,
DumbAware {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            WhatsNewStartupActivity.$$$reportNull$$$0(0);
        }
        if (!WhatsNewAssistantBundleCreator.shouldShowReleaseNotes() || !((Boolean)StudioFlags.WHATS_NEW_ASSISTANT_AUTO_SHOW.get()).booleanValue()) {
            return;
        }
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            return;
        }
        WhatsNewService service = (WhatsNewService)ServiceManager.getService(WhatsNewService.class);
        if (service == null) {
            return;
        }
        WhatsNewData data = service.getState();
        if (GuiTestingService.getInstance().isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Revision applicationRevision = Revision.parseRevision((String)ApplicationInfo.getInstance().getStrictVersion());
        if (this.shouldShowMessage(data, applicationRevision)) {
            WhatsNewStartupActivity.disableTipOfTheDay();
            this.openWhatsNewAssistant(project);
        }
    }

    private void openWhatsNewAssistant(final @NotNull Project project) {
        if (project == null) {
            WhatsNewStartupActivity.$$$reportNull$$$0(1);
        }
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.WHATS_NEW_ASSISTANT_EVENT).setWhatsNewAssistantEvent(WhatsNewAssistantEvent.newBuilder().setType(WhatsNewAssistantEvent.WhatsNewAssistantEventType.AUTO_OPEN)));
        new WhatsNewAssistantSidePanelAction().actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)new DataContext(){

            @Nullable
            public Object getData(String dataId) {
                if (dataId.equalsIgnoreCase(CommonDataKeys.PROJECT.getName())) {
                    return project;
                }
                return null;
            }
        }));
    }

    private static void disableTipOfTheDay() {
        TipOfTheDayManager tips = (TipOfTheDayManager)Extensions.findExtension((ExtensionPointName)StartupActivity.POST_STARTUP_ACTIVITY, TipOfTheDayManager.class);
        try {
            Field flag = TipOfTheDayManager.class.getDeclaredField("myVeryFirstProjectOpening");
            flag.setAccessible(true);
            flag.setBoolean(tips, false);
            flag.setAccessible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean shouldShowMessage(@NotNull WhatsNewData data, @NotNull Revision applicationRevision) {
        if (data == null) {
            WhatsNewStartupActivity.$$$reportNull$$$0(2);
        }
        if (applicationRevision == null) {
            WhatsNewStartupActivity.$$$reportNull$$$0(3);
        }
        String seenRevisionStr = data.myRevision;
        Revision seenRevision = null;
        if (seenRevisionStr != null) {
            try {
                seenRevision = Revision.parseRevision((String)seenRevisionStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (seenRevision == null || applicationRevision.compareTo(seenRevision, Revision.PreviewComparison.ASCENDING) > 0) {
            data.myRevision = applicationRevision.toString();
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationRevision";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/whatsnew/assistant/WhatsNewStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "openWhatsNewAssistant";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldShowMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class WhatsNewData {
        @Tag(value="shownVersion")
        public String myRevision;
    }

    @State(name="whatsNew", storages={@Storage(value="androidStudioFirstRun.xml")})
    public static class WhatsNewService
    implements PersistentStateComponent<WhatsNewData> {
        private WhatsNewData myData;

        @NotNull
        public WhatsNewData getState() {
            if (this.myData == null) {
                this.myData = new WhatsNewData();
            }
            WhatsNewData whatsNewData = this.myData;
            if (whatsNewData == null) {
                WhatsNewService.$$$reportNull$$$0(0);
            }
            return whatsNewData;
        }

        public void loadState(WhatsNewData state) {
            this.myData = state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/whatsnew/assistant/WhatsNewStartupActivity$WhatsNewService", "getState"));
        }
    }
}

