/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.nativeSymbolizer;

import com.android.tools.nativeSymbolizer.NativeSymbolizer;
import com.android.tools.nativeSymbolizer.NativeSymbolizerKt;
import com.android.tools.nativeSymbolizer.Symbol;
import com.android.tools.nativeSymbolizer.SymbolFilesLocator;
import com.intellij.openapi.Disposable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u00020\fH\u0002J \u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/nativeSymbolizer/LlvmSymbolizer;", "Lcom/android/tools/nativeSymbolizer/NativeSymbolizer;", "symbolizerExe", "", "symLocator", "Lcom/android/tools/nativeSymbolizer/SymbolFilesLocator;", "timeoutMsc", "", "(Ljava/lang/String;Lcom/android/tools/nativeSymbolizer/SymbolFilesLocator;J)V", "executor", "Ljava/util/concurrent/ExecutorService;", "procHolder", "Lcom/android/tools/nativeSymbolizer/LlvmSymbolizer$ProcessHolder;", "formatRequest", "symFile", "Ljava/io/File;", "offset", "getProcHolder", "parseResponse", "Lcom/android/tools/nativeSymbolizer/Symbol;", "response", "", "module", "start", "", "stop", "symbolize", "abiArch", "ProcessHolder", "native-symbolizer"})
public final class LlvmSymbolizer
implements NativeSymbolizer {
    private ProcessHolder procHolder;
    private final ExecutorService executor;
    private final String symbolizerExe;
    private final SymbolFilesLocator symLocator;
    private final long timeoutMsc;

    @Override
    @Nullable
    public Symbol symbolize(@NotNull String abiArch, @NotNull String module, long offset) {
        Intrinsics.checkParameterIsNotNull((Object)abiArch, (String)"abiArch");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        List<File> symFiles = this.symLocator.findSymbolFiles(abiArch, module);
        for (File symFile : symFiles) {
            List response;
            String request = this.formatRequest(symFile, offset);
            ProcessHolder holder = this.getProcHolder();
            Future future2 = this.executor.submit((Callable)new Callable<List<? extends String>>(holder, request){
                final /* synthetic */ ProcessHolder $holder;
                final /* synthetic */ String $request;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<String> call() {
                    void var1_1;
                    CharSequence charSequence;
                    String responseLine;
                    this.$holder.getStdin().write(this.$request);
                    this.$holder.getStdin().flush();
                    List response = new ArrayList<E>();
                    while ((responseLine = this.$holder.getStdout().readLine()) != null && !((charSequence = (CharSequence)responseLine).length() == 0)) {
                        response.add(responseLine);
                    }
                    return var1_1;
                }
                {
                    this.$holder = processHolder;
                    this.$request = string;
                }
            });
            try {
                Object t = future2.get(this.timeoutMsc, TimeUnit.MILLISECONDS);
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"future.get(timeoutMsc, TimeUnit.MILLISECONDS)");
                response = (List)t;
            }
            catch (TimeoutException e) {
                NativeSymbolizerKt.getLogger().warn("llvm-symbolizer timed out", (Throwable)e);
                this.stop();
                continue;
            }
            catch (ExecutionException e) {
                NativeSymbolizerKt.getLogger().warn("llvm-symbolizer communication failed", (Throwable)e);
                this.stop();
                continue;
            }
            Symbol result2 = this.parseResponse(response, module);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    private final ProcessHolder getProcHolder() {
        ProcessHolder holder = this.procHolder;
        if (holder == null || !holder.getProcess().isAlive()) {
            this.start();
            ProcessHolder processHolder = this.procHolder;
            if (processHolder == null) {
                Intrinsics.throwNpe();
            }
            holder = processHolder;
        }
        return holder;
    }

    private final String formatRequest(File symFile, long offset) {
        String string = symFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"symFile.path");
        String escapedPath = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
        String string2 = String.format("\"%s\" 0x%x\n", escapedPath, offset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(\u2026\\n\", escapedPath, offset)");
        return string2;
    }

    private final Symbol parseResponse(List<String> response, String module) {
        String string;
        if (response.isEmpty()) {
            return null;
        }
        CharSequence charSequence = (String)CollectionsKt.first(response);
        String string2 = charSequence;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String name = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        charSequence = name;
        if (charSequence.length() == 0 || Intrinsics.areEqual((Object)name, (Object)"??")) {
            return null;
        }
        if (response.size() < 2) {
            return new Symbol(name, module, null, 0, 12, null);
        }
        String string3 = string = response.get(1);
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String locationLine = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        int indexBeforeColumn = StringsKt.lastIndexOf$default((CharSequence)locationLine, (char)':', (int)0, (boolean)false, (int)6, null);
        if (indexBeforeColumn < 2) {
            return new Symbol(name, module, null, 0, 12, null);
        }
        int indexBeforeLine = StringsKt.lastIndexOf$default((CharSequence)locationLine, (char)':', (int)(indexBeforeColumn - 1), (boolean)false, (int)4, null);
        if (indexBeforeColumn < 1) {
            return new Symbol(name, module, null, 0, 12, null);
        }
        String string4 = locationLine;
        int n = 0;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n, indexBeforeLine);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String sourceFile = string6;
        String string7 = locationLine;
        int n2 = indexBeforeLine + 1;
        String string8 = string7;
        if (string8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string9 = string8.substring(n2, indexBeforeColumn);
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        Integer n3 = StringsKt.toIntOrNull((String)string9);
        int lineNumber = n3 != null ? n3 : 0;
        return new Symbol(name, module, sourceFile, lineNumber);
    }

    private final void start() {
        Process process;
        if (this.procHolder != null) {
            this.stop();
        }
        ProcessBuilder builder = new ProcessBuilder(this.symbolizerExe);
        Process process2 = process = builder.start();
        Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"process");
        if (!process2.isAlive()) {
            throw (Throwable)new IOException("Symbolizer process is not alive. Executable: " + this.symbolizerExe);
        }
        OutputStreamWriter stdin = new OutputStreamWriter(process.getOutputStream(), Charsets.UTF_8);
        BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream(), Charsets.UTF_8));
        this.procHolder = new ProcessHolder(process, stdout, stdin);
    }

    @Override
    public void stop() {
        ProcessHolder processHolder = this.procHolder;
        if (processHolder != null) {
            processHolder.dispose();
        }
        this.procHolder = null;
    }

    public LlvmSymbolizer(@NotNull String symbolizerExe, @NotNull SymbolFilesLocator symLocator, long timeoutMsc) {
        Intrinsics.checkParameterIsNotNull((Object)symbolizerExe, (String)"symbolizerExe");
        Intrinsics.checkParameterIsNotNull((Object)symLocator, (String)"symLocator");
        this.symbolizerExe = symbolizerExe;
        this.symLocator = symLocator;
        this.timeoutMsc = timeoutMsc;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
        this.executor = executorService;
    }

    public /* synthetic */ LlvmSymbolizer(String string, SymbolFilesLocator symbolFilesLocator, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = 5000L;
        }
        this(string, symbolFilesLocator, l);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/nativeSymbolizer/LlvmSymbolizer$ProcessHolder;", "Lcom/intellij/openapi/Disposable;", "process", "Ljava/lang/Process;", "stdout", "Ljava/io/BufferedReader;", "stdin", "Ljava/io/OutputStreamWriter;", "(Ljava/lang/Process;Ljava/io/BufferedReader;Ljava/io/OutputStreamWriter;)V", "getProcess", "()Ljava/lang/Process;", "getStdin", "()Ljava/io/OutputStreamWriter;", "getStdout", "()Ljava/io/BufferedReader;", "dispose", "", "native-symbolizer"})
    private static final class ProcessHolder
    implements Disposable {
        @NotNull
        private final Process process;
        @NotNull
        private final BufferedReader stdout;
        @NotNull
        private final OutputStreamWriter stdin;

        public void dispose() {
            this.process.destroy();
        }

        @NotNull
        public final Process getProcess() {
            return this.process;
        }

        @NotNull
        public final BufferedReader getStdout() {
            return this.stdout;
        }

        @NotNull
        public final OutputStreamWriter getStdin() {
            return this.stdin;
        }

        public ProcessHolder(@NotNull Process process, @NotNull BufferedReader stdout, @NotNull OutputStreamWriter stdin) {
            Intrinsics.checkParameterIsNotNull((Object)process, (String)"process");
            Intrinsics.checkParameterIsNotNull((Object)stdout, (String)"stdout");
            Intrinsics.checkParameterIsNotNull((Object)stdin, (String)"stdin");
            this.process = process;
            this.stdout = stdout;
            this.stdin = stdin;
        }
    }
}

