/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.nativeSymbolizer;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.NdkVariant;
import com.android.tools.nativeSymbolizer.SymbolFilesLocatorKt;
import com.android.utils.FileUtils;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"getArchToSymDirsMap", "", "", "", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "getModuleSymbolsDirs", "", "module", "Lcom/intellij/openapi/module/Module;", "abi", "Lcom/android/sdklib/devices/Abi;", "native-symbolizer"})
public final class SymbolFilesLocatorKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Set<File>> getArchToSymDirsMap(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Map result2 = new HashMap();
        Function1 symbolDirFilter2 = getArchToSymDirsMap.symbolDirFilter.1.INSTANCE;
        List allSupportedAbis = CollectionsKt.listOf((Object[])new Abi[]{Abi.X86, Abi.X86_64, Abi.ARM64_V8A, Abi.ARMEABI, Abi.ARMEABI_V7A});
        for (Abi abi : allSupportedAbis) {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            Module[] moduleArray = moduleManager.getModules();
            int n = moduleArray.length;
            for (int i = 0; i < n; ++i) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Module module;
                Module module2 = module = moduleArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
                Iterable iterable = $receiver$iv = (Iterable)SymbolFilesLocatorKt.getModuleSymbolsDirs(module2, abi);
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!((Boolean)symbolDirFilter2.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List symDirs = (List)destination$iv$iv;
                Set existingDirs2 = (Set)result2.computeIfAbsent(abi.getCpuArch(), getArchToSymDirsMap.existingDirs.1.INSTANCE);
                existingDirs2.addAll(symDirs);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<File> getModuleSymbolsDirs(Module module, Abi abi) {
        AndroidModuleModel androidModel;
        Iterable $receiver$iv$iv;
        Collection destination$iv$iv;
        NdkModuleModel ndkModuleModel;
        File file;
        Collection collection;
        Iterable $receiver$iv$iv2;
        Collection destination$iv$iv2;
        LinkedHashSet symDirs = Sets.newLinkedHashSet();
        String abiName = abi.toString();
        ApkFacet apkFacet = ApkFacet.getInstance(module);
        if (apkFacet != null) {
            void $receiver$iv;
            Collection<String> collection2 = ((ApkFacetConfiguration)apkFacet.getConfiguration()).getDebugSymbolFolderPaths(CollectionsKt.listOf((Object)abi));
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"apkFacet.configuration.g\u2026lFolderPaths(listOf(abi))");
            Iterable iterable = collection2;
            void var7_6 = $receiver$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Iterator item$iv$iv : $receiver$iv$iv2) {
                void it;
                String string = (String)((Object)item$iv$iv);
                collection = destination$iv$iv2;
                file = new File(FileUtils.toSystemDependentPath((String)it));
                collection.add(file);
            }
            List dirs = (List)destination$iv$iv2;
            symDirs.addAll(dirs);
        }
        if ((ndkModuleModel = NdkModuleModel.get(module)) != null) {
            NativeArtifact it;
            Iterable $receiver$iv;
            NdkVariant ndkVariant = ndkModuleModel.getSelectedVariant();
            Intrinsics.checkExpressionValueIsNotNull((Object)ndkVariant, (String)"ndkModuleModel.selectedVariant");
            Collection<NativeArtifact> collection3 = ndkVariant.getArtifacts();
            Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"ndkModuleModel.selectedVariant.artifacts");
            $receiver$iv$iv2 = collection3;
            destination$iv$iv2 = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                NativeArtifact nativeArtifact = it = (NativeArtifact)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)nativeArtifact, (String)"it");
                if (!Intrinsics.areEqual((Object)nativeArtifact.getAbi(), (Object)abiName)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (NativeArtifact)item$iv$iv;
                collection = destination$iv$iv;
                NativeArtifact nativeArtifact = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)nativeArtifact, (String)"it");
                File file2 = nativeArtifact.getOutputFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.outputFile");
                file = file2.getParentFile();
                collection.add(file);
            }
            List dirs = (List)destination$iv$iv;
            symDirs.addAll(dirs);
        }
        if ((androidModel = AndroidModuleModel.get(module)) != null) {
            NativeLibrary it;
            Iterable $receiver$iv$iv3;
            Iterable nativeLibraries;
            Object it2;
            Iterable $receiver$iv$iv4;
            Iterable $receiver$iv;
            Object item$iv$iv;
            List<SourceProvider> list = androidModel.getActiveSourceProviders();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"androidModel.activeSourceProviders");
            $receiver$iv$iv = list;
            destination$iv$iv = $receiver$iv;
            Collection destination$iv$iv3 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv4) {
                SourceProvider sourceProvider = it2 = (SourceProvider)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceProvider, (String)"it");
                Iterable list$iv$iv = sourceProvider.getJniLibsDirectories();
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv3;
            $receiver$iv$iv4 = $receiver$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv4) {
                void jniDir;
                it2 = (File)item$iv$iv2;
                collection = destination$iv$iv3;
                file = new File((File)jniDir, abiName);
                collection.add(file);
            }
            List jniDirs = (List)destination$iv$iv3;
            symDirs.addAll(jniDirs);
            IdeVariant ideVariant = androidModel.getSelectedVariant();
            Intrinsics.checkExpressionValueIsNotNull((Object)ideVariant, (String)"androidModel.selectedVariant");
            IdeAndroidArtifact ideAndroidArtifact = ideVariant.getMainArtifact();
            Intrinsics.checkExpressionValueIsNotNull((Object)ideAndroidArtifact, (String)"androidModel.selectedVariant.mainArtifact");
            $receiver$iv$iv4 = ideAndroidArtifact.getNativeLibraries();
            Iterable iterable = $receiver$iv$iv4;
            if (iterable == null) {
                iterable = CollectionsKt.emptyList();
            }
            Iterable $receiver$iv2 = nativeLibraries = iterable;
            item$iv$iv = $receiver$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv3) {
                NativeLibrary nativeLibrary = it = (NativeLibrary)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)nativeLibrary, (String)"it");
                if (!Intrinsics.areEqual((Object)nativeLibrary.getAbi(), (Object)abiName)) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            $receiver$iv2 = (List)destination$iv$iv4;
            $receiver$iv$iv3 = $receiver$iv2;
            destination$iv$iv4 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv3) {
                NativeLibrary nativeLibrary = it = (NativeLibrary)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)nativeLibrary, (String)"it");
                Iterable list$iv$iv = nativeLibrary.getDebuggableLibraryFolders();
                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
            }
            List nativeLibDirs = (List)destination$iv$iv4;
            symDirs.addAll(nativeLibDirs);
        }
        LinkedHashSet linkedHashSet = symDirs;
        Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashSet, (String)"symDirs");
        return linkedHashSet;
    }
}

