/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.tools.adtui.LightCalloutPopup;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.FileResourceOpener;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.ui.resourcechooser.ColorPicker;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerBuilder;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.awt.Color;
import java.awt.MouseInfo;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlPullParser;

public class AndroidColorAnnotator
implements Annotator {
    private static final String SET_COLOR_COMMAND_NAME = "Change Color";
    private static final int ICON_SIZE = 8;
    private static final int MAX_ICON_SIZE = 5000;

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        ResourceType type;
        AndroidPsiUtils.ResourceReferenceType referenceType;
        if (element == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String tagName = tag.getName();
            if (ResourceType.COLOR.getName().equals(tagName) || ResourceType.DRAWABLE.getName().equals(tagName) || ResourceType.MIPMAP.getName().equals(tagName)) {
                DomElement domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement(tag);
                if (domElement instanceof ResourceElement || ApplicationManager.getApplication().isUnitTestMode()) {
                    String value = tag.getValue().getText().trim();
                    AndroidColorAnnotator.annotateXml(element, holder, value);
                }
            } else if ("item".equals(tagName)) {
                XmlTagValue value = tag.getValue();
                String text = value.getText();
                AndroidColorAnnotator.annotateXml(element, holder, text);
            }
        } else if (element instanceof XmlAttributeValue) {
            XmlAttributeValue v = (XmlAttributeValue)element;
            String value = v.getValue();
            if (value == null || value.isEmpty()) {
                return;
            }
            AndroidColorAnnotator.annotateXml(element, holder, value);
        } else if (element instanceof PsiReferenceExpression && (referenceType = AndroidPsiUtils.getResourceReferenceType(element)) != AndroidPsiUtils.ResourceReferenceType.NONE && ((type = AndroidPsiUtils.getResourceType(element)) == ResourceType.COLOR || type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP)) {
            String name = AndroidPsiUtils.getResourceName(element);
            AndroidColorAnnotator.annotateResourceReference(type, holder, element, name, referenceType == AndroidPsiUtils.ResourceReferenceType.FRAMEWORK);
        }
    }

    private static void annotateXml(PsiElement element, AnnotationHolder holder, String value) {
        if (value.startsWith("#")) {
            PsiFile file = element.getContainingFile();
            if (file != null && AndroidResourceUtil.isInResourceSubdirectory(file, null)) {
                if (element instanceof XmlTag) {
                    Annotation annotation = holder.createInfoAnnotation(element, null);
                    annotation.setGutterIconRenderer((GutterIconRenderer)new MyRenderer(element, null));
                } else {
                    assert (element instanceof XmlAttributeValue);
                    Color color = ResourceHelper.parseColor(value);
                    if (color != null) {
                        Annotation annotation = holder.createInfoAnnotation(element, null);
                        annotation.setGutterIconRenderer((GutterIconRenderer)new MyRenderer(element, null));
                    }
                }
            }
        } else if (value.startsWith("@color/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.COLOR, holder, element, value.substring("@color/".length()), false);
        } else if (value.startsWith("@android:color/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.COLOR, holder, element, value.substring("@android:color/".length()), true);
        } else if (value.startsWith("@drawable/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.DRAWABLE, holder, element, value.substring("@drawable/".length()), false);
        } else if (value.startsWith("@android:drawable/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.DRAWABLE, holder, element, value.substring("@android:drawable/".length()), true);
        } else if (value.startsWith("@mipmap/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.MIPMAP, holder, element, value.substring("@mipmap/".length()), false);
        }
    }

    private static void annotateResourceReference(@NotNull ResourceType type, @NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull String name, boolean isFramework) {
        ResourceResolver resourceResolver;
        Module module;
        if (type == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(3);
        }
        if (element == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(4);
        }
        if (name == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)element, PsiFile.class);
        if (file == null) {
            return;
        }
        Configuration configuration = AndroidColorAnnotator.pickConfiguration(facet, module, file);
        if (configuration == null) {
            return;
        }
        ResourceValue value = AndroidColorAnnotator.findResourceValue(type, name, isFramework, module, configuration);
        if (value != null && (resourceResolver = configuration.getResourceResolver()) != null) {
            AndroidColorAnnotator.annotateResourceValue(type, holder, element, value, resourceResolver, facet);
        }
    }

    @Nullable
    static Configuration pickConfiguration(AndroidFacet facet, Module module, PsiFile file) {
        VirtualFile layout2;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parent = virtualFile.getParent();
        if (parent == null) {
            return null;
        }
        String parentName = parent.getName();
        if (!parentName.startsWith("layout")) {
            layout2 = ResourceHelper.pickAnyLayoutFile(module, facet);
            if (layout2 == null) {
                return null;
            }
        } else {
            layout2 = virtualFile;
        }
        return ConfigurationManager.getOrCreateInstance(module).getConfiguration(layout2);
    }

    private static void annotateResourceValue(@NotNull ResourceType type, @NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull ResourceValue value, @NotNull ResourceResolver resourceResolver, @NotNull AndroidFacet facet) {
        if (type == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(7);
        }
        if (element == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(8);
        }
        if (value == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(9);
        }
        if (resourceResolver == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(10);
        }
        if (facet == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(11);
        }
        Project project = element.getProject();
        if (type == ResourceType.COLOR) {
            Color color = ResourceHelper.resolveColor((RenderResources)resourceResolver, value, project);
            if (color != null) {
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setGutterIconRenderer((GutterIconRenderer)new MyRenderer(element, color));
            }
        } else {
            VirtualFile iconFile;
            assert (type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP);
            VirtualFile file = ResourceHelper.resolveDrawableAsVirtualFile((RenderResources)resourceResolver, value, project);
            if (file != null && file.getPath().endsWith(".xml")) {
                file = AndroidColorAnnotator.pickBitmapFromXml(file, resourceResolver, project, facet, value);
            }
            if ((iconFile = AndroidColorAnnotator.pickBestBitmap(file)) != null) {
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setGutterIconRenderer((GutterIconRenderer)new com.android.tools.idea.rendering.GutterIconRenderer(resourceResolver, element, iconFile));
            }
        }
    }

    @Nullable
    private static VirtualFile pickBitmapFromXml(@NotNull VirtualFile file, @NotNull ResourceResolver resourceResolver, @NotNull Project project, AndroidFacet facet, ResourceValue resourceValue2) {
        if (file == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(12);
        }
        if (resourceResolver == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(13);
        }
        if (project == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(14);
        }
        try {
            String tagName;
            XmlPullParser parser = FileResourceOpener.createXmlPullParser(file);
            if (parser == null) {
                return null;
            }
            if (parser.nextTag() != 2) {
                return null;
            }
            String source = null;
            switch (tagName = parser.getName()) {
                case "vector": {
                    LocalResourceRepository resourceRepository = ResourceRepositoryManager.getAppResources(facet);
                    List items2 = resourceRepository.getResourceItems(resourceValue2.getNamespace(), resourceValue2.getResourceType(), resourceValue2.getName());
                    for (ResourceItem item : items2) {
                        Density density;
                        FolderConfiguration configuration = item.getConfiguration();
                        DensityQualifier densityQualifier = configuration.getDensityQualifier();
                        if (densityQualifier == null || (density = densityQualifier.getValue()) == null || !density.isValidValueForDevice()) continue;
                        return ResourceHelper.getSourceAsVirtualFile(item);
                    }
                    return file;
                }
                case "bitmap": 
                case "nine-patch": {
                    source = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "src");
                    break;
                }
                case "clip": 
                case "inset": 
                case "scale": {
                    source = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "drawable");
                    break;
                }
                case "selector": 
                case "level-list": 
                case "layer-list": 
                case "transition": {
                    int childDepth = parser.getDepth() + 1;
                    parser.nextTag();
                    while (parser.getDepth() >= childDepth) {
                        String value;
                        if (parser.getEventType() == 2 && parser.getDepth() == childDepth && "item".equals(parser.getName()) && (value = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "drawable")) != null) {
                            source = value;
                        }
                        parser.nextTag();
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
            if (source == null) {
                return null;
            }
            ResourceValue resValue = resourceResolver.findResValue(source, resourceValue2.isFramework());
            return resValue == null ? null : ResourceHelper.resolveDrawableAsVirtualFile((RenderResources)resourceResolver, resValue, project);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    @Nullable
    public static VirtualFile pickBestBitmap(@Nullable VirtualFile bitmap) {
        if (bitmap != null && bitmap.exists()) {
            VirtualFile smallest = AndroidColorAnnotator.findSmallestDpiVersion(bitmap);
            if (smallest != null) {
                return smallest;
            }
            long length = bitmap.getLength();
            if (length < 5000L) {
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    private static VirtualFile findSmallestDpiVersion(VirtualFile bitmap) {
        VirtualFile parentFile = bitmap.getParent();
        if (parentFile == null) {
            return null;
        }
        VirtualFile resFolder = parentFile.getParent();
        if (resFolder == null) {
            return null;
        }
        String parentName = parentFile.getName();
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)parentName);
        if (config == null) {
            return null;
        }
        DensityQualifier qualifier = config.getDensityQualifier();
        if (qualifier == null) {
            return null;
        }
        Density density = qualifier.getValue();
        if (density != null && density.isValidValueForDevice()) {
            String fileName = bitmap.getName();
            Density[] densities = Density.values();
            int i = densities.length;
            while (--i >= 0) {
                String folderName;
                VirtualFile folder;
                Density d = densities[i];
                if (!d.isValidValueForDevice() || (folder = resFolder.findChild(folderName = parentName.replace(density.getResourceValue(), d.getResourceValue()))) == null || (bitmap = folder.findChild(fileName)) == null) continue;
                if (bitmap.getLength() > 5000L) {
                    return null;
                }
                return bitmap;
            }
        }
        return null;
    }

    @Deprecated
    @Nullable
    private static File pickBitmapFromXml(@NotNull File file, @NotNull ResourceResolver resourceResolver, @NotNull Project project, AndroidFacet facet, ResourceValue resourceValue2) {
        block16: {
            if (file == null) {
                AndroidColorAnnotator.$$$reportNull$$$0(15);
            }
            if (resourceResolver == null) {
                AndroidColorAnnotator.$$$reportNull$$$0(16);
            }
            if (project == null) {
                AndroidColorAnnotator.$$$reportNull$$$0(17);
            }
            try {
                String src;
                ResourceValue value;
                String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document == null || document.getDocumentElement() == null) break block16;
                Element root = document.getDocumentElement();
                String tag = root.getTagName();
                Element target = null;
                String attribute = null;
                if ("vector".equals(tag)) {
                    LocalResourceRepository resourceRepository = ResourceRepositoryManager.getAppResources(facet);
                    List items2 = resourceRepository.getResourceItem(resourceValue2.getResourceType(), resourceValue2.getName());
                    if (items2 != null) {
                        for (ResourceItem item : items2) {
                            File bitmap;
                            PathString itemFile;
                            Density density;
                            FolderConfiguration configuration = item.getConfiguration();
                            DensityQualifier densityQualifier = configuration.getDensityQualifier();
                            if (densityQualifier == null || (density = densityQualifier.getValue()) == null || !density.isValidValueForDevice() || (itemFile = item.getSource()) == null || (bitmap = itemFile.toFile()) == null || !bitmap.isFile()) continue;
                            return bitmap;
                        }
                    }
                    return file;
                }
                if ("bitmap".equals(tag) || "nine-patch".equals(tag)) {
                    target = root;
                    attribute = "src";
                } else if ("selector".equals(tag) || "level-list".equals(tag) || "layer-list".equals(tag) || "transition".equals(tag)) {
                    NodeList children = root.getChildNodes();
                    for (int i = children.getLength() - 1; i >= 0; --i) {
                        Node item = children.item(i);
                        if (item.getNodeType() != 1 || !"item".equals(item.getNodeName()) || !(target = (Element)item).hasAttributeNS("http://schemas.android.com/apk/res/android", "drawable")) continue;
                        attribute = "drawable";
                        break;
                    }
                } else if ("clip".equals(tag) || "inset".equals(tag) || "scale".equals(tag)) {
                    target = root;
                    attribute = "drawable";
                } else {
                    return null;
                }
                if (attribute != null && target.hasAttributeNS("http://schemas.android.com/apk/res/android", attribute) && (value = resourceResolver.findResValue(src = target.getAttributeNS("http://schemas.android.com/apk/res/android", attribute), resourceValue2.isFramework())) != null) {
                    return ResourceHelper.resolveDrawable((RenderResources)resourceResolver, value, project);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static File pickBestBitmap(@Nullable File bitmap) {
        if (bitmap != null && bitmap.exists()) {
            File smallest = AndroidColorAnnotator.findSmallestDpiVersion(bitmap);
            if (smallest != null) {
                return smallest;
            }
            long length = bitmap.length();
            if (length < 5000L) {
                return bitmap;
            }
        }
        return null;
    }

    @Deprecated
    @Nullable
    private static File findSmallestDpiVersion(File bitmap) {
        File parentFile = bitmap.getParentFile();
        if (parentFile == null) {
            return null;
        }
        File resFolder = parentFile.getParentFile();
        if (resFolder == null) {
            return null;
        }
        String parentName = parentFile.getName();
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)parentName);
        if (config == null) {
            return null;
        }
        DensityQualifier qualifier = config.getDensityQualifier();
        if (qualifier == null) {
            return null;
        }
        Density density = qualifier.getValue();
        if (density != null && density.isValidValueForDevice()) {
            String fileName = bitmap.getName();
            Density[] densities = Density.values();
            for (int i = densities.length - 1; i >= 0; --i) {
                String folder;
                Density d = densities[i];
                if (!d.isValidValueForDevice() || !(bitmap = new File(resFolder, (folder = parentName.replace(density.getResourceValue(), d.getResourceValue())) + File.separator + fileName)).exists()) continue;
                if (bitmap.length() > 5000L) {
                    return null;
                }
                return bitmap;
            }
        }
        return null;
    }

    @Nullable
    private static ResourceValue findResourceValue(ResourceType type, String name, boolean isFramework, Module module, Configuration configuration) {
        if (isFramework) {
            AbstractResourceRepository frameworkResources = configuration.getFrameworkResources();
            if (frameworkResources == null) {
                return null;
            }
            List items2 = frameworkResources.getResourceItems(ResourceNamespace.ANDROID, type, name);
            if (items2.isEmpty()) {
                return null;
            }
            return ((ResourceItem)items2.get(0)).getResourceValue();
        }
        LocalResourceRepository appResources = ResourceRepositoryManager.getAppResources(module);
        if (appResources == null) {
            return null;
        }
        if (!appResources.hasResourceItem(type, name)) {
            return null;
        }
        return appResources.getConfiguredValue(type, name, configuration.getFullConfig());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceResolver";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/AndroidColorAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateResourceReference";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateResourceValue";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "pickBitmapFromXml";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyRenderer
    extends GutterIconRenderer {
        private final PsiElement myElement;
        private final Color myColor;

        private MyRenderer(@NotNull PsiElement element, @Nullable Color color) {
            if (element == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            this.myElement = element;
            this.myColor = color;
        }

        @NotNull
        public Icon getIcon() {
            Color color = this.getCurrentColor();
            JBUI.JBIcon jBIcon = color == null ? JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)8)) : JBUI.scale((JBUI.JBIcon)new ColorIcon(8, color));
            if (jBIcon == null) {
                MyRenderer.$$$reportNull$$$0(1);
            }
            return jBIcon;
        }

        @Nullable
        private Color getCurrentColor() {
            if (this.myColor != null) {
                return this.myColor;
            }
            if (this.myElement instanceof XmlTag) {
                return ResourceHelper.parseColor(((XmlTag)this.myElement).getValue().getText());
            }
            if (this.myElement instanceof XmlAttributeValue) {
                return ResourceHelper.parseColor(((XmlAttributeValue)this.myElement).getValue());
            }
            return null;
        }

        public AnAction getClickAction() {
            if (this.myColor != null) {
                return null;
            }
            return new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
                    if (editor != null) {
                        if (((Boolean)StudioFlags.NELE_NEW_COLOR_PICKER.get()).booleanValue()) {
                            this.openNewColorPicker(this.getCurrentColor());
                        } else {
                            Color color = ColorPicker.showDialog(editor.getComponent(), "Choose Color", this.getCurrentColor(), true, null, false);
                            if (color != null) {
                                this.setColorToAttribute(color);
                            }
                        }
                    }
                }
            };
        }

        private void openNewColorPicker(@Nullable Color currentColor) {
            LightCalloutPopup dialog = new LightCalloutPopup();
            Function1 okCallback = c -> {
                this.setColorToAttribute((Color)c);
                dialog.close();
                return Unit.INSTANCE;
            };
            Function1 cancelCallback = c -> {
                dialog.close();
                return Unit.INSTANCE;
            };
            JPanel panel = new ColorPickerBuilder().setOriginalColor(currentColor).addSaturationBrightnessComponent().addColorAdjustPanel().addColorValuePanel().addSeparator().addColorPalette().addSeparator().addOperationPanel((Function1<? super Color, Unit>)okCallback, (Function1<? super Color, Unit>)cancelCallback).build();
            dialog.show((JComponent)panel, null, MouseInfo.getPointerInfo().getLocation());
        }

        private void setColorToAttribute(@NotNull Color color) {
            if (color == null) {
                MyRenderer.$$$reportNull$$$0(2);
            }
            TransactionGuard.submitTransaction((Disposable)this.myElement.getProject(), () -> {
                if (color == null) {
                    MyRenderer.$$$reportNull$$$0(3);
                }
                WriteCommandAction.runWriteCommandAction((Project)this.myElement.getProject(), (String)AndroidColorAnnotator.SET_COLOR_COMMAND_NAME, null, () -> {
                    XmlAttribute attribute;
                    if (color == null) {
                        MyRenderer.$$$reportNull$$$0(4);
                    }
                    if (this.myElement instanceof XmlTag) {
                        ((XmlTag)this.myElement).getValue().setText(ResourceHelper.colorToString(color));
                    } else if (this.myElement instanceof XmlAttributeValue && (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlAttribute.class)) != null) {
                        attribute.setValue(ResourceHelper.colorToString(color));
                    }
                }, (PsiFile[])new PsiFile[0]);
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MyRenderer that = (MyRenderer)((Object)o);
            if (this.myColor != null ? !this.myColor.equals(that.myColor) : that.myColor != null) {
                return false;
            }
            return this.myElement.equals(that.myElement);
        }

        public int hashCode() {
            int result2 = this.myElement.hashCode();
            result2 = 31 * result2 + (this.myColor != null ? this.myColor.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/AndroidColorAnnotator$MyRenderer";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/AndroidColorAnnotator$MyRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setColorToAttribute";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$setColorToAttribute$3";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$2";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

