/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.javadoc.AndroidJavaDocRenderer;
import com.intellij.codeInsight.javadoc.JavaDocExternalFilter;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDocumentationProvider
implements DocumentationProvider,
ExternalDocumentationProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.AndroidDocumentationProvider");

    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (originalElement == null) {
            return null;
        }
        AndroidPsiUtils.ResourceReferenceType referenceType = AndroidPsiUtils.getResourceReferenceType(originalElement);
        if (referenceType == AndroidPsiUtils.ResourceReferenceType.NONE) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module == null) {
            return null;
        }
        ResourceType type = AndroidPsiUtils.getResourceType(originalElement);
        if (type == null) {
            return null;
        }
        String name = AndroidPsiUtils.getResourceName(originalElement);
        boolean isFrameworkResource = referenceType == AndroidPsiUtils.ResourceReferenceType.FRAMEWORK;
        return AndroidJavaDocRenderer.render(module, type, name, isFrameworkResource);
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    public String fetchExternalDocumentation(final Project project, final PsiElement element, final List<String> docUrls) {
        String doc = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                if (AndroidDocumentationProvider.isFrameworkFieldDeclaration(element)) {
                    Module module = AndroidDocumentationProvider.guessAndroidModule(project, element);
                    PsiField field2 = (PsiField)element;
                    PsiClass containingClass = field2.getContainingClass();
                    assert (containingClass != null);
                    ResourceType type = ResourceType.getEnum((String)containingClass.getName());
                    if (module != null && type != null && field2.getName() != null) {
                        String name = field2.getName();
                        String render = AndroidJavaDocRenderer.render(module, type, name, true);
                        String external = JavaDocumentationProvider.fetchExternalJavadoc((PsiElement)element, (List)docUrls, (JavaDocExternalFilter)new MyDocExternalFilter(project));
                        return AndroidJavaDocRenderer.injectExternalDocumentation(render, external);
                    }
                }
                return null;
            }
        });
        if (doc != null) {
            return null;
        }
        return AndroidDocumentationProvider.isMyContext(element, project) ? JavaDocumentationProvider.fetchExternalJavadoc((PsiElement)element, docUrls, (JavaDocExternalFilter)new MyDocExternalFilter(project)) : null;
    }

    @Nullable
    private static Module guessAndroidModule(Project project, PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            Module[] modules;
            for (Module m : modules = ModuleManager.getInstance((Project)project).getModules()) {
                if (AndroidFacet.getInstance(m) == null) continue;
                module = m;
                break;
            }
            if (module == null) {
                return null;
            }
        }
        return module;
    }

    private static boolean isFrameworkFieldDeclaration(PsiElement element) {
        PsiField field2;
        PsiClass typeClass;
        if (element instanceof PsiField && (typeClass = (field2 = (PsiField)element).getContainingClass()) != null) {
            PsiClass rClass = typeClass.getContainingClass();
            return rClass != null && "android.R".equals(AndroidPsiUtils.getQualifiedNameSafely(rClass));
        }
        return false;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return false;
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    private static boolean isMyContext(final @NotNull PsiElement element, final @NotNull Project project) {
        if (element == null) {
            AndroidDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AndroidDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiClass) {
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    PsiFile file = element.getContainingFile();
                    if (file == null) {
                        return false;
                    }
                    VirtualFile vFile = file.getVirtualFile();
                    if (vFile == null) {
                        return false;
                    }
                    String path = FileUtil.toSystemIndependentName((String)vFile.getPath());
                    if (path.toLowerCase(Locale.US).contains("/android.jar!/") && !ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID).isEmpty()) {
                        VirtualFile jarFile = JarFileSystem.getInstance().getVirtualFileForJar(vFile);
                        return jarFile != null && "android.jar".equals(jarFile.getName());
                    }
                    return false;
                }
            });
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/android/AndroidDocumentationProvider";
        objectArray[2] = "isMyContext";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class MyDocExternalFilter
    extends JavaDocExternalFilter {
        public MyDocExternalFilter(Project project) {
            super(project);
        }

        protected void doBuildFromStream(String url, Reader input, StringBuilder data) throws IOException {
            try {
                if (ourAnchorsuffix.matcher(url).find()) {
                    super.doBuildFromStream(url, input, data);
                    return;
                }
                try (BufferedReader buf = new BufferedReader(input);){
                    String read;
                    String startSection = "<!-- ======== START OF CLASS DATA ======== -->";
                    String skipHeader = "<!-- END HEADER -->";
                    data.append("<HTML>");
                    while ((read = buf.readLine()) != null && !read.contains(startSection)) {
                    }
                    if (read == null) {
                        data.delete(0, data.length());
                        return;
                    }
                    data.append(read).append("\n");
                    boolean skip = false;
                    while ((read = buf.readLine()) != null && !read.startsWith("<h2>Class Overview") && !read.equals("<br><hr>")) {
                        if (read.contains("<table class=")) {
                            skip = true;
                        } else if (read.startsWith("<h2 class=\"api-section\"")) {
                            read = null;
                            break;
                        }
                        if (!skip && !read.isEmpty()) {
                            data.append(read).append("\n");
                        }
                        if (!read.contains(skipHeader)) continue;
                        skip = true;
                    }
                    if (read != null) {
                        data.append("<br><div>\n");
                        while ((read = buf.readLine()) != null && !read.startsWith("<h2>") && !read.startsWith("<h2 ")) {
                            data.append(read).append("\n");
                        }
                        data.append("</div>\n");
                    }
                    data.append("</HTML>");
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e, new String[]{"URL: " + url});
            }
        }
    }
}

