/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElementWithRequiredName;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGotoDeclarationHandler
implements GotoDeclarationHandler {
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        if (!(sourceElement instanceof PsiIdentifier)) {
            return null;
        }
        PsiFile file = sourceElement.getContainingFile();
        if (file == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        PsiReferenceExpression refExp = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)sourceElement, PsiReferenceExpression.class);
        if (refExp == null) {
            return null;
        }
        AndroidResourceUtil.MyReferredResourceFieldInfo info = AndroidResourceUtil.getReferredResourceOrManifestField(facet, refExp, false);
        if (info == null) {
            PsiElement parent = refExp.getParent();
            if (parent instanceof PsiReferenceExpression) {
                info = AndroidResourceUtil.getReferredResourceOrManifestField(facet, (PsiReferenceExpression)parent, false);
            }
            if (info == null && (parent = parent.getParent()) instanceof PsiReferenceExpression) {
                info = AndroidResourceUtil.getReferredResourceOrManifestField(facet, (PsiReferenceExpression)parent, false);
            }
        }
        if (info == null) {
            return null;
        }
        String nestedClassName = info.getClassName();
        String fieldName = info.getFieldName();
        ArrayList<PsiElement> resourceList = new ArrayList<PsiElement>();
        if (info.isFromManifest()) {
            AndroidGotoDeclarationHandler.collectManifestElements(nestedClassName, fieldName, facet, resourceList);
        } else {
            ResourceManager manager;
            ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(facet);
            ResourceManager resourceManager = manager = info.getNamespace() == ResourceNamespace.ANDROID ? resourceManagers.getSystemResourceManager(false) : resourceManagers.getLocalResourceManager();
            if (manager == null) {
                return null;
            }
            manager.collectLazyResourceElements(info.getNamespace(), nestedClassName, fieldName, false, (PsiElement)refExp, resourceList);
            if (manager instanceof LocalResourceManager) {
                LocalResourceManager lrm = (LocalResourceManager)manager;
                if (nestedClassName.equals(ResourceType.ATTR.getName())) {
                    for (Attr attr : lrm.findAttrs(fieldName)) {
                        resourceList.add((PsiElement)attr.getName().getXmlAttributeValue());
                    }
                } else if (nestedClassName.equals(ResourceType.STYLEABLE.getName())) {
                    for (DeclareStyleable declareStyleable : lrm.findStyleables(fieldName)) {
                        resourceList.add((PsiElement)declareStyleable.getName().getXmlAttributeValue());
                    }
                    for (Attr attr : lrm.findStyleableAttributesByFieldName(fieldName)) {
                        resourceList.add((PsiElement)attr.getName().getXmlAttributeValue());
                    }
                }
            }
        }
        if (resourceList.size() > 1) {
            resourceList.sort(AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        return resourceList.toArray(PsiElement.EMPTY_ARRAY);
    }

    private static void collectManifestElements(@NotNull String nestedClassName, @NotNull String fieldName, @NotNull AndroidFacet facet, @NotNull List<PsiElement> result2) {
        List<ManifestElementWithRequiredName> list;
        Manifest manifest;
        if (nestedClassName == null) {
            AndroidGotoDeclarationHandler.$$$reportNull$$$0(0);
        }
        if (fieldName == null) {
            AndroidGotoDeclarationHandler.$$$reportNull$$$0(1);
        }
        if (facet == null) {
            AndroidGotoDeclarationHandler.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            AndroidGotoDeclarationHandler.$$$reportNull$$$0(3);
        }
        if ((manifest = facet.getManifest()) == null) {
            return;
        }
        if ("permission".equals(nestedClassName)) {
            list = manifest.getPermissions();
        } else if ("permission_group".equals(nestedClassName)) {
            list = manifest.getPermissionGroups();
        } else {
            return;
        }
        for (ManifestElementWithRequiredName manifestElementWithRequiredName : list) {
            XmlAttributeValue psiElement;
            AndroidAttributeValue<String> nameAttribute = manifestElementWithRequiredName.getName();
            String name = (String)nameAttribute.getValue();
            if (!AndroidUtils.equal(name, fieldName, false) || (psiElement = nameAttribute.getXmlAttributeValue()) == null) continue;
            result2.add((PsiElement)psiElement);
        }
    }

    public String getActionText(DataContext context) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "nestedClassName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fieldName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "facet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/android/AndroidGotoDeclarationHandler";
        objectArray[2] = "collectManifestElements";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

