/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGotoRelatedProvider
extends GotoRelatedProvider {
    public static boolean ourAddDeclarationToManifest;
    private static final String[] CONTEXT_CLASSES;

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement element) {
        Computable<List<GotoRelatedItem>> items2;
        if (element == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        List list = (items2 = AndroidGotoRelatedProvider.getLazyItemsComputable(element)) != null ? (List)items2.compute() : Collections.emptyList();
        if (list == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    private static Computable<List<GotoRelatedItem>> getLazyItemsComputable(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(2);
        }
        if (!((file = element.getContainingFile()) instanceof XmlFile) && !(file instanceof PsiJavaFile)) {
            return null;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        Project project = element.getProject();
        if (!FileIndexFacade.getInstance((Project)project).isInContent(vFile)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)project);
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        if (file instanceof PsiJavaFile) {
            PsiClass[] rootClasses;
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
            if (aClass == null && (rootClasses = ((PsiJavaFile)file).getClasses()).length == 1) {
                aClass = rootClasses[0];
            }
            if (aClass != null) {
                return AndroidGotoRelatedProvider.getLazyItemsForClass(aClass, facet, ourAddDeclarationToManifest);
            }
        } else {
            return AndroidGotoRelatedProvider.getLazyItemsForXmlFile((XmlFile)file, facet);
        }
        return null;
    }

    @Nullable
    public static Computable<List<GotoRelatedItem>> getLazyItemsForXmlFile(@NotNull XmlFile file, @NotNull AndroidFacet facet) {
        ResourceFolderType resourceType;
        if (file == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(3);
        }
        if (facet == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(4);
        }
        if (ResourceFolderType.LAYOUT == (resourceType = ModuleResourceManagers.getInstance(facet).getLocalResourceManager().getFileResourceFolderType((PsiFile)file))) {
            return AndroidGotoRelatedProvider.collectRelatedJavaFiles(file, facet);
        }
        return null;
    }

    @Nullable
    static Computable<List<GotoRelatedItem>> getLazyItemsForClass(@NotNull PsiClass aClass, @NotNull AndroidFacet facet, boolean addDeclarationInManifest) {
        List<GotoRelatedItem> items2;
        if (aClass == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(5);
        }
        if (facet == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(6);
        }
        GotoRelatedItem item = AndroidGotoRelatedProvider.findDeclarationInManifest(aClass);
        boolean isContextClass = AndroidGotoRelatedProvider.isInheritorOfContextClass(aClass, facet.getModule());
        if (!isContextClass && item == null) {
            return null;
        }
        if (isContextClass) {
            items2 = new ArrayList<GotoRelatedItem>(AndroidGotoRelatedProvider.collectRelatedLayoutFiles(facet, aClass));
            if (addDeclarationInManifest && item != null) {
                items2.add(item);
            }
            if (items2.isEmpty()) {
                return null;
            }
        } else {
            items2 = Collections.singletonList(item);
        }
        return () -> items2;
    }

    @Nullable
    private static GotoRelatedItem findDeclarationInManifest(@NotNull PsiClass psiClass) {
        AndroidAttributeValue<PsiClass> domAttrValue;
        if (psiClass == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(7);
        }
        if ((domAttrValue = AndroidDomUtil.findComponentDeclarationInManifest(psiClass)) == null) {
            return null;
        }
        XmlAttributeValue attrValue = domAttrValue.getXmlAttributeValue();
        return attrValue != null ? new MyGotoManifestItem(attrValue) : null;
    }

    private static boolean isInheritorOfContextClass(@NotNull PsiClass psiClass, @NotNull Module module) {
        if (psiClass == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(8);
        }
        if (module == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(9);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        for (String contextClassName : CONTEXT_CLASSES) {
            PsiClass contextClass = facade.findClass(contextClassName, module.getModuleWithDependenciesAndLibrariesScope(false));
            if (contextClass == null || !psiClass.isInheritor(contextClass, true)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Computable<List<GotoRelatedItem>> collectRelatedJavaFiles(@NotNull XmlFile file, @NotNull AndroidFacet facet) {
        String resourceName;
        String resType;
        PsiField[] fields;
        if (file == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(10);
        }
        if (facet == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(11);
        }
        if ((fields = AndroidResourceUtil.findResourceFields(facet, resType = ResourceType.LAYOUT.getName(), resourceName = AndroidCommonUtils.getResourceName((String)resType, (String)file.getName()), true)).length == 0 || fields.length > 1) {
            return null;
        }
        PsiField field2 = fields[0];
        Module module = facet.getModule();
        GlobalSearchScope scope = module.getModuleScope(false);
        return () -> {
            if (file == null) {
                AndroidGotoRelatedProvider.$$$reportNull$$$0(18);
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
            ArrayList<PsiClass> psiContextClasses = new ArrayList<PsiClass>();
            PsiClass declared2 = AndroidPsiUtils.getContextClass(module, file);
            if (declared2 != null) {
                return Collections.singletonList(new GotoRelatedItem((PsiElement)declared2, "JAVA"));
            }
            for (String contextClassName : CONTEXT_CLASSES) {
                PsiClass contextClass = facade.findClass(contextClassName, module.getModuleWithDependenciesAndLibrariesScope(false));
                if (contextClass == null) continue;
                psiContextClasses.add(contextClass);
            }
            if (psiContextClasses.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList result2 = new ArrayList();
            ReferencesSearch.search((PsiElement)field2, (SearchScope)scope).forEach(reference2 -> {
                PsiClass relatedClass;
                PsiElement element = reference2.getElement();
                if (!(element instanceof PsiReferenceExpression)) {
                    return true;
                }
                if (!((element = element.getParent()) instanceof PsiExpressionList)) {
                    return true;
                }
                if (!((element = element.getParent()) instanceof PsiMethodCallExpression)) {
                    return true;
                }
                String methodName = ((PsiMethodCallExpression)element).getMethodExpression().getReferenceName();
                if (("setContentView".equals(methodName) || "inflate".equals(methodName)) && (relatedClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) != null && AndroidGotoRelatedProvider.isInheritorOfOne(relatedClass, psiContextClasses)) {
                    result2.add(new GotoRelatedItem((PsiElement)relatedClass, "JAVA"));
                }
                return true;
            });
            return result2;
        };
    }

    private static boolean isInheritorOfOne(@NotNull PsiClass psiClass, @NotNull Collection<PsiClass> possibleBaseClasses) {
        if (psiClass == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(12);
        }
        if (possibleBaseClasses == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(13);
        }
        for (PsiClass baseClass : possibleBaseClasses) {
            if (!psiClass.isInheritor(baseClass, true)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<GotoRelatedItem> collectRelatedLayoutFiles(final @NotNull AndroidFacet facet, @NotNull PsiClass context) {
        if (facet == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(14);
        }
        if (context == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(15);
        }
        HashSet files2 = new HashSet();
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Set)files2){
            final /* synthetic */ Set val$files;
            {
                this.val$files = set;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                String resClassName = ResourceType.LAYOUT.getName();
                AndroidResourceUtil.MyReferredResourceFieldInfo info = AndroidResourceUtil.getReferredResourceOrManifestField(facet, expression, resClassName, true);
                if (info == null || info.isFromManifest()) {
                    return;
                }
                String resFieldName = info.getFieldName();
                LocalResourceManager resourceManager = ModuleResourceManagers.getInstance(facet).getLocalResourceManager();
                List<PsiElement> resources = resourceManager.findResourcesByFieldName(ResourceNamespace.TODO(), resClassName, resFieldName);
                for (PsiElement resource : resources) {
                    if (!(resource instanceof PsiFile)) continue;
                    this.val$files.add((PsiFile)resource);
                }
            }
        });
        if (files2.isEmpty()) {
            List<GotoRelatedItem> list = Collections.emptyList();
            if (list == null) {
                AndroidGotoRelatedProvider.$$$reportNull$$$0(16);
            }
            return list;
        }
        ArrayList<GotoRelatedItem> result2 = new ArrayList<GotoRelatedItem>(files2.size());
        for (PsiFile file : files2) {
            result2.add(new MyGotoRelatedLayoutItem(file));
        }
        ArrayList<GotoRelatedItem> arrayList = result2;
        if (arrayList == null) {
            AndroidGotoRelatedProvider.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    static {
        CONTEXT_CLASSES = new String[]{"android.app.Activity", "android.app.Fragment", SdkConstants.CLASS_V4_FRAGMENT.oldName(), SdkConstants.CLASS_V4_FRAGMENT.newName(), "android.widget.Adapter"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/AndroidGotoRelatedProvider";
                break;
            }
            case 3: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleBaseClasses";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/AndroidGotoRelatedProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRelatedLayoutFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 16: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLazyItemsComputable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLazyItemsForXmlFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLazyItemsForClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDeclarationInManifest";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInheritorOfContextClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectRelatedJavaFiles";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInheritorOfOne";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectRelatedLayoutFiles";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectRelatedJavaFiles$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyGotoManifestItem
    extends GotoRelatedItem {
        public MyGotoManifestItem(@NotNull XmlAttributeValue attributeValue) {
            if (attributeValue == null) {
                MyGotoManifestItem.$$$reportNull$$$0(0);
            }
            super((PsiElement)attributeValue);
        }

        @Nullable
        public String getCustomName() {
            return "AndroidManifest.xml";
        }

        @Nullable
        public String getCustomContainerName() {
            return "";
        }

        @Nullable
        public Icon getCustomIcon() {
            return XmlFileType.INSTANCE.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValue", "org/jetbrains/android/AndroidGotoRelatedProvider$MyGotoManifestItem", "<init>"));
        }
    }

    private static class MyGotoRelatedLayoutItem
    extends GotoRelatedItem {
        private final PsiFile myFile;

        public MyGotoRelatedLayoutItem(@NotNull PsiFile file) {
            if (file == null) {
                MyGotoRelatedLayoutItem.$$$reportNull$$$0(0);
            }
            super((PsiElement)file, "Layout Files");
            this.myFile = file;
        }

        @Nullable
        public String getCustomContainerName() {
            PsiDirectory directory = this.myFile.getContainingDirectory();
            return directory != null ? "(" + directory.getName() + ")" : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/AndroidGotoRelatedProvider$MyGotoRelatedLayoutItem", "<init>"));
        }
    }
}

