/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.startup.Actions;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ApplicationComponent;
import org.jetbrains.annotations.NotNull;

public class AndroidPlugin
implements ApplicationComponent {
    private static final String GROUP_ANDROID_TOOLS = "AndroidToolsGroup";
    private static final String GROUP_TOOLS = "ToolsMenu";

    @NotNull
    public String getComponentName() {
        if ("AndroidApplicationComponent" == null) {
            AndroidPlugin.$$$reportNull$$$0(0);
        }
        return "AndroidApplicationComponent";
    }

    public void initComponent() {
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            AndroidPlugin.initializeForNonStudio();
        }
        AndroidPlugin.setUpActionsUnderFlag();
    }

    private static void initializeForNonStudio() {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction group = actionManager.getAction(GROUP_ANDROID_TOOLS);
        if (group instanceof ActionGroup) {
            ((ActionGroup)group).setPopup(true);
        }
        Actions.moveAction(GROUP_ANDROID_TOOLS, GROUP_TOOLS, GROUP_TOOLS, new Constraints(Anchor.LAST, null));
        Actions.moveAction("Android.SyncProject", "FileMenu", GROUP_ANDROID_TOOLS, new Constraints(Anchor.FIRST, null));
        Actions.moveAction("Android.MainToolBarGradleGroup", "MainToolBar", "Android.MainToolBarActionGroup", new Constraints(Anchor.LAST, null));
        UsageTracker.getInstance().setIdeBrand(AndroidStudioEvent.IdeBrand.INTELLIJ);
    }

    private static void setUpActionsUnderFlag() {
        ActionManager actionManager;
        AnAction parentGroup;
        if (((Boolean)StudioFlags.RUNDEBUG_ANDROID_BUILD_BUNDLE_ENABLED.get()).booleanValue() && (parentGroup = (actionManager = ActionManager.getInstance()).getAction("BuildMenu")) instanceof DefaultActionGroup) {
            String groupId = "Android.BuildApkOrBundle";
            DefaultActionGroup group = new DefaultActionGroup("Build Bundle(s) / APK(s)", true);
            actionManager.registerAction("Android.BuildApkOrBundle", (AnAction)group);
            ((DefaultActionGroup)parentGroup).add((AnAction)group, new Constraints(Anchor.BEFORE, "Android.GenerateSignedApk"));
            Actions.moveAction("Android.BuildApk", "BuildMenu", "Android.BuildApkOrBundle", new Constraints(Anchor.FIRST, null));
            Actions.moveAction("Android.BuildBundle", "BuildMenu", "Android.BuildApkOrBundle", new Constraints(Anchor.AFTER, null));
        }
    }

    public void disposeComponent() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidPlugin", "getComponentName"));
    }
}

