/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.AndroidUsagesTargetProvider;
import org.jetbrains.android.dom.converters.AndroidResourceReference;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRenameHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Editor editor;
        if (dataContext == null) {
            AndroidRenameHandler.$$$reportNull$$$0(0);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) == null) {
            return false;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return false;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element instanceof SchemaPrefix) {
            return false;
        }
        if (AndroidUsagesTargetProvider.findValueResourceTagInContext(editor, file, true) != null) {
            return true;
        }
        if (AndroidRenameHandler.getResourceReferenceTarget(editor) != null) {
            return true;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        return element != null && AndroidRenameHandler.isPackageAttributeInManifest(project, element);
    }

    @Nullable
    private static PsiElement getResourceReferenceTarget(@NotNull Editor editor) {
        PsiReference reference2;
        if (editor == null) {
            AndroidRenameHandler.$$$reportNull$$$0(1);
        }
        if (!((reference2 = TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset())) instanceof AndroidResourceReference)) {
            return null;
        }
        Collection elements = TargetElementUtil.getInstance().getTargetCandidates(reference2);
        if (elements.isEmpty()) {
            return null;
        }
        ArrayList elementList = new ArrayList(elements);
        Collections.sort(elementList, AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        return (PsiElement)elementList.get(0);
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            AndroidRenameHandler.$$$reportNull$$$0(2);
        }
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            AndroidRenameHandler.$$$reportNull$$$0(3);
        }
        if (file == null || editor == null) {
            return;
        }
        XmlTag tag = AndroidUsagesTargetProvider.findValueResourceTagInContext(editor, file, true);
        if (tag != null) {
            ResourceUrl url = AndroidRenameHandler.findResourceReferenceUnderCaret(editor, file);
            if (url != null && !url.isFramework()) {
                AndroidRenameHandler.performResourceReferenceRenaming(project, editor, dataContext, file, url);
            } else {
                AndroidRenameHandler.performValueResourceRenaming(project, editor, dataContext, tag);
            }
        } else {
            PsiElement element = AndroidRenameHandler.getResourceReferenceTarget(editor);
            if (element != null) {
                AndroidRenameHandler.performResourceReferenceRenaming(project, editor, dataContext, element);
            } else {
                AndroidRenameHandler.performApplicationPackageRenaming(project, editor, dataContext);
            }
        }
    }

    private static void performValueResourceRenaming(Project project, Editor editor, DataContext dataContext, XmlTag tag) {
        XmlAttribute nameAttribute = tag.getAttribute("name");
        if (nameAttribute == null) {
            return;
        }
        XmlAttributeValue attributeValue = nameAttribute.getValueElement();
        if (attributeValue == null) {
            return;
        }
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)new RenameDialog(project, (PsiElement)new ValueResourceElementWrapper(attributeValue), null, editor));
    }

    private static void performResourceReferenceRenaming(Project project, Editor editor, DataContext dataContext, PsiFile file, ResourceUrl url) {
        PsiField[] resourceFields;
        assert (!url.isFramework());
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet != null && (resourceFields = AndroidResourceUtil.findResourceFields(facet, url.type.getName(), url.name, false)).length == 1) {
            RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)new RenameDialog(project, (PsiElement)resourceFields[0], null, editor));
        }
    }

    private static void performResourceReferenceRenaming(@NotNull Project project, @NotNull Editor editor, @NotNull DataContext dataContext, @NotNull PsiElement element) {
        if (project == null) {
            AndroidRenameHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            AndroidRenameHandler.$$$reportNull$$$0(5);
        }
        if (dataContext == null) {
            AndroidRenameHandler.$$$reportNull$$$0(6);
        }
        if (element == null) {
            AndroidRenameHandler.$$$reportNull$$$0(7);
        }
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)new RenameDialog(project, element, null, editor));
    }

    @Nullable
    private static ResourceUrl findResourceReferenceUnderCaret(@NotNull Editor editor, @NotNull PsiFile file) {
        XmlText text;
        if (editor == null) {
            AndroidRenameHandler.$$$reportNull$$$0(8);
        }
        if (file == null) {
            AndroidRenameHandler.$$$reportNull$$$0(9);
        }
        if (!(file instanceof XmlFile)) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        if (!AndroidResourceUtil.isInResourceSubdirectory(file, ResourceFolderType.VALUES.getName())) {
            return null;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return null;
        }
        if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS && (text = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)element, XmlText.class)) != null) {
            return ResourceUrl.parse((String)text.getText().trim());
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        Editor editor;
        if (project == null) {
            AndroidRenameHandler.$$$reportNull$$$0(10);
        }
        if (elements == null) {
            AndroidRenameHandler.$$$reportNull$$$0(11);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) == null) {
            return;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return;
        }
        this.invoke(project, editor, file, dataContext);
    }

    public String getActionTitle() {
        return "Rename Android value resource";
    }

    static boolean isPackageAttributeInManifest(@NotNull Project project, @Nullable PsiElement element) {
        if (project == null) {
            AndroidRenameHandler.$$$reportNull$$$0(12);
        }
        if (element == null) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)psiFile);
        if (facet == null) {
            return false;
        }
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null || !vFile.equals(AndroidRootUtil.getPrimaryManifestFile(facet))) {
            return false;
        }
        if (!(element instanceof XmlAttributeValue)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlAttribute)) {
            return false;
        }
        GenericAttributeValue attrValue = DomManager.getDomManager((Project)project).getDomElement((XmlAttribute)parent);
        if (attrValue == null) {
            return false;
        }
        DomElement parentDomElement = attrValue.getParent();
        return parentDomElement instanceof Manifest && attrValue.equals(((Manifest)parentDomElement).getPackage());
    }

    private static void performApplicationPackageRenaming(@NotNull Project project, @NotNull Editor editor, @NotNull DataContext context) {
        PsiElement element;
        if (project == null) {
            AndroidRenameHandler.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            AndroidRenameHandler.$$$reportNull$$$0(14);
        }
        if (context == null) {
            AndroidRenameHandler.$$$reportNull$$$0(15);
        }
        if (!((element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context)) instanceof XmlAttributeValue)) {
            return;
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        RenameDialog.showRenameDialog((DataContext)context, (RenameDialog)new RenameDialog(project, element, null, editor){

            @NotNull
            protected String getLabelText() {
                String string = "Rename Android application package of module '" + module.getName() + "' to:";
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            protected void canRun() throws ConfigurationException {
                String name = this.getNewName();
                if (name.isEmpty()) {
                    throw new ConfigurationException(AndroidBundle.message("specify.package.name.error", new Object[0]));
                }
                if (!AndroidUtils.isValidAndroidPackageName(name)) {
                    throw new ConfigurationException(AndroidBundle.message("not.valid.package.name.error", name));
                }
                if (!AndroidCommonUtils.contains2Identifiers((String)name)) {
                    throw new ConfigurationException(AndroidBundle.message("package.name.must.contain.2.ids.error", new Object[0]));
                }
                super.canRun();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidRenameHandler$1", "getLabelText"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/AndroidRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getResourceReferenceTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isRenaming";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "performResourceReferenceRenaming";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findResourceReferenceUnderCaret";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isPackageAttributeInManifest";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "performApplicationPackageRenaming";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

