/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlSchemaProvider;
import gnu.trove.THashMap;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestDomFileDescription;
import org.jetbrains.android.dom.raw.RawDomFileDescription;
import org.jetbrains.android.dom.xml.XmlResourceDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidXmlSchemaProvider
extends XmlSchemaProvider {
    private static final Key<Map<String, CachedValue<XmlFile>>> DESCRIPTORS_MAP_IN_MODULE = Key.create((String)"ANDROID_DESCRIPTORS_MAP_IN_MODULE");

    public XmlFile getSchema(@NotNull @NonNls String url, final @Nullable Module module, @NotNull PsiFile baseFile) {
        CachedValue reference2;
        if (url == null) {
            AndroidXmlSchemaProvider.$$$reportNull$$$0(0);
        }
        if (baseFile == null) {
            AndroidXmlSchemaProvider.$$$reportNull$$$0(1);
        }
        if (module == null || AndroidFacet.getInstance(module) == null) {
            return null;
        }
        Map descriptors = (Map)module.getUserData(DESCRIPTORS_MAP_IN_MODULE);
        if (descriptors == null) {
            descriptors = new THashMap();
            module.putUserData(DESCRIPTORS_MAP_IN_MODULE, (Object)descriptors);
        }
        if ((reference2 = (CachedValue)descriptors.get(url)) != null) {
            return (XmlFile)reference2.getValue();
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)module.getProject());
        reference2 = manager.createCachedValue((CachedValueProvider)new CachedValueProvider<XmlFile>(){

            public CachedValueProvider.Result<XmlFile> compute() {
                URL resource = AndroidXmlSchemaProvider.class.getResource("android.xsd");
                VirtualFile fileByURL = VfsUtil.findFileByURL((URL)resource);
                XmlFile result2 = (XmlFile)PsiManager.getInstance((Project)module.getProject()).findFile(fileByURL).copy();
                return new CachedValueProvider.Result((Object)result2, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        }, false);
        descriptors.put(url, reference2);
        return (XmlFile)reference2.getValue();
    }

    public boolean isAvailable(@NotNull XmlFile file) {
        PsiFile f;
        if (file == null) {
            AndroidXmlSchemaProvider.$$$reportNull$$$0(2);
        }
        if (!((f = file.getOriginalFile()) instanceof XmlFile)) {
            return false;
        }
        final XmlFile originalFile = (XmlFile)f;
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (AndroidXmlSchemaProvider.isXmlResourceFile(originalFile) || ManifestDomFileDescription.isManifestFile(originalFile) || RawDomFileDescription.isRawFile(originalFile)) {
                    return AndroidFacet.getInstance((PsiElement)originalFile) != null;
                }
                return false;
            }
        });
    }

    private static boolean isXmlResourceFile(XmlFile file) {
        if (!AndroidResourceUtil.isInResourceSubdirectory((PsiFile)file, null)) {
            return false;
        }
        PsiDirectory parent = file.getParent();
        if (parent == null) {
            return false;
        }
        ResourceFolderType resType = ResourceFolderType.getFolderType((String)parent.getName());
        if (resType == null) {
            return false;
        }
        if (resType == ResourceFolderType.XML) {
            return XmlResourceDomFileDescription.isXmlResourceFile(file);
        }
        return resType != ResourceFolderType.RAW;
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file, @Nullable String tagName) {
        if (file == null) {
            AndroidXmlSchemaProvider.$$$reportNull$$$0(3);
        }
        HashSet<String> result2 = new HashSet<String>();
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet != null) {
            result2.add("http://schemas.android.com/tools");
            ResourceFolderType type = ResourceHelper.getFolderType(file.getOriginalFile());
            if (type == ResourceFolderType.VALUES) {
                result2.add("urn:oasis:names:tc:xliff:document:1.2");
            } else if (type != ResourceFolderType.MIPMAP && type != ResourceFolderType.RAW) {
                String localNs;
                result2.add("http://schemas.android.com/apk/res/android");
                if (type == ResourceFolderType.DRAWABLE) {
                    result2.add("http://schemas.android.com/aapt");
                }
                if ((localNs = AndroidXmlSchemaProvider.getLocalXmlNamespace(facet)) != null) {
                    result2.add(localNs);
                }
                if (type == ResourceFolderType.XML) {
                    result2.add("urn:oasis:names:tc:xliff:document:1.2");
                }
            }
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            AndroidXmlSchemaProvider.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            AndroidXmlSchemaProvider.$$$reportNull$$$0(5);
        }
        if (context == null) {
            AndroidXmlSchemaProvider.$$$reportNull$$$0(6);
        }
        if ("http://schemas.android.com/apk/res/android".equals(namespace)) {
            return "android";
        }
        if (namespace.equals("http://schemas.android.com/tools")) {
            return "tools";
        }
        if (namespace.equals("http://schemas.android.com/apk/res-auto") || namespace.startsWith("http://schemas.android.com/apk/res/")) {
            return "app";
        }
        if (namespace.equals("urn:oasis:names:tc:xliff:document:1.2")) {
            return "xliff";
        }
        if (namespace.equals("http://schemas.android.com/aapt")) {
            return "aapt";
        }
        return null;
    }

    @Nullable
    public static String getLocalXmlNamespace(@NotNull AndroidFacet facet) {
        String aPackage;
        if (facet == null) {
            AndroidXmlSchemaProvider.$$$reportNull$$$0(7);
        }
        if (((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject() || facet.requiresAndroidModel()) {
            return "http://schemas.android.com/apk/res-auto";
        }
        final Manifest manifest = facet.getManifest();
        if (manifest != null && (aPackage = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                return (String)manifest.getPackage().getValue();
            }
        })) != null && !aPackage.isEmpty()) {
            return "http://schemas.android.com/apk/res/" + aPackage;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/AndroidXmlSchemaProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/AndroidXmlSchemaProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSchema";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableNamespaces";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPrefix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLocalXmlNamespace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

