/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.psi.TagToClassMapper;
import com.google.common.collect.Maps;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.annotations.NotNull;

class TagToClassMapperImpl
implements TagToClassMapper {
    private final Map<String, Map<String, SmartPsiElementPointer<PsiClass>>> myInitialClassMaps;
    private final Map<String, CachedValue<Map<String, PsiClass>>> myClassMaps;
    private final Module myModule;

    TagToClassMapperImpl(@NotNull Module module) {
        if (module == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(0);
        }
        this.myInitialClassMaps = new HashMap<String, Map<String, SmartPsiElementPointer<PsiClass>>>();
        this.myClassMaps = Maps.newConcurrentMap();
        this.myModule = module;
        MessageBusConnection connection = module.getMessageBus().connect((Disposable)module);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                TagToClassMapperImpl.this.clear();
            }
        });
    }

    @Override
    @NotNull
    public Map<String, PsiClass> getClassMap(@NotNull String className) {
        CachedValue value;
        if (className == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(1);
        }
        if ((value = this.myClassMaps.get(className)) == null) {
            value = CachedValuesManager.getManager((Project)this.myModule.getProject()).createCachedValue(() -> {
                if (className == null) {
                    TagToClassMapperImpl.$$$reportNull$$$0(14);
                }
                Map<String, PsiClass> map2 = this.computeClassMap(className);
                return CachedValueProvider.Result.create(map2, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }, false);
            this.myClassMaps.put(className, (CachedValue<Map<String, PsiClass>>)value);
        }
        Map map2 = (Map)value.getValue();
        if (map2 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(2);
        }
        return map2;
    }

    @NotNull
    private Map<String, PsiClass> computeClassMap(@NotNull String className) {
        PsiClass aClass;
        SmartPsiElementPointer<PsiClass> pointer;
        if (className == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(3);
        }
        Map<String, SmartPsiElementPointer<PsiClass>> classMap = this.getInitialClassMap(className, false);
        HashMap<String, PsiClass> result2 = new HashMap<String, PsiClass>();
        boolean shouldRebuildInitialMap = false;
        for (String key : classMap.keySet()) {
            pointer = classMap.get(key);
            if (!TagToClassMapperImpl.isUpToDate(pointer, key)) {
                shouldRebuildInitialMap = true;
                break;
            }
            aClass = (PsiClass)pointer.getElement();
            if (aClass == null) continue;
            result2.put(key, aClass);
        }
        if (shouldRebuildInitialMap) {
            result2.clear();
            classMap = this.getInitialClassMap(className, true);
            for (String key : classMap.keySet()) {
                pointer = classMap.get(key);
                aClass = (PsiClass)pointer.getElement();
                if (aClass == null) continue;
                result2.put(key, aClass);
            }
        }
        this.fillMap(className, this.myModule.getModuleWithDependenciesAndLibrariesScope(true), result2, false);
        HashMap<String, PsiClass> hashMap = result2;
        if (hashMap == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static boolean isUpToDate(@NotNull SmartPsiElementPointer<PsiClass> pointer, String tagName) {
        PsiClass aClass;
        if (pointer == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(5);
        }
        if ((aClass = (PsiClass)pointer.getElement()) == null) {
            return false;
        }
        Object[] tagNames = LayoutViewClassUtils.getTagNamesByClass(aClass, -1);
        return ArrayUtilRt.find((Object[])tagNames, (Object)tagName) >= 0;
    }

    @NotNull
    private Map<String, SmartPsiElementPointer<PsiClass>> getInitialClassMap(@NotNull String className, boolean forceRebuild) {
        Map<String, SmartPsiElementPointer<PsiClass>> viewClassMap;
        if (className == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(6);
        }
        if ((viewClassMap = this.myInitialClassMaps.get(className)) != null && !forceRebuild) {
            Map<String, SmartPsiElementPointer<PsiClass>> map2 = viewClassMap;
            if (map2 == null) {
                TagToClassMapperImpl.$$$reportNull$$$0(7);
            }
            return map2;
        }
        HashMap<String, PsiClass> map3 = new HashMap<String, PsiClass>();
        if (this.fillMap(className, this.myModule.getModuleWithDependenciesAndLibrariesScope(true), map3, true)) {
            viewClassMap = new HashMap<String, SmartPsiElementPointer<PsiClass>>(map3.size());
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.myModule.getProject());
            for (Map.Entry entry : map3.entrySet()) {
                viewClassMap.put((String)entry.getKey(), (SmartPsiElementPointer<PsiClass>)manager.createSmartPsiElementPointer((PsiElement)entry.getValue()));
            }
            this.myInitialClassMaps.put(className, viewClassMap);
        }
        Map<String, Object> map4 = viewClassMap != null ? viewClassMap : Collections.emptyMap();
        if (map4 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(8);
        }
        return map4;
    }

    private boolean fillMap(@NotNull String className, @NotNull GlobalSearchScope scope, @NotNull Map<String, PsiClass> map2, boolean libClassesOnly) {
        String[] baseClassTagNames;
        if (className == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(10);
        }
        if (map2 == null) {
            TagToClassMapperImpl.$$$reportNull$$$0(11);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
        PsiClass baseClass = (PsiClass)ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass aClass;
            if (className == null) {
                TagToClassMapperImpl.$$$reportNull$$$0(13);
            }
            try {
                aClass = facade.findClass(className, this.myModule.getModuleWithDependenciesAndLibrariesScope(true));
            }
            catch (IndexNotReadyException e) {
                aClass = null;
            }
            return aClass;
        });
        if (baseClass == null) {
            return false;
        }
        AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(this.myModule);
        int api = androidModuleInfo == null ? 1 : androidModuleInfo.getModuleMinApi();
        for (String tagName : baseClassTagNames = LayoutViewClassUtils.getTagNamesByClass(baseClass, api)) {
            map2.put(tagName, baseClass);
        }
        try {
            ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true).forEach(c -> {
                String[] tagNames;
                if (map2 == null) {
                    TagToClassMapperImpl.$$$reportNull$$$0(12);
                }
                if (libClassesOnly && c.getManager().isInProject((PsiElement)c)) {
                    return true;
                }
                for (String tagName : tagNames = LayoutViewClassUtils.getTagNamesByClass(c, api)) {
                    map2.put(tagName, (PsiClass)c);
                }
                return true;
            });
        }
        catch (IndexNotReadyException e) {
            Logger.getInstance(this.getClass()).info((Throwable)e);
            return false;
        }
        return !map2.isEmpty();
    }

    public void clear() {
        this.myInitialClassMaps.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/TagToClassMapperImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/TagToClassMapperImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeClassMap";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialClassMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClassMap";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeClassMap";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInitialClassMap";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillMap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillMap$2";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillMap$1";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getClassMap$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

