/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.CommonBundle;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.android.actions.CreateXmlResourcePanel;
import org.jetbrains.android.actions.NewResourceCreationHandler;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateXmlResourceDialog
extends DialogWrapper {
    final CreateXmlResourcePanel myPanel;

    public CreateXmlResourceDialog(@NotNull Module module, @NotNull ResourceType resourceType, @Nullable String predefinedName, @Nullable String predefinedValue, boolean chooseName, @Nullable VirtualFile defaultFile, @Nullable VirtualFile contextFile) {
        if (module == null) {
            CreateXmlResourceDialog.$$$reportNull$$$0(0);
        }
        if (resourceType == null) {
            CreateXmlResourceDialog.$$$reportNull$$$0(1);
        }
        super(module.getProject());
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(module.getProject());
        Function<Module, IdeResourceNameValidator> nameValidatorFactory = selectedModule -> {
            if (resourceType == null) {
                CreateXmlResourceDialog.$$$reportNull$$$0(8);
            }
            if (module == null) {
                CreateXmlResourceDialog.$$$reportNull$$$0(9);
            }
            return IdeResourceNameValidator.forResourceName(resourceType, ResourceRepositoryManager.getAppResources(module));
        };
        this.myPanel = newResourceHandler.createNewResourceValuePanel(module, resourceType, ResourceFolderType.VALUES, predefinedName, predefinedValue, chooseName, true, true, defaultFile, contextFile, nameValidatorFactory);
        this.init();
    }

    protected ValidationInfo doValidate() {
        return this.myPanel.doValidate();
    }

    protected void doOKAction() {
        String resourceName = this.myPanel.getResourceName();
        String fileName = this.myPanel.getFileName();
        List<String> dirNames = this.myPanel.getDirNames();
        Module module = this.myPanel.getModule();
        JComponent panel = this.myPanel.getPanel();
        if (resourceName.isEmpty()) {
            Messages.showErrorDialog((Component)panel, (String)"Resource name is not specified", (String)CommonBundle.getErrorTitle());
        } else if (!AndroidResourceUtil.isCorrectAndroidResourceName(resourceName)) {
            Messages.showErrorDialog((Component)panel, (String)(resourceName + " is not correct resource name"), (String)CommonBundle.getErrorTitle());
        } else if (fileName.isEmpty()) {
            Messages.showErrorDialog((Component)panel, (String)"File name is not specified", (String)CommonBundle.getErrorTitle());
        } else if (dirNames.isEmpty()) {
            Messages.showErrorDialog((Component)panel, (String)"Directories are not selected", (String)CommonBundle.getErrorTitle());
        } else if (module == null) {
            Messages.showErrorDialog((Component)panel, (String)"Module is not specified", (String)CommonBundle.getErrorTitle());
        } else {
            super.doOKAction();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "AndroidCreateXmlResourceDialog";
    }

    protected JComponent createCenterPanel() {
        return this.myPanel.getPanel();
    }

    @Nullable
    public VirtualFile getResourceDirectory() {
        return this.myPanel.getResourceDirectory();
    }

    public String getResourceName() {
        return this.myPanel.getResourceName();
    }

    public String getFileName() {
        return this.myPanel.getFileName();
    }

    public List<String> getDirNames() {
        return this.myPanel.getDirNames();
    }

    public String getValue() {
        return this.myPanel.getValue();
    }

    @Nullable
    public static ValidationInfo checkIfResourceAlreadyExists(@NotNull Project project, @NotNull VirtualFile resourceDir, @NotNull String resourceName, @Nullable String resourceValue2, @NotNull ResourceType resourceType, @NotNull List<String> dirNames, @NotNull String fileName) {
        if (project == null) {
            CreateXmlResourceDialog.$$$reportNull$$$0(2);
        }
        if (resourceDir == null) {
            CreateXmlResourceDialog.$$$reportNull$$$0(3);
        }
        if (resourceName == null) {
            CreateXmlResourceDialog.$$$reportNull$$$0(4);
        }
        if (resourceType == null) {
            CreateXmlResourceDialog.$$$reportNull$$$0(5);
        }
        if (dirNames == null) {
            CreateXmlResourceDialog.$$$reportNull$$$0(6);
        }
        if (fileName == null) {
            CreateXmlResourceDialog.$$$reportNull$$$0(7);
        }
        if (resourceName.isEmpty() || dirNames.isEmpty() || fileName.isEmpty()) {
            return null;
        }
        for (String directoryName : dirNames) {
            VirtualFile resFile;
            VirtualFile resourceSubdir = resourceDir.findChild(directoryName);
            if (resourceSubdir == null || (resFile = resourceSubdir.findChild(fileName)) == null) continue;
            if (resFile.getFileType() != StdFileTypes.XML) {
                return new ValidationInfo("File " + FileUtil.toSystemDependentName((String)resFile.getPath()) + " is not XML file");
            }
            Resources resources = AndroidUtils.loadDomElement(project, resFile, Resources.class);
            if (resources == null) {
                return new ValidationInfo(AndroidBundle.message("not.resource.file.error", FileUtil.toSystemDependentName((String)resFile.getPath())));
            }
            for (ResourceElement element : AndroidResourceUtil.getValueResourcesFromElement(resourceType, resources)) {
                if (!resourceName.equals(element.getName().getStringValue()) || StringUtil.equals((CharSequence)resourceValue2, (CharSequence)element.getStringValue())) continue;
                return new ValidationInfo("resource '" + resourceName + "' already exists in " + FileUtil.toSystemDependentName((String)resFile.getPath()) + "with a different value.");
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/actions/CreateXmlResourceDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIfResourceAlreadyExists";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

