/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.resources.ResourceType;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.augment.AndroidLightInnerClassBase;
import org.jetbrains.android.augment.PermissionClass;
import org.jetbrains.android.augment.PermissionGroupClass;
import org.jetbrains.android.augment.ResourceTypeClass;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidPsiAugmentProvider
extends PsiAugmentProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.augment.AndroidPsiAugmentProvider");

    @NotNull
    public <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        String resClassName;
        PsiClass parentClass;
        boolean rClassAugment;
        if (element == null) {
            AndroidPsiAugmentProvider.$$$reportNull$$$0(0);
        }
        if (type == null) {
            AndroidPsiAugmentProvider.$$$reportNull$$$0(1);
        }
        if (!ProjectSystemUtil.getProjectSystem(element.getProject()).getAugmentRClasses()) {
            List list = Collections.emptyList();
            if (list == null) {
                AndroidPsiAugmentProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (type != PsiClass.class && type != PsiField.class || !(element instanceof PsiExtensibleClass)) {
            List list = Collections.emptyList();
            if (list == null) {
                AndroidPsiAugmentProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiExtensibleClass aClass = (PsiExtensibleClass)element;
        String className = aClass.getName();
        boolean bl = rClassAugment = "R".equals(className) && type == PsiClass.class;
        if (DumbService.isDumb((Project)element.getProject())) {
            if (rClassAugment) {
                LOG.debug("R_CLASS_AUGMENT: empty because of dumb mode");
            }
            List list = Collections.emptyList();
            if (list == null) {
                AndroidPsiAugmentProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        if (facet == null) {
            if (rClassAugment) {
                LOG.debug("R_CLASS_AUGMENT: empty because no facet");
            }
            List list = Collections.emptyList();
            if (list == null) {
                AndroidPsiAugmentProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            if (rClassAugment) {
                LOG.debug("R_CLASS_AUGMENT: empty because of no containing file");
            }
            List list = Collections.emptyList();
            if (list == null) {
                AndroidPsiAugmentProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (type == PsiClass.class) {
            if ("R".equals(className) && AndroidResourceUtil.isRJavaFile(facet, containingFile)) {
                Set<String> existingInnerClasses = AndroidPsiAugmentProvider.getOwnInnerClasses(aClass);
                EnumSet<ResourceType> types = ResourceReferenceConverter.getResourceTypesInCurrentModule(facet);
                ArrayList<ResourceTypeClass> result2 = new ArrayList<ResourceTypeClass>();
                for (ResourceType resType : types) {
                    if (resType == ResourceType.SAMPLE_DATA || existingInnerClasses.contains(resType.getName())) continue;
                    ResourceTypeClass resClass = new ResourceTypeClass(facet, resType.getName(), (PsiClass)aClass);
                    result2.add(resClass);
                }
                if (rClassAugment) {
                    LOG.debug("R_CLASS_AUGMENT: " + result2.size() + " classes added");
                }
                ArrayList<ResourceTypeClass> arrayList = result2;
                if (arrayList == null) {
                    AndroidPsiAugmentProvider.$$$reportNull$$$0(7);
                }
                return arrayList;
            }
            if ("Manifest".equals(className) && AndroidResourceUtil.isManifestJavaFile(facet, containingFile)) {
                List<PsiElement> list = Arrays.asList(new PsiElement[]{new PermissionClass(facet, (PsiClass)aClass), new PermissionGroupClass(facet, (PsiClass)aClass)});
                if (list == null) {
                    AndroidPsiAugmentProvider.$$$reportNull$$$0(8);
                }
                return list;
            }
            if (rClassAugment) {
                LOG.debug("R_CLASS_AUGMENT: empty because containing file is not actual R.java file");
            }
        } else if (type == PsiField.class && !(aClass instanceof AndroidLightInnerClassBase) && (parentClass = aClass.getContainingClass()) != null && "R".equals(parentClass.getName()) && AndroidResourceUtil.isRJavaFile(facet, containingFile) && (resClassName = aClass.getName()) != null && ResourceType.getEnum((String)resClassName) != null) {
            Set<String> existingFields = AndroidPsiAugmentProvider.getOwnFields(aClass);
            PsiField[] newFields = ResourceTypeClass.buildLocalResourceFields(facet, resClassName, (PsiClass)aClass);
            ArrayList<PsiField> result3 = new ArrayList<PsiField>();
            for (PsiField field2 : newFields) {
                if (existingFields.contains(field2.getName())) continue;
                result3.add(field2);
            }
            ArrayList<PsiField> arrayList = result3;
            if (arrayList == null) {
                AndroidPsiAugmentProvider.$$$reportNull$$$0(9);
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            AndroidPsiAugmentProvider.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static Set<String> getOwnInnerClasses(@NotNull PsiExtensibleClass aClass) {
        if (aClass == null) {
            AndroidPsiAugmentProvider.$$$reportNull$$$0(11);
        }
        HashSet result2 = new HashSet();
        for (PsiClass innerClass : aClass.getOwnInnerClasses()) {
            result2.add(innerClass.getName());
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            AndroidPsiAugmentProvider.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @NotNull
    private static Set<String> getOwnFields(@NotNull PsiExtensibleClass aClass) {
        if (aClass == null) {
            AndroidPsiAugmentProvider.$$$reportNull$$$0(13);
        }
        HashSet result2 = new HashSet();
        for (PsiField field2 : aClass.getOwnFields()) {
            result2.add(field2.getName());
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            AndroidPsiAugmentProvider.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/augment/AndroidPsiAugmentProvider";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/augment/AndroidPsiAugmentProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugments";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnInnerClasses";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAugments";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOwnInnerClasses";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getOwnFields";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

