/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.DeclareStyleableResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.augment.AndroidLightInnerClassBase;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ResourceTypeClassBase
extends AndroidLightInnerClassBase {
    private CachedValue<PsiField[]> myFieldsCache;

    public ResourceTypeClassBase(PsiClass context, String name) {
        super(context, name);
    }

    @NotNull
    static PsiField[] buildResourceFields(@NotNull ResourceManager manager, @NotNull AbstractResourceRepository repository, @NotNull ResourceNamespace namespace, boolean nonFinal, @NotNull String resClassName, @NotNull PsiClass context) {
        ResourceType resourceType;
        if (manager == null) {
            ResourceTypeClassBase.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            ResourceTypeClassBase.$$$reportNull$$$0(1);
        }
        if (namespace == null) {
            ResourceTypeClassBase.$$$reportNull$$$0(2);
        }
        if (resClassName == null) {
            ResourceTypeClassBase.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ResourceTypeClassBase.$$$reportNull$$$0(4);
        }
        if ((resourceType = ResourceType.getEnum((String)resClassName)) == null) {
            if (PsiField.EMPTY_ARRAY == null) {
                ResourceTypeClassBase.$$$reportNull$$$0(5);
            }
            return PsiField.EMPTY_ARRAY;
        }
        if (resourceType == ResourceType.STYLEABLE) {
            resourceType = ResourceType.DECLARE_STYLEABLE;
        }
        HashMap fieldNames = new HashMap();
        PsiPrimitiveType basicType = ResourceType.DECLARE_STYLEABLE == resourceType ? PsiType.INT.createArrayType() : PsiType.INT;
        for (Object resName : repository.getItemsOfType(namespace, resourceType)) {
            fieldNames.put(resName, basicType);
        }
        if (ResourceType.DECLARE_STYLEABLE == resourceType) {
            List items2 = repository.getResourceItems(namespace, ResourceType.DECLARE_STYLEABLE);
            for (ResourceItem item : items2) {
                DeclareStyleableResourceValue value = (DeclareStyleableResourceValue)item.getResourceValue();
                if (value == null) continue;
                List attributes = value.getAllAttributes();
                for (AttrResourceValue attr : attributes) {
                    if (!manager.isResourcePublic(attr.getResourceType().getName(), attr.getName())) continue;
                    ResourceNamespace attrNamespace = attr.getNamespace();
                    String packageName = attrNamespace.getPackageName();
                    if (attrNamespace.equals((Object)namespace) || StringUtil.isEmpty((String)packageName)) {
                        fieldNames.put(item.getName() + '_' + attr.getName(), PsiType.INT);
                        continue;
                    }
                    fieldNames.put(item.getName() + '_' + packageName.replace('.', '_') + '_' + attr.getName(), PsiType.INT);
                }
            }
        }
        PsiField[] result2 = new PsiField[fieldNames.size()];
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        int idIterator = resourceType.ordinal() * 100000;
        int i = 0;
        for (Map.Entry entry : fieldNames.entrySet()) {
            String fieldName = AndroidResourceUtil.getFieldNameByResourceName((String)entry.getKey());
            PsiType type = (PsiType)entry.getValue();
            int id = -idIterator++;
            AndroidLightField field2 = new AndroidLightField(fieldName, context, type, !nonFinal, nonFinal ? null : Integer.valueOf(id));
            field2.setInitializer(factory.createExpressionFromText(Integer.toString(id), (PsiElement)field2));
            result2[i++] = field2;
        }
        if (result2 == null) {
            ResourceTypeClassBase.$$$reportNull$$$0(6);
        }
        return result2;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        if (this.myFieldsCache == null) {
            this.myFieldsCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<PsiField[]>(){

                public CachedValueProvider.Result<PsiField[]> compute() {
                    return CachedValueProvider.Result.create((Object)ResourceTypeClassBase.this.doGetFields(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                }
            });
        }
        PsiField[] psiFieldArray = (PsiField[])this.myFieldsCache.getValue();
        if (psiFieldArray == null) {
            ResourceTypeClassBase.$$$reportNull$$$0(7);
        }
        return psiFieldArray;
    }

    @NotNull
    protected abstract PsiField[] doGetFields();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resClassName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/augment/ResourceTypeClassBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/augment/ResourceTypeClassBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildResourceFields";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildResourceFields";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

